/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.mq.consumer;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.epm.eb.common.elasticsearch.ElasticSearchService;
import kd.epm.eb.common.elasticsearch.OlapDataBusinessEvent;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LocalDateFormat;
import kd.epm.eb.common.utils.base.StrUtils;

public class AuditConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(AuditConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        OlapDataBusinessEvent event = null;
        Stats stats = new Stats("AuditConsumer");
        stats.appendMessage(StrUtils.format("messageId: {}", messageId));
        try {
            if (body instanceof OlapDataBusinessEvent) {
                event = (OlapDataBusinessEvent)body;
                String eventString = JSONUtils.toJson(event, new LocalDateFormat());
                ElasticSearchService.getInstance().insertDoc(event.getEsIndex(), eventString);
            }
            acker.ack(messageId);
        }
        catch (Exception e) {
            stats.appendMessage("epm-consumer-error");
            log.error("epm-consumer-error", (Throwable)e);
            acker.discard(messageId);
        }
        finally {
            stats.close();
            log.info(stats.toString("epm-consumer"));
        }
    }
}

