/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.DeleteOlapDataLog;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.shrek.exception.OlapFeildOverException;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.param.BgParamUtils;
import org.apache.commons.collections4.CollectionUtils;

public final class BgmdOlapWriter
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(BgmdOlapWriter.class);
    private OlapConnection conn;
    private OlapDataWriter writer;
    private List<String> writeDims;
    private IModelCacheHelper modelCache;
    private static final BigDecimal MAX_VALUE = BgConstant.MAX_VALUE;
    private static final BigDecimal MIN_VALUE = BgConstant.MIN_VALUE;
    private static final int OLAP_DATA_SCALA = 15;
    private static final int REMOVE_LOG_SIZE = 5;
    private long updateSize = 0L;
    private long removeSize = 0L;
    private List<BGCell> removes = Lists.newArrayListWithExpectedSize((int)5);

    public BgmdOlapWriter(OlapConnection conn, OlapDataWriter writer, List<String> writeDims, IModelCacheHelper modelCache) {
        this.conn = conn;
        this.writer = writer;
        this.writeDims = writeDims;
        this.modelCache = modelCache;
    }

    public boolean addValue(BGCell cell, Long busModelByDataSet) {
        Object measureValue = cell.getValue();
        if (measureValue != null) {
            String metricNumber = cell.getMemberMap().get(SysDimensionEnum.Metric.getNumber());
            Member metric = this.modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
            if (MetricUtils.isNumeric(metric.getDatatype())) {
                if (!(measureValue instanceof Number)) {
                    cell.setValue(ConvertUtils.toDecimal(measureValue));
                }
            } else {
                String strVal = measureValue instanceof String ? (String)measureValue : measureValue.toString();
                if (strVal.length() > 600) {
                    StringBuilder msg = new StringBuilder();
                    for (Map.Entry<String, String> entry : cell.getMemberMap().entrySet()) {
                        Dimension dimension = this.modelCache.getDimension(entry.getKey());
                        if (dimension == null) {
                            msg.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
                            continue;
                        }
                        Member member = this.modelCache.getMemberByAnyView(busModelByDataSet, dimension.getNumber(), entry.getValue());
                        if (member == null) {
                            msg.append(dimension.getName()).append(":").append(entry.getValue()).append(",");
                            continue;
                        }
                        msg.append(dimension.getName()).append(":").append(member.getName()).append(",");
                    }
                    throw new OlapFeildOverException(ResManager.loadResFormat((String)"\u6587\u672c\u8d85\u8fc7600\u5b57\u7b26\uff0c\u8d85\u51fa\u5b58\u50a8\u9650\u5236\u3002\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\uff08%1\uff09\u3002", (String)"CubeData_12", (String)"epm-eb-olap", (Object[])new Object[]{msg.substring(0, msg.length() - 1)}));
                }
                cell.setValue(strVal);
            }
        }
        if (measureValue instanceof BigDecimal) {
            BigDecimal _measureValue = (BigDecimal)measureValue;
            if (_measureValue.scale() > 15) {
                cell.setValue(_measureValue.setScale(15, 4));
            }
            if (_measureValue.compareTo(MAX_VALUE) > 0) {
                cell.setValue(MAX_VALUE);
            } else if (_measureValue.compareTo(MIN_VALUE) < 0) {
                cell.setValue(MIN_VALUE);
            }
        }
        if (measureValue == null) {
            ++this.removeSize;
            if (BgParamUtils.isWriteDataOperationLog()) {
                this.removes.add(cell);
            }
        }
        this.writer.setValues(BGCells.toArray(cell, this.writeDims));
        ++this.updateSize;
        return true;
    }

    @Override
    public void close() {
        this.writer.flush();
        OlapContext.clearSaveDataContext();
        ShrekOlapUtils.close(this.writer, this.conn);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("saveData.user:" + UserUtils.getUserName() + "; userId:" + UserUtils.getUserId());
        stats.addInfo("all-update-size=" + this.updateSize);
        stats.addInfo("remove-size=" + this.removeSize);
        if (CollectionUtils.isNotEmpty(this.removes)) {
            DeleteOlapDataLog.getInstance().log(this.modelCache, this.removes);
        }
        log.info(stats.toString());
    }
}

