/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.DistinctSelectCommandInfo;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.OlapServerRuntimeException;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.trace.util.TraceIdUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.BgmdOlapWriter;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.olapdao.FixMember;
import kd.epm.eb.common.olapdao.ICalcRuleInvoke;
import kd.epm.eb.common.olapdao.IOlapSandboxManager;
import kd.epm.eb.common.olapdao.OlapReadOption;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.ShrekDataSource;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekMemberServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimMembers;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public final class BgmdShrekDao {
    private static final String SHREK_CUBE_MEASURE = "FMONEY";
    private static final Log log = LogFactory.getLog(BgmdShrekDao.class);
    private static Enum _V2 = null;
    public static final String STORAGE_Stored = "Stored";
    public static final String STORAGE_DynamicCalc = "DynamicCalc";
    public static final String STORAGE_DynamicCalcAndStored = "DynamicCalcAndStored";
    public static final ShrekDB ShrekDB = new ShrekDB();

    public static BgmdShrekDao getInstance() {
        return InnerClass.instance;
    }

    private BgmdShrekDao() {
    }

    public void createSandbox(Model model, String cubeNumber, String sandboxName) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        OlapConnection conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
        Object builder = this.getSandboxBuilder(sandboxName, conn);
        try {
            Method method = builder.getClass().getMethod("createSandbox", String[].class);
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(builder, new Object[]{new String[]{SHREK_CUBE_MEASURE}});
        }
        catch (Exception e) {
            log.error("invoke createSandbox error", (Throwable)e);
            throw new KDBizException("invoke createSandbox error:" + e.getMessage());
        }
    }

    public void dropSandbox(Model model, String cubeNumber, String sandboxName) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        OlapConnection conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
        Object builder = this.getSandboxBuilder(sandboxName, conn);
        try {
            Method method = builder.getClass().getMethod("dropSandbox", new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            log.error("invoke dropSandbox error", (Throwable)e);
            throw new KDBizException("invoke dropSandbox error:" + e.getMessage());
        }
    }

    public boolean existSandbox(Model model, String cubeNumber, String sandboxName) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        OlapConnection conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
        PropertyBag property = new PropertyBag();
        property.set("prefixName", sandboxName);
        FunctionCommandInfo fc = new FunctionCommandInfo("getCubeMeasures", property);
        PropertyBag propertyBag = new OlapCommand(conn, (CommandInfo)fc).executeFunction();
        String measures = propertyBag.get("measures");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)measures)) {
            return false;
        }
        JSONArray array = JSON.parseArray((String)measures);
        return array.size() > 0;
    }

    private Object getSandboxBuilder(String sandboxName, OlapConnection conn) {
        try {
            Class<?> builder = Class.forName("kd.bos.olap.dataSources.PersistentSandboxBuilder");
            Constructor<?> c = builder.getConstructor(String.class, OlapConnection.class);
            return c.newInstance(sandboxName, conn);
        }
        catch (Throwable ex) {
            log.error("get PersistentSandboxBuilder class error", ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u5ba2\u6237\u7aef\u53ca\u670d\u52a1\u7aef\u7248\u672c\u52309.6.0\u53ca\u4ee5\u4e0a\u3002", (String)"BgmdShrekDao_4", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public BgmdOlapReader read(Model model, String cubeNumber, Map<String, Set<String>> queryMemberMap, List<String> selectDims, Dataset dataset, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList) {
        return this.read(model, cubeNumber, queryMemberMap, selectDims, null, dataset, functionVirtualMap, closeableList);
    }

    public BgmdOlapReader read(Model model, String cubeNumber, Map<String, Set<String>> queryMemberMap, List<String> selectDims, OlapReadOption readOption) {
        SelectCommandInfo query = this.getSelectCommandInfo(queryMemberMap, selectDims, readOption);
        return this.read(model, cubeNumber, query);
    }

    private SelectCommandInfo getSelectCommandInfo(Map<String, Set<String>> queryMemberMap, List<String> selectDims, OlapReadOption readOption) {
        if (readOption == null) {
            readOption = new OlapReadOption();
        }
        Object query = readOption.isUseDistinct() ? this.toDistinctSelectCommandInfo(queryMemberMap, selectDims) : this.toSelectCommandInfo(queryMemberMap, selectDims);
        query.setExcludeNull(readOption.isExcludeNull());
        query.setExcludeDynamicCalcResult(readOption.isExcludeDynamicCalcResult());
        query.setExcludeNullOrDefault(readOption.isExcludeNullOrDefault());
        Enum _v2 = this.getV2();
        if (_v2 != null) {
            try {
                Class<?> cls = query.getClass();
                Field field = cls.getDeclaredField("_dynamicCalcVersion");
                ReflectionUtils.makeAccessible((Field)field);
                field.set(query, _v2);
            }
            catch (KDBizException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error("dynamicCalcVersion-error", (Throwable)ex);
            }
        }
        return query;
    }

    private Enum getV2() {
        if (_V2 == null) {
            try {
                Class<?> dynamicCalcVersion = Class.forName("kd.bos.olap.dataSources.DynamicCalcVersion");
                Method method = dynamicCalcVersion.getMethod("valueOf", String.class);
                _V2 = (Enum)method.invoke(dynamicCalcVersion, "V2");
            }
            catch (Throwable ex) {
                log.error("getV2-error", ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u5ba2\u6237\u7aef\u53ca\u670d\u52a1\u7aef\u7248\u672c\u52309.3.0\u53ca\u4ee5\u4e0a\u3002", (String)"BgmdShrekDao_3", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        }
        return _V2;
    }

    public BgmdOlapReader read(Model model, String cubeNumber, Map<String, Set<String>> queryMemberMap, List<String> selectDims, OlapReadOption readOption, Dataset dataset, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, IOlapSandboxManager sandboxManager, ICalcRuleInvoke invoke) {
        SelectCommandInfo query = this.getSelectCommandInfo(queryMemberMap, selectDims, readOption);
        return this.read(model, cubeNumber, query, dataset, functionVirtualMap, closeableList, sandboxManager, invoke);
    }

    public BgmdOlapReader read(Model model, String cubeNumber, Map<String, Set<String>> queryMemberMap, List<String> selectDims, OlapReadOption readOption, Dataset dataset, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList) {
        SelectCommandInfo query = this.getSelectCommandInfo(queryMemberMap, selectDims, readOption);
        return this.read(model, cubeNumber, query, dataset, functionVirtualMap, closeableList);
    }

    private SelectCommandInfo toSelectCommandInfo(Map<String, Set<String>> queryMemberMap, List<String> selectDims) {
        SelectCommandInfo sci = new SelectCommandInfo();
        queryMemberMap.forEach((k, v) -> sci.addFilter(k, v.toArray(new String[0])));
        sci.addMeasures(new String[]{SHREK_CUBE_MEASURE});
        sci.setDimensions(selectDims);
        return sci;
    }

    private DistinctSelectCommandInfo toDistinctSelectCommandInfo(Map<String, Set<String>> queryMemberMap, List<String> selectDims) {
        DistinctSelectCommandInfo sci = new DistinctSelectCommandInfo();
        queryMemberMap.forEach((k, v) -> sci.addFilter(k, v.toArray(new String[0])));
        sci.addMeasures(new String[]{SHREK_CUBE_MEASURE});
        sci.setDimensions(selectDims);
        return sci;
    }

    private BgmdOlapReader read(Model model, String cubeNumber, SelectCommandInfo query) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        OlapConnection conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
        return new BgmdOlapReader(conn, new OlapCommand(conn, (CommandInfo)query).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE));
    }

    private BgmdOlapReader read(Model model, String cubeNumber, SelectCommandInfo query, Dataset dataset, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList) {
        return this.read(model, cubeNumber, query, dataset, functionVirtualMap, closeableList, null, null);
    }

    public BgmdOlapReader read(Model model, String cubeNumber, SelectCommandInfo query, Dataset dataset, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, IOlapSandboxManager sandboxManager, ICalcRuleInvoke invoke) {
        OlapConnection conn;
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        OlapConnection olapConnection = conn = sandboxManager != null && sandboxManager.isUseSandbox() ? sandboxManager.getOlapConnection(model, dataset) : ConnectionManager.getInstance().openConnection(ds, cubeNumber);
        if (functionVirtualMap != null && !functionVirtualMap.isEmpty()) {
            if (!conn.isSandboxEnv()) {
                Closeable closeable = conn.createSandbox();
                closeableList.add(closeable);
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(model.getId());
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig(model);
            for (Map.Entry<String, Map<String, String>> entry : functionVirtualMap.entrySet()) {
                String dimNumber = entry.getKey();
                Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                Map<String, String> memberRelation = entry.getValue();
                ArrayList members = Lists.newArrayListWithExpectedSize((int)16);
                for (Map.Entry<String, String> memberEntry : memberRelation.entrySet()) {
                    String virMemNum = memberEntry.getValue();
                    Member virMember = new Member();
                    virMember.setName(virMemNum);
                    virMember.setNumber(virMemNum);
                    virMember.setAggType(AggOprtEnum.SKIP.getSign());
                    virMember.setDimension(dimension);
                    virMember.setDatasetId(dataset.getId());
                    members.add(virMember);
                }
                ShrekMemberServiceHelper.addFunctionVirtualMembers(conn, cubeNumber, model, dataset, dimNumber, members, config);
            }
        }
        if (invoke != null) {
            invoke.invoke(conn);
        }
        return new BgmdOlapReader(conn, new OlapCommand(conn, (CommandInfo)query).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE), sandboxManager == null || !sandboxManager.isUseSandbox());
    }

    public BgmdOlapWriter save(IModelCacheHelper modelCache, String cubeNumber, List<String> writeDims, List<FixMember> fixMembers) {
        return this.save(modelCache, cubeNumber, writeDims, fixMembers, null);
    }

    public BgmdOlapWriter save(IModelCacheHelper modelCache, String cubeNumber, List<String> writeDims, List<FixMember> fixMembers, OlapWriteOption writeOption) {
        if (writeOption == null) {
            writeOption = new OlapWriteOption();
        }
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(modelCache.getModelobj());
        OlapConnection conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
        SaveCommandInfo command = this.getSaveCommandInfo(modelCache.getModelobj().getNumber(), cubeNumber, writeDims, this.genFixedDimension(fixMembers));
        command.setIncrement(writeOption.isIncrement());
        try {
            command.setIgnoreDataLock(writeOption.isIgnoreDataLock());
            command.setDisallowLockData(writeOption.isDataLockThrowErr());
        }
        catch (Exception e) {
            throw new KDBizException("need upgrade olap client above 2.8.17, and olap server above 9.16");
        }
        OlapDataWriter writer = new OlapCommand(conn, (CommandInfo)command).CreateWriter();
        return new BgmdOlapWriter(conn, writer, writeDims, modelCache);
    }

    private SaveCommandInfo getSaveCommandInfo(String modelNumber, String cubeNumber, List<String> writeDims, List<FixedDimension> fixedDimensionList) {
        SaveCommandInfo command = new SaveCommandInfo();
        command.addDimensions(writeDims.toArray(new String[0]));
        command.setMeasures(new String[]{SHREK_CUBE_MEASURE});
        command.setFixedDimensions(fixedDimensionList);
        Map<String, String> shrekProperties = ShrekIdCodeUtils.getDefaultIdCodes(null);
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, shrekProperties);
        OlapDataAuditService.getInstance().enhanceCommandWithAudit(modelNumber, cubeNumber, (CommandInfo)command);
        return command;
    }

    private List<FixedDimension> genFixedDimension(List<FixMember> fixMembers) {
        if (CollectionUtils.isEmpty(fixMembers)) {
            return Collections.emptyList();
        }
        return fixMembers.stream().map(m -> new FixedDimension(m.getDimNumber(), m.getMemberNumber())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Model model, String cubeNumber, Map<String, Set<String>> deleteRange) {
        if (model == null || cubeNumber == null || deleteRange == null || deleteRange.isEmpty()) {
            return;
        }
        int size = Integer.MAX_VALUE;
        String mainDimNumber = null;
        for (Map.Entry<String, Set<String>> entry : deleteRange.entrySet()) {
            if (entry.getValue().size() >= size) continue;
            mainDimNumber = entry.getKey();
            size = entry.getValue().size();
        }
        OlapConnection conn = null;
        OlapDataAuditService auditService = OlapDataAuditService.getInstance();
        try {
            ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
            conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
            Set<String> members = deleteRange.get(mainDimNumber);
            for (String memberNumber : members) {
                String left = mainDimNumber + "@" + memberNumber;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)left)) {
                    log.error("\u5220\u9664\u6761\u4ef6\u4e0d\u6b63\u786e,\u65e0\u6210\u5458\u8303\u56f4\u4e3a1\u7684\u7ef4\u5ea6");
                    throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u6761\u4ef6\u4e0d\u6b63\u786e\u3002", (String)"BgmdShrekDao_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                FelLambdaExpressionItem exp = new FelLambdaExpressionItem();
                exp.setExpressLeft(left);
                exp.setExpression("1*null");
                ComputingCommandInfo command = new ComputingCommandInfo();
                ArrayList filters = new ArrayList(16);
                if (MapUtils.isNotEmpty(deleteRange)) {
                    String finalDimNumber = mainDimNumber;
                    deleteRange.forEach((k, v) -> {
                        if (!finalDimNumber.equals(k)) {
                            filters.add(new DimensionFilterItem(k, new ArrayList(v)));
                        }
                    });
                }
                command.setFilter(filters);
                command.getExpressionItems().add(exp);
                command.setMainMeaName(SHREK_CUBE_MEASURE);
                command.setMainDimName(mainDimNumber);
                ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, null);
                auditService.enhanceCommandWithAudit(model.getNumber(), cubeNumber, (CommandInfo)command);
                OlapCommand cmd = new OlapCommand(conn, (CommandInfo)command);
                cmd.executeCompute();
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
    }

    public void calcRule(Model model, String cubeNumber, String mainDimNumber, Map<String, Set<String>> calcRange, List<Pair<String, String>> rules, boolean addLog) {
        this.calcRule(null, model, cubeNumber, mainDimNumber, calcRange, rules, addLog);
    }

    public void calcRule(OlapConnection sandboxConn, Model model, String cubeNumber, String mainDimNumber, Map<String, Set<String>> calcRange, List<Pair<String, String>> rules, boolean addLog) {
        ComputingCommandInfo command = new ComputingCommandInfo();
        ArrayList filters = new ArrayList(16);
        if (MapUtils.isNotEmpty(calcRange)) {
            calcRange.forEach((k, v) -> {
                if (!k.equals(mainDimNumber)) {
                    filters.add(new DimensionFilterItem(k, new ArrayList(v)));
                }
            });
        }
        command.setFilter(filters);
        command.setMainDimName(mainDimNumber);
        for (Pair<String, String> rule : rules) {
            FelLambdaExpressionItem exp = new FelLambdaExpressionItem();
            exp.setExpressLeft((String)rule.p1);
            exp.setExpression((String)rule.p2);
            command.getExpressionItems().add(exp);
        }
        command.setMainMeaName(SHREK_CUBE_MEASURE);
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, ShrekIdCodeUtils.getDefaultIdCodes(null));
        if (addLog) {
            OlapDataAuditService.getInstance().enhanceCommandWithAudit(model.getNumber(), cubeNumber, (CommandInfo)command);
        }
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        OlapConnection conn = null;
        try {
            conn = sandboxConn != null ? sandboxConn : ConnectionManager.getInstance().openConnection(ds, cubeNumber);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)command);
            cmd.executeCompute();
        }
        catch (OlapServerRuntimeException e) {
            log.error((Throwable)e);
            if (org.apache.commons.lang3.StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"out of range")) {
                throw new KDBizException(new ErrorCode("EB060001", ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u503c\u5df2\u8d85\u6700\u5927\u503c\uff0c\u672c\u6b21\u8ba1\u7b97\u65e0\u6548\u3002", (String)"BgmdShrekDao_2", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
            }
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (conn != null && sandboxConn == null) {
                conn.Close();
            }
        }
    }

    public static class ShrekDB {
        private static final int MAX_LOG_COUNT = 10000;
        private static final int MAX_LOG_SIZE = 50;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TransactionTraceInfo> queryCommandInfo(@NotNull Long modelId, Long busModelId, Long datasetId, Map<String, Set<String>> membersMap, Date filterTime, Long traceId, int logSize, IModelCacheHelper modelCacheHelper) {
            if (IDUtils.isNull(modelId) || kd.epm.eb.common.utils.CollectionUtils.isEmpty(membersMap)) {
                return null;
            }
            LogStats stats = new LogStats("budget-olap-log : ");
            stats.addInfo("begin-query-command.");
            OlapConnection conn = null;
            LinkedList<TransactionTraceInfo> trans = new LinkedList<TransactionTraceInfo>();
            HashMap<String, String> memberMap = new HashMap<String, String>();
            if (logSize > 50) {
                logSize = 50;
            }
            if (logSize <= 0) {
                logSize = 3;
            }
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
            }
            HashMap storageMap = Maps.newHashMap();
            storageMap.put(BgmdShrekDao.STORAGE_Stored, StorageTypeEnum.STORAGE);
            storageMap.put(BgmdShrekDao.STORAGE_DynamicCalc, StorageTypeEnum.DYNAMIC);
            try {
                List<Dimension> dimensions;
                Model model = modelCacheHelper.getModelobj();
                Map<String, List<Long>> viewGroupViews = modelCacheHelper.getViewGroupViewsByBusModel(busModelId);
                if (model.isModelByEB()) {
                    conn = EbShrekOlapServiceHelper.getConnection(model);
                    dimensions = modelCacheHelper.getDimensionList();
                } else {
                    if (IDUtils.isNull(datasetId)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"", (String)"epm-eb-common", (Object[])new Object[0]));
                    }
                    Dataset dataset = Dataset.of(DatasetServiceHelper.loadDatasets(datasetId));
                    conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                    dimensions = modelCacheHelper.getDimensionList(datasetId);
                }
                DimMembers members = new DimMembers();
                for (Dimension dimension : dimensions) {
                    View view;
                    Set<String> _memberNums;
                    List<Object> viewIds = new ArrayList(16);
                    if (viewGroupViews != null) {
                        viewIds = viewGroupViews.get(dimension.getNumber());
                    }
                    if ((_memberNums = membersMap.get(dimension.getNumber())) != null) {
                        LinkedHashSet<String> leafNums = new LinkedHashSet<String>(_memberNums.size());
                        if (CollectionUtils.isNotEmpty(viewIds)) {
                            for (Long l : viewIds) {
                                view = dimension.getView(l);
                                if (view == null) continue;
                                leafNums.addAll(view.getLeaf(_memberNums));
                            }
                        } else {
                            leafNums.addAll(dimension.getLeaf(_memberNums));
                        }
                        members.addMembers(dimension.getNumber(), new ArrayList<String>(leafNums));
                        continue;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                        members.addMembers(dimension.getNumber(), dimension.getLeafMembers().stream().filter(member -> member.getDatasetId() != null && member.getDatasetId().equals(datasetId)).map(BaseCache::getNumber).collect(Collectors.toList()));
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(viewIds)) {
                        for (Long l : viewIds) {
                            view = dimension.getView(l);
                            if (view == null) continue;
                            members.addMembers(dimension.getNumber(), view.getLeafMembers().stream().map(m -> m.getNumber()).collect(Collectors.toList()));
                        }
                        continue;
                    }
                    members.addMembers(dimension.getNumber(), dimension.getLeafMembers().stream().map(m -> m.getNumber()).collect(Collectors.toList()));
                }
                List<String> dimNumbers = members.getDimensions();
                for (int index = 0; members.hasNext() && index < 10000; ++index) {
                    String[] memberNums = members.next();
                    int in = dimNumbers.size();
                    for (int i = 0; i < in; ++i) {
                        memberMap.put(dimNumbers.get(i), memberNums[i]);
                    }
                    PropertyBag propertyBag = new PropertyBag();
                    propertyBag.set("cellKey", JSON.toJSONString(memberMap));
                    propertyBag.set("measureName", FacTabFieldDefEnum.FIELD_MONEY.getField());
                    propertyBag.set("deadlineTime", ConvertUtils.toString(filterTime));
                    propertyBag.set("limit", String.valueOf(logSize));
                    FunctionCommandInfo command = new FunctionCommandInfo("queryTransactionTraceInfo", propertyBag);
                    try {
                        JavaType javaType;
                        List<TransactionTraceInfo> _trans;
                        propertyBag = new OlapCommand(conn, (CommandInfo)command).executeFunction();
                        if (propertyBag == null) continue;
                        String history = propertyBag.get("history");
                        String currentStorage = propertyBag.get("currentStorage");
                        if (!StringUtils.isNotEmpty(history) || "[]".equals(history) || (_trans = (List<TransactionTraceInfo>)JSONUtils.parse(history, javaType = JSONUtils.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{TransactionTraceInfo.class}))) == null || _trans.isEmpty()) continue;
                        if (IDUtils.isNotNull(traceId)) {
                            _trans = _trans.stream().filter(t -> traceId.compareTo(t.traceId) == 0).collect(Collectors.toList());
                        }
                        _trans.forEach(t -> {
                            if (t.traceId != null) {
                                t.traceStr = TraceIdUtil.idToHex((long)t.traceId);
                            }
                            t.members = memberNums;
                            t.storage = (StorageTypeEnum)((Object)((Object)((Object)storageMap.get(currentStorage))));
                            if (StringUtils.isNotEmpty(t.time)) {
                                try {
                                    t.tranTime = ConvertUtils.toDate(t.time);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        trans.addAll(_trans);
                        continue;
                    }
                    catch (Exception ex) {
                        log.error("queryShrekLog-error:", (Object)ex.getMessage());
                    }
                }
                if (!trans.isEmpty()) {
                    trans.sort((t1, t2) -> {
                        Date time1 = t1.tranTime;
                        Date time2 = t2.tranTime;
                        if (time1 != null && time2 != null) {
                            return time2.compareTo(time1);
                        }
                        return 0;
                    });
                }
                this.queryCommand(conn, trans);
            }
            catch (JsonProcessingException ex) {
                try {
                    log.error("json-parse-error", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    stats.addInfo("end-query-command.");
                    log.info(stats.toString());
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
                stats.addInfo("end-query-command.");
                log.info(stats.toString());
            }
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-query-command.");
            log.info(stats.toString());
            return trans;
        }

        private void queryCommand(@NotNull OlapConnection conn, List<TransactionTraceInfo> trans) throws JsonProcessingException {
            JavaType javaType;
            List commands;
            if (trans == null || trans.isEmpty()) {
                return;
            }
            List transIds = trans.stream().map(t -> t.transactionId).collect(Collectors.toList());
            PropertyBag bag = new PropertyBag();
            bag.set("transactionIds", JSON.toJSONString(transIds));
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)new FunctionCommandInfo("queryTransactionCommandInfo", bag));
            PropertyBag result = olapCommand.executeFunction();
            String commandStr = result.get("commands");
            if (StringUtils.isNotEmpty(commandStr) && (commands = (List)JSONUtils.parse(commandStr, javaType = JSONUtils.getMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{String.class}))) != null) {
                HashMap commandMap = new HashMap(transIds.size());
                int in = transIds.size();
                for (int i = 0; i < in; ++i) {
                    if (i >= commands.size()) continue;
                    commandMap.put(transIds.get(i), commands.get(i));
                }
                for (TransactionTraceInfo tran : trans) {
                    tran.command = (String)commandMap.get(tran.transactionId);
                }
            }
        }
    }

    public static class TransactionTraceInfo {
        public Long transactionId = 0L;
        public Long traceId = 0L;
        public String time = null;
        public Object value = null;
        public String command = null;
        public String traceStr = null;
        public Date tranTime = null;
        public StorageTypeEnum storage = null;
        public String[] members = null;
    }

    private static class InnerClass {
        private static final BgmdShrekDao instance = new BgmdShrekDao();

        private InnerClass() {
        }
    }
}

