/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.CubeDataScopeItem;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SliceScopeItemV2;
import kd.bos.olap.metadata.MetadataTypes;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.olapdao.ShrekDataSource;

public final class BgmdShrekLockDao {
    private BgmdShrekLockDao() {
    }

    public static BgmdShrekLockDao getInstance() {
        return Singleton.INSTANCE.instance;
    }

    public void createLockRule(Model model, String cubeNumber, String scopeName, LinkedHashMap<String, Set<String>> lockScope) {
        SliceScopeItemV2 lockItem = new SliceScopeItemV2(scopeName);
        lockScope.forEach((dimNumber, memberSet) -> {
            String[] filterValue = memberSet.toArray(new String[0]);
            lockItem.addFilter(dimNumber, filterValue);
        });
        BgmdShrekLockDao.execCubeDataScope(model, cubeNumber, CommandTypes.create, new CubeDataScopeItem[]{lockItem});
    }

    public void dropLockRule(Model model, String cubeNumber, String scopeName) {
        BgmdShrekLockDao.execCubeDataScope(model, cubeNumber, CommandTypes.drop, new CubeDataScopeItem[]{new SliceScopeItemV2(scopeName)});
    }

    public void alterLockScope(Model model, String cubeNumber, String scopeName, LinkedHashMap<String, Set<String>> lockScope) {
        SliceScopeItemV2 lockItem = new SliceScopeItemV2(scopeName);
        lockScope.forEach((dimNumber, memberSet) -> {
            String[] filterValue = memberSet.toArray(new String[0]);
            lockItem.addFilter(dimNumber, filterValue);
        });
        BgmdShrekLockDao.execCubeDataScope(model, cubeNumber, CommandTypes.alter, new CubeDataScopeItem[]{lockItem});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LockRuleInfo> getCubeLockRule(Model model, String cubeNumber, String scopeName) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        try (OlapConnection conn = null;){
            conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeNumber);
            propertyBag.set("name", scopeName);
            FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getCubeDataLockRule", propertyBag);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            PropertyBag retPropertyBag = cmd.executeFunction();
            String scope = retPropertyBag.get("scope");
            List list = JSON.parseArray((String)scope, LockRuleInfo.class);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCubeLockRuleNames(Model model, String cubeNumber) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        try (OlapConnection conn = null;){
            conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeNumber);
            FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getCubeDataLockRuleNames", propertyBag);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            PropertyBag retPropertyBag = cmd.executeFunction();
            String scopeNames = retPropertyBag.get("scopeNames");
            List list = JSON.parseArray((String)scopeNames, String.class);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execCubeDataScope(Model model, String cubeNumber, CommandTypes type, CubeDataScopeItem ... scopeItems) {
        ShrekDataSource ds = ConnectionManager.getInstance().getDataSource(model);
        try (OlapConnection conn = null;){
            conn = ConnectionManager.getInstance().openConnection(ds, cubeNumber);
            MetadataCommandInfo commandInfo = new MetadataCommandInfo();
            commandInfo.setMetadataType(MetadataTypes.CubeLockRule);
            commandInfo.setOwnerUniqueName(cubeNumber);
            if (CommandTypes.alter == type) {
                commandInfo.setName(scopeItems[0].getName());
            }
            commandInfo.setAction(type);
            Arrays.stream(scopeItems).forEach(item -> commandInfo.getItems().add(item));
            OlapCommand command = new OlapCommand(conn, (CommandInfo)commandInfo);
            command.executeNonQuery();
        }
    }

    public static class LockRuleInfo {
        private String name;
        private ArrayList<String> dimensions;
        private ArrayList<ArrayList<String>> members;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ArrayList<String> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(ArrayList<String> dimensions) {
            this.dimensions = dimensions;
        }

        public ArrayList<ArrayList<String>> getMembers() {
            return this.members;
        }

        public void setMembers(ArrayList<ArrayList<String>> members) {
            this.members = members;
        }
    }

    private static enum Singleton {
        INSTANCE;

        private final BgmdShrekLockDao instance = new BgmdShrekLockDao();
    }
}

