/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.ShrekDataSource;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.DataSourceUtils;
import kd.epm.eb.common.utils.EncryptUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ConnectionManager {
    private static final Log log = LogFactory.getLog(ConnectionManager.class);

    public static ConnectionManager getInstance() {
        return InnerClass.instance;
    }

    private ConnectionManager() {
    }

    public OlapConnection openConnection(ShrekDataSource ds, String cubeNumber) {
        OlapConnection conn = this.getConnection(MessageFormat.format("http://{0}:{1}/bos-olap-webserver/services/httpolap", ds.getIp(), ds.getPort()), ds.getUsername(), ds.getPassword(), cubeNumber);
        conn.Open();
        return conn;
    }

    public OlapConnection getConnection(String modelNumber, String cubeNumber) {
        ShrekDataSource ds = this.getDataSource(modelNumber);
        return this.openConnection(ds, cubeNumber);
    }

    public OlapConnection getConnection(Model model, Dataset dataset) {
        ShrekDataSource ds = this.getDataSource(model);
        String cubeNumber = model.isModelByEB() ? ShrekOlapUtils.getCubeNumber(model) : ShrekOlapUtils.getCubeNumber(dataset);
        return this.getConnection(MessageFormat.format("http://{0}:{1}/bos-olap-webserver/services/httpolap", ds.getIp(), ds.getPort()), ds.getUsername(), ds.getPassword(), cubeNumber);
    }

    public OlapConnection getEmptyConnection(Model model) {
        ShrekDataSource ds = this.getDataSource(model);
        return this.getConnection(MessageFormat.format("http://{0}:{1}/bos-olap-webserver/services/httpolap", ds.getIp(), ds.getPort()), ds.getUsername(), ds.getPassword(), null);
    }

    public OlapConnection getConnection(String dataSource, String userName, String password, String cubeNumber) {
        AnalysisContext analysisContext;
        OlapConnectionStringBuilder builder = new OlapConnectionStringBuilder();
        builder.setProvider("kingdee.olap.Shrek");
        builder.setDataSource(dataSource);
        builder.setTimeout(10000);
        builder.setLanguage(Lang.get().getLocale().getLanguage());
        if (StringUtils.isNotBlank((CharSequence)cubeNumber)) {
            builder.setInitialCatalog(cubeNumber);
        }
        if ((analysisContext = OlapContext.getAnalysisContext()) != null) {
            String sandboxName = ShrekOlapUtils.getSandboxName(analysisContext.getSeq());
            try {
                Class<?> cls = builder.getClass();
                Method method = cls.getDeclaredMethod("setPersistentSandboxName", String.class);
                ReflectionUtils.makeAccessible((Method)method);
                method.invoke((Object)builder, sandboxName);
            }
            catch (NoSuchMethodException ex) {
                log.error("setPersistentSandboxName-NoSuchMethodException cubeNumber:" + cubeNumber + " sandboxName:" + sandboxName, (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u5ba2\u6237\u7aef\u53ca\u670d\u52a1\u7aef\u7248\u672c\u52309.6.0\u53ca\u4ee5\u4e0a\u3002", (String)"BgmdShrekDao_4", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                log.error("setPersistentSandboxName-error cubeNumber:" + cubeNumber + " sandboxName:" + sandboxName, (Throwable)ex);
                throw new KDBizException("setPersistentSandboxName  cubeNumber:" + cubeNumber + " sandboxName:" + sandboxName + " error:" + ex.getMessage());
            }
        }
        OlapConnection conn = new OlapConnection(builder.toString());
        conn.setUserName(EncryptUtils.aesDecrypt(userName));
        conn.setPassword(EncryptUtils.aesDecrypt(password));
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOlapConnect(String dataSource, String userName, String password) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setAction(CommandTypes.create);
        cmd.setName("olapTestCube");
        boolean isSuccess = true;
        OlapConnection conn = null;
        try {
            conn = this.getConnection(dataSource, userName, password, null);
            conn.Open();
            new OlapCommand(conn, (CommandInfo)cmd).executeNonQuery();
        }
        catch (Exception e) {
            try {
                isSuccess = false;
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{conn});
                throw throwable;
            }
            ShrekOlapUtils.close(new Object[]{conn});
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOlapConnect(String address, String port, String userName, String password) {
        boolean isSuccess = false;
        String url = MessageFormat.format("http://{0}:{1}/bos-olap-webserver/services/dbmanage/isReady", address, port);
        HttpEntity entity = null;
        try {
            HttpPost post = new HttpPost(url);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            RequestConfig config = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build();
            post.setConfig(config);
            post.setHeader("Authorization", this.getBasicAuthorizationHeaderValue(userName, password));
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                isSuccess = Boolean.parseBoolean(this.getData(entity));
            }
        }
        catch (Exception ex) {
            log.error("tryOlapConnect-error", (Throwable)ex);
        }
        finally {
            EntityUtils.consumeQuietly(entity);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBasicAuthorizationHeaderValue(String username, String password) throws Exception {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] byes = encoder.encode((EncryptUtils.aesDecrypt(username) + ":" + EncryptUtils.aesDecrypt(password)).getBytes(StandardCharsets.UTF_8));
        try {
            String string = "Basic " + new String(byes, "UTF-8");
            return string;
        }
        finally {
            Arrays.fill(byes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getData(HttpEntity httpEntity) throws Exception {
        String result;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            new BufferedHttpEntity(httpEntity).writeTo((OutputStream)baos);
            byte[] _bytes = baos.toByteArray();
            result = new String(_bytes, "UTF-8");
            result = StringUtils.trim((String)result);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOlapConnectCount(String dataSource, String userName, String password) {
        int n;
        OlapConnection conn = null;
        try {
            conn = this.getConnection(dataSource, userName, password, null);
            conn.Open();
            n = FunctionCommandInfo.getCubeCount((OlapConnection)conn);
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return n;
    }

    public ShrekDataSource getDataSource(Model model) {
        String select = "id, number, name, serveraddress, port, username, password, accountid";
        QFilter filter = new QFilter("id", "=", (Object)model.getDataSourceId());
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingleFromCache((String)"epbs_datasource", (String)select, (QFilter[])new QFilter[]{filter});
        if (dataSource != null) {
            if (!DataSourceUtils.verifyAccount(dataSource.getLong("id"), dataSource.getString("accountid"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u4e0d\u662f\u8be5\u6570\u636e\u4e2d\u5fc3\u521b\u5efa\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u6570\u636e\u6e90\u3002", (String)"ConnectionManager_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            return new ShrekDataSource(dataSource.getString("serveraddress"), dataSource.getString("port"), dataSource.getString("username"), dataSource.getString("password"));
        }
        log.warn("error-datasource:" + model.getCubeNumber() + ",datasourceId=" + model.getDataSourceId());
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u6216\u8005\u5207\u6362\u8fc7\u6570\u636e\u6e90\u662f\u5426\u6709\u91cd\u542f\u670d\u52a1", (String)"ConnectionManager_0", (String)"epm-eb-common", (Object[])new Object[0]));
    }

    public ShrekDataSource getDataSource(String modelNumber) {
        QFilter filter = new QFilter("number", "=", (Object)modelNumber);
        String select = "datasource.serveraddress, datasource.port, datasource.username, datasource.password";
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)select, (QFilter[])new QFilter[]{filter});
        if (dataSource != null) {
            return new ShrekDataSource(dataSource.getString("datasource.serveraddress"), dataSource.getString("datasource.port"), dataSource.getString("datasource.username"), dataSource.getString("datasource.password"));
        }
        log.warn("error-datasource:" + modelNumber);
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u6216\u8005\u5207\u6362\u8fc7\u6570\u636e\u6e90\u662f\u5426\u6709\u91cd\u542f\u670d\u52a1", (String)"ConnectionManager_0", (String)"epm-eb-common", (Object[])new Object[0]));
    }

    private static class InnerClass {
        private static final ConnectionManager instance = new ConnectionManager();

        private InnerClass() {
        }
    }
}

