/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;

public class DeleteOlapDataLog {
    private static final int LOG_DAY_RANGE = -60;
    private static final String LOG_TABLE_KEY = "t_eb_log";
    private static final String LOG_INDEX_KEY = "ix_eb_log";
    private static final String LOG_PK_KEY = "pk_eb_log";

    public static DeleteOlapDataLog getInstance() {
        return InnerClass.instance;
    }

    private DeleteOlapDataLog() {
    }

    public void log(IModelCacheHelper modelCache, List<BGCell> cellList) {
        Long cubeId = modelCache.getModelobj().getId();
        String logTable = this.checkLogTable(cubeId);
        this.deleteHistory(logTable);
        ArrayList sqlParams = Lists.newArrayListWithCapacity((int)cellList.size());
        Long userId = UserUtils.getUserId();
        DeleteOlapDataLog.getInstance().deleteHistory(logTable);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        for (BGCell cell : cellList) {
            if (cell.getValue() != null) continue;
            String orgNumber = cell.getMemberMap().get(SysDimensionEnum.Entity.getNumber());
            String accNumber = cell.getMemberMap().get(SysDimensionEnum.Account.getNumber());
            Object[] params = new Object[7];
            params[0] = null;
            params[1] = time;
            params[2] = userId;
            params[3] = this.getMemberId(modelCache, SysDimensionEnum.Entity.getNumber(), orgNumber);
            params[4] = this.getMemberId(modelCache, SysDimensionEnum.Account.getNumber(), accNumber);
            params[5] = JsonUtils.getJsonString(cell.getMemberMap());
            BigDecimal oldValue = this.getOldValue(cell);
            if (oldValue.compareTo(BgConstant.MAX_VALUE.divide(new BigDecimal(10), 2, RoundingMode.HALF_DOWN)) > 0 || oldValue.compareTo(BgConstant.MIN_VALUE.divide(new BigDecimal(10), 2, RoundingMode.HALF_DOWN)) < 0) continue;
            params[6] = oldValue;
            sqlParams.add(params);
        }
        if (!sqlParams.isEmpty()) {
            long[] ids = DBServiceHelper.genLongIds((String)logTable, (int)sqlParams.size());
            int in = sqlParams.size();
            for (int i = 0; i < in; ++i) {
                ((Object[])sqlParams.get((int)i))[0] = ids[i];
            }
            String sql = "insert into " + logTable + "(fid, fmodifytime, fmodifierid, forgunitid, faccountid, fdata, fvalue) values (?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, (List)sqlParams);
        }
    }

    private BigDecimal getOldValue(BGCell cell) {
        Object oldValue = cell.getOldValue();
        if (oldValue instanceof Number) {
            return ConvertUtils.toDecimal(oldValue);
        }
        return BigDecimal.ZERO;
    }

    private Long getMemberId(IModelCacheHelper modelCache, String dimNumber, String memNumber) {
        Member member = modelCache.getMemberByAnyView(dimNumber, memNumber);
        return member.getId();
    }

    public void deleteHistory(String logTable) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(6, -60);
        DB.execute((DBRoute)BgBaseConstant.epm, (String)("delete from " + logTable + " where fmodifytime < ?"), (Object[])new Object[]{calendar.getTime()});
    }

    public String getLogTable(Long cubeId) {
        return LOG_TABLE_KEY + cubeId;
    }

    public String checkLogTable(Long cubeId) {
        String logTable = this.getLogTable(cubeId);
        if (!SqlBatchUtils.hasTable(logTable)) {
            this.createLogTable(cubeId, logTable);
        } else if (!SqlBatchUtils.hasColumn(logTable, "fid")) {
            this.dropLogTable(logTable);
            this.createLogTable(cubeId, logTable);
        }
        return logTable;
    }

    private void createLogTable(Long cubeId, String logTable) {
        String pkName = LOG_PK_KEY + cubeId;
        StringBuilder sql = new StringBuilder();
        sql.append("create table ").append(logTable).append(" (fid bigint default 0 not null, fmodifytime datetime, fmodifierid bigint default 0 not null, ").append("forgunitid bigint default 0 not null, faccountid bigint default 0 not null, ").append("fvalue decimal(26,8) default 0 not null, fdata nvarchar(512), ftype char(1) default 'D' not null, ").append("constraint ").append(pkName).append(" primary key (fid))");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        String indexName = LOG_INDEX_KEY + cubeId;
        DB.execute((DBRoute)BgBaseConstant.epm, (String)("create index " + indexName + " on " + logTable + " (fmodifytime, forgunitid, faccountid)"));
    }

    private void dropLogTable(String logTable) {
        DB.execute((DBRoute)BgBaseConstant.epm, (String)("drop table " + logTable));
    }

    private static class InnerClass {
        private static DeleteOlapDataLog instance = new DeleteOlapDataLog();

        private InnerClass() {
        }
    }
}

