/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.olapdao.IOlapSandboxManager;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;

public class OlapSandboxBaseManager
implements IOlapSandboxManager {
    private static final Log log = LogFactory.getLog(OlapSandboxBaseManager.class);
    private Map<String, OlapConnection> connectionMap = new HashMap<String, OlapConnection>(10);
    private Map<String, Closeable> closeableMap = new HashMap<String, Closeable>(10);

    @Override
    public boolean isUseSandbox() {
        return true;
    }

    @Override
    public OlapConnection getOlapConnection(Model model, Dataset dataset) {
        if (!this.isUseSandbox()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e34\u65f6\u6c99\u7bb1\u529f\u80fd\uff0c\u8bf7\u52ff\u83b7\u53d6\u4e34\u65f6\u6c99\u7bb1\u8fde\u63a5\u3002", (String)"OlapSandboxBaseManager_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        log.info("OlapSandboxBaseManager-getOlapConnection");
        String key = model.getId() + "!" + (model.isModelByEB() ? ShrekOlapUtils.getCubeNumber(model) : ShrekOlapUtils.getCubeNumber(dataset));
        OlapConnection conn = this.connectionMap.get(key);
        if (conn == null) {
            conn = ShrekCubeServiceHelper.getConnection(model, dataset);
            boolean isClientError = false;
            try {
                Method method = conn.getClass().getMethod("isSandboxEnv", new Class[0]);
                if (method == null) {
                    isClientError = true;
                }
                if ((method = conn.getClass().getMethod("createSandbox", new Class[0])) == null) {
                    isClientError = true;
                }
            }
            catch (Throwable e) {
                log.error(e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u5ba2\u6237\u7aef\u53ca\u670d\u52a1\u7aef\u7248\u672c\u52309.3.0\u53ca\u4ee5\u4e0a\u3002", (String)"BgmdShrekDao_3", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            if (isClientError) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u5ba2\u6237\u7aef\u53ca\u670d\u52a1\u7aef\u7248\u672c\u52309.3.0\u53ca\u4ee5\u4e0a\u3002", (String)"BgmdShrekDao_3", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            try {
                Closeable closeable = conn.createSandbox();
                this.closeableMap.put(key, closeable);
            }
            catch (Throwable ex) {
                log.error(ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u5ba2\u6237\u7aef\u53ca\u670d\u52a1\u7aef\u7248\u672c\u52309.3.0\u53ca\u4ee5\u4e0a\u3002", (String)"BgmdShrekDao_3", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            conn.Open();
            this.connectionMap.put(key, conn);
        }
        return conn;
    }

    @Override
    public void close() {
        for (OlapConnection conn : this.connectionMap.values()) {
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
        for (Closeable c : this.closeableMap.values()) {
            try {
                c.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

