/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao.valueConverter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.valueConverter.ValueConverter;
import kd.epm.eb.common.utils.ConvertUtils;

public class TypeDateValueConverter
implements ValueConverter {
    private int metricIndex = -1;
    private Map<String, Boolean> isDateMap = new HashMap<String, Boolean>();
    private Map<String, Long> dateValueMap = new HashMap<String, Long>();
    private IModelCacheHelper modelCache;

    public TypeDateValueConverter(List<String> selectDims, IModelCacheHelper modelCache) {
        for (int i = 0; i < selectDims.size(); ++i) {
            String dimNumber = selectDims.get(i);
            if (!SysDimensionEnum.Metric.getNumber().equals(dimNumber)) continue;
            this.metricIndex = i + 1;
            break;
        }
        this.modelCache = modelCache;
    }

    @Override
    public Object[] convert(Object[] values) {
        if (this.metricIndex == -1 || values[0] == null) {
            return values;
        }
        String metricNumber = (String)values[this.metricIndex];
        Boolean isDate = this.isDateMap.computeIfAbsent(metricNumber, v -> {
            Member metricMember = this.modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
            return metricMember != null && MetricDataTypeEnum.DATE.getIndex().equals(metricMember.getDatatype());
        });
        if (!isDate.booleanValue()) {
            return values;
        }
        values[0] = this.dateValueMap.computeIfAbsent((String)values[0], v -> {
            Object value = values[0];
            Date date = ConvertUtils.from((String)value);
            if (date == null) {
                return null;
            }
            return date.getTime();
        });
        return values;
    }
}

