/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.pageinteraction;

import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.utils.ObjectSerialUtil;

public interface DynamicPage {
    default public Page getPage(IFormView curview) {
        if (this.getPageCache(curview) == null) {
            return null;
        }
        String cac = this.getPageCache(curview).get("page");
        if (cac != null) {
            return (Page)ObjectSerialUtil.deSerializedBytes(cac);
        }
        return null;
    }

    default public void setPage(IFormView curview, Page page) {
        this.setPage(curview, page, false);
    }

    default public void setPage(IFormView curview, Page page, boolean isaddElement) {
        if (this.getPageCache(curview) == null) {
            return;
        }
        if (isaddElement) {
            curview.getModel().getDataEntity(true);
        }
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> e.check(curview)));
        this.getPageCache(curview).put("page", ObjectSerialUtil.toByteSerialized(page));
    }

    default public IPageCache getPageCache(IFormView curview) {
        FormViewPluginProxy curproxy = (FormViewPluginProxy)curview.getService(FormViewPluginProxy.class);
        IPageCache pageCache = null;
        for (IFormPlugin pl : curproxy.getPlugIns()) {
            if (!AbstractFormPlugin.class.isAssignableFrom(pl.getClass())) continue;
            pageCache = ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).getPageCache();
        }
        if (pageCache == null) {
            return null;
        }
        return pageCache;
    }
}

