/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.pageinteraction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.InteractivePage;
import kd.epm.eb.common.pageinteraction.PageListenerRegister;
import org.apache.commons.lang.RandomStringUtils;

public interface MainPage
extends InteractivePage {
    public static final Log logger = LogFactory.getLog(MainPage.class);

    default public void dispatchMsg(IFormView currView, CommandParam cmd) {
        FormViewPluginProxy currProxy = (FormViewPluginProxy)currView.getService(FormViewPluginProxy.class);
        IPageCache pageCache = null;
        for (IFormPlugin pl : currProxy.getPlugIns()) {
            if (!AbstractFormPlugin.class.isAssignableFrom(pl.getClass())) continue;
            pageCache = ((AbstractFormPlugin)pl).getPageCache();
        }
        if (pageCache == null) {
            return;
        }
        Map<String, String> map = this.getPagePool(pageCache);
        map.put(currView.getPageId(), currView.getFormShowParameter().getFormId());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String pageId;
            IFormView pageView;
            if (entry.getValue().equals(cmd.getSender()) || StringUtils.isNotEmpty((String)cmd.getReceiver()) && !cmd.getReceiver().equals(entry.getValue()) || (pageView = currView.getView(pageId = entry.getKey())) == null) continue;
            FormViewPluginProxy proxy = (FormViewPluginProxy)pageView.getService(FormViewPluginProxy.class);
            PageListenerRegister register = this.getListener(pageCache);
            proxy.getPlugIns().forEach(e -> {
                if (InteractivePage.class.isAssignableFrom(e.getClass())) {
                    if (cmd.isModule()) {
                        if (register.check(cmd.getParam().get(0).toString(), cmd.getParam().get(1).toString(), cmd.getOperation())) {
                            try {
                                Method method = e.getClass().getDeclaredMethod(cmd.getOperation(), cmd.getParam().get(2).getClass());
                                method.invoke(e, cmd.getParam().get(2));
                            }
                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    } else if (cmd.isReFlect()) {
                        try {
                            Class[] classes = new Class[cmd.getParam().size()];
                            for (int i = 0; i < cmd.getParam().size(); ++i) {
                                classes[i] = cmd.getParam().get(i).getClass();
                            }
                            Method method = e.getClass().getDeclaredMethod(cmd.getOperation(), classes);
                            method.invoke(e, cmd.getParam().toArray());
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    } else {
                        ((InteractivePage)e).dealMsg(cmd);
                    }
                }
            });
            currView.sendFormAction(pageView);
        }
    }

    @Override
    default public void sendMsg(IFormView currView, CommandParam cmd) {
        this.dispatchMsg(currView, cmd);
    }

    default public void cachePageId(IPageCache pageCache, String formId, String pageId) {
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
    }

    default public Map<String, String> getPagePool(IPageCache pageCache) {
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        return map;
    }

    default public String getPageIdAndCache(IPageCache pageCache, String formId) {
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
        return pageId;
    }
}

