/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.params;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;

public class ParamServiceHelper {
    public static final String PARAMS_CACHE = "eb_param_cache";
    private static final String EPM_PARAMS_CACHE = "epm_param_cache";
    public static final String BCS_SERVICE_APP_ID = "BCS_SERVICE_APPID";

    public static String queryParam(String paramKey, String defaultValue) {
        HashMap EPM_PARAMS = Maps.newHashMap();
        String paramJson = Cache.get().get(EPM_PARAMS_CACHE);
        if (StringUtils.isEmpty(paramJson)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid,fnumber,fvalue from t_eb_param", new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)"queryEpmParamSetting", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        EPM_PARAMS.put(row.getString("fnumber"), row.getString("fvalue"));
                    }
                }
            }
            paramJson = SerializationUtils.toJsonString((Object)EPM_PARAMS);
            Cache.get().set(EPM_PARAMS_CACHE, paramJson, 5, TimeUnit.MINUTES);
        } else {
            Map _paramMap = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
            if (_paramMap != null) {
                EPM_PARAMS.putAll(_paramMap);
            }
        }
        String _value = (String)EPM_PARAMS.get(paramKey);
        if (StringUtils.isEmpty(_value)) {
            _value = defaultValue;
        }
        return _value;
    }
}

