/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.enums.DataPermDataTypeEnum;
import kd.epm.eb.common.enums.DataPermTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.tree.model.DataPermTreeNode;
import kd.epm.eb.common.tree.model.PermDataNodeTreeBuilder;

public class BgmdDataPermUpdateUtil {
    private Map<Long, String> dimIdMapNumber = new HashMap<Long, String>();
    private List<Object[]> toSavePermRecordObjs = new ArrayList<Object[]>();
    private DBRoute dbRoute = new DBRoute("EPM");
    private String permTable = "t_eb_dataperm";
    private Map<String, DataPermTreeNode> busModelTreeeByView = new HashMap<String, DataPermTreeNode>();
    private Map<Long, List<Long>> allDataSetIds = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> allLevel2AccountMembIds = new HashMap<Long, List<Long>>();

    private BgmdDataPermUpdateUtil() {
    }

    public static BgmdDataPermUpdateUtil getInstance() {
        return new BgmdDataPermUpdateUtil();
    }

    public void update() {
        if (!this.checkNeedUpdate()) {
            return;
        }
        Map<Long, Map<Long, Map<Long, Long>>> allBusModelInfoOfModel = this.getAllBusModelInfo();
        if (allBusModelInfoOfModel.isEmpty()) {
            return;
        }
        this.initDimNumberInfo(allBusModelInfoOfModel.values());
        this.initDataSetIds(allBusModelInfoOfModel.values());
        this.initLevel2Account();
        HashSet<Long> busModelRefDimIds = new HashSet<Long>();
        for (Map.Entry<Long, Map<Long, Map<Long, Long>>> busModelInfoEntry : allBusModelInfoOfModel.entrySet()) {
            Long modelId = busModelInfoEntry.getKey();
            Map<Long, Map<Long, Long>> busModelInfo = busModelInfoEntry.getValue();
            if (busModelInfo.isEmpty()) continue;
            for (Map.Entry<Long, Map<Long, Long>> busModelDimEntry : busModelInfo.entrySet()) {
                busModelRefDimIds.addAll(busModelDimEntry.getValue().keySet());
            }
            for (Long dimId : busModelRefDimIds) {
                DataPermTreeNode treeBase;
                DynamicInfoCollection dimPermInfo = this.getPermRecordOfDim(modelId, dimId);
                if (dimPermInfo.isEmpty() || (treeBase = this.getMembTreeOfBusModel(modelId, dimId, null, null)) == null) continue;
                for (DynamicInfoCollection.InfoObject userPermInfo : dimPermInfo.getValues()) {
                    Long userId = (Long)userPermInfo.getValueByPropName("userId");
                    String userType = (String)userPermInfo.getValueByPropName("userType");
                    Map<Long, List<Integer>> allMembPerm = this.fillPermRecordToMembTree((Map)userPermInfo.getValueByPropName("membPermRecord"), treeBase);
                    for (Map.Entry<Long, Map<Long, Long>> busModelDimEntry : busModelInfo.entrySet()) {
                        Long busModelId;
                        DataPermTreeNode treeBus;
                        Long viewId = busModelDimEntry.getValue().get(dimId);
                        if (viewId == null || (treeBus = this.getMembTreeOfBusModel(modelId, dimId, viewId, busModelId = busModelDimEntry.getKey())) == null) continue;
                        this.fillAndSelectPermRecordToSave(allMembPerm, treeBus, dimId, modelId, userId, userType, busModelId);
                    }
                }
                this.checkAndSavePermRecord(false);
            }
            busModelRefDimIds.clear();
            this.busModelTreeeByView.clear();
        }
        this.checkAndSavePermRecord(true);
        this.deleteOldPerm(allBusModelInfoOfModel);
    }

    public void deleteOldPerm(Map<Long, Map<Long, Map<Long, Long>>> allBusModelInfoOfModel) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from t_eb_dataperm where fmodel in (");
        allBusModelInfoOfModel.keySet().forEach(modelId -> sb.append(modelId).append(','));
        sb.setCharAt(sb.length() - 1, ')');
        sb.append(" and fbusinessmodel = 0");
        sb.append(" and fpermission in (7,-7,11,-11,13,-13)");
        DB.execute((DBRoute)this.dbRoute, (String)sb.toString());
    }

    private boolean checkNeedUpdate() {
        String sql = "select top 1 fid from " + this.permTable + " where fbusinessmodel != 0";
        try (DataSet dataSet = DB.queryDataSet((String)"initDimTreeModel", (DBRoute)this.dbRoute, (String)sql);){
            if (dataSet.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private DataPermTreeNode getMembTreeOfBusModel(Long modelId, Long dimensionId, Long viewId, Long busModelId) {
        DataPermTreeNode treeNode;
        String dimNum = this.dimIdMapNumber.get(dimensionId);
        if (dimNum == null) {
            return null;
        }
        boolean isAccount = dimNum.equals(SysDimensionEnum.Account.getNumber());
        if (viewId != null) {
            treeNode = this.busModelTreeeByView.get(dimNum + viewId);
            if (treeNode == null) {
                treeNode = PermDataNodeTreeBuilder.buildTreeNew(modelId, dimNum, dimensionId, viewId);
                this.busModelTreeeByView.put(dimNum + viewId, treeNode);
            }
            if (treeNode != null && isAccount) {
                DataPermTreeNode accountRootNode = new DataPermTreeNode(treeNode.getId(), treeNode.getName(), treeNode.getNumber());
                List<Long> dataSetIds = this.allDataSetIds.get(busModelId);
                ArrayList accountIds = new ArrayList();
                if (dataSetIds != null) {
                    dataSetIds.forEach(dataSetId -> {
                        if (this.allLevel2AccountMembIds.containsKey(dataSetId)) {
                            accountIds.addAll(this.allLevel2AccountMembIds.get(dataSetId));
                        }
                    });
                }
                treeNode.getChildren().forEach(level2Child -> {
                    if (accountIds.contains(level2Child.getId())) {
                        accountRootNode.getChildren().add((DataPermTreeNode)level2Child);
                    }
                });
                treeNode = accountRootNode;
            }
        } else {
            treeNode = PermDataNodeTreeBuilder.buildTreeNew(modelId, dimNum, dimensionId, viewId);
        }
        return treeNode;
    }

    private Map<Long, List<Integer>> fillPermRecordToMembTree(Map<Long, List<Integer>> permRecord, DataPermTreeNode treeNode) {
        List<Integer> rootNodePerm = permRecord.get(treeNode.getId());
        ArrayList<DataPermTypeEnum> permTypes = new ArrayList<DataPermTypeEnum>(2);
        permTypes.add(DataPermTypeEnum.READ);
        permTypes.add(DataPermTypeEnum.WRITE);
        DimMembPermUtil.setRootNodePermInfo(rootNodePerm, treeNode, permTypes, null);
        DimMembPermUtil.fillMembPermInfo(permRecord, new HashMap<String, List<Integer>>(), treeNode, null);
        HashMap<Long, List<Integer>> allMembPerm = new HashMap<Long, List<Integer>>();
        treeNode.iterate(20, memb -> allMembPerm.put(memb.getId(), memb.getPermNums()));
        return allMembPerm;
    }

    private void fillAndSelectPermRecordToSave(Map<Long, List<Integer>> permInfo, DataPermTreeNode treeNode, Long dimensionId, Long modelId, Long userId, String userType, Long busModelId) {
        treeNode.iterate(20, memb -> {
            ArrayList<Integer> membPerm = (ArrayList<Integer>)permInfo.get(memb.getId());
            if (membPerm == null) {
                membPerm = new ArrayList<Integer>();
                membPerm.add(DataPermTypeEnum.NOWRITE.getPermNum());
                membPerm.add(DataPermTypeEnum.NOREAD.getPermNum());
                permInfo.put(memb.getId(), membPerm);
            }
            memb.setPermNums((List<Integer>)membPerm);
        });
        this.dealRootNodePermObj(treeNode, SysDimensionEnum.getMemberTreemodelByNumber(this.dimIdMapNumber.get(dimensionId)), modelId, userId, userType, dimensionId, busModelId);
        this.dealPermObj4Save(treeNode, SysDimensionEnum.getMemberTreemodelByNumber(this.dimIdMapNumber.get(dimensionId)), modelId, userId, userType, dimensionId, busModelId);
    }

    public void dealPermObj4Save(DataPermTreeNode rootNode, String membEntity, Long modelId, Long userId, String userType, Long dimensionId, Long bizModel) {
        List<Integer> pPermNums = rootNode.getPermNums();
        List<Integer> childPermNums = null;
        if (rootNode.getChildren() != null) {
            for (DataPermTreeNode childNode : rootNode.getChildren()) {
                childPermNums = childNode.getPermNums();
                for (int permNum : pPermNums) {
                    if (!childPermNums.contains(-permNum)) continue;
                    this.toSavePermRecordObjs.add(new Object[]{DBServiceHelper.genGlobalLongId(), -permNum, membEntity, DataPermDataTypeEnum.MEMBER.getDataTypeNum(), childNode.getId(), userId, modelId, userType, dimensionId, 1, bizModel});
                }
                this.dealPermObj4Save(childNode, membEntity, modelId, userId, userType, dimensionId, bizModel);
            }
        }
        rootNode.setPermNums(null);
    }

    private void dealRootNodePermObj(DataPermTreeNode rootNode, String membEntity, Long modelId, Long userId, String userType, Long dimensionId, Long bizModel) {
        List<Integer> pPermNums = rootNode.getPermNums();
        if (!pPermNums.isEmpty()) {
            for (int permNum : pPermNums) {
                if (permNum <= 0) continue;
                this.toSavePermRecordObjs.add(new Object[]{DBServiceHelper.genGlobalLongId(), permNum, membEntity, DataPermDataTypeEnum.MEMBER.getDataTypeNum(), rootNode.getId(), userId, modelId, userType, dimensionId, 1, bizModel});
            }
        }
    }

    private void checkAndSavePermRecord(boolean isLast) {
        if (isLast && this.toSavePermRecordObjs.size() > 0 || this.toSavePermRecordObjs.size() > 10000) {
            String sqlStr = "insert into t_eb_dataperm (fid,fpermission,fmembertype,fdatatype,fmember,FUSERSID,fmodel,fusertype,fdimension,fisconfer,fbusinessmodel) values (?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)new DBRoute("EPM"), (String)sqlStr, this.toSavePermRecordObjs);
            this.toSavePermRecordObjs.clear();
        }
    }

    private DynamicInfoCollection getPermRecordOfDim(Long modelId, Long dimemsionId) {
        DynamicInfoCollection permInfo = new DynamicInfoCollection("allPermInfoOfOneDim", "userId", "userType", "membPermRecord");
        String sql = "select fpermission,fmember,fusersid,fusertype from t_eb_dataperm where fdimension = ? and fmodel = ? and fpermission in (?,?,?,?)";
        try (DataSet dataSet = DB.queryDataSet((String)"initDimTreeModel", (DBRoute)this.dbRoute, (String)sql, (Object[])new Object[]{dimemsionId, modelId, DataPermTypeEnum.READ.getPermNum(), DataPermTypeEnum.WRITE.getPermNum(), DataPermTypeEnum.NOREAD.getPermNum(), DataPermTypeEnum.NOWRITE.getPermNum()});){
            for (Row row : dataSet) {
                Long memberId;
                Map membPermRecord;
                ArrayList<Integer> permNums;
                Long userId = row.getLong("fusersid");
                DynamicInfoCollection.InfoObject permInfoOfUser = permInfo.getInfoByOneProp("userId", userId);
                if (permInfoOfUser == null) {
                    permInfoOfUser = permInfo.addInfo(userId, row.getString("fuserType"), new HashMap());
                }
                if ((permNums = (ArrayList<Integer>)(membPermRecord = (Map)permInfoOfUser.getValueByPropName("membPermRecord")).get(memberId = row.getLong("fmember"))) == null) {
                    permNums = new ArrayList<Integer>(2);
                    membPermRecord.put(memberId, permNums);
                }
                permNums.add(row.getInteger("fpermission"));
            }
        }
        return permInfo;
    }

    public Map<Long, Map<Long, Map<Long, Long>>> getAllBusModelInfo() {
        HashMap<Long, Map<Long, Map<Long, Long>>> allBusModelInfoOfModel = new HashMap<Long, Map<Long, Map<Long, Long>>>();
        Set<Long> bgmdModelIds = this.getBgmdModelIds();
        String sql = "select A.fid,A.fmodelid,B.FDIMENSIONID,B.FVIEWID,C.fsource from t_eb_businessmodel A LEFT JOIN  t_eb_viewentry B on A.fid = B.fid LEFT JOIN t_eb_dimensionview C on B.FVIEWID = C.fid";
        try (DataSet dataSet = DB.queryDataSet((String)"initDimTreeModel", (DBRoute)this.dbRoute, (String)sql);){
            for (Row row : dataSet) {
                Long dimensionId;
                Long busModelId;
                HashMap<Long, Long> allRefDimAndView;
                Long modelId = row.getLong("fmodelid");
                if (!bgmdModelIds.contains(modelId)) continue;
                HashMap allDimInfoOfBusModel = (HashMap)allBusModelInfoOfModel.get(modelId);
                if (allDimInfoOfBusModel == null) {
                    allDimInfoOfBusModel = new HashMap();
                    allBusModelInfoOfModel.put(modelId, allDimInfoOfBusModel);
                }
                if ((allRefDimAndView = (HashMap<Long, Long>)allDimInfoOfBusModel.get(busModelId = row.getLong("fid"))) == null) {
                    allRefDimAndView = new HashMap<Long, Long>();
                    allDimInfoOfBusModel.put(busModelId, allRefDimAndView);
                }
                Long viewId = row.getLong("FVIEWID");
                Integer viewSource = row.getInteger("fsource");
                if (!viewId.equals(0L)) {
                    if (viewSource == null) continue;
                    viewId = 0L;
                }
                if ((dimensionId = row.getLong("FDIMENSIONID")).equals(0L)) continue;
                allRefDimAndView.put(dimensionId, viewId);
            }
        }
        return allBusModelInfoOfModel;
    }

    private Set<Long> getBgmdModelIds() {
        HashSet<Long> modelIds = new HashSet<Long>(16);
        String sql = "select fid from t_eb_model where freporttype = '7'";
        try (DataSet dataSet = DB.queryDataSet((String)"initDimTreeModel", (DBRoute)this.dbRoute, (String)sql);){
            for (Row row : dataSet) {
                modelIds.add(row.getLong("fid"));
            }
        }
        return modelIds;
    }

    private void initDimNumberInfo(Collection<Map<Long, Map<Long, Long>>> busModelInfo) {
        HashSet allDimIds = new HashSet();
        busModelInfo.forEach(busmDimInfo -> busmDimInfo.values().forEach(refDimInfo -> allDimIds.addAll(refDimInfo.keySet())));
        StringBuilder sql = new StringBuilder("select Fid,Fnumber from t_eb_dimension where fid in(");
        for (int i = 0; i < allDimIds.size(); ++i) {
            sql.append('?').append(',');
        }
        sql.setCharAt(sql.length() - 1, ')');
        try (DataSet dataSet = DB.queryDataSet((String)"initDimTreeModel", (DBRoute)this.dbRoute, (String)sql.toString(), (Object[])allDimIds.toArray());){
            for (Row row : dataSet) {
                this.dimIdMapNumber.put(row.getLong("Fid"), row.getString("Fnumber"));
            }
        }
    }

    private void initDataSetIds(Collection<Map<Long, Map<Long, Long>>> busModelInfo) {
        ArrayList allBusModelId = new ArrayList();
        busModelInfo.forEach(busmDimInfo -> allBusModelId.addAll(busmDimInfo.keySet()));
        StringBuilder sb = new StringBuilder("select fid,fbizmodelid from t_eb_dataset where fbizmodelid in (");
        for (int i = 0; i < allBusModelId.size(); ++i) {
            sb.append('?').append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)this.dbRoute, (String)sb.toString(), (Object[])allBusModelId.toArray());){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long busModelId = row.getLong("fbizmodelid");
                List<Long> dataSetIds = this.allDataSetIds.get(busModelId);
                if (dataSetIds == null) {
                    dataSetIds = new ArrayList<Long>();
                    this.allDataSetIds.put(busModelId, dataSetIds);
                }
                dataSetIds.add(row.getLong("fid"));
            }
        }
    }

    private void initLevel2Account() {
        StringBuilder sb = new StringBuilder("select fid,fdataset from t_eb_StructOfAccount where flevel = 2 and fdataset in (");
        ArrayList allDataSetId = new ArrayList();
        this.allDataSetIds.forEach((busModelId, datasetIds) -> allDataSetId.addAll(datasetIds));
        for (int i = 0; i < allDataSetId.size(); ++i) {
            sb.append('?').append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        try (DataSet ds = DB.queryDataSet((String)"getLevel2AccountIdByDataset", (DBRoute)this.dbRoute, (String)sb.toString(), (Object[])allDataSetId.toArray());){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long dataSetId = row.getLong("fdataset");
                List<Long> accountIds = this.allLevel2AccountMembIds.get(dataSetId);
                if (accountIds == null) {
                    accountIds = new ArrayList<Long>();
                    this.allLevel2AccountMembIds.put(dataSetId, accountIds);
                }
                accountIds.add(row.getLong("fid"));
            }
        }
    }

    private void savePermRecordObj() {
    }
}

