/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import java.util.HashMap;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.IIgnoreMembCheck;
import kd.epm.eb.common.permission.IgnoreMembCheck4Account;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermTreeNode;

public class DimMembPermTreeUtil {
    public static DimMembPermTreeNode buildTree(Member root, boolean needLongNum, int userSize, Long bizCtrlRangeId) {
        if (root == null) {
            return null;
        }
        if (SysDimensionEnum.Account.getNumber().equals(root.getDimension().getNumber())) {
            IgnoreMembCheck4Account ignoreMembCheck = bizCtrlRangeId == null || bizCtrlRangeId.equals(0L) ? null : IgnoreMembCheck4Account.getInstance(bizCtrlRangeId);
            return DimMembPermTreeUtil.buildAccoutnTree(root, needLongNum, userSize, ignoreMembCheck);
        }
        return DimMembPermTreeUtil.buildTree(root, needLongNum, userSize);
    }

    private static DimMembPermTreeNode buildTree(Member root, boolean needLongNum, int userSize) {
        DimMembPermTreeNode rootNode = null;
        if (root != null) {
            rootNode = new DimMembPermTreeNode(root.getId(), root.getNumber(), root.getName(), userSize);
            rootNode.setGlobalSeq(root.getGlobalSeq());
            DimMembPermTreeUtil.setTreeNodeCustomData(rootNode, needLongNum, root);
            if (!root.isLeaf()) {
                for (Member childMemb : root.getChildrenNotWithCosmic()) {
                    DimMembPermTreeNode childNode = DimMembPermTreeUtil.buildTree(childMemb, needLongNum, userSize);
                    if (childNode == null) continue;
                    rootNode.addChild(childNode);
                }
            }
        }
        return rootNode;
    }

    private static DimMembPermTreeNode buildAccoutnTree(Member root, boolean needLongNum, int permSize, IIgnoreMembCheck ignoreMembCheck) {
        if (root == null) {
            return null;
        }
        DimMembPermTreeNode rootNode = new DimMembPermTreeNode(root.getId(), root.getNumber(), root.getName(), permSize);
        rootNode.setGlobalSeq(0);
        DimMembPermTreeUtil.setTreeNodeCustomData(rootNode, needLongNum, root);
        root.getChildren().forEach(memb -> {
            DimMembPermTreeNode childNode;
            if (!(ignoreMembCheck != null && ignoreMembCheck.ignore((Member)memb) || (childNode = DimMembPermTreeUtil.buildTree(memb, needLongNum, permSize)) == null)) {
                rootNode.addChild(childNode);
            }
        });
        return rootNode;
    }

    private static void setTreeNodeCustomData(DimMembPermTreeNode node, boolean needLongNum, Member member) {
        HashMap<String, Object> customData = new HashMap<String, Object>(3);
        customData.put("pid", member.getParentId());
        node.setDseq(member.getSeq());
        if (needLongNum) {
            customData.put("longNumber", member.getLongNumber());
        }
        node.setCustomData(customData);
    }

    public static DimMembPermTreeNode buildPermTree(int userSize, Long modelId, Long bizCtrlRangeId, String dimNum, Long viewId, PermGroupEnum permGroup) {
        if (modelId == null || bizCtrlRangeId == null || dimNum == null) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        if (permGroup == PermGroupEnum.DATA) {
            bizCtrlRangeId = DimMembPermUtil.switchBizModelId(bizCtrlRangeId, dimNum, modelId);
        }
        Member rootMemb = modelCacheHelper.getRootMember(dimNum, viewId);
        return DimMembPermTreeUtil.buildTree(rootMemb, false, userSize, bizCtrlRangeId);
    }
}

