/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AbstractDimension;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.AbstractView;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.perm.ContainResult;
import kd.epm.eb.common.cache.impl.perm.MemberRecord;
import kd.epm.eb.common.cache.impl.perm.PermCheckCallBackInfo;
import kd.epm.eb.common.cache.impl.perm.PermCheckResult;
import kd.epm.eb.common.cache.impl.perm.PermMemberItem;
import kd.epm.eb.common.cache.impl.perm.RefRowRecord;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.impl.perm.SinglePermInfo;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.DataPermTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermTreeUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.AccountMemberTree;
import kd.epm.eb.common.permission.pojo.DimMembPermTreeNode;
import kd.epm.eb.common.permission.pojo.MemberDKRJContext;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.permission.pojo.PermDataContext;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.permission.pojo.PermRowParseInfo;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.BooleanObj;
import kd.epm.eb.common.tree.model.DataPermTreeNode;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;

public class DimMembPermUtil {
    public static final byte dataPermVal = 12;

    public static DimMembPermTreeNode getPermTree(Long userId, Long modelId, Long bizCtrlRangeId, String dimNum, Long viewId, PermGroupEnum permGroup) {
        HashMap<String, Set<Long>> refViewIds = null;
        if (permGroup == PermGroupEnum.DATA) {
            bizCtrlRangeId = DimMembPermUtil.switchBizModelId(bizCtrlRangeId, dimNum, modelId);
            viewId = DimMembPermUtil.switchViewId(modelId, bizCtrlRangeId, dimNum, viewId);
        } else {
            refViewIds = new HashMap<String, Set<Long>>(16);
            refViewIds.put(dimNum, DimensionViewServiceHelper.getViewsByViewId(viewId));
        }
        DimMembPermTreeNode permTree = DimMembPermTreeUtil.buildPermTree(1, modelId, bizCtrlRangeId, dimNum, viewId, permGroup);
        if (permTree != null) {
            List<DimMembPermType> permTypes = DimMembPermType.getPermTypeListByGroup(permGroup);
            HashMap permVal = new HashMap(16);
            DimMembPermHelper.readMemberPerm(modelId, bizCtrlRangeId, Sets.newHashSet((Object[])new String[]{dimNum}), refViewIds, userId, permTypes, false, false, null, null, permInfo -> {
                MemberItem memberItem = permInfo.getMemberGroup().get(dimNum);
                if (memberItem != null) {
                    Byte aByte = (Byte)permVal.get(memberItem.getMemberId());
                    if (aByte == null) {
                        permVal.put(memberItem.getMemberId(), permInfo.getPermVal());
                    } else {
                        byte newPermVal = aByte;
                        for (DimMembPermType permType : permTypes) {
                            if (!permType.hasPerm(permInfo.getPermVal())) continue;
                            newPermVal = permType.setPermValue(newPermVal, true);
                        }
                        permVal.put(memberItem.getMemberId(), newPermVal);
                    }
                }
            });
            permTree.iterate(20, memberNode -> {
                Byte pVal = (Byte)permVal.get(memberNode.getMembId());
                if (pVal != null) {
                    memberNode.setPerm(0, pVal);
                }
            });
        }
        return permTree;
    }

    public static boolean hasPerm(byte allPermNum, DimMembPermType permType) {
        return (allPermNum & permType.getDivNum()) > 0;
    }

    public static byte setPermValue(byte allPermNum, DimMembPermType permType, boolean hasPerm) {
        allPermNum = hasPerm ? (byte)(allPermNum | permType.getDivNum()) : (byte)(allPermNum & ~permType.getDivNum());
        return allPermNum;
    }

    public static void delPermCtrlDimGroup(Long modelId, Set<String> dimShortNumStrs) {
        DynamicObject permDimGroupObj = BusinessDataServiceHelper.loadSingle((String)"eb_permdimgroup", (String)"entryentity.dimgroup", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (permDimGroupObj != null) {
            BooleanObj changed = new BooleanObj();
            List<Dimension> dimensionList = ModelCacheContext.getOrCreate(modelId).getDimensionList();
            permDimGroupObj.getDynamicObjectCollection("entryentity").removeIf(row -> {
                ArrayList<String> dimShortNums = new ArrayList<String>(16);
                HashSet dimIds = new HashSet(16);
                row.getDynamicObjectCollection("dimgroup").forEach(dim -> {
                    Long dimId = dim.getLong("fbasedataid_id");
                    dimIds.add(dimId);
                });
                dimensionList.forEach(dim -> {
                    if (dimIds.contains(dim.getId())) {
                        dimShortNums.add(dim.getShortNumber());
                    }
                });
                boolean contains = dimShortNumStrs.contains(DimMembPermUtil.getDimShortNumsStr(dimShortNums, false));
                if (contains) {
                    changed.mark(true);
                }
                return contains;
            });
            if (changed.marked()) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{permDimGroupObj});
            }
        }
    }

    public static List<PermDimGroup> getPermControlDimGroup(Long modelId) {
        ArrayList<PermDimGroup> result = new ArrayList<PermDimGroup>(10);
        DynamicObject permDimGroupObj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_permdimgroup", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (permDimGroupObj != null) {
            permDimGroupObj.getDynamicObjectCollection("entryentity").forEach(row -> {
                PermDimGroup permDimGroup = new PermDimGroup();
                permDimGroup.setName(row.getString("dimgroupname"));
                ArrayList<String> dimShortNums = new ArrayList<String>(16);
                HashSet dimIds = new HashSet(16);
                row.getDynamicObjectCollection("dimgroup").forEach(dim -> dimIds.add(dim.getLong("fbasedataid_id")));
                ModelCacheContext.getOrCreate(modelId).getDimensionList().forEach(dimension -> {
                    if (dimIds.contains(dimension.getId())) {
                        dimShortNums.add(dimension.getShortNumber());
                        permDimGroup.getDimGroup().add(new BasedataPojo(dimension.getId(), dimension.getName(), dimension.getNumber()));
                    }
                });
                permDimGroup.setId(row.getLong("id"));
                permDimGroup.setDimShortNumStr(DimMembPermUtil.getDimShortNumsStr(dimShortNums, false));
                result.add(permDimGroup);
            });
        }
        return result;
    }

    public static Set<String> getRefDimShortNums(Collection<Long> dimensionIds, Long modelId, boolean needSingleDim) {
        Map dimObjs = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"shortnumber", (QFilter[])new QFilter("id", "in", dimensionIds).toArray());
        HashSet<String> result = new HashSet<String>(16);
        if (dimObjs != null) {
            List<PermDimGroup> permControlDimGroup;
            if (needSingleDim) {
                dimObjs.values().forEach(obj -> result.add(DimMembPermUtil.getDimShortNumsStr(obj.getString("shortnumber"))));
            }
            if ((permControlDimGroup = DimMembPermUtil.getPermControlDimGroup(modelId)).size() > 0) {
                Set<Object> dimIds = dimensionIds instanceof Set ? (Set<Object>)dimensionIds : new HashSet<Long>(dimensionIds);
                block0: for (PermDimGroup permDimGroup : permControlDimGroup) {
                    for (BasedataPojo dimPojo : permDimGroup.getDimGroup()) {
                        if (!dimIds.contains(dimPojo.getId())) continue;
                        result.add(permDimGroup.getDimShortNumStr());
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public static Set<String> getRefDimShortNums(Collection<Long> dimensionIds, Long modelId) {
        return DimMembPermUtil.getRefDimShortNums(dimensionIds, modelId, true);
    }

    public static List<PermDimGroup> getPermControlDimGroup(Long modelId, Long bizModelId) {
        List<PermDimGroup> result = DimMembPermUtil.getPermControlDimGroup(modelId);
        if (result.size() > 0 && IDUtils.isNotEmptyLong(bizModelId).booleanValue()) {
            Set dimNums = ModelCacheContext.getOrCreate(modelId).getDimensionListByBusModel(bizModelId).stream().map(AbstractTree::getDimNum).collect(Collectors.toSet());
            result.removeIf(group -> {
                List<BasedataPojo> dimGroup = group.getDimGroup();
                for (BasedataPojo dim : dimGroup) {
                    if (dimNums.contains(dim.getNumber())) continue;
                    return true;
                }
                return false;
            });
        }
        return result;
    }

    public static List<Dimension> getPermControlDim(Long modelId) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(10);
        if (IDUtils.isEmptyLong(modelId).booleanValue()) {
            return dimensions;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_permcontroldim", (String)"model,permcontroldim", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            String permControlDim = dynamicObject.getString("permcontroldim");
            if (StringUtils.isBlank((CharSequence)permControlDim)) {
                return dimensions;
            }
            String[] split = permControlDim.split("!");
            for (int i = 0; i < split.length; ++i) {
                Dimension dimension = modelCache.getDimension(split[i]);
                if (dimension == null) continue;
                dimensions.add(dimension);
            }
        } else {
            Dimension dimension = modelCache.getDimension("Entity");
            dimensions.add(dimension);
        }
        return dimensions;
    }

    public static boolean needCheckDataPerm(String dimNum, Long modelId) {
        List<Dimension> permControlDim = DimMembPermUtil.getPermControlDim(modelId);
        for (Dimension dimension : permControlDim) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            return true;
        }
        return false;
    }

    public static boolean needCheckDataPerm(List<String> dimNums, Long modelId) {
        if (dimNums == null) {
            return false;
        }
        if (dimNums.size() == 1) {
            List<Dimension> permControlDim = DimMembPermUtil.getPermControlDim(modelId);
            String dimNum = dimNums.get(0);
            for (Dimension dimension : permControlDim) {
                if (!dimension.getNumber().equals(dimNum)) continue;
                return true;
            }
        } else {
            List<PermDimGroup> controlDimGroup = DimMembPermUtil.getPermControlDimGroup(modelId);
            HashSet<String> dimNumsSet = new HashSet<String>(dimNums);
            for (PermDimGroup dimGroup : controlDimGroup) {
                int containsCount = 0;
                for (BasedataPojo dimObj : dimGroup.getDimGroup()) {
                    if (!dimNumsSet.contains(dimObj.getNumber())) continue;
                    ++containsCount;
                }
                if (containsCount != dimNumsSet.size()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNoManagerPermDim(String dimNum) {
        return DimMembPermHelper.noCheckDimsOnManPerm.contains(dimNum);
    }

    public static Long switchBizModelId(Long bizModelId, String dimensionNum, Long modelId) {
        if (bizModelId.equals(0L)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
            Model modelObj = modelCacheHelper.getModelobj();
            if (modelObj.isModelByNewEB()) {
                DynamicObject val = NewEbAppUtil.getDefaultObj("eb_businessmodel", modelId);
                if (val != null) {
                    bizModelId = val.getLong("id");
                }
            } else if (!modelObj.isModelByEB()) {
                Long defaultViewId = dimensionNum.equals(SysDimensionEnum.AuditTrail.getNumber()) || dimensionNum.equals(SysDimensionEnum.ChangeType.getNumber()) ? Long.valueOf(0L) : modelCacheHelper.getDefaultViewIdOnDim(dimensionNum);
                List<Long> bizModelIds = BusinessModelServiceHelper.getInstance().getRefBizModelIdsByViewId(defaultViewId, modelId);
                if (!bizModelIds.isEmpty()) {
                    bizModelId = bizModelIds.get(0);
                }
            }
        }
        return bizModelId;
    }

    @Deprecated
    public static Set<Long> getDimManagerHasPermMembIds(Long modelId, Long userId, String dimensionNum, boolean isVirtual) {
        return DimMembPermUtil.getDimManagerHasPermMembIds(modelId, userId, dimensionNum, null, isVirtual);
    }

    public static Set<Long> getDimManagerHasPermMembIds(Long modelId, Long userId, String dimensionNum, Long viewId, boolean isVirtual) {
        HashSet<Long> hasPermMembIds = new HashSet<Long>();
        if (ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
            return null;
        }
        DimMembPermTreeNode permTree = DimMembPermUtil.getPermTree(userId, modelId, 0L, dimensionNum, viewId, PermGroupEnum.MANAGER);
        if (permTree != null) {
            if (isVirtual) {
                hasPermMembIds.add(permTree.getMembId());
                DimMembPermUtil.getVirtualTreeMembIds(permTree, hasPermMembIds, DimMembPermType.MANAGER, isVirtual);
            } else {
                DimMembPermUtil.getMembPermInfo(permTree, DimMembPermType.MANAGER, hasPermMembIds, new HashSet<Long>());
            }
        }
        return hasPermMembIds;
    }

    public static List<Member> delAccountMembByBusModel(List<Member> members, String dimNum, Long busModelId) {
        if (dimNum.equals(SysDimensionEnum.Account.getNumber()) && busModelId != null && !busModelId.equals(0L)) {
            ArrayList<Member> newMembs = new ArrayList<Member>(16);
            List<Long> dataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(busModelId);
            members.forEach(member -> {
                if (dataSetIds.contains(member.getDatasetId()) || member.getParentId().equals(0L)) {
                    newMembs.add((Member)member);
                }
            });
            return newMembs;
        }
        return members;
    }

    @Deprecated
    public static DimMembPermTreeNode getMembTreeNodeWithDataPerm(Long modelId, Long busModelId, Long userId, String dimensionNum) {
        return DimMembPermUtil.getMembTreeNodeWithDataPerm(modelId, busModelId, userId, dimensionNum, null);
    }

    public static DimMembPermTreeNode getMembTreeNodeWithDataPerm(Long modelId, Long busModelId, Long userId, String dimensionNum, Long viewId) {
        DimMembPermTreeNode rootNode;
        boolean hasAllPerm = false;
        if (ModelServiceHelper.isUserHasRootPermByModel(userId, modelId) || !DimMembPermUtil.needCheckDataPerm(dimensionNum, modelId)) {
            hasAllPerm = true;
        }
        if ((rootNode = DimMembPermUtil.getPermTree(userId, modelId, busModelId, dimensionNum, viewId, PermGroupEnum.DATA)) == null) {
            return rootNode;
        }
        if (hasAllPerm) {
            rootNode.iterate(20, node -> node.setPerm(0, (byte)12));
        } else {
            LinkedList<DimMembPermTreeNode> nodes = new LinkedList<DimMembPermTreeNode>();
            nodes.addAll(rootNode.getChildren());
            while (!nodes.isEmpty()) {
                DimMembPermTreeNode treeNode = (DimMembPermTreeNode)nodes.poll();
                if (!treeNode.hasPerm(DimMembPermType.READ)) {
                    treeNode.getParent().removeChild(treeNode);
                    treeNode.getChildren().forEach(childNode -> {
                        rootNode.addChild((DimMembPermTreeNode)childNode);
                        nodes.add((DimMembPermTreeNode)childNode);
                    });
                    continue;
                }
                treeNode.getChildren().forEach(childNode -> nodes.add((DimMembPermTreeNode)childNode));
            }
        }
        return rootNode;
    }

    private static void getVirtualTreeMembIds(DimMembPermTreeNode permTreeNode, Set<Long> membIds, DimMembPermType permType, boolean isVitual) {
        if (permTreeNode.getChildren() != null) {
            for (DimMembPermTreeNode child : permTreeNode.getChilds()) {
                boolean hasPerm = false;
                if (child.hasPerm(permType)) {
                    membIds.add(child.getMembId());
                    hasPerm = true;
                }
                if (isVitual && hasPerm) continue;
                DimMembPermUtil.getVirtualTreeMembIds(child, membIds, permType, isVitual);
            }
        }
    }

    private static void getMembPermInfo(DimMembPermTreeNode permTreeNode, DimMembPermType permType, Set<Long> hasPermMembIds, Set<Long> noPermMembIds) {
        boolean hasPerm = false;
        if (permTreeNode.hasPerm(permType)) {
            hasPerm = true;
            hasPermMembIds.add(permTreeNode.getMembId());
        }
        if (!hasPerm) {
            noPermMembIds.add(permTreeNode.getMembId());
        }
        if (permTreeNode.getChildren() != null) {
            for (DimMembPermTreeNode childNode : permTreeNode.getChildren()) {
                DimMembPermUtil.getMembPermInfo(childNode, permType, hasPermMembIds, noPermMembIds);
            }
        }
    }

    public static void fillMembPermInfo(Map<Long, List<Integer>> membPermMap, Map<String, List<Integer>> sharedMembPermMap, DataPermTreeNode root, Long userId) {
        List<Integer> parentPerms = root.getPermNums();
        List<Integer> childPerms = null;
        for (DataPermTreeNode childNode : root.getChilds()) {
            if (!sharedMembPermMap.isEmpty() && childNode.isShareNode()) continue;
            childPerms = membPermMap.get(childNode.getId());
            if (childPerms == null) {
                childPerms = new ArrayList<Integer>();
            }
            for (int permNum : parentPerms) {
                if (childPerms.contains(-permNum) || childPerms.contains(permNum)) continue;
                if (userId != null && !root.isShareNode() && childNode.getDetailData().get("creator").equals(userId)) {
                    childPerms.add(permNum > 0 ? permNum : -permNum);
                    continue;
                }
                childPerms.add(permNum);
            }
            if (!sharedMembPermMap.isEmpty() && sharedMembPermMap.containsKey(childNode.getNumber())) {
                sharedMembPermMap.put(childNode.getNumber(), childPerms);
            }
            childNode.setPermNums(childPerms);
            membPermMap.remove(childNode.getId());
            if (childNode.getChildren() == null) continue;
            DimMembPermUtil.fillMembPermInfo(membPermMap, sharedMembPermMap, childNode, userId);
        }
    }

    public static void setRootNodePermInfo(List<Integer> rootNodePerm, DataPermTreeNode root, List<DataPermTypeEnum> permTypes, Long userId) {
        if (rootNodePerm == null) {
            rootNodePerm = new ArrayList<Integer>();
        }
        DimMembPermUtil.removeRepetitivePerm(rootNodePerm);
        for (DataPermTypeEnum type : permTypes) {
            if (rootNodePerm.contains(type.getPermNum()) || rootNodePerm.contains(-type.getPermNum())) continue;
            if (userId != null && root.getDetailData().get("creator").equals(userId)) {
                rootNodePerm.add(type.getPermNum());
                continue;
            }
            rootNodePerm.add(-type.getPermNum());
        }
        root.setPermNums(rootNodePerm);
    }

    private static void removeRepetitivePerm(List<Integer> permNums) {
        if (permNums != null && !permNums.isEmpty()) {
            List collect = permNums.stream().distinct().collect(Collectors.toList());
            permNums.clear();
            permNums.addAll(collect);
        }
    }

    public static long getUserId() {
        return UserUtils.getUserId();
    }

    public static Boolean isPassCheckPerm(String dimNum, Long modelId) {
        long userId = DimMembPermUtil.getUserId();
        Boolean isPass = false;
        Boolean isHasRootPerm = ModelServiceHelper.isUserHasRootPermByModel(userId, modelId);
        Boolean isNeedCheckDataPerm = DimMembPermUtil.needCheckDataPerm(dimNum, modelId);
        if (isHasRootPerm.booleanValue() || !isNeedCheckDataPerm.booleanValue()) {
            isPass = true;
        }
        return isPass;
    }

    public static void parsePermRecord(String dimShortNumStr, Map<Long, List<RowRecord>> rowRecords, List<MemberTree> dimTrees, MemberPropCache memberPropCache, List<DimMembPermType> permTypes, boolean parseAllGroup, Map<String, Set<Long>> filterMemberIds, Consumer<PermCheckResult> memberGroupConsumer) {
        boolean singleDim;
        if (rowRecords == null) {
            return;
        }
        boolean bl = singleDim = dimTrees.size() == 1;
        if (singleDim) {
            DimMembPermUtil.parseSingleDimPermRecord(dimShortNumStr, dimTrees.get(0), rowRecords, memberPropCache, permTypes, parseAllGroup, filterMemberIds, memberGroupConsumer);
        } else {
            DimMembPermUtil.parseMulDimPermRecord(dimShortNumStr, rowRecords, dimTrees, memberPropCache, permTypes, parseAllGroup, filterMemberIds, memberGroupConsumer);
        }
    }

    public static void parseMulDimPermRecord(String dimShortNumStr, Map<Long, List<RowRecord>> rowRecords, List<MemberTree> dimTrees, MemberPropCache memberPropCache, List<DimMembPermType> permTypes, boolean parseAllGroup, Map<String, Set<Long>> filterMemberIds, Consumer<PermCheckResult> memberGroupConsumer) {
        PermDataContext permDataContext = new PermDataContext(dimShortNumStr, rowRecords, dimTrees, memberPropCache, permTypes, parseAllGroup);
        Map<Long, Map<Long, List<RefRowRecord>>> allRefRowRecords = DimMembPermUtil.buildRefPermRecordOnRow(permDataContext);
        Count descartesCount = new Count(1);
        ArrayList<List<PermMemberItem>> allMember = new ArrayList<List<PermMemberItem>>(dimTrees.size());
        for (Map.Entry<Long, List<RowRecord>> entry : rowRecords.entrySet()) {
            int rowRecordIndex = -1;
            for (RowRecord currentRowRecord : entry.getValue()) {
                ++rowRecordIndex;
                List<MemberRecord> memberRecords = currentRowRecord.getMemberRecords();
                boolean containsChild = DimMembPermType.DATAPERMEXTENDS.hasPerm(currentRowRecord.getPermVal());
                boolean containNotDataPerm = permDataContext.isHasNotDataPermType() && DimMembPermType.hasNotDataPerm(currentRowRecord.getPermVal());
                descartesCount.setCount(1);
                int ignorePermTypeCount = 0;
                for (DimMembPermType permType : permTypes) {
                    if (permType.hasPerm(currentRowRecord.getPermVal())) continue;
                    ++ignorePermTypeCount;
                }
                if (ignorePermTypeCount == permTypes.size() || !DimMembPermUtil.selAllDimMember(memberRecords, dimTrees, containsChild, containNotDataPerm, memberPropCache, descartesCount, allMember, null, filterMemberIds)) continue;
                Map<Long, List<RefRowRecord>> refRowRecords = allRefRowRecords.get(currentRowRecord.getRowId());
                PermRowParseInfo rowParseInfo = new PermRowParseInfo(refRowRecords, entry.getKey(), rowRecordIndex, currentRowRecord.getPermVal());
                DimMembPermUtil.parseMemberDKRJ(descartesCount.getCount(), dimTrees, allMember, memberContext -> {
                    if (!DimMembPermUtil.checkPreRowContains(permDataContext, rowParseInfo, memberContext.getGroupMembers())) {
                        DimMembPermUtil.parseDimMembGroup(permDataContext, rowParseInfo, memberContext, memberGroupConsumer);
                    }
                    return true;
                });
            }
        }
    }

    public static void parseSingleDimPermRecord(String dimShortNumStr, MemberTree memberTree, Map<Long, List<RowRecord>> rowRecords, MemberPropCache memberPropCache, List<DimMembPermType> permTypes, boolean parseAllGroup, Map<String, Set<Long>> filterMemberIds, Consumer<PermCheckResult> memberGroupConsumer) {
        String dimNum = memberTree.getDimNum();
        Set<Long> membersFilter = filterMemberIds == null ? null : filterMemberIds.get(dimNum);
        int userCount = rowRecords.size();
        byte allPermVal = 0;
        boolean hasGivePerm = false;
        for (DimMembPermType permType : permTypes) {
            allPermVal = permType.setPermValue(allPermVal, true);
            if (permType != DimMembPermType.GIVE) continue;
            hasGivePerm = true;
            break;
        }
        HashMap<Long, Byte> memberAllPermVal = new HashMap<Long, Byte>(16);
        LinkedList<Pair<Long, Map<Long, Byte>>> memberAllUserPermVal = new LinkedList<Pair<Long, Map<Long, Byte>>>();
        HashMap<Long, Long> allMembers = new HashMap<Long, Long>(16);
        HashSet<Long> allPropIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<RowRecord>> entry : rowRecords.entrySet()) {
            Long uId = entry.getKey();
            List<RowRecord> permRecordList = entry.getValue();
            --userCount;
            HashMap<Long, Byte> memberPermVal = new HashMap<Long, Byte>(16);
            for (RowRecord rowRecord : permRecordList) {
                MemberRecord memberRecord = rowRecord.getMemberRecords().get(0);
                if (memberRecord.isMember()) {
                    DimMembPermUtil.selMemberPermVal(rowRecord.getPermVal(), permTypes, memberRecord.getId(), memberTree.getMember(memberRecord.getId(), memberRecord.getViewId()), memberPermVal, allMembers);
                    continue;
                }
                if (memberPropCache == null) continue;
                Set<String> refMemberNums = memberPropCache.getRefMemberNums(dimNum, memberRecord.getId());
                for (String memberNum : refMemberNums) {
                    Member member = memberTree.getMember(memberNum);
                    if (member == null) continue;
                    DimMembPermUtil.selMemberPermVal(rowRecord.getPermVal(), permTypes, member.getId(), member, memberPermVal, allMembers);
                }
                if (!hasGivePerm) continue;
                DimMembPermUtil.selMemberPermVal(rowRecord.getPermVal(), permTypes, memberRecord.getId(), null, memberPermVal, allMembers);
                allPropIds.add(memberRecord.getId());
            }
            if (parseAllGroup) {
                if (memberPermVal.size() > 0) {
                    memberAllUserPermVal.add(new Pair<Long, HashMap<Long, Byte>>(uId, memberPermVal));
                }
                if (userCount != 0 || memberAllUserPermVal.size() <= 0) continue;
                DimMembPermUtil.pushMemberPermRecord(allMembers, allPropIds, memberAllUserPermVal, membersFilter, memberTree, dimNum, dimShortNumStr, memberGroupConsumer);
                continue;
            }
            if (rowRecords.size() == 1) {
                memberAllPermVal = memberPermVal;
            } else {
                DimMembPermUtil.mergePermRecord(memberPermVal, memberAllPermVal, membersFilter);
            }
            if (userCount != 0) continue;
            memberAllUserPermVal.add(new Pair<Long, HashMap<Long, Byte>>(uId, memberAllPermVal));
            DimMembPermUtil.pushMemberPermRecord(allMembers, allPropIds, memberAllUserPermVal, membersFilter, memberTree, dimNum, dimShortNumStr, memberGroupConsumer);
        }
    }

    private static void mergePermRecord(Map<Long, Byte> memberPermVal, Map<Long, Byte> memberAllPermVal, Set<Long> membersFilter) {
        for (Map.Entry<Long, Byte> permValEntry : memberPermVal.entrySet()) {
            Long memberId = permValEntry.getKey();
            byte permVal = permValEntry.getValue();
            if (membersFilter != null && !membersFilter.contains(memberId) || permVal == 0) continue;
            byte prePermVal = memberAllPermVal.getOrDefault(memberId, (byte)0);
            permVal = (byte)(permVal + prePermVal);
            memberAllPermVal.put(memberId, permVal);
        }
    }

    public static void pushMemberPermRecord(Map<Long, Long> allMembers, Set<Long> allPropIds, List<Pair<Long, Map<Long, Byte>>> memberAllUserPermVal, Set<Long> membersFilter, MemberTree memberTree, String dimNum, String dimShortNumStr, Consumer<PermCheckResult> memberGroupConsumer) {
        HashMap<String, MemberItem> memberMap = new HashMap<String, MemberItem>(1);
        for (Map.Entry<Long, Long> memberEntry : allMembers.entrySet()) {
            Member member;
            if (membersFilter != null && !membersFilter.contains(memberEntry.getKey()) || (member = memberTree.getMember(memberEntry.getKey(), memberEntry.getValue())) == null) continue;
            for (Pair<Long, Map<Long, Byte>> permValMap : memberAllUserPermVal) {
                Byte permVal = (Byte)((Map)permValMap.p2).get(member.getId());
                if (permVal == null) continue;
                DimMembPermUtil.pushMemberPermRecord(memberMap, memberTree, dimNum, dimShortNumStr, (Long)permValMap.p1, member.getId(), member, permVal, memberGroupConsumer);
            }
        }
        for (Long propId : allPropIds) {
            if (membersFilter != null && !membersFilter.contains(propId)) continue;
            for (Pair<Long, Map<Long, Byte>> permValMap : memberAllUserPermVal) {
                Byte permVal = (Byte)((Map)permValMap.p2).get(propId);
                if (permVal == null) continue;
                DimMembPermUtil.pushMemberPermRecord(memberMap, memberTree, dimNum, dimShortNumStr, (Long)permValMap.p1, propId, null, permVal, memberGroupConsumer);
            }
        }
    }

    public static void pushMemberPermRecord(Map<String, MemberItem> memberMap, MemberTree memberTree, String dimNum, String dimShortNumStr, Long uId, Long memberId, Member member, byte permVal, Consumer<PermCheckResult> memberGroupConsumer) {
        if (permVal != 0) {
            memberMap.clear();
            if (member == null) {
                member = memberTree.getMember(memberId);
            }
            if (member != null) {
                Long viewId = member.getViewOrDim() instanceof AbstractView ? member.getViewOrDim().getId() : null;
                memberMap.put(dimNum, new MemberItem(true, member.getId(), viewId, member.getGlobalSeq()));
            } else {
                memberMap.put(dimNum, new MemberItem(false, memberId, null, 0));
            }
            memberGroupConsumer.accept(new PermCheckResult(permVal, uId, memberMap, dimShortNumStr));
        }
    }

    public static void selMemberPermVal(byte permVal, List<DimMembPermType> permTypes, Long memberId, Member member, Map<Long, Byte> memberPermValMap, Map<Long, Long> allMembers) {
        for (DimMembPermType permType : permTypes) {
            boolean hasPerm = permType.hasPerm(permVal);
            if (!permType.isDataPerm() && !hasPerm) continue;
            if (member != null) {
                AbstractTree tree = member.getViewOrDim();
                Long viewId = tree instanceof AbstractView ? tree.getId() : null;
                allMembers.put(memberId, viewId);
                if (!permType.isDataPerm() || DimMembPermType.DATAPERMEXTENDS.hasPerm(permVal)) {
                    member.iterateNoRoot(child -> {
                        byte childPermVal = memberPermValMap.getOrDefault(child.getId(), (byte)0);
                        childPermVal = permType.setPermValue(childPermVal, hasPerm);
                        memberPermValMap.put(child.getId(), childPermVal);
                        allMembers.put(child.getId(), viewId);
                    });
                }
            }
            byte _permVal = memberPermValMap.getOrDefault(memberId, (byte)0);
            _permVal = permType.setPermValue(_permVal, hasPerm);
            memberPermValMap.put(memberId, _permVal);
        }
    }

    public static Map<Long, List<SinglePermInfo>> parseSingleDimPermBat(Long modelId, Long bizModelId, String dimNum, List<Long> refUserId, List<DimMembPermType> permTypes, boolean refGroup) {
        List<String> dimNums = Collections.singletonList(dimNum);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Map<String, Map<Long, List<RowRecord>>> allPermRecord = MembPermRecordUtil.getUsersPermRowRecords(modelCacheHelper, bizModelId, dimNums, refUserId, permTypes.get(0).getPermGroup(), refGroup, true, false);
        HashMap<Long, List<SinglePermInfo>> result = new HashMap<Long, List<SinglePermInfo>>(16);
        DimMembPermHelper.readMemberPerm(modelId, bizModelId, Collections.singleton(dimNum), 0L, permTypes, true, false, allPermRecord, DimMembPermUtil.getSingleDimPermConsumer(dimNum, result, permTypes));
        return result;
    }

    public static Consumer<PermCheckResult> getSingleDimPermConsumer(String dimNum, Map<Long, List<SinglePermInfo>> result, List<DimMembPermType> permTypes) {
        return permInfo -> {
            MemberItem memberItem = permInfo.getMemberGroup().get(dimNum);
            if (memberItem != null) {
                Long refUserGroup = permInfo.getRefUserGroup();
                ArrayList<SinglePermInfo> singlePermInfo = (ArrayList<SinglePermInfo>)result.get(refUserGroup);
                if (singlePermInfo != null) {
                    int index = 0;
                    for (SinglePermInfo pInfo : singlePermInfo) {
                        if (((DimMembPermType)((Object)((Object)permTypes.get(index)))).hasPerm(permInfo.getPermVal())) {
                            if (memberItem.isMember()) {
                                pInfo.getMemberPermVal().set(memberItem.getSeq(), true);
                            } else {
                                pInfo.addPermPropId(memberItem.getMemberId());
                            }
                        }
                        ++index;
                    }
                } else {
                    singlePermInfo = new ArrayList<SinglePermInfo>(permTypes.size());
                    for (DimMembPermType permType : permTypes) {
                        SinglePermInfo permInfo1 = new SinglePermInfo();
                        BitSet membPermInfo = new BitSet();
                        permInfo1.setMemberPermVal(membPermInfo);
                        if (permType == DimMembPermType.GIVE) {
                            permInfo1.setPermPropIds(new HashSet<Long>(16));
                        }
                        if (permType.hasPerm(permInfo.getPermVal())) {
                            if (memberItem.isMember()) {
                                permInfo1.getMemberPermVal().set(memberItem.getSeq(), true);
                            } else {
                                permInfo1.addPermPropId(memberItem.getMemberId());
                            }
                        }
                        singlePermInfo.add(permInfo1);
                    }
                    result.put(refUserGroup, singlePermInfo);
                }
            }
        };
    }

    public static List<SinglePermInfo> parseSingleDimPerm(Long modelId, Long bizModelId, String dimNum, List<Long> refUserId, List<DimMembPermType> permTypes) {
        String dimShortNumStr;
        List<String> dimNums = Collections.singletonList(dimNum);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Map<String, Map<Long, List<RowRecord>>> allPermRecord = MembPermRecordUtil.getUsersPermRowRecords(modelCacheHelper, bizModelId, dimNums, refUserId, permTypes.get(0).getPermGroup(), false, false, false);
        Map<Long, List<RowRecord>> rowRecords = allPermRecord.get(dimShortNumStr = DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNums, false));
        if (rowRecords != null && rowRecords.size() > 0) {
            ArrayList<SinglePermInfo> result = new ArrayList<SinglePermInfo>(permTypes.size());
            for (DimMembPermType permType : permTypes) {
                SinglePermInfo singlePermInfo = new SinglePermInfo();
                BitSet membPermInfo = new BitSet();
                singlePermInfo.setMemberPermVal(membPermInfo);
                if (permType == DimMembPermType.GIVE) {
                    singlePermInfo.setPermPropIds(new HashSet<Long>(16));
                }
                result.add(singlePermInfo);
            }
            DimMembPermHelper.readMemberPerm(modelId, bizModelId, Sets.newHashSet((Object[])new String[]{dimNum}), 0L, permTypes, allPermRecord, permCheckResult -> {
                MemberItem memberItem = permCheckResult.getMemberGroup().get(dimNum);
                if (memberItem != null) {
                    for (SinglePermInfo permInfo : result) {
                        if (memberItem.isMember()) {
                            permInfo.getMemberPermVal().set(memberItem.getSeq(), true);
                            continue;
                        }
                        permInfo.addPermPropId(memberItem.getMemberId());
                    }
                }
            });
            return result;
        }
        return null;
    }

    public static List<String> getDimNumsByShortStr(String dimShortNums, IModelCacheHelper modelCacheHelper) {
        if (kd.epm.eb.common.utils.StringUtils.isEmpty(dimShortNums)) {
            return new ArrayList<String>(0);
        }
        String[] shortNums = dimShortNums.split("!");
        ArrayList<String> dimNums = new ArrayList<String>(shortNums.length);
        Map<String, String> numberMap = modelCacheHelper.getDimensionList().stream().collect(Collectors.toMap(AbstractDimension::getShortNumber, BaseCache::getNumber));
        for (String shortNum : shortNums) {
            if (kd.epm.eb.common.utils.StringUtils.isEmpty(shortNum)) continue;
            String dimNum = numberMap.get(shortNum);
            if (dimNum == null) {
                return new ArrayList<String>(0);
            }
            dimNums.add(dimNum);
        }
        return dimNums;
    }

    public static String getDimShortNumsStr(IModelCacheHelper modelCacheHelper, List<String> dimNums, boolean like) {
        return DimMembPermUtil.getDimShortNumsStr(DimMembPermUtil.toShortNums(modelCacheHelper, dimNums), like);
    }

    public static List<String> toShortNums(IModelCacheHelper modelCacheHelper, List<String> dimNums) {
        ArrayList<String> dimSortNums = new ArrayList<String>(dimNums.size());
        HashSet<String> dimNumSet = new HashSet<String>(dimNums);
        modelCacheHelper.getDimensionList().forEach(dim -> {
            if (dimNumSet.contains(dim.getNumber())) {
                dimSortNums.add(dim.getShortNumber());
            }
        });
        if (dimSortNums.size() != dimNums.size()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7b80\u7801\u5b57\u7b26\u4e32\u8f6c\u6362\u5931\u8d25%1-%2", (String)"MembPermRecordUtil_1", (String)"epm-eb-common", (Object[])new Object[]{SerializationUtils.toJsonString(dimNums), SerializationUtils.toJsonString(dimSortNums)}));
        }
        return dimSortNums;
    }

    public static String getDimShortNumsStr(List<String> dimShortNums, boolean like) {
        StringBuilder sb = new StringBuilder();
        if (dimShortNums != null) {
            for (String dimShortNum : dimShortNums) {
                sb.append('!').append(dimShortNum).append('!');
                if (!like) continue;
                sb.append('%');
            }
            if (like) {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static String getDimShortNumsStr(String dimShortNum) {
        return "!" + dimShortNum + "!";
    }

    public static List<String> getDimShortNumsByStr(String dimShortNumStr, boolean needSign) {
        ArrayList<String> shortNums = new ArrayList<String>(16);
        int length = dimShortNumStr.length();
        StringBuilder sb = new StringBuilder();
        boolean matchSign = false;
        for (int seq = 0; seq < length; ++seq) {
            char word = dimShortNumStr.charAt(seq);
            if (word == '!') {
                if (needSign) {
                    sb.append(word);
                }
                if (matchSign) {
                    shortNums.add(sb.toString());
                    sb.setLength(0);
                    matchSign = false;
                    continue;
                }
                matchSign = true;
                continue;
            }
            sb.append(word);
        }
        return shortNums;
    }

    public static boolean isMultiDim(String dimShortDimStr) {
        return dimShortDimStr != null && dimShortDimStr.contains("!!");
    }

    public static boolean hasNotDataPermType(List<DimMembPermType> permTypes) {
        boolean hasNotDataPermType = false;
        for (DimMembPermType permType : permTypes) {
            if (permType.isDataPerm()) continue;
            hasNotDataPermType = true;
            break;
        }
        return hasNotDataPermType;
    }

    public static boolean selAllDimMember(List<MemberRecord> memberRecords, List<MemberTree> dimTrees, boolean containsChild, boolean containNotDataPerm, MemberPropCache memberPropCache, Count descartesCount, List<List<PermMemberItem>> allMember, Map<String, PermMemberItem> repMemberItems, Map<String, Set<Long>> memberFilter) {
        HashSet<Long> existIds = new HashSet<Long>(16);
        if (allMember.isEmpty()) {
            for (int i = 0; i < dimTrees.size(); ++i) {
                allMember.add(new ArrayList(16));
            }
        }
        for (int i = 0; i < dimTrees.size() && i < allMember.size(); ++i) {
            PermMemberItem repMemberItem;
            MemberRecord memberRecord = memberRecords.get(i);
            MemberTree dimTree = dimTrees.get(i);
            List<PermMemberItem> members = allMember.get(i);
            members.clear();
            PermMemberItem permMemberItem = repMemberItem = repMemberItems == null ? null : repMemberItems.get(dimTree.getDimNum());
            if (repMemberItem != null) {
                members.add(repMemberItem);
            } else {
                Member member;
                Set<Long> fMemberIds;
                Set<Long> set = fMemberIds = memberFilter == null ? null : memberFilter.get(dimTree.getDimNum());
                if (memberRecord.isMember()) {
                    member = dimTree.getMember(memberRecord.getId(), memberRecord.getViewId());
                    if (member == null) {
                        return false;
                    }
                    members.add(new PermMemberItem(true, member));
                    if (containsChild || containNotDataPerm) {
                        member.iterateNoRoot(memb -> members.add(new PermMemberItem(true, memb, !containsChild)));
                    }
                } else {
                    CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(memberRecord.getId());
                    if (propertyValue != null) {
                        Set<String> refMemberNums = memberPropCache.getRefMembers(dimTree.getDimNum(), propertyValue.getProp().getNumber(), propertyValue.getNumber());
                        if (refMemberNums != null && !refMemberNums.isEmpty()) {
                            for (String membNum : refMemberNums) {
                                member = dimTree.getMember(membNum);
                                if (member == null) continue;
                                if (!existIds.contains(member.getId())) {
                                    members.add(new PermMemberItem(true, member));
                                }
                                if (!containNotDataPerm) continue;
                                existIds.add(member.getId());
                                member.iterate(memb -> {
                                    if (existIds.add(memb.getId())) {
                                        members.add(new PermMemberItem(true, memb, true));
                                    }
                                });
                            }
                            existIds.clear();
                        }
                        if (containNotDataPerm) {
                            members.add(new PermMemberItem(false, propertyValue, true));
                        }
                    }
                    if (members.isEmpty()) {
                        return false;
                    }
                }
                if (fMemberIds != null) {
                    Iterator<PermMemberItem> iterator = members.iterator();
                    while (iterator.hasNext()) {
                        if (fMemberIds.contains(iterator.next().getId())) continue;
                        iterator.remove();
                    }
                }
            }
            descartesCount.setCount(descartesCount.getCount() * members.size());
        }
        return true;
    }

    public static void parseMemberDKRJ(int allCount, List<MemberTree> dimTrees, List<List<PermMemberItem>> allMember, Function<MemberDKRJContext, Boolean> memberGroupConsumer) {
        HashMap<String, PermMemberItem> memberMap = new HashMap<String, PermMemberItem>(dimTrees.size());
        int groupCount = 0;
        boolean ignoreDataPerm = false;
        while (allCount > groupCount) {
            String dimNum;
            List<PermMemberItem> members;
            int index;
            memberMap.clear();
            int count = 1;
            for (int i = dimTrees.size() - 1; i >= 0; --i) {
                index = groupCount / count;
                members = allMember.get(i);
                dimNum = dimTrees.get(i).getDimNum();
                PermMemberItem memberItem = members.get(index %= members.size());
                if (memberItem.isIgnoreDataPerm()) {
                    ignoreDataPerm = true;
                }
                memberMap.put(dimNum, memberItem);
                count *= members.size();
            }
            MemberDKRJContext memberPermInfo = new MemberDKRJContext(memberMap, 0L, 0L, ignoreDataPerm);
            memberPermInfo.setIgnoreDataPerm(ignoreDataPerm);
            if (!memberGroupConsumer.apply(memberPermInfo).booleanValue()) {
                return;
            }
            String removeDimNum = memberPermInfo.getRemoveDim();
            if (removeDimNum != null && dimTrees.size() > 1) {
                int delAllCount = 1;
                int dimIndex = 0;
                count = 1;
                ArrayList<Integer> passedIndex = new ArrayList<Integer>(dimTrees.size());
                boolean addOne = false;
                for (int i = dimTrees.size() - 1; i >= 0; --i) {
                    dimNum = dimTrees.get(i).getDimNum();
                    members = allMember.get(i);
                    index = groupCount / count;
                    index %= members.size();
                    count *= members.size();
                    if (removeDimNum.equals(dimNum)) {
                        members.remove(index);
                        dimIndex = i;
                        if (members.isEmpty()) {
                            return;
                        }
                    } else {
                        delAllCount *= members.size();
                    }
                    if (addOne) {
                        ++index;
                    }
                    boolean bl = addOne = index >= members.size();
                    if (addOne) {
                        if (i == 0) {
                            return;
                        }
                        index = 0;
                    }
                    passedIndex.add(index);
                }
                allCount -= delAllCount;
                int newGroupCount = 0;
                dimIndex = dimTrees.size() - dimIndex - 1;
                for (int i = passedIndex.size() - 1; i >= 0; --i) {
                    int pIndex = (Integer)passedIndex.get(i);
                    if (pIndex > 0) {
                        for (int j = dimTrees.size() - i; j < dimTrees.size(); ++j) {
                            pIndex *= allMember.get(j).size();
                        }
                        newGroupCount += pIndex;
                    }
                    if (i == dimIndex) break;
                }
                groupCount = newGroupCount;
                continue;
            }
            ++groupCount;
        }
    }

    private static boolean checkPreRowContains(PermDataContext permDataContext, PermRowParseInfo rowParseInfo, Map<String, PermMemberItem> memberMap) {
        Map<Long, List<RefRowRecord>> allRefRowRecords = rowParseInfo.getAllRefRowRecords();
        if (allRefRowRecords == null || allRefRowRecords.isEmpty()) {
            return false;
        }
        Map<Long, List<RowRecord>> allPermRowRecords = permDataContext.getRowRecords();
        for (Map.Entry<Long, List<RowRecord>> entry : allPermRowRecords.entrySet()) {
            Long uid = entry.getKey();
            List<RefRowRecord> refRowRecords = allRefRowRecords.get(uid);
            if (refRowRecords != null) {
                List<RowRecord> rowRecords = entry.getValue();
                for (RefRowRecord refRowRecord : refRowRecords) {
                    if (uid.equals(rowParseInfo.getCurrentUid()) && refRowRecord.getSourceIndex() == rowParseInfo.getCurrRowIndex()) break;
                    RowRecord sourceRow = rowRecords.get(refRowRecord.getSourceIndex());
                    ContainResult containResult = DimMembPermUtil.checkRowAndGroupContains(sourceRow, permDataContext.getDimTrees(), memberMap, permDataContext.getMemberPropCache(), permDataContext.isHasNotDataPermType());
                    if (!containResult.isMatchMembPerm() && !containResult.isMatchGivePerm() || !refRowRecord.isSourceHasPerm()) continue;
                    return true;
                }
            }
            if (!uid.equals(rowParseInfo.getCurrentUid())) continue;
            break;
        }
        return false;
    }

    private static void parseDimMembGroup(PermDataContext permDataContext, PermRowParseInfo rowParseInfo, MemberDKRJContext dkrjContext, Consumer<PermCheckResult> memberGroupConsumer) {
        Map<String, PermMemberItem> memberMap = dkrjContext.getGroupMembers();
        boolean ignoreDataPerm = dkrjContext.isIgnoreDataPerm();
        byte permVal = 0;
        for (DimMembPermType permType : permDataContext.getPermTypes()) {
            if (ignoreDataPerm && permType.isDataPerm()) continue;
            permVal = permType.setPermValue(permVal, permType.hasPerm(rowParseInfo.getCurrentRowPermVal()));
        }
        byte ignorePermType = 0;
        boolean begin = false;
        int index = 0;
        Map<Long, List<RowRecord>> allRowRecords = permDataContext.getRowRecords();
        Map<Long, List<RefRowRecord>> allRefRowRecords = rowParseInfo.getAllRefRowRecords();
        Long currentUid = rowParseInfo.getCurrentUid();
        PermCheckCallBackInfo permCheckCallBackInfo = null;
        for (Map.Entry<Long, List<RowRecord>> entry : allRowRecords.entrySet()) {
            List<RefRowRecord> refRowRecords;
            Long uId = entry.getKey();
            ++index;
            if (uId.equals(currentUid)) {
                begin = true;
            }
            if (!begin) continue;
            if (allRefRowRecords != null && (refRowRecords = allRefRowRecords.get(uId)) != null) {
                List<RowRecord> rowRecords = entry.getValue();
                boolean isSourceGroup = uId.equals(currentUid);
                for (RefRowRecord refRowRecord : refRowRecords) {
                    RowRecord targetRow;
                    ContainResult containResult;
                    boolean isSourceRecord;
                    boolean bl = isSourceRecord = rowParseInfo.getCurrRowIndex() == refRowRecord.getSourceIndex();
                    if (!isSourceRecord && isSourceGroup || !(containResult = DimMembPermUtil.checkRowAndGroupContains(targetRow = rowRecords.get(refRowRecord.getTargetIndex()), permDataContext.getDimTrees(), memberMap, permDataContext.getMemberPropCache(), permDataContext.isHasNotDataPermType())).isMatchMembPerm() && !containResult.isMatchGivePerm()) continue;
                    for (DimMembPermType permType : permDataContext.getPermTypes()) {
                        if (permType.hasPerm(ignorePermType) || !containResult.isMatchMembPerm() && containResult.isMatchGivePerm() && permType.isDataPerm()) continue;
                        if (permType.hasPerm(targetRow.getPermVal())) {
                            permVal = permType.setPermValue(permVal, true);
                            continue;
                        }
                        if (!permType.isDataPerm()) continue;
                        permVal = permType.setPermValue(permVal, false);
                    }
                }
            }
            if (permVal <= 0) continue;
            boolean hasAllPerm = true;
            for (DimMembPermType permType : permDataContext.getPermTypes()) {
                if (!permType.hasPerm(permVal)) {
                    hasAllPerm = false;
                    continue;
                }
                if (permDataContext.isParseAllGroup()) continue;
                ignorePermType = permType.setPermValue(ignorePermType, true);
            }
            PermCheckResult checkResult = new PermCheckResult(permVal, uId, DimMembPermUtil.switchMemberItem(memberMap));
            checkResult.setDimShortNumStr(permDataContext.getDimShortNumStr());
            if (permDataContext.isParseAllGroup()) {
                memberGroupConsumer.accept(checkResult);
                permVal = 0;
                if (permCheckCallBackInfo != null) continue;
                permCheckCallBackInfo = checkResult.getCallBackInfo();
                continue;
            }
            if (!hasAllPerm && index != allRowRecords.size()) continue;
            memberGroupConsumer.accept(checkResult);
            if (permCheckCallBackInfo != null) break;
            permCheckCallBackInfo = checkResult.getCallBackInfo();
            break;
        }
        if (permCheckCallBackInfo != null) {
            dkrjContext.setRemoveDim(permCheckCallBackInfo.getRemoveDim());
        }
    }

    private static Map<String, MemberItem> switchMemberItem(Map<String, PermMemberItem> memberMap) {
        HashMap<String, MemberItem> result = new HashMap<String, MemberItem>();
        memberMap.forEach((dimNum, member) -> {
            Long viewId = member.isMember() && member.getMember().getViewOrDim() instanceof AbstractView ? member.getMember().getViewOrDim().getId() : null;
            result.put((String)dimNum, new MemberItem(member.isMember(), member.getId(), viewId, member.isMember() ? member.getMember().getGlobalSeq() : 0));
        });
        return result;
    }

    public static ContainResult checkRowAndGroupContains(RowRecord targetRow, List<MemberTree> dimTrees, Map<String, PermMemberItem> memberMap, MemberPropCache memberPropCache, boolean hasNotDataPermType) {
        boolean noNotDataPerm = !hasNotDataPermType || !DimMembPermType.hasNotDataPerm(targetRow.getPermVal());
        boolean containsChild = !noNotDataPerm || DimMembPermType.DATAPERMEXTENDS.hasPerm(targetRow.getPermVal());
        ContainResult result = new ContainResult(!noNotDataPerm, true);
        for (int i = 0; i < dimTrees.size(); ++i) {
            MemberTree dimTree = dimTrees.get(i);
            MemberRecord memberRecord = targetRow.getMemberRecords().get(i);
            String dimNum = dimTree.getDimNum();
            PermMemberItem member = memberMap.get(dimNum);
            if (member == null) continue;
            if (memberRecord.isMember()) {
                if (member.isMember() && DimMembPermUtil.checkMembersContains(member.getMember(), dimTree.getMember(memberRecord.getId(), memberRecord.getViewId()), false, containsChild)) continue;
                result.setMatchMembPerm(false);
                result.setMatchGivePerm(false);
                break;
            }
            if (member.isMember()) {
                Set<String> memberNums = memberPropCache.getRefMemberNums(dimNum, memberRecord.getId());
                if (memberNums == null) {
                    result.setMatchMembPerm(false);
                    result.setMatchGivePerm(false);
                    break;
                }
                if (memberNums.contains(member.getMember().getNumber())) continue;
                result.setMatchMembPerm(false);
                if (noNotDataPerm || DimMembPermUtil.checkMembAndRefMembsContains(memberNums, dimTree, member.getMember().getId())) continue;
                result.setMatchGivePerm(false);
                break;
            }
            result.setMatchMembPerm(false);
            if (member.getPropVal().getId().equals(memberRecord.getId())) continue;
            result.setMatchGivePerm(false);
            break;
        }
        return result;
    }

    private static boolean checkMembAndRefMembsContains(Set<String> memberNums, MemberTree dimTree, Long targetMemberId) {
        if (IDUtils.isEmptyLong(targetMemberId).booleanValue()) {
            return false;
        }
        Count count = new Count();
        for (String memberNum : memberNums) {
            Member member = dimTree.getMember(memberNum);
            if (member == null) continue;
            member.iterateAll(memb -> {
                if (targetMemberId.equals(memb.getId())) {
                    count.addOne();
                    return false;
                }
                return true;
            });
            if (count.getCount() > 0) {
                return true;
            }
            count.setCount(0);
        }
        return false;
    }

    public static Map<Long, Map<Long, List<RefRowRecord>>> buildRefPermRecordOnRow(PermDataContext permDataContext) {
        Map<Long, List<RowRecord>> rowRecords = permDataContext.getRowRecords();
        if (rowRecords == null) {
            return new HashMap<Long, Map<Long, List<RefRowRecord>>>(1);
        }
        int size = rowRecords.size();
        HashMap<Long, Map<Long, List<RefRowRecord>>> allRefRowRecords = new HashMap<Long, Map<Long, List<RefRowRecord>>>(size);
        ArrayList<Long> allUserIds = new ArrayList<Long>(rowRecords.keySet());
        for (int i = 0; i < size; ++i) {
            Long uId = (Long)allUserIds.get(i);
            List<RowRecord> sourceGroup = rowRecords.get(uId);
            for (int j = 0; j < sourceGroup.size(); ++j) {
                RowRecord sourceRow = sourceGroup.get(j);
                int beginTargetIndex = j;
                for (int z = i; z < size; ++z) {
                    Long tUid = (Long)allUserIds.get(z);
                    List<RowRecord> targetGroup = rowRecords.get(tUid);
                    DimMembPermUtil.buildRefPermRecordOnRow(permDataContext, sourceRow, allRefRowRecords, beginTargetIndex, j, uId, tUid, targetGroup);
                    beginTargetIndex = -1;
                }
            }
        }
        return allRefRowRecords;
    }

    private static void buildRefPermRecordOnRow(PermDataContext permDataContext, RowRecord sourceRow, Map<Long, Map<Long, List<RefRowRecord>>> allRefRowRecords, int beginTargetIndex, int sourceRowIndex, Long sourceUserId, Long targetUserId, List<RowRecord> rowRecords) {
        int size = rowRecords.size();
        for (int i = beginTargetIndex + 1; i < size; ++i) {
            RowRecord targetRow = rowRecords.get(i);
            if (!DimMembPermUtil.checkRowsContains(sourceRow, targetRow, permDataContext.getDimTrees(), permDataContext.getMemberPropCache(), permDataContext.isHasNotDataPermType())) continue;
            RefRowRecord refRowRecord = new RefRowRecord(sourceRowIndex, i, DimMembPermUtil.checkRowHasPerm(sourceRow, permDataContext.getPermTypes()), DimMembPermUtil.checkRowHasPerm(targetRow, permDataContext.getPermTypes()));
            allRefRowRecords.computeIfAbsent(sourceRow.getRowId(), key -> new HashMap(16)).computeIfAbsent(targetUserId, key -> new LinkedList()).add(refRowRecord);
            allRefRowRecords.computeIfAbsent(targetRow.getRowId(), key -> new HashMap(16)).computeIfAbsent(sourceUserId, key -> new LinkedList()).add(refRowRecord);
        }
    }

    private static boolean checkRowHasPerm(RowRecord sourceRow, List<DimMembPermType> permTypes) {
        for (DimMembPermType permType : permTypes) {
            if (!permType.hasPerm(sourceRow.getPermVal())) continue;
            return true;
        }
        return false;
    }

    public static void buildRefPermRecordInside(List<RowRecord> rowRecords, List<MemberTree> dimTrees, MemberPropCache memberPropCache, boolean hasNotDataPermType) {
        int size = rowRecords.size();
        for (int i = 0; i < size - 1; ++i) {
            RowRecord sourceRow = rowRecords.get(i);
            for (int j = i + 1; j < size; ++j) {
                RowRecord targetRow = rowRecords.get(j);
                if (!DimMembPermUtil.checkRowsContains(sourceRow, targetRow, dimTrees, memberPropCache, hasNotDataPermType)) continue;
                sourceRow.addRefRowIndex(j);
            }
        }
    }

    public static List<MemberTree> getDimViews(Collection<String> dimNums, IModelCacheHelper modelCacheHelper, Long bizModelId) {
        ArrayList<MemberTree> dimTrees = new ArrayList<MemberTree>(dimNums.size());
        DimMembPermUtil.getDimViews(dimNums, modelCacheHelper, bizModelId, null, (tree, dimNum) -> dimTrees.add((MemberTree)tree));
        return dimTrees;
    }

    public static List<MemberTree> getDimViews(Collection<String> dimNums, Map<String, Set<Long>> refViewIds, IModelCacheHelper modelCacheHelper, Long bizModelId) {
        ArrayList<MemberTree> dimTrees = new ArrayList<MemberTree>(dimNums.size());
        DimMembPermUtil.getDimViews(dimNums, modelCacheHelper, bizModelId, refViewIds, (tree, dimNum) -> dimTrees.add((MemberTree)tree));
        return dimTrees;
    }

    public static Map<String, MemberTree> getDimViewMap(Collection<String> dimNums, IModelCacheHelper modelCacheHelper, Long bizModelId) {
        HashMap<String, MemberTree> result = new HashMap<String, MemberTree>(dimNums.size());
        DimMembPermUtil.getDimViews(dimNums, modelCacheHelper, bizModelId, null, (tree, dimNum) -> result.put((String)dimNum, (MemberTree)tree));
        return result;
    }

    private static void getDimViews(Collection<String> dimNums, IModelCacheHelper modelCacheHelper, Long bizModelId, Map<String, Set<Long>> refViewIds, BiConsumer<MemberTree, String> treeConsumer) {
        for (String dimNum : dimNums) {
            Set<Long> refViewIdSet = refViewIds == null ? null : refViewIds.get(dimNum);
            String viewStr = refViewIdSet == null ? "0" : SerializationUtils.toJsonString(refViewIdSet.stream().sorted().collect(Collectors.toList()));
            String cacheKey = "DImView_" + modelCacheHelper.getModelobj().getNumber() + "_" + bizModelId + "_" + viewStr + "_" + dimNum;
            MemberTree memberTree = (MemberTree)ThreadCache.get((Object)cacheKey, () -> {
                Dimension dimension = modelCacheHelper.getDimension(dimNum);
                if (dimension == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6%1\u5931\u8d25", (String)"DimMembPermUtil_1", (String)"epm-eb-common", (Object[])new Object[]{dimNum}));
                }
                if (SysDimensionEnum.Account.getNumber().equals(dimNum) && modelCacheHelper.getModelobj().isModelByBGMD()) {
                    return new AccountMemberTree(dimension, bizModelId);
                }
                MemberTree _memberTree = refViewIdSet != null ? new MemberTree(dimension, refViewIdSet) : new MemberTree(dimension, bizModelId);
                return _memberTree;
            });
            treeConsumer.accept(memberTree, dimNum);
        }
    }

    private static boolean checkRowsContains(RowRecord row1, RowRecord row2, List<MemberTree> dimTrees, MemberPropCache memberPropCache, boolean checkMemberChildByProp) {
        List<MemberRecord> memberRecords1 = row1.getMemberRecords();
        List<MemberRecord> memberRecords2 = row2.getMemberRecords();
        if (memberRecords1.size() != memberRecords2.size() || memberRecords1.size() < dimTrees.size() || row1 == row2) {
            return false;
        }
        boolean checkMemberChildByProp1 = checkMemberChildByProp && DimMembPermType.hasNotDataPerm(row1.getPermVal());
        boolean checkMemberChildByProp2 = checkMemberChildByProp && DimMembPermType.hasNotDataPerm(row2.getPermVal());
        boolean containsChild1 = checkMemberChildByProp1 || DimMembPermType.DATAPERMEXTENDS.hasPerm(row1.getPermVal());
        boolean containsChild2 = checkMemberChildByProp2 || DimMembPermType.DATAPERMEXTENDS.hasPerm(row2.getPermVal());
        for (int i = 0; i < dimTrees.size(); ++i) {
            Set<String> refMemberNums2;
            Set<String> refMemberNums1;
            Member member2;
            Set<String> refMemberNums;
            Member member22;
            Member member1;
            MemberTree dimTree = dimTrees.get(i);
            MemberRecord memberRecord1 = memberRecords1.get(i);
            MemberRecord memberRecord2 = memberRecords2.get(i);
            if (!(memberRecord1.isMember() && memberRecord2.isMember() ? !DimMembPermUtil.checkMembersContains(member1 = dimTree.getMember(memberRecord1.getId(), memberRecord1.getViewId()), member22 = dimTree.getMember(memberRecord2.getId(), memberRecord2.getViewId()), containsChild1, containsChild2) : (memberRecord1.isMember() && !memberRecord2.isMember() ? !DimMembPermUtil.checkMembAndRefMembsContains(member1 = dimTree.getMember(memberRecord1.getId(), memberRecord1.getViewId()), refMemberNums = memberPropCache.getRefMemberNums(dimTree.getDimNum(), memberRecord2.getId()), containsChild1, checkMemberChildByProp2, dimTree) : (!memberRecord1.isMember() && memberRecord2.isMember() ? !DimMembPermUtil.checkMembAndRefMembsContains(member2 = dimTree.getMember(memberRecord2.getId(), memberRecord2.getViewId()), refMemberNums = memberPropCache.getRefMemberNums(dimTree.getDimNum(), memberRecord1.getId()), containsChild2, checkMemberChildByProp1, dimTree) : !DimMembPermUtil.checkMemberSetContains(refMemberNums1 = memberPropCache.getRefMemberNums(dimTree.getDimNum(), memberRecord1.getId()), refMemberNums2 = memberPropCache.getRefMemberNums(dimTree.getDimNum(), memberRecord2.getId()), checkMemberChildByProp1, checkMemberChildByProp2, dimTree))))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkMembAndRefMembsContains(Member member1, Set<String> refMemberNums, boolean containsChild) {
        Count count = new Count();
        if (containsChild) {
            member1.iterateAll(member -> {
                if (refMemberNums.contains(member.getNumber())) {
                    count.addOne();
                    return false;
                }
                return true;
            });
            return count.getCount() == 1;
        }
        return refMemberNums.contains(member1.getNumber());
    }

    public static boolean checkMemberSetContains(Set<String> refMemberNums1, Set<String> refMemberNums2, boolean checkAllChild1, boolean checkAllChild2, MemberTree memberTree) {
        if (refMemberNums1 == null || refMemberNums2 == null || refMemberNums2.isEmpty() || refMemberNums1.isEmpty()) {
            return false;
        }
        refMemberNums1 = DimMembPermUtil.addAllRefChildMember(checkAllChild1, refMemberNums1, memberTree);
        refMemberNums2 = DimMembPermUtil.addAllRefChildMember(checkAllChild2, refMemberNums2, memberTree);
        return Collections.disjoint(refMemberNums1, refMemberNums2);
    }

    public static Set<String> addAllRefChildMember(boolean addAllChild, Set<String> refMemberNums, MemberTree memberTree) {
        if (addAllChild) {
            HashSet<String> refMemberNums1 = new HashSet<String>(16);
            for (String memberNum : refMemberNums) {
                Member member = memberTree.getMember(memberNum);
                if (member == null) continue;
                member.iterate(memb -> refMemberNums1.add(memb.getNumber()));
            }
            if (refMemberNums1.size() > 0) {
                refMemberNums1.addAll(refMemberNums);
                refMemberNums = refMemberNums1;
            }
        }
        return refMemberNums;
    }

    public static boolean checkMembAndRefMembsContains(Member member1, Set<String> refMemberNums, boolean containsChild, boolean containNotDataPerm, MemberTree memberTree) {
        if (member1 == null || refMemberNums == null || refMemberNums.isEmpty()) {
            return false;
        }
        refMemberNums = DimMembPermUtil.addAllRefChildMember(containNotDataPerm, refMemberNums, memberTree);
        return DimMembPermUtil.checkMembAndRefMembsContains(member1, refMemberNums, containsChild);
    }

    public static boolean checkMembersContains(Member member1, Member member2, boolean containsChild1, boolean containsChild2) {
        int index;
        String longNum2;
        String longNum1;
        if (member1 == null || member2 == null) {
            return false;
        }
        if (member1.getId().equals(member2.getId())) {
            return true;
        }
        if (!containsChild1 && !containsChild2) {
            return false;
        }
        Member _member = member1.getViewOrDim().getMember(member2.getId());
        if (_member == null) {
            _member = member2.getViewOrDim().getMember(member1.getId());
            if (_member == null) {
                return false;
            }
            member1 = _member;
        } else {
            member2 = _member;
        }
        if (member1.getLevel() == member2.getLevel()) {
            return false;
        }
        if (member1.getLevel() > member2.getLevel()) {
            longNum1 = member2.getLongNumber();
            longNum2 = member1.getLongNumber();
            containsChild1 = containsChild2;
        } else {
            longNum1 = member1.getLongNumber();
            longNum2 = member2.getLongNumber();
        }
        for (index = 0; index < longNum1.length() && index < longNum2.length(); ++index) {
            if (longNum1.charAt(index) == longNum2.charAt(index)) continue;
            return false;
        }
        return longNum2.charAt(index) == '!' && containsChild1;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkMemberNumberContains(String sourceLongNumber, int beginIndex, String targetNumber) {
        if (sourceLongNumber == null || targetNumber == null) {
            return false;
        }
        numLength = targetNumber.length();
        longNumLength = sourceLongNumber.length();
        block0: while (true) lbl-1000:
        // 3 sources

        {
            ++beginIndex;
            for (i = 0; i < numLength; ++i) {
                block7: {
                    block6: {
                        if (beginIndex >= longNumLength) break block6;
                        if (targetNumber.charAt(i) == sourceLongNumber.charAt(beginIndex)) break block7;
                        while (true) {
                            if (beginIndex >= longNumLength || sourceLongNumber.charAt(beginIndex) == '!') ** GOTO lbl-1000
                            ++beginIndex;
                        }
                    }
                    return false;
                }
                ++beginIndex;
            }
            if (beginIndex == longNumLength || sourceLongNumber.charAt(beginIndex) == '!') {
                return true;
            }
            while (true) {
                if (beginIndex >= longNumLength || sourceLongNumber.charAt(beginIndex) == '!') continue block0;
                ++beginIndex;
            }
            break;
        }
    }

    public static Map<Long, Set<Long>> getAllViewAndGroupFromCache(Long modelId, Long dimensionId) {
        return (Map)ThreadCache.get((Object)("ViewAndGroup_" + modelId + "_" + dimensionId), () -> {
            HashMap<Long, Set> viewGroupMapView = new HashMap<Long, Set>(16);
            QFBuilder qb = new QFBuilder("model", "=", modelId);
            qb.add("dimension", "=", dimensionId);
            DynamicObjectCollection viewObjs = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,viewgroup,viewgroup.parent", (QFilter[])qb.toArrays());
            for (DynamicObject obj : viewObjs) {
                Long viewId = obj.getLong("id");
                Long viewGroupPId = obj.getLong("viewgroup.parent");
                Long viewGroupId = IDUtils.isNotEmptyLong(viewGroupPId) != false ? viewGroupPId : Long.valueOf(obj.getLong("viewgroup"));
                viewGroupMapView.computeIfAbsent(viewGroupId, key -> new HashSet(16)).add(viewId);
            }
            return viewGroupMapView;
        });
    }

    public static Long switchViewId(Long modelId, Long bizCtrlRangeId, String dimensionNumber, Long currentViewId) {
        IModelCacheHelper cacheHelper;
        Model modelObj;
        if (IDUtils.isEmptyLong(currentViewId).booleanValue() && !(modelObj = (cacheHelper = ModelCacheContext.getOrCreate(modelId)).getModelobj()).isModelByEB()) {
            if (IDUtils.isEmptyLong(bizCtrlRangeId).booleanValue()) {
                return cacheHelper.getDefaultViewIdOnDim(dimensionNumber);
            }
            return cacheHelper.getViewByBusModelAndDimNumber(bizCtrlRangeId, dimensionNumber);
        }
        return currentViewId;
    }
}

