/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.EBPermissionUtils;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public interface EBPermission {
    public static final Log loggerv = LogFactory.getLog(EBPermission.class);
    public static final List<String> rootForms = Arrays.asList("bgm_apphome", "bgmd_apphome", "eb_apphome", "bd_apphome", "bgc_apphome", "bgrp_apphome", "ide_formdesigner");
    public static final List<String> wfApps = Arrays.asList("wf", "bpm", "wftask", "bec");

    public Long getModelId();

    default public Long getUserId() {
        return UserUtils.getUserId();
    }

    public String getBizAppId();

    default public String getBizAppId4WF(boolean checkModel) {
        String bizAppId = this.getBizAppId4BGRP();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            if (checkModel) {
                bizAppId = this.getRealAppId(this.getModelId());
            }
            return bizAppId;
        }
        String entityId = parentView.getEntityId();
        if (entityId.startsWith("wf_")) {
            Long modelId = this.getModelId();
            return this.getRealAppId(modelId);
        }
        return bizAppId;
    }

    default public String getBizAppId4BGRP() {
        IFormView view = this.getView();
        if (view == null) {
            return "";
        }
        return CommonServiceHelper.getBizAppId4BGRP(view, this.getModelId());
    }

    public IFormView getView();

    public boolean isCheckModel();

    default public void checkPermission(IFormView view, String permKey) {
        String specialEntity;
        if (view == null) {
            throw new KDBizException("view is null.");
        }
        String source = view.getEntityId();
        if (view instanceof ListView && "bos_list".equals(source)) {
            source = ((ListView)view).getBillFormId();
            if (source.equals("eb_model_list")) {
                source = "epm_model";
            }
        } else if (view instanceof ListView && "bos_templatetreelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bos_treelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bos_usergroup_treelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bgc_recipientmapboslist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "eb_approvebill_newlist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        }
        if (StringUtils.isNotEmpty(specialEntity = this.getBGRPSpecialEntity())) {
            source = specialEntity;
        }
        this.checkPermission(source, permKey);
    }

    default public EBPermissionUtils getPermissionUtils() {
        return EBPermissionUtils.getInstance();
    }

    default public void checkPermission(String source, String permKey) {
        String[] items;
        String permItem;
        Map<String, Map<String, String>> permItemsMap = this.getPermissionUtils().getPermItem().getPermItemsMap();
        Map<String, String> entityItems = permItemsMap.get(source);
        if (entityItems != null && (permItem = entityItems.get(permKey)) != null && (items = permItem.split("@")).length >= 3) {
            String descKey = items[0] + "#" + permKey + "#" + items[1];
            String permItemDesc = ResManager.loadKDString((String)items[2], (String)descKey, (String)"epm-eb-common", (Object[])new Object[0]);
            this.doEBCheckPermission(items[0], items[1], permItemDesc);
        }
    }

    default public void checkPermission(Long modelId, Long userId, String appId, String source, String permKey) {
        String[] items;
        String permItem;
        Map<String, Map<String, String>> permItemsMap = this.getPermissionUtils().getPermItem().getPermItemsMap();
        Map<String, String> entityItems = permItemsMap.get(source);
        if (entityItems != null && (permItem = entityItems.get(permKey)) != null && (items = permItem.split("@")).length >= 3) {
            String descKey = items[0] + "#" + permKey + "#" + items[1];
            String permItemDesc = ResManager.loadKDString((String)items[2], (String)descKey, (String)"epm-eb-common", (Object[])new Object[0]);
            this.doEBCheckPermission(modelId, userId, appId, items[0], items[1], permItemDesc);
        }
    }

    default public void doEBCheckPermission(String entityNumber, String permItemId, String permItemDesc) {
        this.doEBCheckPermission(this.getModelId(), this.getUserId(), this.getBizAppId(), entityNumber, permItemId, permItemDesc);
    }

    default public String getModelType(long dimObjId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimObjId)});
        if (dynamicObject == null) {
            dynamicObject = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimObjId)});
        }
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u7f16\u7801\u3002", (String)"EBPermission_4", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return dynamicObject.getString("reporttype");
    }

    default public void doEBCheckPermission(Long modelId, Long userId, String appId, String entityNumber, String permItemId, String permItemDesc) {
        AppInfo app;
        if (this.isCheckModel() && (modelId == null || modelId == 0L) && !FunPermissionHelper.isDatasource(entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EBPermission_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (modelId == null) {
            modelId = 0L;
        }
        if (userId == null) {
            userId = 0L;
        }
        if (appId == null) {
            appId = "";
        }
        if ((app = AppMetadataCache.getAppInfo((String)appId)) == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u5e94\u7528\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_2", (String)"epm-eb-common", (Object[])new Object[]{appId}));
        }
        int is = this.checkItemPermission(userId, modelId, app.getId(), entityNumber, permItemId);
        if (is == 0) {
            if (this.isCheckModel() && ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
                return;
            }
            loggerv.error("EBPermission#doEBCheckPermission appId={},entityNumber={}", (Object)appId, (Object)entityNumber);
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (met != null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u201c%2\u201d\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_1", (String)"epm-eb-common", (Object[])new Object[]{met.getDisplayName(), permItemDesc}));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_5", (String)"epm-eb-common", (Object[])new Object[]{permItemDesc}));
        }
    }

    default public int checkItemPermission(long userId, long dimObjId, String appId, String entityNumber, String permItemId) {
        return FunPermissionHelper.checkItemPermission(userId, dimObjId, appId, entityNumber, permItemId, this.getView(), this.isCheckModel());
    }

    default public void checkViewPermPreOpen(PreOpenFormEventArgs e) {
        Map<String, Map<String, String>> permItemsMap;
        Map<String, String> entityItems;
        String formId;
        if (!this.needCheckViewPerm().booleanValue()) {
            return;
        }
        FormShowParameter fs = (FormShowParameter)e.getSource();
        String parentFormId = fs.getParentFormId();
        if (rootForms.contains(parentFormId)) {
            return;
        }
        fs.setHasRight(true);
        String appId = fs.getAppId();
        Long modelId = ConvertUtils.toLong(fs.getCustomParam(this.getModelCustomKey()));
        if (wfApps.contains(appId)) {
            if (this.notCheckPermInWorkFlow()) {
                return;
            }
            appId = this.getRealAppId(modelId);
        } else {
            appId = this.getAppIdFromMsgCentral(appId, modelId);
        }
        if (StringUtils.isEmpty(appId)) {
            appId = this.getSpecAppId();
        }
        if ((formId = fs.getFormId()).equals("bos_list")) {
            ListShowParameter source = (ListShowParameter)e.getSource();
            formId = source.getBillFormId();
        }
        if ((entityItems = (permItemsMap = EBPermissionUtils.getInstance().getPermItem().getPermItemsMap()).get(formId)) == null) {
            return;
        }
        Long userId = this.getUserId();
        int is = this.checkItemPermission(userId, modelId, AppMetadataCache.getAppInfo((String)appId).getId(), formId, "47150e89000000ac");
        if (is == 0) {
            if (this.isCheckModel() && ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
                this.ignoreSpecialPermCheck(fs);
                return;
            }
            loggerv.error("EBPermission#checkViewPermPreOpen appId={},formId={}", (Object)appId, (Object)formId);
            String permItemDesc = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"EBPermission_6", (String)"epm-eb-common", (Object[])new Object[0]);
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)formId);
            String errMessage = null;
            errMessage = met != null ? ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u201c%2\u201d\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_1", (String)"epm-eb-common", (Object[])new Object[]{met.getDisplayName(), permItemDesc}) : ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_5", (String)"epm-eb-common", (Object[])new Object[]{permItemDesc});
            e.setCancel(true);
            e.setCancelMessage(errMessage);
        }
    }

    default public String getAppIdFromMsgCentral(String appId, Long modelId) {
        return appId;
    }

    default public String getAppIdFromMsgCentral4BGRP(String appId, Long modelId) {
        if (ApplicationTypeEnum.BGRP.getAppnum().equals(appId)) {
            return appId;
        }
        return this.getRealAppId(modelId);
    }

    default public void ignoreSpecialPermCheck(FormShowParameter formShowParameter) {
    }

    default public String getRealAppId(Long modelId) {
        if (NewEbAppUtil.isNewEbModel(modelId)) {
            return ApplicationTypeEnum.BG.getAppnum();
        }
        return ApplicationTypeEnum.BGM.getAppnum();
    }

    default public String getModelCustomKey() {
        return "model";
    }

    default public Boolean needCheckViewPerm() {
        return true;
    }

    default public String getSpecAppId() {
        return ApplicationTypeEnum.BGM.getAppnum();
    }

    default public String getBGRPSpecialEntity() {
        return null;
    }

    default public boolean notCheckPermInWorkFlow() {
        return true;
    }
}

