/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EBPermissionUtils {
    private static final Log log = LogFactory.getLog(EBPermissionUtils.class);
    private static final String PERMISSION_TAG = "budget-permission-log : ";
    private static final List<String> ignorePages = Arrays.asList("eb_analysiscanvaslist", "eb_analysiscanvas_design", "bgc_controlwarningrule", "eb_modeltransfer", "epm_model", "eb_adddimmaterule", "eb_bgcontrolporcesslist", "eb_billlist", "eb_parametercontrolset", "eb_modeltransfer_nbg", "eb_logparamsetting", "eb_param_setting", "eb_templateuser_allocate", "eb_usertemplatereport", "epbs_datasource", "epm_modelperm", "epm_perm_role", "epm_usergroup_user_inh");
    private static final Map<String, Map<String, String>> permItemsMap = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, List<String>>> funcPermItems = new HashMap<String, Map<String, List<String>>>();
    private static String addedPermPath = null;
    private static final int sourceIndex = 0;
    private static final int operationIndex = 1;
    private static final int entityIndex = 2;
    private static final int permItemIndex = 3;
    private static final int permItemDescIndex = 4;
    private static final int appNumIndex = 5;

    public static EBPermissionUtils getInstance() {
        return new EBPermissionUtils();
    }

    public Map<String, Map<String, String>> getPermItemsMap() {
        return Collections.unmodifiableMap(permItemsMap);
    }

    public Map<String, Map<String, List<String>>> getFuncPermItems() {
        return Collections.unmodifiableMap(funcPermItems);
    }

    public EBPermissionUtils getPermItem() {
        if (permItemsMap.isEmpty()) {
            String defaultPermPath = "permission/epm_permitemlist.xlsx";
            this.getPermItem(defaultPermPath);
            String paths = System.getProperty("CACHE_PERM_PATH_EPM_KEY");
            if (StringUtils.isNotEmpty(paths)) {
                String[] pathArray;
                for (String path : pathArray = paths.split(",")) {
                    this.getPermItem(path);
                }
            }
        }
        return this;
    }

    public void getPermItem(String permPath) {
        Map entityItems = null;
        XSSFSheet sheet = null;
        XSSFRow row = null;
        String source = null;
        String operation = null;
        String entityNumber = null;
        String permItem = null;
        String permItemDesc = null;
        String appNum = null;
        Map entityPermMap = null;
        List permItems = null;
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(permPath);){
            if (in == null) {
                log.error("load added permission error:", (Object)permPath);
                return;
            }
            try (XSSFWorkbook book = new XSSFWorkbook(in);){
                sheet = book.getSheetAt(0);
                int rowCount = sheet.getLastRowNum();
                for (int rowIndex = 1; rowIndex <= rowCount; ++rowIndex) {
                    row = sheet.getRow(rowIndex);
                    if (row == null) continue;
                    source = this.getValue(row.getCell(0));
                    operation = this.getValue(row.getCell(1));
                    entityNumber = this.getValue(row.getCell(2));
                    permItem = this.getValue(row.getCell(3));
                    permItemDesc = this.getValue(row.getCell(4));
                    appNum = this.getValue(row.getCell(5));
                    if (StringUtils.isEmpty(entityNumber) || StringUtils.isEmpty(permItem)) continue;
                    if (StringUtils.isNotEmpty(source) && StringUtils.isNotEmpty(operation)) {
                        entityItems = permItemsMap.computeIfAbsent(source, k -> new HashMap(16));
                        entityItems.put(operation, this.getPermKey(entityNumber, permItem, permItemDesc));
                    }
                    entityPermMap = funcPermItems.computeIfAbsent(appNum, k -> new HashMap());
                    permItems = entityPermMap.computeIfAbsent(entityNumber, k -> new ArrayList());
                    permItems.add(permItem);
                }
            }
        }
        catch (IOException ex) {
            log.error("load budget permission error:", (Throwable)ex);
        }
    }

    private String getValue(XSSFCell cell) {
        String value = "";
        if (cell != null) {
            value = cell.getStringCellValue();
        }
        return StringUtils.isNotEmpty(value) ? value.trim() : value;
    }

    private String getPermKey(String entityNumber, String permItem, String permItemDesc) {
        return entityNumber + "@" + permItem + "@" + permItemDesc;
    }

    public void addPermByUser(Long modelId, List<Long> userIds, boolean hasClearPerm) {
        this.addPermByUser(modelId, userIds, null, hasClearPerm);
    }

    public void addPermByUser(Long modelId, List<Long> userIds, String appNum, boolean hasClearPerm) {
        this.addPermByUser(modelId, userIds, appNum, null, hasClearPerm);
    }

    public void addPermByUser(Long modelId, List<Long> userIds, String appNum, String reportType, boolean hasClearPerm) {
        if (modelId == null || modelId == 0L || userIds.isEmpty()) {
            return;
        }
        if (hasClearPerm) {
            this.delPermNyUser(modelId, userIds);
        }
        Map<String, Map<String, List<String>>> appFuncPermItems = this.getPermItem().getFuncPermItems();
        ApplicationTypeEnum app = null;
        app = StringUtils.isEmpty(appNum) ? ModelServiceHelper.getModelApp(modelId) : ApplicationTypeEnum.getEnumByNumber(appNum);
        if (app == null) {
            throw new KDBizException("AppNum is null or error ApppNum. ApppNum = " + appNum);
        }
        String dimType = "DIM_EPM_MODEL";
        Map.Entry<String, Map<String, List<String>>> entry2 = null;
        for (Map.Entry<String, Map<String, List<String>>> entry2 : appFuncPermItems.entrySet()) {
            String _appNum = entry2.getKey();
            if (_appNum != null && (app == ApplicationTypeEnum.EB || app == ApplicationTypeEnum.BG ? _appNum.equals(ApplicationTypeEnum.BGM.getAppnum()) || _appNum.equals(ApplicationTypeEnum.BGMD.getAppnum()) || _appNum.equals(ApplicationTypeEnum.BGRP.getAppnum()) && !ApplicationTypeEnum.BG.getIndex().equals(reportType) && ApplicationTypeEnum.BG != app : (app == ApplicationTypeEnum.BGM || app == ApplicationTypeEnum.BGMD) && (_appNum.equals(ApplicationTypeEnum.EB.getAppnum()) || _appNum.equals(ApplicationTypeEnum.BGRP.getAppnum()) && app != ApplicationTypeEnum.BGMD))) continue;
            HashMap<String, List<String>> pagePerms = new HashMap<String, List<String>>(16);
            Map<String, List<String>> perms = entry2.getValue();
            if (perms != null) {
                perms.forEach((pageKey, items) -> {
                    if (!ignorePages.contains(pageKey)) {
                        pagePerms.put((String)pageKey, (List<String>)items);
                    }
                });
            }
            HashMap<String, Map<String, List<String>>> appEntityPermItemMap = new HashMap<String, Map<String, List<String>>>(16);
            if (StringUtils.isEmpty(_appNum)) {
                appEntityPermItemMap.put(AppMetadataCache.getAppInfo((String)app.getAppnum()).getId(), this.getPermItems(pagePerms, app, reportType, _appNum));
            } else {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)_appNum);
                if (appInfo == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6743\u9650\u914d\u7f6e\u6587\u4ef6\u5b9a\u4e49\u7684\u5e94\u7528\u7f16\u7801\u201c%1\u201d\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u6587\u4ef6\u3002", (String)"EBPermissionUtils_0", (String)"epm-eb-common", (Object[])new Object[]{_appNum}));
                }
                appEntityPermItemMap.put(appInfo.getId(), this.getPermItems(pagePerms, app, reportType, _appNum));
            }
            log.info(PERMISSION_TAG + (StringUtils.isEmpty(_appNum) ? app.getAppnum() : _appNum) + " - " + JSON.toJSONString(appEntityPermItemMap));
            for (Long userId : userIds) {
                PermissionServiceHelper.userDirectAssignPerm((Long)userId, (String)dimType, (Long)modelId, appEntityPermItemMap, (boolean)true);
            }
            PermissionServiceHelper.clearAllCache();
        }
    }

    private Map<String, List<String>> getPermItems(Map<String, List<String>> permItems, ApplicationTypeEnum currentApp, String reportType, String itemAppNum) {
        boolean newEbModel;
        HashMap<String, List<String>> items = new HashMap<String, List<String>>(16);
        boolean bl = newEbModel = ApplicationTypeEnum.BG == currentApp || ApplicationTypeEnum.BG.getIndex().equals(reportType);
        if (ApplicationTypeEnum.BGRP.getAppnum().equals(itemAppNum)) {
            for (Map.Entry<String, List<String>> entry : permItems.entrySet()) {
                String entityId = entry.getKey();
                if ((!newEbModel || !NewEbAppUtil.bgrpNewEbPage.contains(entityId)) && (newEbModel || !NewEbAppUtil.bgrpEbModelPage.contains(entityId))) continue;
                items.put(entityId, entry.getValue());
            }
        } else {
            if ("bgc".equals(itemAppNum) || ApplicationTypeEnum.EB != currentApp && ApplicationTypeEnum.BG != currentApp) {
                return permItems;
            }
            for (Map.Entry<String, List<String>> entry : permItems.entrySet()) {
                String entityId = entry.getKey();
                if ((!newEbModel || !NewEbAppUtil.isNewEbPage(entityId)) && (newEbModel || NewEbAppUtil.isNewEbPage(entityId))) continue;
                items.put(entityId, entry.getValue());
            }
        }
        return items;
    }

    public int delPermNyUser(Long modelId, List<Long> userIds) {
        if (modelId == null || modelId == 0L || userIds.isEmpty()) {
            return 0;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("org", "=", (Object)modelId));
        builder.add(new QFilter("user", "in", userIds));
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])builder.toArrays());
    }
}

