/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.cache.BcmPermSingleModel;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.UserUtils;
import org.jetbrains.annotations.NotNull;

public class FunPermissionHelper {
    private static ThreadLocal<Map<String, Set<Long>>> modelRoleLocal = ThreadLocal.withInitial(HashMap::new);

    public static void addRootPermByUser(Long modelId, Long userId) {
        Map<String, List<String>> map = BcmPermSingleModel.getInstance().getPermbyentity();
        String[] entities = new String[map.size()];
        map.keySet().toArray(entities);
        ApplicationTypeEnum app = ModelServiceHelper.getModelApp(modelId);
        HashMap<String, Map<String, List<String>>> appEntityPermItemMap = new HashMap<String, Map<String, List<String>>>();
        appEntityPermItemMap.put(AppMetadataCache.getAppInfo((String)app.getAppnum()).getId(), map);
        PermissionServiceHelper.userDirectAssignPerm((Long)userId, (String)"DIM_BCM_MODEL", (Long)modelId, appEntityPermItemMap, (boolean)true);
    }

    public static int delPermBymodelId(Long modelId) {
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)modelId)});
    }

    public static int delPermByUser(Long modelId, List<Long> userids) {
        QFilter qcf = new QFilter("org", "=", (Object)modelId);
        QFilter qcf2 = new QFilter("user", "in", userids);
        QFilter[] qFilters = new QFilter[]{qcf, qcf2};
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])qFilters);
    }

    public static Set<Long> getAllHasPermModel(QFilter[] filters) {
        HashSet<Long> sets = new HashSet<Long>();
        Map dys = BusinessDataServiceHelper.loadFromCache((String)"perm_userperm", (String)"org", (QFilter[])filters);
        if (dys != null && dys.size() > 0) {
            for (DynamicObject dy : dys.values()) {
                sets.add(dy.getLong("org_id"));
            }
        }
        return sets;
    }

    public static Set<Long> getEffectiveByPermModel(String entity, @NotNull ApplicationTypeEnum application) {
        return EpmThreadLocalUtils.getEffectiveByPermModel(entity, application);
    }

    public static Set<Long> $getEffectiveByPermModel(String entity, @NotNull ApplicationTypeEnum application) {
        QFilter filter = new QFilter("user.id", "=", (Object)UserUtils.getUserId());
        AppInfo app = AppMetadataCache.getAppInfo((String)application.getAppnum());
        if (app == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u5e94\u7528\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_2", (String)"epm-eb-common", (Object[])new Object[]{application.getAppnum()}));
        }
        QFilter bizApp = new QFilter("entryentity.bizapp", "=", (Object)app.getId());
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        Set<Long> set = FunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, bizApp, filter2});
        QFilter filter1 = new QFilter("id", "in", set);
        QFilter qcf = new QFilter("ReportType", "!=", (Object)"-1");
        switch (application) {
            case EB: {
                qcf = new QFilter("ReportType", "=", (Object)"4");
                break;
            }
            case BG: {
                qcf = new QFilter("ReportType", "=", (Object)application.getIndex());
                break;
            }
            case BGMD: 
            case BGM: {
                qcf = new QFilter("ReportType", "=", (Object)"7");
                break;
            }
            case BGBD: {
                qcf = new QFilter("ReportType", "=", (Object)"9");
                qcf.or("ReportType", "=", (Object)"4").or("ReportType", "=", (Object)"7");
                break;
            }
            case BGRP: {
                qcf = new QFilter("ReportType", "=", (Object)"6").or("ReportType", "=", (Object)"7");
                break;
            }
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{filter1, qcf});
        if (dys != null) {
            set.clear();
            for (DynamicObject dy : dys) {
                set.add(dy.getLong("id"));
            }
        }
        return set;
    }

    public static Set<Long> getEffectiveByPermItemModel(String entity, @NotNull ApplicationTypeEnum application, String permItemId) {
        QFilter filter = new QFilter("user.id", "=", (Object)UserUtils.getUserId());
        AppInfo app = AppMetadataCache.getAppInfo((String)application.getAppnum());
        if (app == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6682\u65e0\u201c%1\u201d\u7684\u5e94\u7528\u64cd\u4f5c\u6743\u9650\u3002", (String)"EBPermission_2", (String)"epm-eb-common", (Object[])new Object[]{application.getAppnum()}));
        }
        QFilter bizApp = new QFilter("entryentity.bizapp", "=", (Object)app.getId());
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        QFilter filter3 = new QFilter("entryentity.permitem", "=", (Object)permItemId);
        Set<Long> set = FunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, bizApp, filter2, filter3});
        QFilter filter1 = new QFilter("id", "in", set);
        QFilter qcf = new QFilter("ReportType", "!=", (Object)"-1");
        switch (application) {
            case EB: {
                qcf = new QFilter("ReportType", "=", (Object)"4");
                break;
            }
            case BG: {
                qcf = new QFilter("ReportType", "=", (Object)application.getIndex());
                break;
            }
            case BGMD: 
            case BGM: {
                qcf = new QFilter("ReportType", "=", (Object)"7");
                break;
            }
            case BGBD: {
                qcf = new QFilter("ReportType", "=", (Object)"9");
                qcf.or("ReportType", "=", (Object)"4").or("ReportType", "=", (Object)"7");
                break;
            }
            case BGRP: {
                qcf = new QFilter("ReportType", "=", (Object)"6").or("ReportType", "=", (Object)"7");
                break;
            }
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{filter1, qcf});
        if (dys != null) {
            set.clear();
            for (DynamicObject dy : dys) {
                set.add(dy.getLong("id"));
            }
        }
        return set;
    }

    public static Set<Long> getRoleModel(Long UserID, String perType, ApplicationTypeEnum application, String entityNum, String permItemId) {
        if (modelRoleLocal.get().containsKey(UserID + perType + application.getName() + entityNum)) {
            return modelRoleLocal.get().get(UserID + perType + application.getName() + entityNum);
        }
        HashSet<Long> publicModelIds = new HashSet<Long>();
        HasPermDimObjResult perResult = entityNum == null ? PermissionServiceHelper.getUserHasPermDimObjs((long)UserID, (String)perType) : PermissionServiceHelper.getHasPermDimObjs((long)UserID, (String)AppMetadataCache.getAppInfo((String)application.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        QFilter qcf = null;
        if (!perResult.hasAllDimObjPerm()) {
            publicModelIds.addAll(perResult.getHasPermDimObjs());
            qcf = new QFilter("id", "in", publicModelIds);
            ArrayList<String> reportTypes = new ArrayList<String>(16);
            if (ApplicationTypeEnum.BGBD == application || ApplicationTypeEnum.BGC == application) {
                reportTypes.add(ApplicationTypeEnum.EB.getIndex());
                reportTypes.add(ApplicationTypeEnum.BGMD.getIndex());
                reportTypes.add(ApplicationTypeEnum.BG.getIndex());
            } else if (ApplicationTypeEnum.BGM == application || ApplicationTypeEnum.BGMD == application) {
                reportTypes.add(ApplicationTypeEnum.BGMD.getIndex());
            } else if (ApplicationTypeEnum.BGRP == application) {
                reportTypes.add(ApplicationTypeEnum.BGMD.getIndex());
                reportTypes.add(ApplicationTypeEnum.BG.getIndex());
            } else {
                reportTypes.add(application.getIndex());
            }
            qcf.and("reporttype", "in", reportTypes);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{qcf});
            if (dys != null) {
                publicModelIds.clear();
                for (DynamicObject dy : dys) {
                    publicModelIds.add(dy.getLong("id"));
                }
            }
        } else {
            switch (application) {
                case EB: {
                    qcf = new QFilter("ReportType", "=", (Object)"4");
                    break;
                }
                case BG: {
                    qcf = new QFilter("ReportType", "=", (Object)application.getIndex());
                    break;
                }
                case BGMD: {
                    qcf = new QFilter("ReportType", "=", (Object)"7");
                    break;
                }
                case BGBD: {
                    qcf = new QFilter("ReportType", "=", (Object)"4");
                    qcf.or("ReportType", "=", (Object)"7");
                    qcf.or("ReportType", "=", (Object)"6");
                    break;
                }
                case BGRP: {
                    qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getIndex());
                    qcf.or("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex());
                    break;
                }
            }
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{qcf});
            if (dys != null) {
                for (DynamicObject dy : dys) {
                    publicModelIds.add(dy.getLong("id"));
                }
            }
        }
        modelRoleLocal.get().put(UserID + perType + application.getName() + entityNum, publicModelIds);
        return publicModelIds;
    }

    public static Set<Long> getRoleModel(long UserID, String perType, ApplicationTypeEnum application) {
        return FunPermissionHelper.getRoleModel(UserID, perType, application, null, null);
    }

    public static boolean checkPageModelFunPerm(long userId, long modelId, String appId, String entityNumber, String permItemId, IFormView formView, boolean checkModel) {
        if (checkModel && ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
            return true;
        }
        int re = FunPermissionHelper.checkItemPermission(userId, modelId, appId, entityNumber, permItemId, formView, checkModel);
        return re == 1;
    }

    public static int checkBGRP4SpecialApp(Long modelId, Long userId, String formId, String checkAppId, String permItemId, IFormView formView, boolean checkModel) {
        int permResult = 0;
        AppInfo bgrpInfo = AppMetadataCache.getAppInfoByNumber((String)ApplicationTypeEnum.BGRP.getAppnum());
        if ((NewEbAppUtil.bgrpEbModelPage.contains(formId) || NewEbAppUtil.bgrpNewEbPage.contains(formId)) && checkModel && !bgrpInfo.getId().equals(checkAppId)) {
            if (formView != null) {
                String appId = formView.getFormShowParameter().getAppId();
                if (ApplicationTypeEnum.BGRP.getAppnum().equals(appId) || ApplicationTypeEnum.EB.getAppnum().equals(appId) || ApplicationTypeEnum.BGMD.getAppnum().equals(appId) || ApplicationTypeEnum.BGM.getAppnum().equals(appId)) {
                    return permResult;
                }
            }
            permResult = FunPermissionHelper.checkItemPermission(userId, modelId, bgrpInfo.getId(), formId, permItemId, true);
        }
        return permResult;
    }

    public static int checkItemPermission(long userId, long dimObjId, String appId, String entityNumber, String permItemId) {
        return FunPermissionHelper.checkItemPermission(userId, dimObjId, appId, entityNumber, permItemId, null, true);
    }

    public static int checkItemPermission(long userId, long dimObjId, String appId, String entityNumber, String permItemId, IFormView formView, boolean checkModel) {
        int permResult = FunPermissionHelper.checkItemPermission(userId, dimObjId, appId, entityNumber, permItemId, checkModel);
        if (permResult == 0) {
            permResult = FunPermissionHelper.checkBGRP4SpecialApp(dimObjId, userId, entityNumber, appId, permItemId, formView, checkModel);
        }
        return permResult;
    }

    private static int checkItemPermission(long userId, long dimObjId, String appId, String entityNumber, String permItemId, boolean checkModel) {
        int permResult = !checkModel || FunPermissionHelper.isDatasource(entityNumber) ? PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_NULL", (long)0L, (String)appId, (String)entityNumber, (String)permItemId) : PermissionServiceHelper.checkPermission((long)userId, (String)"epm_model", (long)dimObjId, (String)appId, (String)entityNumber, (String)permItemId);
        return permResult;
    }

    public static boolean isDatasource(String entityNumber) {
        return "bcm_datasourceedit".equals(entityNumber);
    }
}

