/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;

public class MemberPermCacheServiceHelper {
    private static final Log log = LogFactory.getLog(MemberPermCacheServiceHelper.class);

    @Deprecated
    public static IMemberPermCache build(Long modelId, String[] dimNums, boolean verifyHasPerm) {
        return new MemberPermCache(null, modelId, 0L, dimNums);
    }

    @Deprecated
    public static IMemberPermCache build(Long modelId, String[] dimNums) {
        return new MemberPermCache(null, modelId, 0L, dimNums);
    }

    public static IMemberPermCache build(Long userId, Long modelId, Long bizModelId, String[] dimNums) {
        return new MemberPermCache(userId, modelId, bizModelId, dimNums);
    }

    @Deprecated
    public static IMemberPermCache build(Long userId, Long modelId, String[] dimNums) {
        return new MemberPermCache(userId, modelId, 0L, dimNums);
    }

    static class MemberPermCache
    implements IMemberPermCache {
        private static final long serialVersionUID = 1L;
        private Long userId;
        private Long modelId;
        private Long bizModelId;
        private Map<Long, String> dimIdNumberMapping = new HashMap<Long, String>();
        private boolean isHasRootPerm;

        @Override
        public boolean isHasRootPerm() {
            return this.isHasRootPerm;
        }

        private MemberPermCache(Long userId, Long modelId, Long bizModelId) {
            this.userId = userId;
            this.modelId = modelId;
            this.bizModelId = bizModelId;
            this.isHasRootPerm = ModelServiceHelper.isUserHasRootPermByModel(this.getUserId(), modelId);
        }

        private MemberPermCache(Long userId, Long modelId, Long bizModelId, String[] dimnums) {
            this(userId, modelId, bizModelId);
        }

        private Long getUserId() {
            return this.userId != null && this.userId != 0L ? this.userId : UserUtils.getUserId();
        }

        private String getdimNumber(Long dimid) {
            String dimnumber = this.dimIdNumberMapping.get(dimid);
            if (dimnumber != null) {
                return dimnumber;
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimid), new QFilter("model", "=", (Object)this.modelId)}, null);){
                if (ds.hasNext()) {
                    dimnumber = ds.next().getString("number");
                    this.dimIdNumberMapping.put(dimid, dimnumber);
                    String string = dimnumber;
                    return string;
                }
            }
            throw new KDBizException(ResManager.loadResFormat((String)"id\u4e3a\uff1a%1\u7684\u7ef4\u5ea6\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MemberPermCacheServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[]{dimid}));
        }

        @Override
        public boolean isNoperm(String dimnumber, String membernumber, Long viewId) {
            if (this.isHasRootPerm) {
                return false;
            }
            Set<String> noperm = EpmThreadLocalUtils.getPermMembNumbers(this.getUserId(), dimnumber, this.modelId, this.bizModelId, viewId, DimMembPermType.READ, false);
            return noperm != null && noperm.contains(membernumber);
        }

        @Override
        public boolean isNoperm(Long dimid, String membernumber, Long viewId) {
            Set<String> noperm;
            if (this.isHasRootPerm) {
                return false;
            }
            String dimnumber = this.dimIdNumberMapping.get(dimid);
            if (dimnumber == null) {
                dimnumber = this.getdimNumber(dimid);
            }
            return (noperm = EpmThreadLocalUtils.getPermMembNumbers(this.getUserId(), dimnumber, this.modelId, this.bizModelId, viewId, DimMembPermType.READ, false)) != null && noperm.contains(membernumber);
        }

        @Override
        public Set<String> getNopermMems(String dimnumber, Long viewId) {
            return DimMembPermHelper.getPermMembNumbers(this.getUserId(), dimnumber, this.modelId, this.bizModelId, viewId, DimMembPermType.READ, false);
        }

        @Override
        public Set<String> getWritePermMems(String dimnumber, Long viewId) {
            return DimMembPermHelper.getPermMembNumbers(this.getUserId(), dimnumber, this.modelId, this.bizModelId, viewId, DimMembPermType.WRITE, true);
        }

        @Override
        public boolean hasWritePerm(String dimnumber, String memberNumber, Long viewId) {
            if (this.isHasRootPerm) {
                return true;
            }
            if (DimMembPermUtil.needCheckDataPerm(dimnumber, this.modelId)) {
                Set<String> writePerm = EpmThreadLocalUtils.getPermMembNumbers(this.getUserId(), dimnumber, this.modelId, this.bizModelId, viewId, DimMembPermType.WRITE, true);
                return writePerm != null && writePerm.contains(memberNumber);
            }
            return true;
        }
    }
}

