/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.DataPermDataTypeEnum;
import kd.epm.eb.common.enums.DataPermTypeEnum;
import kd.epm.eb.common.enums.PermEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.tree.model.DataPermTreeNode;
import kd.epm.eb.common.tree.model.PermDataNodeTreeBuilder;
import kd.epm.eb.common.utils.QFBuilder;

public class PermUpdateUtil {
    private static final Log log = LogFactory.getLog(PermUpdateUtil.class);
    private List<Integer> noPermNums = Arrays.asList(DataPermTypeEnum.NOREAD.getPermNum(), DataPermTypeEnum.NOWRITE.getPermNum());
    private List<Integer> readPermNums = Collections.singletonList(DataPermTypeEnum.READ.getPermNum());
    private List<Integer> readWritePermNums = Arrays.asList(DataPermTypeEnum.READ.getPermNum(), DataPermTypeEnum.WRITE.getPermNum());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String update() {
        DynamicInfoCollection modelInfo;
        long beginTime;
        Throwable throwable;
        TXHandle tx;
        String info;
        block22: {
            String string;
            block23: {
                block20: {
                    String string2;
                    block21: {
                        info = "";
                        tx = TX.requiresNew((String)"ebOldPermDataUpdata");
                        throwable = null;
                        beginTime = System.currentTimeMillis();
                        if (this.checkNeedUpdate()) break block20;
                        string2 = "no need";
                        if (tx == null) return string2;
                        if (throwable == null) break block21;
                        try {
                            tx.close();
                            return string2;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        return string2;
                    }
                    tx.close();
                    return string2;
                }
                modelInfo = this.collectModelDim();
                if (!modelInfo.isEmpty()) break block22;
                string = "no model to update";
                if (tx == null) return string;
                if (throwable == null) break block23;
                try {
                    tx.close();
                    return string;
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                return string;
            }
            tx.close();
            return string;
        }
        try {
            try {
                HashSet<Long> allUserIds = new HashSet<Long>();
                this.collecFunPermUsers(modelInfo, allUserIds);
                this.collecOldPermRecordAndUpdate(modelInfo, allUserIds);
                long endTime = System.currentTimeMillis();
                info = "end update " + (endTime - beginTime);
                return info;
            }
            catch (Exception e) {
                log.error((Throwable)e);
                if (e instanceof KDBizException && e.getMessage().equals("noNeedToUpdateOldPerm")) return info;
                info = "update failed " + e.getMessage();
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private PermUpdateUtil() {
    }

    public static PermUpdateUtil getInstance() {
        return new PermUpdateUtil();
    }

    private boolean checkNeedUpdate() {
        String sqlStr = "select fid from t_eb_dataperm where fmodel = 0";
        boolean need = true;
        try (DataSet dataSet = DB.queryDataSet((String)"EPM-checkNeedUpdateOldPerm", (DBRoute)new DBRoute("EPM"), (String)sqlStr);){
            if (dataSet.hasNext()) {
                need = false;
            }
        }
        return need;
    }

    private DynamicInfoCollection collectModelDim() {
        QFBuilder qb = new QFBuilder("model.reporttype", "=", ApplicationTypeEnum.EB.getIndex());
        qb.or("model.reporttype", "=", ApplicationTypeEnum.BGMD.getIndex());
        DynamicInfoCollection modelInfo = new DynamicInfoCollection("modelInfo", "id", "number", "dimension", "funPermUsers");
        DBRoute dbRoute = new DBRoute("bcm");
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"t_bcm_model")) {
            return modelInfo;
        }
        String sql = "select fid,fshownumber from t_bcm_model where freporttype = '4' or freporttype = '7'";
        Row row = null;
        try (DataSet dataSet = DB.queryDataSet((String)"updateoldperm-getmodels", (DBRoute)dbRoute, (String)sql);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                modelInfo.addInfo(row.getLong("fid"), row.getString("fshownumber"), new DynamicInfoCollection("dimnesion", "id", "number", "permUsers", "defaultPerm"), new HashSet());
            }
        }
        if (!modelInfo.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < modelInfo.getValues().size(); ++i) {
                sb.append("?");
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sql = "select fid,fnumber,fisuseddataperm,fmodelid from t_bcm_dimension where fmodelid in (" + sb + ")";
            try (DataSet dataSet = DB.queryDataSet((String)"updateoldperm-getDimension", (DBRoute)dbRoute, (String)sql, (Object[])modelInfo.getAllValOfOneProp("id").toArray());){
                Long dimId = null;
                Object infoObject = null;
                DynamicInfoCollection dimInfo = null;
                while (dataSet.hasNext()) {
                    boolean dimDefPerm;
                    row = dataSet.next();
                    Long modelId = row.getLong("fmodelid");
                    dimId = row.getLong("fid");
                    String dimNum = row.getString("fnumber");
                    boolean bl = dimDefPerm = row.getInteger("fisuseddataperm") == 1;
                    dimInfo = (DynamicInfoCollection)modelInfo.getValOfOnePropByAnotherProp("dimension", "id", modelId);
                    if (dimInfo == null) continue;
                    dimInfo.addInfo(dimId, dimNum, new DynamicInfoCollection("permUsers", "id", "userType", "permRecord"), dimDefPerm);
                }
            }
        }
        return modelInfo;
    }

    private void collecFunPermUsers(DynamicInfoCollection modelInfo, Set<Long> allUserIds) {
        Set funPermUsers;
        Long userId;
        Long modelId;
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < modelInfo.getValues().size(); ++i) {
            sb.append("?");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setCharAt(sb.length() - 1, ')');
        }
        DBRoute dbRoute = new DBRoute("sys");
        String sql = "select forgid,fuserid from t_perm_userperm where forgid in " + sb;
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"t_perm_userperm")) {
            throw new KDBizException("noNeedToUpdateOldPerm");
        }
        Row row = null;
        try (DataSet dataSet = DB.queryDataSet((String)"collecFunPermUsers", (DBRoute)dbRoute, (String)sql, (Object[])modelInfo.getAllValOfOneProp("id").toArray());){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                modelId = row.getLong("forgid");
                userId = row.getLong("fuserid");
                allUserIds.add(userId);
                funPermUsers = (Set)modelInfo.getValOfOnePropByAnotherProp("funPermUsers", "id", modelId);
                funPermUsers.add(userId);
            }
        }
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"t_perm_userrole")) {
            throw new KDBizException("noNeedToUpdateOldPerm");
        }
        sql = "select forgid,fuserid from t_perm_userrole where forgid in" + sb;
        dataSet = DB.queryDataSet((String)"switchOldPermRecord", (DBRoute)dbRoute, (String)sql, (Object[])modelInfo.getAllValOfOneProp("id").toArray());
        var11_9 = null;
        try {
            while (dataSet.hasNext()) {
                row = dataSet.next();
                modelId = row.getLong("forgid");
                userId = row.getLong("fuserid");
                allUserIds.add(userId);
                funPermUsers = (Set)modelInfo.getValOfOnePropByAnotherProp("funPermUsers", "id", modelId);
                funPermUsers.add(userId);
            }
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var11_9 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var11_9.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    private Map<Long, Long> getAllUserGroupInfo(Set<Long> userIds) {
        StringBuilder sb = new StringBuilder();
        HashMap<Long, Long> userGroupInfo = new HashMap<Long, Long>();
        if (userIds.isEmpty()) {
            return userGroupInfo;
        }
        userIds.forEach(userId -> {
            sb.append("?");
            sb.append(',');
        });
        sb.deleteCharAt(sb.length() - 1);
        DBRoute dbRoute = new DBRoute("sys");
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"T_SEC_UserGroupStaff")) {
            throw new KDBizException("noNeedToUpdateOldPerm");
        }
        String sql = "select FUserGroupID,fuserid from T_SEC_UserGroupStaff where fuserid in(" + sb + ")";
        try (DataSet dataSet = DB.queryDataSet((String)"getAllUserGroupInfo", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])userIds.toArray());){
            for (Row row : dataSet) {
                Long userId2 = row.getLong("fuserid");
                Long groupId = row.getLong("FUserGroupID");
                userGroupInfo.put(userId2, groupId);
            }
        }
        return userGroupInfo;
    }

    private void collecOldPermRecordAndUpdate(DynamicInfoCollection modelInfo, Set<Long> allUserIds) {
        HashMap<Long, Set<Long>> modelGroupRecord = new HashMap<Long, Set<Long>>();
        DBRoute dbRoute = new DBRoute("bcm");
        String sql = "select fmember,frange,fpermission,fmodel,fusersid,fusertype,fdimensionid from t_bcm_memberperm where fmodel = ?";
        for (DynamicInfoCollection.InfoObject infoObject : modelInfo.getValues()) {
            this.queryOldPerm(dbRoute, modelGroupRecord, sql, infoObject, modelInfo, allUserIds);
        }
        Map<Long, Long> userGroupInfo = this.getAllUserGroupInfo(allUserIds);
        for (DynamicInfoCollection.InfoObject model : modelInfo.getValues()) {
            this.changeRecord(model, userGroupInfo, allUserIds, (Set)modelGroupRecord.get(model.getValueByPropName("id")));
        }
        String string = "insert into t_eb_dataperm (fid,fpermission,fmembertype,fdatatype,fmember,FUSERSID,fmodel,fusertype,fdimension,fisconfer) values (?,?,?,?,?,?,?,?,?,?)";
        DB.execute((DBRoute)new DBRoute("EPM"), (String)string, (Object[])new Object[]{DBServiceHelper.genGlobalLongId(), 0, "", 0, 0L, 0L, 0L, "", 0L, 1});
    }

    private void queryOldPerm(DBRoute dbRoute, Map<Long, Set<Long>> modelGroupRecord, String sql, DynamicInfoCollection.InfoObject model, DynamicInfoCollection modelInfo, Set<Long> allUserIds) {
        Row row = null;
        String userType = null;
        Set<Long> groupIds = null;
        try (DataSet dataSet = DB.queryDataSet((String)"collecOldPermRecord", (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{model.getValueByPropName("id")});){
            while (dataSet.hasNext()) {
                DynamicInfoCollection permRecordInfo;
                row = dataSet.next();
                Long userId = row.getLong("fusersid");
                Long modelId = row.getLong("fmodel");
                DynamicInfoCollection dimInfo = (DynamicInfoCollection)modelInfo.getValOfOnePropByAnotherProp("dimension", "id", modelId);
                DynamicInfoCollection permUsersInfo = (DynamicInfoCollection)dimInfo.getValOfOnePropByAnotherProp("permUsers", "id", row.getLong("fdimensionid"));
                if (permUsersInfo == null) continue;
                DynamicInfoCollection.InfoObject infoObject = permUsersInfo.getInfoByOneProp("id", userId);
                if (infoObject == null) {
                    userType = row.getString("fusertype");
                    if (userType.equals("bos_user")) {
                        allUserIds.add(userId);
                    } else {
                        groupIds = modelGroupRecord.get(modelId);
                        if (groupIds == null) {
                            groupIds = new HashSet<Long>();
                            modelGroupRecord.put(modelId, groupIds);
                        }
                        groupIds.add(userId);
                    }
                    permRecordInfo = new DynamicInfoCollection("permRecordInfo", "perm", "range", "membId");
                    permUsersInfo.addInfo(userId, userType, permRecordInfo);
                } else {
                    permRecordInfo = (DynamicInfoCollection)infoObject.getValueByPropName("permRecord");
                }
                permRecordInfo.addInfo(row.getInteger("fpermission"), row.getString("frange"), row.getLong("fmember"));
            }
        }
    }

    private void changeRecord(DynamicInfoCollection.InfoObject model, Map<Long, Long> userGroupInfo, Set<Long> userIds, Set<Long> groupRecord) {
        HashSet<Long> oldDataPermUsers = new HashSet<Long>();
        DynamicInfoCollection dimInfo = (DynamicInfoCollection)model.getValueByPropName("dimension");
        Long modelId = (Long)model.getValueByPropName("id");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Set funPermUsers = (Set)model.getValueByPropName("funPermUsers");
        if (groupRecord != null) {
            funPermUsers.addAll(groupRecord);
        }
        if (dimInfo != null) {
            Date date = TimeServiceHelper.now();
            for (DynamicInfoCollection.InfoObject dim : dimInfo.getValues()) {
                String userType;
                DataPermTreeNode membTreeNode;
                oldDataPermUsers.clear();
                boolean defaultPerm = (Boolean)dim.getValueByPropName("defaultPerm");
                String dimNum = (String)dim.getValueByPropName("number");
                Long dimId = (Long)dim.getValueByPropName("id");
                SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber(dimNum);
                String entryKey = dimensionEnum == null ? "bcm_userdefinedmembertree" : dimensionEnum.getMemberTreemodel();
                DynamicInfoCollection permUsersInfo = (DynamicInfoCollection)dimInfo.getValOfOnePropByAnotherProp("permUsers", "id", dim.getValueByPropName("id"));
                if (permUsersInfo.isEmpty() && !defaultPerm || (membTreeNode = PermDataNodeTreeBuilder.buildTree(modelId, dimId, entryKey, new String[0])) == null) continue;
                for (DynamicInfoCollection.InfoObject permUser : permUsersInfo.getValues()) {
                    DynamicInfoCollection permRecordInfo = (DynamicInfoCollection)permUser.getValueByPropName("permRecord");
                    Long userId = (Long)permUser.getValueByPropName("id");
                    oldDataPermUsers.add(userId);
                    userType = (String)permUser.getValueByPropName("userType");
                    for (DynamicInfoCollection.InfoObject record : permRecordInfo.getValues()) {
                        int permmision = (Integer)record.getValueByPropName("perm");
                        if (permmision == PermEnum.NOPERM.getValue() && !defaultPerm || permmision != PermEnum.NOPERM.getValue() && defaultPerm) continue;
                        Long membId = (Long)record.getValueByPropName("membId");
                        String permRange = (String)record.getValueByPropName("range");
                        DataPermTreeNode membNode = PermDataNodeTreeBuilder.getChildNodeByNodeId(membId, membTreeNode);
                        if (membNode == null) continue;
                        this.fillNodePerm(membNode, permRange, permmision);
                    }
                    List<Integer> defaultPermNums = defaultPerm ? this.readWritePermNums : this.noPermNums;
                    membTreeNode.iterate(20, childNode -> {
                        if (childNode.getPermNums().isEmpty()) {
                            childNode.setPermNums(defaultPermNums);
                        }
                    });
                    this.dealRootNodePermObj(membTreeNode, paramsList, entryKey, DataPermDataTypeEnum.MEMBER.getDataTypeNum(), modelId, userId, userType, dimId, 1, date);
                    this.dealPermObj4Save(membTreeNode, paramsList, entryKey, DataPermDataTypeEnum.MEMBER.getDataTypeNum(), modelId, userId, userType, dimId, 1, date);
                }
                if (defaultPerm) {
                    for (Long user : funPermUsers) {
                        if (oldDataPermUsers.contains(user)) continue;
                        userType = "bos_user";
                        if (userIds.contains(user)) {
                            Long groupId = userGroupInfo.get(user);
                            if (groupId != null && funPermUsers.contains(groupId) && !oldDataPermUsers.contains(groupId)) {
                                continue;
                            }
                        } else {
                            userType = "bos_usergroup";
                        }
                        paramsList.add(new Object[]{DBServiceHelper.genGlobalLongId(), DataPermTypeEnum.READ.getPermNum(), entryKey, DataPermDataTypeEnum.MEMBER.getDataTypeNum(), membTreeNode.getId(), user, modelId, userType, dimId, 1, date});
                        paramsList.add(new Object[]{DBServiceHelper.genGlobalLongId(), DataPermTypeEnum.WRITE.getPermNum(), entryKey, DataPermDataTypeEnum.MEMBER.getDataTypeNum(), membTreeNode.getId(), user, modelId, userType, dimId, 1, date});
                    }
                }
                funPermUsers.addAll(oldDataPermUsers);
            }
        }
        if (!paramsList.isEmpty()) {
            String sqlStr = "insert into t_eb_dataperm (fid,fpermission,fmembertype,fdatatype,fmember,FUSERSID,fmodel,fusertype,fdimension,fisconfer,fmodifydate) values (?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)new DBRoute("EPM"), (String)sqlStr, paramsList);
        }
        model.getValues().clear();
    }

    private void fillNodePerm(DataPermTreeNode membNode, String range, int perm) {
        List<Integer> newPermNums = this.getNewPermNums(perm);
        Long membId = membNode.getId();
        switch (range) {
            case "10": {
                this.setPermNums(membNode, newPermNums);
                break;
            }
            case "20": {
                membNode.getChilds().forEach(childNode -> this.setPermNums((DataPermTreeNode)childNode, newPermNums));
                break;
            }
            case "30": {
                this.setPermNums(membNode, newPermNums);
                membNode.getChilds().forEach(childNode -> this.setPermNums((DataPermTreeNode)childNode, newPermNums));
                break;
            }
            case "40": {
                membNode.iterate(20, childNode -> {
                    if (!childNode.getId().equals(membId)) {
                        this.setPermNums((DataPermTreeNode)childNode, newPermNums);
                    }
                });
                break;
            }
            case "50": {
                membNode.iterate(20, childNode -> this.setPermNums((DataPermTreeNode)childNode, newPermNums));
                break;
            }
            case "60": {
                DataPermTreeNode pNode = membNode.getParent();
                if (pNode == null) {
                    return;
                }
                pNode.getChilds().forEach(childNode -> {
                    if (!childNode.getId().equals(membId)) {
                        this.setPermNums((DataPermTreeNode)childNode, newPermNums);
                    }
                });
                break;
            }
            case "70": {
                DataPermTreeNode pNode = membNode.getParent();
                if (pNode == null) {
                    this.setPermNums(membNode, newPermNums);
                    break;
                }
                pNode.getChilds().forEach(childNode -> this.setPermNums((DataPermTreeNode)childNode, newPermNums));
                break;
            }
        }
    }

    private void dealRootNodePermObj(DataPermTreeNode rootNode, List<Object[]> permObjs, String membEntity, int dataType, Long modelId, Long userId, String userType, Long dimensionId, Object isConfer, Date nowTime) {
        List<Integer> pPermNums = rootNode.getPermNums();
        if (!pPermNums.isEmpty()) {
            for (int permNum : pPermNums) {
                if (permNum <= 0) continue;
                permObjs.add(new Object[]{DBServiceHelper.genGlobalLongId(), permNum, membEntity, dataType, rootNode.getId(), userId, modelId, userType, dimensionId, isConfer, nowTime});
            }
        }
    }

    private void dealPermObj4Save(DataPermTreeNode rootNode, List<Object[]> permObjs, String membEntity, int dataType, Long modelId, Long userId, String userType, Long dimensionId, Object isConfer, Date nowTime) {
        List<Integer> pPermNums = rootNode.getPermNums();
        rootNode.setPermNums(null);
        List<Integer> childPermNums = null;
        DataPermTreeNode node = null;
        if (rootNode.getChildren() != null) {
            Iterator<DataPermTreeNode> iterator = rootNode.getChildren().iterator();
            while (iterator.hasNext()) {
                DataPermTreeNode childNode;
                node = childNode = iterator.next();
                childPermNums = node.getPermNums();
                for (int permNum : pPermNums) {
                    if (!childPermNums.contains(-permNum)) continue;
                    permObjs.add(new Object[]{DBServiceHelper.genGlobalLongId(), -permNum, membEntity, dataType, node.getId(), userId, modelId, userType, dimensionId, isConfer, nowTime});
                }
                this.dealPermObj4Save(node, permObjs, membEntity, dataType, modelId, userId, userType, dimensionId, isConfer, nowTime);
            }
        }
    }

    private void setPermNums(DataPermTreeNode membNode, List<Integer> permNums) {
        if (membNode.getPermNums().size() < permNums.size()) {
            membNode.setPermNums(permNums);
        }
    }

    private List<Integer> getNewPermNums(int perm) {
        List<Integer> permNums = null;
        permNums = perm == PermEnum.NOPERM.getValue() ? this.noPermNums : (perm == PermEnum.READWRITE.getValue() ? this.readWritePermNums : this.readPermNums);
        return permNums;
    }
}

