/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BcmPermSingleModel {
    private static final Log log = LogFactory.getLog(BcmPermSingleModel.class);
    private Map<String, Map<String, String>> permitem;
    private Map<String, List<String>> permbyentity;

    private BcmPermSingleModel() {
        this.setPermitem(this.getPermItem());
        this.setPermbyentity(this.getPermByEntity());
    }

    public Map<String, Map<String, String>> getPermitem() {
        return this.permitem;
    }

    private void setPermitem(Map<String, Map<String, String>> permitem) {
        this.permitem = permitem;
    }

    public Map<String, List<String>> getPermbyentity() {
        return this.permbyentity;
    }

    private void setPermbyentity(Map<String, List<String>> permbyentity) {
        this.permbyentity = permbyentity;
    }

    public static BcmPermSingleModel getInstance() {
        return BcmPermSingleModelHolder.INSTANCE;
    }

    private Map<String, List<String>> getPermByEntity() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream("perm/permitemlist.xlsx");
            XSSFWorkbook hssfWorkbook = new XSSFWorkbook(in);
            XSSFSheet sheetAt = hssfWorkbook.getSheetAt(0);
            for (int rowNum = 1; rowNum <= sheetAt.getLastRowNum(); ++rowNum) {
                XSSFRow row = sheetAt.getRow(rowNum);
                String entity = this.getCellValue(row.getCell(2));
                ArrayList<String> list = (ArrayList<String>)map.get(entity);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                String permitem = this.getCellValue(row.getCell(3));
                list.add(permitem);
                map.put(entity, list);
            }
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.toString(e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return map;
    }

    private Map<String, Map<String, String>> getPermItem() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream("perm/permitemlist.xlsx");
            XSSFWorkbook hssfWorkbook = new XSSFWorkbook(in);
            XSSFSheet sheetAt = hssfWorkbook.getSheetAt(0);
            for (int rowNum = 1; rowNum <= sheetAt.getLastRowNum(); ++rowNum) {
                XSSFRow row = sheetAt.getRow(rowNum);
                String form = this.getCellValue(row.getCell(0));
                if (StringUtils.isEmpty((String)form)) continue;
                HashMap<String, String> itemmap = (HashMap<String, String>)map.get(form);
                if (itemmap == null) {
                    itemmap = new HashMap<String, String>();
                }
                String opsign = this.getCellValue(row.getCell(1));
                String entity = this.getCellValue(row.getCell(2));
                String permitem = this.getCellValue(row.getCell(3));
                String value = entity + "@" + permitem;
                itemmap.put(opsign, value);
                map.put(form, itemmap);
            }
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.toString(e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return map;
    }

    private String getCellValue(XSSFCell c) {
        if (c == null) {
            return "";
        }
        return c.getStringCellValue();
    }

    private static class BcmPermSingleModelHolder {
        private static final BcmPermSingleModel INSTANCE = new BcmPermSingleModel();

        private BcmPermSingleModelHolder() {
        }
    }
}

