/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.enums;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.PermGroupEnum;

public enum DimMembPermType {
    GIVE(1, 1, "give_box", DimMembPermType.getGIVE(), PermGroupEnum.DATA, false),
    MANAGER(2, 2, "manager_box", DimMembPermType.getMANAGER(), PermGroupEnum.MANAGER, false),
    READ(3, 4, "read_box", DimMembPermType.getREAD(), PermGroupEnum.DATA, true),
    WRITE(4, 8, "write_box", DimMembPermType.getWRITE(), PermGroupEnum.DATA, true),
    DATAPERMEXTENDS(5, 16, "extends_box", DimMembPermType.getEXTENDS(), PermGroupEnum.DATA, false);

    private boolean isDataPerm;
    private int index;
    private MultiLangEnumBridge name;
    private String boxKey;
    private PermGroupEnum permGroup;
    private byte divNum;

    private DimMembPermType(int index, byte divNum, String boxKey, MultiLangEnumBridge name, PermGroupEnum permGroup, boolean isDataPerm) {
        this.index = index;
        this.name = name;
        this.divNum = divNum;
        this.boxKey = boxKey;
        this.permGroup = permGroup;
        this.isDataPerm = isDataPerm;
    }

    public boolean isDataPerm() {
        return this.isDataPerm;
    }

    public PermGroupEnum getPermGroup() {
        return this.permGroup;
    }

    public String getBoxKey() {
        return this.boxKey;
    }

    public byte getDivNum() {
        return this.divNum;
    }

    private static MultiLangEnumBridge getGIVE() {
        return new MultiLangEnumBridge("\u6388\u6743\u6743", "DimMembPermType_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMANAGER() {
        return new MultiLangEnumBridge("\u7ba1\u7406\u6743", "DimMembPermType_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getREAD() {
        return new MultiLangEnumBridge("\u6570\u636e\u8bfb\u53d6", "DimMembPermType_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getWRITE() {
        return new MultiLangEnumBridge("\u6570\u636e\u5199\u5165", "DimMembPermType_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEXTENDS() {
        return new MultiLangEnumBridge("\u7ee7\u627f\u6743", "DimMembPermType_5", "epm-eb-common");
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public boolean hasPerm(byte allPermNum) {
        return DimMembPermUtil.hasPerm(allPermNum, this);
    }

    public byte setPermValue(byte allPermNum, boolean hasPerm) {
        return DimMembPermUtil.setPermValue(allPermNum, this, hasPerm);
    }

    public byte setPermValue(int allPermNum, boolean hasPerm) {
        return DimMembPermUtil.setPermValue((byte)allPermNum, this, hasPerm);
    }

    public static DimMembPermType getPermTypeByBoxKey(String boxKey) {
        for (DimMembPermType permType : DimMembPermType.values()) {
            if (!permType.getBoxKey().equals(boxKey)) continue;
            return permType;
        }
        return null;
    }

    public static List<DimMembPermType> getPermTypeListByGroup(PermGroupEnum permGroup) {
        ArrayList<DimMembPermType> result = new ArrayList<DimMembPermType>(16);
        for (DimMembPermType permType : DimMembPermType.values()) {
            if (permGroup != permType.getPermGroup()) continue;
            result.add(permType);
        }
        return result;
    }

    public static boolean hasNotDataPerm(byte permVal) {
        return MANAGER.hasPerm(permVal) || GIVE.hasPerm(permVal);
    }
}

