/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.membPerm;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.perm.PermCheckCallBackInfo;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.impl.perm.SinglePermInfo;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermHandler;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.pojo.BooleanObj;
import kd.epm.eb.common.utils.IDUtils;

public class DimMembPermFilterReader
extends DimMemberPermHandler {
    private Collection<String> refFilterDimNums;
    private String targetDimNum;
    private Long targetViewId;

    public DimMembPermFilterReader(Collection<String> refFilterDimNums, String targetDimNum, Long targetViewId) {
        this.refFilterDimNums = refFilterDimNums;
        this.targetDimNum = targetDimNum;
        this.targetViewId = targetViewId;
    }

    public Set<Long> readPerm(Map<String, Set<Long>> memberFilters) {
        List<PermDimGroup> matchDimGroup = this.getMatchDimGroup();
        Set<String> matchSingleDim = this.getMatchSingleDim();
        HashSet<Long> filterMemberIds = new HashSet<Long>();
        String dimNum = this.getDimNum();
        HashSet<Long> memberIdsBySingleDim = new HashSet<Long>();
        MemberTree targetTree = this.getTargetTree();
        if (matchDimGroup != null) {
            for (PermDimGroup dimGroup : matchDimGroup) {
                String dimShortNumStr = dimGroup.getDimShortNumStr();
                Map<Long, List<RowRecord>> allRowRecords = this.getMultiDimPermRowRecords().get(dimShortNumStr);
                if (allRowRecords == null || allRowRecords.isEmpty()) continue;
                List<MemberTree> dimTrees = DimMembPermUtil.getDimViews(dimGroup.getDimNums(), this.getModelCacheHelper(), this.getBizModelId());
                DimMembPermUtil.parsePermRecord(dimShortNumStr, allRowRecords, dimTrees, this.getMemberPropCache(), this.getPermTypes(), false, memberFilters, permInfo -> {
                    MemberItem memberItem = permInfo.getMemberGroup().get(dimNum);
                    if (memberItem != null) {
                        if (targetTree == null || !memberItem.isMember() || targetTree.getMember(memberItem.getMemberId()) != null) {
                            filterMemberIds.add(memberItem.getMemberId());
                        }
                        PermCheckCallBackInfo callBackInfo = new PermCheckCallBackInfo();
                        callBackInfo.setRemoveDim(dimNum);
                        permInfo.setCallBackInfo(callBackInfo);
                    }
                });
            }
        }
        if (matchSingleDim != null) {
            Map<String, MemberTree> dimTrees = DimMembPermUtil.getDimViewMap(matchSingleDim, this.getModelCacheHelper(), this.getBizModelId());
            Map<String, Map<Long, List<SinglePermInfo>>> singleDimMemberUPermInfo = this.getSingleDimMemberUPermInfo();
            if (singleDimMemberUPermInfo.keySet().containsAll(matchSingleDim)) {
                if (matchSingleDim.size() == 1) {
                    this.iterateMember(singleDimMemberUPermInfo, dimTrees, matchSingleDim.iterator().next(), (member, permVal) -> memberIdsBySingleDim.add((Long)member));
                } else {
                    this.readMultiDimPerm(matchSingleDim, dimTrees, singleDimMemberUPermInfo, memberFilters, memberIdsBySingleDim, dimNum);
                }
            }
        }
        if (memberIdsBySingleDim.size() > 0) {
            filterMemberIds.addAll(memberIdsBySingleDim);
        }
        return filterMemberIds;
    }

    private MemberTree getTargetTree() {
        List<MemberTree> dimViews;
        MemberTree memberTree = null;
        if (IDUtils.isNotEmptyLong(this.targetViewId).booleanValue() && (dimViews = DimMembPermUtil.getDimViews(Sets.newHashSet((Object[])new String[]{this.getDimNum()}), this.getModelCacheHelper(), this.getBizModelId())).size() > 0) {
            memberTree = dimViews.get(0);
        }
        return memberTree;
    }

    private String getDimNum() {
        return this.targetDimNum;
    }

    @Override
    protected void initMatchDimInfo(PermGroupEnum permGroup, Long modelId, Set<String> permCtrlDimNums) {
        super.initMatchDimInfo(permGroup, modelId, permCtrlDimNums);
        Set<String> matchSingleDim = this.getMatchSingleDim();
        if (matchSingleDim == null) {
            matchSingleDim = new HashSet<String>(16);
        }
        if (this.refFilterDimNums != null) {
            for (String dimNum : this.refFilterDimNums) {
                if (!permCtrlDimNums.contains(dimNum)) continue;
                matchSingleDim.add(dimNum);
            }
        }
        matchSingleDim.add(this.targetDimNum);
        this.setMatchSingleDim(matchSingleDim);
    }

    private void readMultiDimPerm(Set<String> toCheckDimNums, Map<String, MemberTree> dimTrees, Map<String, Map<Long, List<SinglePermInfo>>> singleDimMemberUPermInfo, Map<String, Set<Long>> filterMemberMap, Set<Long> memberIds, String dimNum) {
        block0: for (String cDimNum : toCheckDimNums) {
            if (cDimNum.equals(dimNum)) {
                this.iterateMember(singleDimMemberUPermInfo, dimTrees, cDimNum, (member, permVal) -> memberIds.add((Long)member));
                continue;
            }
            Set<Long> refMemberIds = filterMemberMap.get(cDimNum);
            Map<Long, List<SinglePermInfo>> dimPermInfo = singleDimMemberUPermInfo.get(cDimNum);
            if (refMemberIds != null && dimPermInfo != null) {
                MemberTree memberTree = dimTrees.get(cDimNum);
                BooleanObj hasPerm = new BooleanObj();
                for (Long membId : refMemberIds) {
                    Member member2 = memberTree.getMember(membId);
                    if (member2 == null) continue;
                    for (List<SinglePermInfo> permInfos : dimPermInfo.values()) {
                        if (permInfos == null) continue;
                        this.iteratePermTypeList(permInfos, member2, (memb, permVal) -> hasPerm.mark(true));
                        if (!hasPerm.marked()) continue;
                        continue block0;
                    }
                }
            } else if (dimPermInfo != null) {
                for (List<SinglePermInfo> permInfos : dimPermInfo.values()) {
                    if (permInfos == null) continue;
                    for (SinglePermInfo permInfo : permInfos) {
                        if (permInfo == null || (permInfo.getMemberPermVal() == null || permInfo.getMemberPermVal().isEmpty()) && (permInfo.getPermPropIds() == null || permInfo.getPermPropIds().size() <= 0)) continue;
                        continue block0;
                    }
                }
            }
            memberIds.clear();
            break;
        }
    }

    private void iterateMember(Map<String, Map<Long, List<SinglePermInfo>>> singleDimMemberUPermInfo, Map<String, MemberTree> memberTrees, String dimNum, BiConsumer<Long, Byte> memberConsumer) {
        List<SinglePermInfo> permInfos = singleDimMemberUPermInfo.get(dimNum).get(this.getTargetUserId());
        if (permInfos == null) {
            return;
        }
        MemberTree memberTree = memberTrees.get(dimNum);
        Member rootMember = memberTree.getRootMember(this.targetViewId);
        if (rootMember != null) {
            rootMember.iterate(member -> this.iteratePermTypeList(permInfos, (Member)member, memberConsumer));
        }
        if (this.needPropIds()) {
            HashSet<Long> propValIds = new HashSet<Long>(16);
            for (SinglePermInfo permInfo : permInfos) {
                if (permInfo != null && permInfo.getPermPropIds() != null && permInfo.getPermPropIds().size() > 0) {
                    if (propValIds.isEmpty()) {
                        propValIds.addAll(permInfo.getPermPropIds());
                    } else {
                        propValIds.retainAll(permInfo.getPermPropIds());
                    }
                } else {
                    propValIds.clear();
                }
                if (!propValIds.isEmpty()) continue;
                break;
            }
            byte permVal = 0;
            for (DimMembPermType permType : this.getPermTypes()) {
                permVal = permType.setPermValue(permVal, true);
            }
            for (Long propValId : propValIds) {
                memberConsumer.accept(propValId, permVal);
            }
        }
    }

    private boolean needPropIds() {
        for (DimMembPermType permType : this.getPermTypes()) {
            if (permType != DimMembPermType.GIVE) continue;
            return true;
        }
        return false;
    }

    private void iteratePermTypeList(List<SinglePermInfo> permInfos, Member member, BiConsumer<Long, Byte> memberConsumer) {
        byte permVal = 0;
        for (int index = 0; index < permInfos.size(); ++index) {
            SinglePermInfo permInfo = permInfos.get(index);
            if (permInfo == null || !permInfo.getMemberPermVal().get(member.getGlobalSeq())) {
                permVal = 0;
                break;
            }
            DimMembPermType permType = this.getPermTypes().get(index);
            permVal = permType.setPermValue(permVal, true);
        }
        if (permVal > 0) {
            memberConsumer.accept(member.getId(), permVal);
        }
    }

    @Override
    protected Map<String, Object> getBaseInfoMap() {
        Map<String, Object> baseInfoMap = super.getBaseInfoMap();
        baseInfoMap.put("refFilterDimNums", this.refFilterDimNums);
        baseInfoMap.put("targetDimNum", this.targetDimNum);
        return baseInfoMap;
    }
}

