/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.membPerm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.impl.perm.ContainResult;
import kd.epm.eb.common.cache.impl.perm.PermCheckResult;
import kd.epm.eb.common.cache.impl.perm.PermMemberItem;
import kd.epm.eb.common.cache.impl.perm.PermValObj;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.impl.perm.SinglePermInfo;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermHandler;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.pojo.BasedataPojo;

public class DimMemberPermChecker
extends DimMemberPermHandler {
    private Map<String, List<Pair<List<PermDimGroup>, List<String>>>> allMatchInfo = new HashMap<String, List<Pair<List<PermDimGroup>, List<String>>>>(16);

    private boolean checkSingleDimPerm(Collection<String> singleDim2Check, Map<String, PermMemberItem> memberGroupItem, Map<String, Boolean> checkResultMap) {
        for (String dimNum : singleDim2Check) {
            boolean hasPerm = checkResultMap.computeIfAbsent(dimNum, key -> {
                PermMemberItem permMemberItem = (PermMemberItem)memberGroupItem.get(key);
                if (permMemberItem != null) {
                    Map<Long, List<SinglePermInfo>> singleDimUPermInfos = this.getSingleDimMemberUPermInfo().get(key);
                    if (singleDimUPermInfos != null) {
                        PermValObj permValObj = new PermValObj(this.getPermTypes());
                        for (Map.Entry<Long, List<SinglePermInfo>> entry : singleDimUPermInfos.entrySet()) {
                            List<SinglePermInfo> permInfo = entry.getValue();
                            this.checkSingleDimPerm(permInfo, permMemberItem, permValObj);
                            if (!permValObj.hasAllPerm()) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            });
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    protected void checkSingleDimPerm(List<SinglePermInfo> singlePermInfo, PermMemberItem memberItem, PermValObj permValObj) {
        if (singlePermInfo == null || memberItem == null) {
            return;
        }
        for (int i = 0; i < permValObj.getPermTypes().size() && i < singlePermInfo.size(); ++i) {
            SinglePermInfo permInfo = singlePermInfo.get(i);
            if (permInfo == null) continue;
            DimMembPermType permType = permValObj.getPermTypes().get(i);
            if (memberItem.isMember()) {
                if (permInfo.getMemberPermVal() == null || !permInfo.getMemberPermVal().get(memberItem.getMember().getGlobalSeq())) continue;
                permValObj.updateVal(permType);
                continue;
            }
            if (permInfo.getPermPropIds() == null || !permInfo.getPermPropIds().contains(memberItem.getId())) continue;
            permValObj.updateVal(permType);
        }
    }

    private List<Pair<List<PermDimGroup>, List<String>>> getMatchInfo(Map<String, MemberItem> itemMap) {
        String dimNumStr = this.getDimensionNums().stream().filter(itemMap::containsKey).collect(Collectors.joining(","));
        return this.allMatchInfo.computeIfAbsent(dimNumStr, key -> {
            LinkedList<Pair<LinkedList<Object>, List<Object>>> result = new LinkedList<Pair<LinkedList<Object>, List<Object>>>();
            LinkedList matchMoreResult = new LinkedList();
            List<PermDimGroup> matchDimGroup = this.getMatchDimGroup();
            Set<String> matchSingleDim = this.getMatchSingleDim();
            if (matchSingleDim != null) {
                if (matchDimGroup != null) {
                    HashSet<String> toCheckDimNums = new HashSet<String>(itemMap.keySet());
                    LinkedList<PermDimGroup> matchGroup = new LinkedList<PermDimGroup>();
                    for (PermDimGroup permDimGroup : matchDimGroup) {
                        int checkResult = this.checkGroupContains(toCheckDimNums, permDimGroup);
                        if (checkResult == 2) {
                            LinkedList<PermDimGroup> matchGroup1 = new LinkedList<PermDimGroup>();
                            matchGroup1.add(permDimGroup);
                            matchMoreResult.add(new Pair(matchGroup1, new LinkedList()));
                            continue;
                        }
                        if (checkResult != 1) continue;
                        matchGroup.add(permDimGroup);
                    }
                    if (matchGroup.size() > 0) {
                        HashSet allDimNumOnGroup = new HashSet(16);
                        matchGroup.forEach(group -> allDimNumOnGroup.addAll(group.getDimNums()));
                        List matchDim = toCheckDimNums.stream().filter(dimNum -> matchSingleDim.contains(dimNum) && !allDimNumOnGroup.contains(dimNum)).collect(Collectors.toList());
                        result.add(new Pair(matchGroup, matchDim));
                    }
                }
                if (result.size() > 0) {
                    HashSet existStr = new HashSet(16);
                    result.forEach(matchInfo -> existStr.add(this.buildMatchInfoStr((List)matchInfo.getKey())));
                    LinkedList otherResult = new LinkedList();
                    Set allToCheckDimNums = matchSingleDim.stream().filter(itemMap::containsKey).collect(Collectors.toSet());
                    result.forEach(matchInfo -> {
                        if (matchInfo.getKey() != null) {
                            LinkedList<List<PermDimGroup>> newGroups = new LinkedList<List<PermDimGroup>>();
                            this.selectAllGroup((List)matchInfo.getKey(), newGroups);
                            newGroups.forEach(newGroupList -> {
                                if (existStr.add(this.buildMatchInfoStr((List<PermDimGroup>)newGroupList))) {
                                    HashSet toCheckDimNums = new HashSet(allToCheckDimNums);
                                    newGroupList.forEach(group -> group.getDimNums().forEach(toCheckDimNums::remove));
                                    otherResult.add(new Pair((List)newGroupList, new LinkedList(toCheckDimNums)));
                                }
                            });
                        }
                    });
                    result.addAll(otherResult);
                }
                result.addAll(matchMoreResult);
                List singleDimNums = matchSingleDim.stream().filter(itemMap::containsKey).collect(Collectors.toList());
                result.add(new Pair(null, singleDimNums));
            }
            return result;
        });
    }

    private void selectAllGroup(List<PermDimGroup> sourceGroup, List<List<PermDimGroup>> resultGroup) {
        for (PermDimGroup currentGroup : sourceGroup) {
            int endIndex = resultGroup.size();
            LinkedList<PermDimGroup> newGroupList = new LinkedList<PermDimGroup>();
            newGroupList.add(currentGroup);
            resultGroup.add(newGroupList);
            for (int j = 0; j < endIndex; ++j) {
                newGroupList = new LinkedList(resultGroup.get(j));
                newGroupList.add(currentGroup);
                resultGroup.add(newGroupList);
            }
        }
    }

    private String buildMatchInfoStr(List<PermDimGroup> matchGroupInfo) {
        StringBuilder sb = new StringBuilder();
        if (matchGroupInfo != null) {
            matchGroupInfo.forEach(dimGroup -> sb.append(dimGroup.getDimShortNumStr()).append('!'));
        }
        return sb.toString();
    }

    private boolean checkGroupPerm(PermDimGroup permDimGroup, Map<String, PermMemberItem> memberGroupItem, Map<String, MemberItem> memberGroup) {
        Count permCount = new Count();
        this.checkDimGroupPerm(permDimGroup, memberGroupItem, memberGroup, checkResult -> {
            permCount.addOne();
            return true;
        });
        return permCount.getCount() > 0;
    }

    private int checkGroupContains(Set<String> toCheckDimNums, PermDimGroup permDimGroup) {
        int matchDimCount = 0;
        for (String dimNum : permDimGroup.getDimNums()) {
            if (!toCheckDimNums.contains(dimNum)) continue;
            ++matchDimCount;
        }
        if (matchDimCount == toCheckDimNums.size() && matchDimCount <= permDimGroup.getDimGroup().size()) {
            return 2;
        }
        if (matchDimCount < toCheckDimNums.size() && matchDimCount == permDimGroup.getDimGroup().size()) {
            return 1;
        }
        return 0;
    }

    public boolean check(Map<String, MemberItem> memberGroup) {
        if (this.hasAllPerm()) {
            return true;
        }
        List<Pair<List<PermDimGroup>, List<String>>> matchInfo = this.getMatchInfo(memberGroup);
        if (matchInfo == null || matchInfo.isEmpty()) {
            return true;
        }
        Map<String, PermMemberItem> memberGroupItem = this.toMemberItem(memberGroup);
        if (memberGroupItem == null) {
            return false;
        }
        HashMap<String, Boolean> checkResultMap = new HashMap<String, Boolean>(16);
        block0: for (Pair<List<PermDimGroup>, List<String>> mInfo : matchInfo) {
            List<PermDimGroup> matchGroups = mInfo.getKey();
            List<String> matchDims = mInfo.getValue();
            if (matchGroups != null && matchGroups.size() > 0) {
                for (PermDimGroup dimGroup : matchGroups) {
                    boolean hasPerm = checkResultMap.computeIfAbsent(dimGroup.getDimShortNumStr(), key -> this.checkGroupPerm(dimGroup, memberGroupItem, memberGroup));
                    if (hasPerm) continue;
                    continue block0;
                }
            }
            if (matchDims != null && matchDims.size() > 0 && !this.checkSingleDimPerm(matchDims, memberGroupItem, checkResultMap)) continue;
            return true;
        }
        return false;
    }

    protected void checkDimGroupPerm(PermDimGroup permDimGroup, Map<String, PermMemberItem> permMembGroupItem, Map<String, MemberItem> memberGroup, Function<PermCheckResult, Boolean> permCheckConsumer) {
        Map<Long, List<RowRecord>> userPermRecords;
        if (this.getMultiDimPermRowRecords() != null && (userPermRecords = this.getMultiDimPermRowRecords().get(permDimGroup.getDimShortNumStr())) != null && userPermRecords.size() > 0) {
            ArrayList<MemberTree> memberTrees = new ArrayList<MemberTree>(permDimGroup.getDimGroup().size());
            for (BasedataPojo basedataPojo : permDimGroup.getDimGroup()) {
                memberTrees.add(this.getAllDimTree().get(basedataPojo.getNumber()));
            }
            boolean matchAllDim = true;
            for (BasedataPojo dimObj : permDimGroup.getDimGroup()) {
                if (permMembGroupItem.containsKey(dimObj.getNumber())) continue;
                matchAllDim = false;
                break;
            }
            boolean bl = this.isHasNotDataPermType();
            boolean breakUser = false;
            for (Map.Entry<Long, List<RowRecord>> entry : userPermRecords.entrySet()) {
                block12: {
                    ContainResult containResult;
                    List<RowRecord> uPermRecords = entry.getValue();
                    if (matchAllDim) {
                        for (RowRecord rowRecord : uPermRecords) {
                            containResult = DimMembPermUtil.checkRowAndGroupContains(rowRecord, memberTrees, permMembGroupItem, this.getMemberPropCache(), bl);
                            if (!containResult.isMatchMembPerm() && !containResult.isMatchGivePerm()) continue;
                            byte permVal = this.checkValOnRefRows(uPermRecords, memberTrees, this.getMemberPropCache(), 0, rowRecord.getRefRowsIndex(), permMembGroupItem, rowRecord.getPermVal(), bl);
                            for (DimMembPermType permType : this.getPermTypes()) {
                                if (!permType.hasPerm(permVal)) continue;
                                PermCheckResult checkResult = new PermCheckResult(permVal, entry.getKey(), memberGroup);
                                checkResult.setDimShortNumStr(permDimGroup.getDimShortNumStr());
                                breakUser = permCheckConsumer.apply(checkResult);
                                break block12;
                            }
                            break;
                        }
                    } else {
                        LinkedList<Integer> allRefRowIndex = new LinkedList<Integer>();
                        for (int index = 0; index < uPermRecords.size(); ++index) {
                            containResult = DimMembPermUtil.checkRowAndGroupContains(uPermRecords.get(index), memberTrees, permMembGroupItem, this.getMemberPropCache(), bl);
                            if (!containResult.isMatchMembPerm() && !containResult.isMatchGivePerm()) continue;
                            allRefRowIndex.add(index);
                        }
                        PermValObj permValObj = new PermValObj(this.getPermTypes());
                        ArrayList<List<PermMemberItem>> members = new ArrayList<List<PermMemberItem>>(16);
                        for (int i = 0; i < allRefRowIndex.size(); ++i) {
                            RowRecord rowRecord = uPermRecords.get((Integer)allRefRowIndex.get(i));
                            int beginIndex = i + 1;
                            boolean containsChild = DimMembPermType.DATAPERMEXTENDS.hasPerm(rowRecord.getPermVal());
                            boolean containNotDataPerm = bl && DimMembPermType.hasNotDataPerm(rowRecord.getPermVal());
                            Count descartesCount = new Count(1);
                            boolean suss = DimMembPermUtil.selAllDimMember(rowRecord.getMemberRecords(), memberTrees, containsChild, containNotDataPerm, this.getMemberPropCache(), descartesCount, members, permMembGroupItem, null);
                            if (suss) {
                                byte currentPermVal = rowRecord.getPermVal();
                                DimMembPermUtil.parseMemberDKRJ(descartesCount.getCount(), memberTrees, members, memberInfo -> {
                                    byte permVal = this.checkValOnRefRows(uPermRecords, memberTrees, this.getMemberPropCache(), beginIndex, allRefRowIndex, memberInfo.getGroupMembers(), currentPermVal, hasNotDataPermType);
                                    permValObj.updateVal(permVal);
                                    return !permValObj.hasAllPerm();
                                });
                            }
                            if (permValObj.hasAllPerm()) break;
                        }
                        if (permValObj.getPermVal() > 0) {
                            PermCheckResult checkResult = new PermCheckResult(permValObj.getPermVal(), entry.getKey(), memberGroup);
                            checkResult.setDimShortNumStr(permDimGroup.getDimShortNumStr());
                            breakUser = permCheckConsumer.apply(checkResult);
                        }
                    }
                }
                if (!breakUser) continue;
                return;
            }
        }
    }

    private byte checkValOnRefRows(List<RowRecord> rowRecords, List<MemberTree> memberTrees, MemberPropCache memberPropCache, int beginIndex, List<Integer> refRowIndex, Map<String, PermMemberItem> memberGroupItem, byte permVal, boolean hasNotDataPermType) {
        if (refRowIndex != null) {
            for (int i = beginIndex; i < refRowIndex.size(); ++i) {
                RowRecord rowRecord;
                ContainResult containResult;
                int index = refRowIndex.get(i);
                if (index >= rowRecords.size() || !(containResult = DimMembPermUtil.checkRowAndGroupContains(rowRecord = rowRecords.get(index), memberTrees, memberGroupItem, memberPropCache, hasNotDataPermType)).isMatchMembPerm() && !containResult.isMatchGivePerm()) continue;
                for (DimMembPermType permType : this.getPermTypes()) {
                    if (!containResult.isMatchMembPerm() && permType.isDataPerm()) continue;
                    if (permType.hasPerm(rowRecord.getPermVal())) {
                        permVal = permType.setPermValue(permVal, true);
                        continue;
                    }
                    if (!permType.isDataPerm()) continue;
                    permVal = permType.setPermValue(permVal, false);
                }
            }
        }
        return permVal;
    }
}

