/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.membPerm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.perm.DimMembPermCacheContext;
import kd.epm.eb.common.cache.impl.perm.MemberPermCacheItem;
import kd.epm.eb.common.cache.impl.perm.PermMemberItem;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.impl.perm.SinglePermInfo;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;

public class DimMemberPermHandler {
    protected static final Log log = LogFactory.getLog(DimMemberPermHandler.class);
    private boolean hasNotDataPermType;
    private List<PermDimGroup> matchDimGroup;
    private Set<String> matchSingleDim;
    private List<DimMembPermType> permTypes;
    private Map<String, Map<Long, List<SinglePermInfo>>> singleDimMemberUPermInfo;
    private List<Long> refUserIds;
    private IModelCacheHelper modelCacheHelper;
    private MemberPropCache memberPropCache;
    private Long bizModelId;
    private Long targetUserId;
    private List<String> dimensionNums;
    private boolean hasAllPerm;
    private Map<String, MemberTree> allDimTree;
    private boolean matchAllDim;
    private Set<String> logSign;
    private Map<String, Map<Long, List<RowRecord>>> multiDimPermRowRecords;

    public List<DimMembPermType> getPermTypes() {
        return this.permTypes;
    }

    public void setPermTypes(List<DimMembPermType> permTypes) {
        this.permTypes = permTypes;
    }

    public void setMultiDimPermRowRecords(Map<String, Map<Long, List<RowRecord>>> multiDimPermRowRecords) {
        this.multiDimPermRowRecords = multiDimPermRowRecords;
    }

    public boolean isHasNotDataPermType() {
        return this.hasNotDataPermType;
    }

    public void setHasNotDataPermType(boolean hasNotDataPermType) {
        this.hasNotDataPermType = hasNotDataPermType;
    }

    public Map<String, Map<Long, List<RowRecord>>> getMultiDimPermRowRecords() {
        return this.multiDimPermRowRecords;
    }

    public List<Long> getRefUserIds() {
        if (this.refUserIds == null) {
            this.refUserIds = new LinkedList<Long>();
        }
        return this.refUserIds;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public MemberPropCache getMemberPropCache() {
        return this.memberPropCache;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public Long getTargetUserId() {
        return this.targetUserId;
    }

    public List<String> getDimensionNums() {
        return this.dimensionNums;
    }

    public boolean hasAllPerm() {
        return this.hasAllPerm;
    }

    public Map<String, MemberTree> getAllDimTree() {
        if (this.allDimTree == null) {
            this.allDimTree = new HashMap<String, MemberTree>(16);
        }
        return this.allDimTree;
    }

    public MemberTree getOrLoadDimTree(String dimNum) {
        return this.getAllDimTree().computeIfAbsent(dimNum, key -> DimMembPermUtil.getDimViewMap(Collections.singletonList(dimNum), this.modelCacheHelper, this.bizModelId).get(key));
    }

    public void init(IModelCacheHelper modelCacheHelper, Long bizModelId, Long userId, List<DimMembPermType> permTypes, List<String> dimensionNums) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        List<Dimension> permControlDim = DimMembPermUtil.getPermControlDim(modelId);
        PermGroupEnum permGroup = permTypes.get(0).getPermGroup();
        Set<String> permCtrlDimNums = permGroup == PermGroupEnum.DATA ? permControlDim.stream().map(BaseCache::getNumber).collect(Collectors.toSet()) : new HashSet<String>(dimensionNums);
        if (IDUtils.isNotNull(userId)) {
            if (permGroup == PermGroupEnum.DATA && Collections.disjoint(permCtrlDimNums, dimensionNums) || ModelServiceHelper.isUserHasRootPermByModel(userId, modelId)) {
                this.hasAllPerm = true;
                return;
            }
            this.refUserIds = UserUtils.getAllRefUserGroupIds(userId);
        }
        this.bizModelId = bizModelId;
        this.modelCacheHelper = modelCacheHelper;
        this.dimensionNums = dimensionNums;
        this.targetUserId = userId;
        this.permTypes = permTypes;
        this.hasNotDataPermType = false;
        this.memberPropCache = MemberPropCacheService.getOrCreate(modelId);
        this.hasNotDataPermType = DimMembPermUtil.hasNotDataPermType(permTypes);
        this.initMatchDimInfo(permGroup, modelId, permCtrlDimNums);
        this.allDimTree = DimMembPermUtil.getDimViewMap(permCtrlDimNums, this.getModelCacheHelper(), this.getBizModelId());
        this.initPermRecord(modelId);
        this.handleLogInfo();
    }

    private void handleLogInfo() {
        this.logSign = LogSignHelper.getLogSignByGropNum("DimMemberPermHandler");
        if (this.logSign.isEmpty()) {
            return;
        }
        if (this.logSign.contains("baseInfo")) {
            CommonServiceHelper.handleLog(log, "DimMemberPermHandler_baseInfo", SerializationUtils.toJsonString(this.getBaseInfoMap()));
        }
        if (this.logSign.contains("permInfo")) {
            HashMap<String, Map<String, Map<Long, List<Object>>>> permInfoMap = new HashMap<String, Map<String, Map<Long, List<Object>>>>(16);
            permInfoMap.put("singleDimMemberUPermInfo", this.singleDimMemberUPermInfo);
            permInfoMap.put("multiDimPermRowRecords", this.multiDimPermRowRecords);
            CommonServiceHelper.handleLog(log, "DimMemberPermHandler_permInfo", SerializationUtils.toJsonString(permInfoMap));
        }
        if (this.logSign.contains("matchInfo")) {
            HashMap<String, Collection<Object>> matchInfo = new HashMap<String, Collection<Object>>(16);
            matchInfo.put("singleD", this.matchSingleDim);
            matchInfo.put("groupD", this.matchDimGroup);
            CommonServiceHelper.handleLog(log, "DimMemberPermHandler_matchInfo", SerializationUtils.toJsonString(matchInfo));
        }
    }

    protected Map<String, Object> getBaseInfoMap() {
        HashMap<String, Object> baseInfo = new HashMap<String, Object>(16);
        baseInfo.put("model", this.modelCacheHelper.getModelobj().getId());
        baseInfo.put("dimNums", this.dimensionNums);
        baseInfo.put("bizModel", this.bizModelId);
        baseInfo.put("permTypes", this.permTypes);
        baseInfo.put("refUser", this.refUserIds);
        baseInfo.put("targetUser", this.targetUserId);
        baseInfo.put("matchAllDim", this.matchAllDim);
        return baseInfo;
    }

    protected void initMatchDimInfo(PermGroupEnum permGroup, Long modelId, Set<String> permCtrlDimNums) {
        LinkedList<PermDimGroup> matchDimGroup = new LinkedList<PermDimGroup>();
        HashSet<String> matchSingleDimNums = new HashSet<String>(16);
        HashSet<String> toCheckDimNums = new HashSet<String>(this.dimensionNums);
        if (permGroup == PermGroupEnum.DATA) {
            List<PermDimGroup> permControlDimGroup = DimMembPermUtil.getPermControlDimGroup(modelId);
            for (PermDimGroup dimGroup : permControlDimGroup) {
                int matchDimCount = 0;
                for (BasedataPojo obj : dimGroup.getDimGroup()) {
                    if (!toCheckDimNums.contains(obj.getNumber())) continue;
                    ++matchDimCount;
                }
                if (this.matchAllDim && matchDimCount == dimGroup.getDimGroup().size() && matchDimCount == toCheckDimNums.size()) {
                    matchDimGroup.add(dimGroup);
                    continue;
                }
                if (this.matchAllDim || matchDimCount <= 0) continue;
                matchDimGroup.add(dimGroup);
            }
        }
        for (String dimNum : toCheckDimNums) {
            if (!permCtrlDimNums.contains(dimNum)) continue;
            matchSingleDimNums.add(dimNum);
        }
        if (matchSingleDimNums.size() > 0) {
            this.matchSingleDim = matchSingleDimNums;
        }
        if (matchDimGroup.size() > 0) {
            this.matchDimGroup = matchDimGroup;
        }
    }

    protected void initPermRecord(Long modelId) {
        Set<String> matchSingleDim;
        HashMap<String, Map<Long, List<SinglePermInfo>>> singleDimUPermInfo = new HashMap<String, Map<Long, List<SinglePermInfo>>>();
        HashMap<String, Map<Long, List<RowRecord>>> multiDimPermInfo = new HashMap<String, Map<Long, List<RowRecord>>>();
        List<PermDimGroup> matchDimGroup = this.getMatchDimGroup();
        if (matchDimGroup != null) {
            for (PermDimGroup dimGroup : matchDimGroup) {
                List<String> dimGroupNums;
                Map<Long, List<RowRecord>> multiDimRecord = this.loadMultiDimRecord(dimGroup, modelId, dimGroupNums = dimGroup.getDimGroup().stream().map(BasedataPojo::getNumber).collect(Collectors.toList()));
                if (multiDimRecord == null) continue;
                multiDimPermInfo.put(dimGroup.getDimShortNumStr(), multiDimRecord);
            }
        }
        if ((matchSingleDim = this.getMatchSingleDim()) != null) {
            for (String dimNum : matchSingleDim) {
                Map<Long, List<SinglePermInfo>> permInfos = this.loadSingleDimRecord(modelId, dimNum);
                if (permInfos == null) continue;
                singleDimUPermInfo.put(dimNum, permInfos);
            }
        }
        this.setMultiDimPermRowRecords(multiDimPermInfo);
        this.setSingleDimMemberUPermInfo(singleDimUPermInfo);
    }

    protected Map<Long, List<SinglePermInfo>> loadSingleDimRecord(Long modelId, String dimNum) {
        if (!this.hasNotDataPermType && this.canLoadFromCache()) {
            MemberPermCacheItem memberPermCacheItem = DimMembPermCacheContext.getOrCreateSingleDimPerm(modelId, this.getBizModelId(), dimNum, this.getTargetUserId(), this.getRefUserIds(), false);
            if (!memberPermCacheItem.isEmpty()) {
                HashMap<Long, List<SinglePermInfo>> userPermInfo = new HashMap<Long, List<SinglePermInfo>>(1);
                ArrayList<SinglePermInfo> permInfos = new ArrayList<SinglePermInfo>(this.permTypes.size());
                for (DimMembPermType permType : this.permTypes) {
                    if (permType == DimMembPermType.READ) {
                        permInfos.add(new SinglePermInfo(memberPermCacheItem.getSingleDimReadPermInfo()));
                        continue;
                    }
                    if (permType == DimMembPermType.WRITE) {
                        permInfos.add(new SinglePermInfo(memberPermCacheItem.getSingleDimWritePermInfo()));
                        continue;
                    }
                    permInfos.add(null);
                }
                userPermInfo.put(this.getTargetUserId(), permInfos);
                return userPermInfo;
            }
        } else {
            HashMap<Long, List<SinglePermInfo>> permInfos = new HashMap<Long, List<SinglePermInfo>>(1);
            List<SinglePermInfo> permInfo = DimMembPermUtil.parseSingleDimPerm(modelId, this.getBizModelId(), dimNum, this.getRefUserIds(), this.getPermTypes());
            if (permInfo != null) {
                permInfos.put(this.getTargetUserId(), permInfo);
            }
            return permInfos;
        }
        return null;
    }

    protected Map<Long, List<RowRecord>> loadMultiDimRecord(PermDimGroup dimGroup, Long modelId, List<String> dimGroupNums) {
        Map<Long, List<RowRecord>> rowRecords;
        if (!this.hasNotDataPermType && this.canLoadFromCache()) {
            Map<Long, MemberPermCacheItem> userPermInfos = DimMembPermCacheContext.batGetOrCreateMultiPerm(modelId, this.getBizModelId(), dimGroupNums, this.getRefUserIds());
            rowRecords = new HashMap<Long, List<RowRecord>>(userPermInfos.size());
            for (Map.Entry<Long, MemberPermCacheItem> entry : userPermInfos.entrySet()) {
                if (entry.getValue() == null || entry.getValue().getMultiDimPermInfo() == null) continue;
                rowRecords.put(entry.getKey(), entry.getValue().getMultiDimPermInfo());
            }
        } else {
            rowRecords = MembPermRecordUtil.getUserPermRowRecords(modelId, this.getBizModelId(), dimGroupNums, this.getRefUserIds(), this.getPermGroup(), false, true, this.isHasNotDataPermType());
        }
        return rowRecords;
    }

    protected Map<String, PermMemberItem> toMemberItem(Map<String, MemberItem> memberGroup) {
        HashMap<String, PermMemberItem> memberItemMap = new HashMap<String, PermMemberItem>(memberGroup.size());
        try {
            memberGroup.forEach((dimNum, mItem) -> {
                if (mItem.isMember()) {
                    Member member;
                    MemberTree memberTree = this.getOrLoadDimTree((String)dimNum);
                    if (memberTree == null) throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6\u5931\u8d25\uff1a%1\u3002", (String)"DimMemberPermHandler_2", (String)"epm-eb-common", (Object[])new Object[]{dimNum}));
                    if (mItem.isNumberFirst()) {
                        member = IDUtils.isEmptyLong(mItem.getViewId()) != false ? memberTree.getMember(mItem.getMemberNum()) : memberTree.getMember(mItem.getMemberNum(), mItem.getViewId());
                    } else {
                        Member member2 = member = IDUtils.isEmptyLong(mItem.getViewId()) != false ? memberTree.getMember(mItem.getMemberId()) : memberTree.getMember(mItem.getMemberId(), mItem.getViewId());
                    }
                    if (member == null) throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff1a%1-%2", (String)"DimMemberPermHandler_1", (String)"epm-eb-common", (Object[])new Object[]{dimNum, mItem.getMemberId()}));
                    memberItemMap.put((String)dimNum, new PermMemberItem(true, member));
                    return;
                } else {
                    CustomPropertyValue propertyValue = this.getMemberPropCache().getPropertyValue((String)dimNum, mItem.getMemberId());
                    if (propertyValue == null) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u6210\u5458\u5c5e\u6027\u503c\u5931\u8d25\uff1a%1-%2\u3002", (String)"DimMemberPermHandler_3", (String)"epm-eb-common", (Object[])new Object[]{dimNum, mItem.getMemberId()}));
                    }
                    memberItemMap.put((String)dimNum, new PermMemberItem(false, propertyValue));
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
        return memberItemMap;
    }

    public Map<String, Map<Long, List<SinglePermInfo>>> getSingleDimMemberUPermInfo() {
        return this.singleDimMemberUPermInfo;
    }

    public void setSingleDimMemberUPermInfo(Map<String, Map<Long, List<SinglePermInfo>>> singleDimMemberUPermInfo) {
        this.singleDimMemberUPermInfo = singleDimMemberUPermInfo;
    }

    public PermGroupEnum getPermGroup() {
        return this.getPermTypes().get(0).getPermGroup();
    }

    public boolean canLoadFromCache() {
        return true;
    }

    public boolean isMatchAllDim() {
        return this.matchAllDim;
    }

    public void setMatchAllDim(boolean matchAllDim) {
        this.matchAllDim = matchAllDim;
    }

    public Set<String> getLogSign() {
        return this.logSign;
    }

    public List<PermDimGroup> getMatchDimGroup() {
        return this.matchDimGroup;
    }

    protected void setMatchDimGroup(List<PermDimGroup> matchDimGroup) {
        this.matchDimGroup = matchDimGroup;
    }

    public Set<String> getMatchSingleDim() {
        return this.matchSingleDim;
    }

    protected void setMatchSingleDim(Set<String> matchSingleDim) {
        this.matchSingleDim = matchSingleDim;
    }
}

