/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.membPerm;

import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.impl.perm.PermMemberItem;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;

public class DimMemberPermLogChecker
extends DimMemberPermChecker {
    private int checkCount = 1;
    private StringBuilder logInfo = new StringBuilder();
    private String permName;

    @Override
    public boolean check(Map<String, MemberItem> memberGroup) {
        boolean checkResult = super.check(memberGroup);
        this.logInfo.append("permCheck{");
        this.logInfo.append("CC:").append(this.checkCount).append(',');
        this.logInfo.append("MG:").append(memberGroup.toString()).append(',');
        this.logInfo.append("PT:").append(this.getPermName()).append(',');
        this.logInfo.append("RS:").append(checkResult).append('}');
        log.info(this.logInfo.toString());
        this.logInfo.setLength(0);
        ++this.checkCount;
        return checkResult;
    }

    private String getPermName() {
        if (this.permName == null) {
            List<DimMembPermType> permTypes = this.getPermTypes();
            this.permName = permTypes == null || permTypes.isEmpty() ? "NONE" : permTypes.get(0).name();
        }
        return this.permName;
    }

    @Override
    protected Map<String, PermMemberItem> toMemberItem(Map<String, MemberItem> memberGroup) {
        Map<String, PermMemberItem> itemMap = super.toMemberItem(memberGroup);
        if (itemMap != null) {
            memberGroup.forEach((dimNum, item) -> {
                PermMemberItem permMemberItem;
                if (item.getMemberNum() == null && (permMemberItem = (PermMemberItem)itemMap.get(dimNum)) != null) {
                    item.setMemberNum(permMemberItem.getName() + "(" + permMemberItem.getNumber() + ")");
                }
            });
        }
        return itemMap;
    }
}

