/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.pojo;

import java.util.HashSet;
import java.util.List;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import org.jetbrains.annotations.NotNull;

public class AccountMemberTree
extends MemberTree {
    private Member rootMember;

    public AccountMemberTree(@NotNull Dimension dimMemberTree, Long bizModelId) {
        super(dimMemberTree, bizModelId);
    }

    @Override
    public Member getMember(Long memberId) {
        Member member = super.getMember(memberId);
        if (member != null && SysDimensionEnum.Account.getNumber().equals(member.getNumber())) {
            member = this.getRootMember(member);
        }
        return member;
    }

    @Override
    public Member getMember(String memberNumber) {
        if (SysDimensionEnum.Account.getNumber().equals(memberNumber)) {
            return this.getRootMember((Member)null);
        }
        return super.getMember(memberNumber);
    }

    @Override
    public Member getRootMember(Long viewId) {
        return this.getRootMember((Member)null);
    }

    public Member getRootMember(Member rootMember) {
        if (this.rootMember == null) {
            Long bizModelId;
            if (rootMember == null) {
                rootMember = super.getMember(SysDimensionEnum.Account.getNumber());
            }
            if ((bizModelId = this.getBizModelId()) == null || bizModelId.equals(0L)) {
                this.rootMember = rootMember;
            } else {
                this.rootMember = rootMember.cloneNoChild();
                List<Long> dataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(bizModelId);
                HashSet<Long> dataSetIdSet = new HashSet<Long>(dataSetIds);
                rootMember.getChildren().forEach(childMemb -> {
                    if (dataSetIdSet.contains(childMemb.getDatasetId())) {
                        this.rootMember.addChild((Member)childMemb);
                    }
                });
            }
        }
        return this.rootMember;
    }
}

