/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.pojo;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import org.jetbrains.annotations.NotNull;

public class MemberTree {
    private final Dimension dimMemberTree;
    private Long[] refViewIds;
    private Set<Long> refViewIdSet;
    private Long bizModelId;

    public MemberTree(@NotNull Dimension dimMemberTree, Set<Long> refViewIdSet) {
        this.dimMemberTree = dimMemberTree;
        this.refViewIdSet = refViewIdSet;
    }

    public MemberTree(@NotNull Dimension dimMemberTree, Long bizModelId) {
        this.dimMemberTree = dimMemberTree;
        this.bizModelId = bizModelId;
    }

    public String getDimNum() {
        return this.dimMemberTree.getDimNum();
    }

    public Member getMember(Long memberId) {
        return this.getMemberByDefView(memberId, null);
    }

    public Member getMember(String memberNumber) {
        return this.getMemberByDefView(null, memberNumber);
    }

    private Member getMemberByDefView(Long memberId, String memberNum) {
        boolean useId;
        Long[] refViewIds = this.getRefViewIds();
        boolean bl = useId = memberId != null;
        if (refViewIds.length == 0) {
            return useId ? this.dimMemberTree.getMember(null, memberId) : this.dimMemberTree.getMember(null, memberNum);
        }
        Member member = null;
        for (int index = 0; index < refViewIds.length; ++index) {
            Long viewId = refViewIds[index];
            Member member2 = member = useId ? this.dimMemberTree.getMember(viewId, memberId) : this.dimMemberTree.getMember(viewId, memberNum);
            if (member == null) continue;
            if (index == 0) break;
            refViewIds[index] = refViewIds[0];
            refViewIds[0] = viewId;
            break;
        }
        return member;
    }

    public Member getMember(String memberNumber, Long viewId) {
        if (viewId != null && !viewId.equals(0L) && this.getRefViewIdSet().size() > 0 && !this.getRefViewIdSet().contains(viewId)) {
            return null;
        }
        return this.dimMemberTree.getMember(viewId, memberNumber);
    }

    public Member getMember(Long memberId, Long viewId) {
        if (viewId != null && !viewId.equals(0L) && this.getRefViewIdSet().size() > 0 && !this.getRefViewIdSet().contains(viewId)) {
            return null;
        }
        return this.dimMemberTree.getMember(viewId, memberId);
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public Long[] getRefViewIds() {
        if (this.refViewIds == null) {
            Set<Long> refViewIdSet = this.getRefViewIdSet();
            this.refViewIds = refViewIdSet.toArray(new Long[0]);
        }
        return this.refViewIds;
    }

    public Set<Long> getRefViewIdSet() {
        if (this.refViewIdSet == null) {
            Long modelId;
            List<Long> viewIds;
            if (SysDimensionEnum.dimHasView(this.dimMemberTree.getDimNum()) && (viewIds = ModelCacheContext.getOrCreate(modelId = this.dimMemberTree.getModel().getId()).getViewGroupViewsByBusModelAndDimNumber(this.bizModelId, this.dimMemberTree.getNumber())) != null) {
                this.refViewIdSet = new HashSet<Long>(viewIds);
            }
            if (this.refViewIdSet == null) {
                this.refViewIdSet = new HashSet<Long>(1);
            }
        }
        return this.refViewIdSet;
    }

    public Member getRootMember(Long viewId) {
        View view = this.dimMemberTree.getView(viewId);
        if (view != null) {
            Member member = view.getMember(this.getDimNum());
            if (member == null) {
                member = view.getMember(this.getDimNum() + "_" + view.getNumber());
            }
            return member;
        }
        return this.dimMemberTree.getMember(null, this.getDimNum());
    }
}

