/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.policyUtils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.epm.eb.common.permission.DetailPermSqlBuilder;
import kd.epm.eb.common.permission.IPermRecordSqlBuilder;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.policyUtils.DetailRecordHandler;
import org.jetbrains.annotations.NotNull;

public class DetailRecord4SeqHandler
extends DetailRecordHandler {
    private Map<Long, Set<Integer>> mainIdSeqMap;

    public DetailRecord4SeqHandler(@NotNull Map<Long, DimMembPermRecord> mainRecordMap, @NotNull Map<Long, Set<Integer>> mainIdSeqMap) {
        super(mainRecordMap);
        this.mainIdSeqMap = mainIdSeqMap;
    }

    @Override
    public void dealRow(Row row) {
        Long mainId = row.getLong("fid");
        Integer seq = row.getInteger("fseq");
        Set<Integer> refSeqSet = this.mainIdSeqMap.get(mainId);
        if (refSeqSet != null && refSeqSet.contains(seq)) {
            super.dealRow(row);
        }
    }

    @Override
    public void addFilter(IPermRecordSqlBuilder sqlBuilder) {
        super.addFilter(sqlBuilder);
    }

    @Override
    public void addFilter(DetailPermSqlBuilder sqlBuilder) {
        super.addFilter(sqlBuilder);
        HashSet allSeq = new HashSet(16);
        this.mainIdSeqMap.values().forEach(allSeq::addAll);
        sqlBuilder.addFilter("fseq", allSeq);
    }
}

