/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.policyUtils;

import java.util.Map;
import kd.bos.algo.Row;
import kd.epm.eb.common.permission.DetailPermSqlBuilder;
import kd.epm.eb.common.permission.IPermRecordSqlBuilder;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.policyUtils.AbstractDetailRecordHandler;
import org.jetbrains.annotations.NotNull;

public class DetailRecordHandler
extends AbstractDetailRecordHandler {
    private Map<Long, DimMembPermRecord> mainRecordMap;

    public DetailRecordHandler(@NotNull Map<Long, DimMembPermRecord> mainRecordMap) {
        this.mainRecordMap = mainRecordMap;
    }

    public Map<Long, DimMembPermRecord> getMainRecordMap() {
        return this.mainRecordMap;
    }

    @Override
    public void dealRow(Row row) {
        Long mainId = row.getLong("fid");
        DimMembPermRecord mainRecord = this.mainRecordMap.get(mainId);
        if (mainRecord != null) {
            int permVal = row.getInteger("fpermval");
            DimMembPermDetailRecord detailRecord = new DimMembPermDetailRecord(mainId, row.getLong("fentryid"), row.getLong("fmemberid"), row.getLong("fviewid"), (byte)permVal, row.getInteger("fseq"), row.getBoolean("fmembtype") == false, row.getInteger("fmembseq"));
            int seq = row.getInteger("fseq");
            DimMembPermDetailRecord[] dimMembPermDetailRecords = mainRecord.getAllDetailRecords().computeIfAbsent(seq, key -> new DimMembPermDetailRecord[mainRecord.getDimSize()]);
            dimMembPermDetailRecords[detailRecord.getMemberSeq()] = detailRecord;
        }
    }

    @Override
    public void addSelFields(IPermRecordSqlBuilder sqlBuilder) {
        super.addSelFields(sqlBuilder);
        sqlBuilder.addSelFields("fentryid", "fmemberid", "fseq", "fmembseq", "fmembtype", "fviewid");
    }

    @Override
    public void addFilter(DetailPermSqlBuilder sqlBuilder) {
        sqlBuilder.setMainIdsFilter(this.mainRecordMap.keySet());
    }
}

