/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.policyUtils;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermSaveArgs;
import kd.epm.eb.common.permission.policyUtils.IMembPermSaveCheck;

public class LevelBreakCheck
implements IMembPermSaveCheck {
    private final DimMembPermType checkPermType;

    public LevelBreakCheck(DimMembPermType checkPermType) {
        this.checkPermType = checkPermType;
    }

    @Override
    public boolean check(PermSaveArgs args, IFormView formView, IDataModel dataModel) {
        DimMembPermRecord toSavePermRecrod = args.getToSavePermRecrod();
        if (toSavePermRecrod != null) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(args.getModelId());
            List<String> dimNums = args.getDimNums();
            Map<Integer, DimMembPermDetailRecord[]> allDetailRecords = toSavePermRecrod.getAllDetailRecords();
            LinkedList<DimMembPermDetailRecord[]> hasPermRecords = new LinkedList<DimMembPermDetailRecord[]>();
            LinkedList<DimMembPermDetailRecord[]> noPermRecords = new LinkedList<DimMembPermDetailRecord[]>();
            for (DimMembPermDetailRecord[] rowRecord : allDetailRecords.values()) {
                byte permVal = rowRecord[0].getPermVal();
                if (!this.checkPermType.hasPerm(permVal)) {
                    noPermRecords.add(rowRecord);
                    continue;
                }
                hasPermRecords.add(rowRecord);
            }
            if (!hasPermRecords.isEmpty() && !noPermRecords.isEmpty()) {
                for (DimMembPermDetailRecord[] rowRecord1 : noPermRecords) {
                    block2: for (DimMembPermDetailRecord[] rowRecord2 : hasPermRecords) {
                        Member member2;
                        Member member1;
                        String dimNum;
                        int levelSub = 0;
                        for (int i = 0; i < dimNums.size(); ++i) {
                            dimNum = dimNums.get(i);
                            DimMembPermDetailRecord record1 = rowRecord1[i];
                            DimMembPermDetailRecord record2 = rowRecord2[i];
                            if (!record1.isMember() || !record2.isMember() || !DimMembPermUtil.checkMembersContains(member1 = modelCacheHelper.getMember(dimNum, record1.getViewId(), record1.getMemberId()), member2 = modelCacheHelper.getMember(dimNum, record2.getViewId(), record2.getMemberId()), true, true)) continue block2;
                            if (levelSub != 0) continue;
                            levelSub = member1.getLongNumber().length() - member2.getLongNumber().length();
                        }
                        if (levelSub < 0) continue;
                        StringBuilder sb1 = new StringBuilder();
                        StringBuilder sb2 = new StringBuilder();
                        for (int i = 0; i < dimNums.size(); ++i) {
                            dimNum = dimNums.get(i);
                            member1 = modelCacheHelper.getMember(dimNum, rowRecord1[i].getViewId(), rowRecord1[i].getMemberId());
                            member2 = modelCacheHelper.getMember(dimNum, rowRecord2[i].getViewId(), rowRecord2[i].getMemberId());
                            sb1.append(member1.getName()).append(',');
                            sb2.append(member2.getName()).append(',');
                        }
                        sb1.setLength(sb1.length() - 1);
                        sb2.setLength(sb2.length() - 1);
                        args.getCheckErrorMsg().add(ResManager.loadResFormat((String)"%1\u4e0d\u5141\u8bb8\u65ad\u5c42\uff0c\u6210\u5458%2\u4e0e%3\u7684\u8bbe\u7f6e\u6709\u51b2\u7a81\u3002", (String)"LevelBreakCheck_1", (String)"epm-eb-common", (Object[])new Object[]{this.checkPermType.getName(), sb1.toString(), sb2.toString()}));
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

