/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.policyUtils;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermSaveArgs;
import kd.epm.eb.common.permission.pojo.ShowConfirmInfo;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.permission.policyUtils.IMembPermSaveCheck;
import kd.epm.eb.common.utils.UserUtils;

public class ModifiedCheck
implements IMembPermSaveCheck {
    private Date permInitTime;

    public ModifiedCheck(Date permInitTime) {
        this.permInitTime = permInitTime;
    }

    @Override
    public boolean check(PermSaveArgs args, IFormView formView, IDataModel dataModel) {
        PermGroupEnum permGroupEnum = args.isManagerForm() ? PermGroupEnum.MANAGER : PermGroupEnum.DATA;
        Long modelId = args.getModelId();
        Long bizCtrlRangeId = args.getBizCtrlRangeId();
        Long targetPersonId = args.getTargetUserId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        List<String> dimShortNums = DimMembPermUtil.toShortNums(modelCacheHelper, args.getDimNums());
        Map<Long, DimMembPermRecord> refPermMainRecords = MembPermRecordUtil.getBRCsPermRecordNoDetail(modelId, bizCtrlRangeId, dimShortNums, targetPersonId, permGroupEnum);
        if (refPermMainRecords.size() > 0) {
            for (DimMembPermRecord permRecord : refPermMainRecords.values()) {
                if (!permRecord.getModifytime().after(this.permInitTime)) continue;
                UserInfo userInfo = UserUtils.getUserInfo(permRecord.getModifierId());
                ShowConfirmInfo showConfirmInfo = new ShowConfirmInfo();
                showConfirmInfo.setMessage(ResManager.loadResFormat((String)"\u201c%1\u201d\u5728\u201c%2\u201d\u66f4\u6539\u4e86\u8be5\u7528\u6237\u7684\u6743\u9650\u8bb0\u5f55\uff0c\u662f\u5426\u8986\u76d6\u5e76\u4fdd\u5b58\uff1f", (String)"ModifiedCheck_1", (String)"epm-eb-common", (Object[])new Object[]{userInfo.getName(), permRecord.getModifytime()}));
                showConfirmInfo.setCallBackKey("overwriteToSave_" + args.getCallBackKey());
                args.getConfirmMsg().add(showConfirmInfo);
                args.setRollbackCondition(true);
                return false;
            }
        }
        Long currentUserId = args.getCurrentUserId();
        DimMembPermRecord currentBRCRecord = refPermMainRecords.get(bizCtrlRangeId);
        if (currentBRCRecord == null) {
            currentBRCRecord = new DimMembPermRecord((Long)0L, modelId, DimMembPermUtil.getDimShortNumsStr(dimShortNums, false), targetPersonId, bizCtrlRangeId, permGroupEnum, currentUserId, new Timestamp(System.currentTimeMillis()));
        } else {
            currentBRCRecord.setModifierId(currentUserId);
            currentBRCRecord.setModifytime(new Timestamp(System.currentTimeMillis()));
        }
        Set<Long> refMainRecordIds = refPermMainRecords.values().stream().map(DimMembPermRecord::getId).collect(Collectors.toSet());
        args.setToSavePermRecrod(currentBRCRecord);
        args.setRefMainRecordIds(refMainRecordIds);
        return true;
    }
}

