/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission.policyUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermSaveArgs;
import kd.epm.eb.common.permission.policyUtils.IMembPermSaveCheck;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;

public class MustInputCheck
implements IMembPermSaveCheck {
    private List<DimMembPermType> permTypeList;

    public MustInputCheck(List<DimMembPermType> permTypeList) {
        this.permTypeList = permTypeList;
    }

    @Override
    public boolean check(PermSaveArgs args, IFormView formView, IDataModel dataModel) {
        DynamicObjectCollection entryRows = dataModel.getEntryEntity("memberentry");
        int dimSize = args.getDimNums().size();
        Long mainId = 0L;
        int seq = 0;
        HashMap<Integer, DimMembPermDetailRecord[]> allDetailRecords = new HashMap<Integer, DimMembPermDetailRecord[]>(16);
        ArrayList<String> noInputRowsIndex = new ArrayList<String>(16);
        for (DynamicObject row : entryRows) {
            DimMembPermDetailRecord[] rowRecord = new DimMembPermDetailRecord[dimSize];
            byte permVal = this.selectPermVal(row);
            for (int i = 0; i < dimSize; ++i) {
                Long rowId = GlobalIdUtil.genGlobalLongId();
                Long memberId = row.getLong("memberid" + i);
                if (IDUtils.isEmptyLong(memberId).booleanValue()) {
                    noInputRowsIndex.add(String.valueOf(seq + 1));
                    break;
                }
                rowRecord[i] = new DimMembPermDetailRecord(mainId, rowId, memberId, row.getLong("viewid" + i), permVal, seq, row.getBoolean("ismember" + i), i);
            }
            if (noInputRowsIndex.size() == 0) {
                allDetailRecords.put(seq, rowRecord);
            }
            ++seq;
        }
        if (noInputRowsIndex.size() > 0) {
            args.getCheckErrorMsg().add(ResManager.loadResFormat((String)"\u7b2c[%1]\u884c\u6210\u5458\u672a\u8bbe\u7f6e\u3002", (String)"MustInputCheck_1", (String)"epm-eb-common", (Object[])new Object[]{String.join((CharSequence)",", noInputRowsIndex)}));
            return false;
        }
        DimMembPermRecord toSavePermRecrod = args.getToSavePermRecrod();
        if (toSavePermRecrod != null) {
            toSavePermRecrod.setAllDetailRecords(allDetailRecords);
        }
        return true;
    }

    private byte selectPermVal(DynamicObject row) {
        byte permVal = 0;
        List<DimMembPermType> permTypeList = this.getPermTypeList();
        for (DimMembPermType permType : permTypeList) {
            boolean hasPerm = row.getBoolean(permType.getBoxKey());
            permVal = permType.setPermValue(permVal, hasPerm);
        }
        return permVal;
    }

    public List<DimMembPermType> getPermTypeList() {
        return this.permTypeList;
    }
}

