/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.report.excel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.report.excel.DistributedCacheHelper;
import kd.epm.eb.common.report.excel.exception.KDEpmExportCancelException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxFloatRowException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportTimeoutException;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportExceptionHelper {
    private static final Log log = LogFactory.getLog(ExportExceptionHelper.class);
    private static final String cancelExportLogCacheKey = "epm-eb-exportLogCancelIds";
    private static final ExportExceptionHelper instance = new ExportExceptionHelper();

    public static ExportExceptionHelper getInstance() {
        return instance;
    }

    public void judgeTimeout(Long exportLogId) {
        if (DistributedCacheHelper.isExpireKey(exportLogId + "")) {
            log.info("judgeTimeout.");
            throw new KDEpmExportTimeoutException(ResManager.loadKDString((String)"\u5bfc\u51fa\u8d85\u65f6\uff0c\u672a\u80fd\u5168\u90e8\u5bfc\u51fa\uff0c\u8bf7\u51cf\u5c11\u62a5\u8868\u6570\u91cf\u540e\u91cd\u8bd5\u3002", (String)"POIExportCommand_007", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void setTimeout(String cacheKey, int timeout) {
        DistributedCacheHelper.setExpireTime(cacheKey, timeout);
    }

    public void judgeMaxExportSize(int size, int maxSize) {
        if (size > maxSize) {
            log.info("judgeMaxExportSize:size=" + size + ";maxSize=" + maxSize);
            log.info("judgeMaxExportSize.");
            throw new KDEpmExportMaxException("more than max export size.");
        }
    }

    public void judgeMaxExportFloatRowSize(int size, int maxSize) {
        if (size > maxSize) {
            log.info("judgeMaxExportFloatRowSize:size=" + size + ";maxSize=" + maxSize);
            log.info("judgeMaxExportFloatRowSize.");
            throw new KDEpmExportMaxFloatRowException("more than max export float row size.");
        }
    }

    public void judgeExportCancel(Long exportLogId) {
        if (IDUtils.isEmptyLong(exportLogId).booleanValue()) {
            log.info("exportLogId is empty.");
            return;
        }
        this.judgeTimeout(exportLogId);
        if (this.exportLogIsCancel(exportLogId)) {
            log.info("---export judgeExportCancel exportLogIsCancel");
            throw new KDEpmExportCancelException("export id " + exportLogId + " is canceled.");
        }
    }

    public void cacheCancelExportLogIds(Set<Long> exportLogIds) {
        if (CollectionUtils.isEmpty(exportLogIds)) {
            return;
        }
        HashSet<Long> toCacheLogIds = new HashSet<Long>(exportLogIds);
        Set<Long> cancelExportLogIdsFromCache = this.getCancelExportLogIdsFromCache();
        if (CollectionUtils.isNotEmpty(cancelExportLogIdsFromCache)) {
            toCacheLogIds.addAll(cancelExportLogIdsFromCache);
        }
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").put(cancelExportLogCacheKey, (Object)SerializationUtils.toJsonString(toCacheLogIds), 7200);
    }

    public Set<Long> getCancelExportLogIdsFromCache() {
        HashSet<Long> result = new HashSet<Long>(16);
        String cancelLogIdsFromCache = (String)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").get(cancelExportLogCacheKey);
        if (StringUtils.isNotBlank((CharSequence)cancelLogIdsFromCache)) {
            result.addAll((Collection)SerializationUtils.fromJsonString((String)cancelLogIdsFromCache, Set.class));
        }
        return result;
    }

    public void removeCancelExportLogIdCache(Long exportLogId) {
        if (IDUtils.isEmptyLong(exportLogId).booleanValue()) {
            return;
        }
        Set<Long> cancelExportLogIdsFromCache = this.getCancelExportLogIdsFromCache();
        if (CollectionUtils.isNotEmpty(cancelExportLogIdsFromCache)) {
            cancelExportLogIdsFromCache.removeIf(t -> t.equals(exportLogId));
            this.cacheCancelExportLogIds(cancelExportLogIdsFromCache);
        }
    }

    public boolean exportLogIsCancel(Long exportLogId) {
        if (IDUtils.isEmptyLong(exportLogId).booleanValue()) {
            log.info("exportLogId is empty.");
            return false;
        }
        Set<Long> cancelExportLogIdsFromCache = this.getCancelExportLogIdsFromCache();
        return CollectionUtils.isNotEmpty(cancelExportLogIdsFromCache) && cancelExportLogIdsFromCache.contains(exportLogId);
    }
}

