/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.report.ruleexec;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.report.ruleexec.exception.RuleCaseExecCancelException;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleCaseExecExceptionHelper {
    private static final Log log = LogFactory.getLog(RuleCaseExecExceptionHelper.class);
    private static final String cancelTaskLogCacheKey = "epm-eb-reportRuleTaskLogCancelIds";
    private static final RuleCaseExecExceptionHelper instance = new RuleCaseExecExceptionHelper();

    public static RuleCaseExecExceptionHelper getInstance() {
        return instance;
    }

    public void judgeTaskCancel(Long taskLogId) {
        if (IDUtils.isEmptyLong(taskLogId).booleanValue()) {
            log.info("taskLogId is empty.");
            return;
        }
        if (this.taskLogIsCancel(taskLogId)) {
            log.info("---export judgeTaskCancel taskLogIsCancel");
            throw new RuleCaseExecCancelException("export id " + taskLogId + " is canceled.");
        }
    }

    public void cacheCancelTaskLogIds(Set<Long> taskLogIds) {
        if (CollectionUtils.isEmpty(taskLogIds)) {
            return;
        }
        HashSet<Long> toCacheLogIds = new HashSet<Long>(taskLogIds);
        Set<Long> cancelTaskLogIdsFromCache = this.getCancelTaskLogIdsFromCache();
        if (CollectionUtils.isNotEmpty(cancelTaskLogIdsFromCache)) {
            toCacheLogIds.addAll(cancelTaskLogIdsFromCache);
        }
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").put(cancelTaskLogCacheKey, (Object)SerializationUtils.toJsonString(toCacheLogIds), 86400);
    }

    public Set<Long> getCancelTaskLogIdsFromCache() {
        HashSet<Long> result = new HashSet<Long>(16);
        String cancelLogIdsFromCache = (String)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").get(cancelTaskLogCacheKey);
        if (StringUtils.isNotBlank((CharSequence)cancelLogIdsFromCache)) {
            result.addAll((Collection)SerializationUtils.fromJsonString((String)cancelLogIdsFromCache, Set.class));
        }
        return result;
    }

    public void removeCancelTaskLogIdCache(Long taskLogId) {
        if (IDUtils.isEmptyLong(taskLogId).booleanValue()) {
            return;
        }
        Set<Long> cancelTaskLogIdsFromCache = this.getCancelTaskLogIdsFromCache();
        if (CollectionUtils.isNotEmpty(cancelTaskLogIdsFromCache)) {
            cancelTaskLogIdsFromCache.removeIf(t -> t.equals(taskLogId));
            this.cacheCancelTaskLogIds(cancelTaskLogIdsFromCache);
        }
    }

    public boolean taskLogIsCancel(Long taskLogId) {
        if (IDUtils.isEmptyLong(taskLogId).booleanValue()) {
            log.info("taskLogId is empty.");
            return false;
        }
        Set<Long> cancelTaskLogIdsFromCache = this.getCancelTaskLogIdsFromCache();
        return CollectionUtils.isNotEmpty(cancelTaskLogIdsFromCache) && cancelTaskLogIdsFromCache.contains(taskLogId);
    }
}

