/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.entity.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.utils.GlobalIdUtil;

public class ReportProcess
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String hashKey;
    private Long id = 0L;
    private Long modelId = 0L;
    private Long entityViewId = 0L;
    private String status = "";
    private Long periodId = 0L;
    private Long dataTypeId = 0L;
    private Long versionId = 0L;
    private Long entityId = 0L;
    private String entityNumber;
    private String entityName;
    private Long templateId = 0L;
    private String templateNumber;
    private String templateName;
    private boolean isReadOnly;
    private Long creater = 0L;
    private Date createDate;
    private Long modifier = 0L;
    private String modifierName;
    private Date modifyDate;
    private Long submitUser = 0L;
    private String submitUserName;
    private Date submitDate;
    private Long submitEntity = 0L;
    private String submitEntityName;
    private Long approveBillId = 0L;
    private String billno;
    private ReportProcessQuote processQuote;
    public static final String TABLE_FIELD_KEYS = "fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill";
    public static final String INSERT_FIELD_KEYS = "fid, fentity, fversion, fdatatype, fperiod, ftemplate, fmodel, fcreater, fcreatedate, fstatus, fsubmitentity, fsubmitdate, fsubmituser,fapprovebill";
    public static final String ADD_FIELD_KEYS = "fid, fentity, fversion, fdatatype, fperiod, ftemplate, fmodel,fmodifier, fmodifydate, fcreater, fcreatedate, fstatus, fsubmitentity, fsubmitdate, fsubmituser,fapprovebill";
    public static final String BASEDATA_FIELD_KEYS = "id,template, entity, version,datatype, period, status, model,submitdate, submituser,submitentity,creater, createdate,modifier,modifydate,approvebill";

    public ReportProcessQuote getProcessQuote() {
        return this.processQuote;
    }

    public void setProcessQuote(ReportProcessQuote processQuote) {
        this.processQuote = processQuote;
    }

    public Long getEntityViewId() {
        return this.entityViewId;
    }

    public void setEntityViewId(Long entityViewId) {
        this.entityViewId = entityViewId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Long dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getTemplateNumber() {
        return this.templateNumber;
    }

    public void setTemplateNumber(String templateNumber) {
        this.templateNumber = templateNumber;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isReadOnly() {
        return this.isReadOnly || BgTaskStateEnum.READONLY.getNumber().equals(this.status);
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getCreater() {
        return this.creater;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getModifier() {
        return this.modifier;
    }

    public void setModifier(Long modifier) {
        this.modifier = modifier;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Long getSubmitUser() {
        return this.submitUser;
    }

    public void setSubmitUser(Long submitUser) {
        this.submitUser = submitUser;
    }

    public String getSubmitUserName() {
        return this.submitUserName;
    }

    public void setSubmitUserName(String submitUserName) {
        this.submitUserName = submitUserName;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public Long getSubmitEntity() {
        return this.submitEntity;
    }

    public void setSubmitEntity(Long submitEntity) {
        this.submitEntity = submitEntity;
    }

    public String getSubmitEntityName() {
        return this.submitEntityName;
    }

    public void setSubmitEntityName(String submitEntityName) {
        this.submitEntityName = submitEntityName;
    }

    public Long getApproveBillId() {
        return this.approveBillId;
    }

    public void setApproveBillId(Long approveBillId) {
        this.approveBillId = approveBillId;
    }

    public String getBillno() {
        return this.billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public String getModifierName() {
        return this.modifierName;
    }

    public void setModifierName(String modifierName) {
        this.modifierName = modifierName;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    private void buildHashKey() {
        this.hashKey = this.templateId + "" + this.entityId + this.periodId + this.dataTypeId + this.versionId;
    }

    public ReportProcess(Long modelId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId) {
        this(modelId, 0L, templateId, entityId, periodId, dataTypeId, versionId);
    }

    public ReportProcess(Long modelId, Long entityViewId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId) {
        this(GlobalIdUtil.genGlobalLongId(), modelId, entityViewId, templateId, entityId, periodId, dataTypeId, versionId);
    }

    public ReportProcess(Long id, Long modelId, Long entityViewId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId) {
        this.id = id;
        this.modelId = modelId;
        this.entityViewId = entityViewId;
        this.templateId = templateId;
        this.entityId = entityId;
        this.periodId = periodId;
        this.dataTypeId = dataTypeId;
        this.versionId = versionId;
        this.buildHashKey();
    }

    public ReportProcess(Long id, Long modelId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId, String status, Long creater, Date createDate, Long modifier, Date modifyDate, Long submitEntity, Date submitDate, Long submituser, Long approveBillId) {
        this.id = id;
        this.modelId = modelId;
        this.templateId = templateId;
        this.entityId = entityId;
        this.periodId = periodId;
        this.dataTypeId = dataTypeId;
        this.versionId = versionId;
        this.status = status;
        this.creater = creater;
        this.createDate = createDate;
        this.modifier = modifier;
        this.modifyDate = modifyDate;
        this.submitEntity = submitEntity;
        this.submitDate = submitDate;
        this.submitUser = submituser;
        this.approveBillId = approveBillId;
        this.buildHashKey();
    }

    public ReportProcess getReportProcessCombination() {
        return this;
    }

    public static ReportProcess buildReportProcessCombination(Long modelId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId) {
        return new ReportProcess(modelId, 0L, templateId, entityId, periodId, dataTypeId, versionId);
    }

    public static ReportProcess buildReportProcessCombination(Long modelId, Long templateId, Long entityId, String pdvStr) {
        String[] str = pdvStr.split("#");
        return ReportProcess.buildReportProcessCombination(modelId, templateId, entityId, Long.valueOf(str[0]), Long.valueOf(str[1]), Long.valueOf(str[2]));
    }

    public static ReportProcess createProcessFromDataSetRow(DynamicObject dynamicObject) {
        Long fid = dynamicObject.getLong("id");
        Long fentity = dynamicObject.getLong("entity.id");
        Long fversion = dynamicObject.getLong("version.id");
        Long fdatatype = dynamicObject.getLong("datatype.id");
        Long fperiod = dynamicObject.getLong("period.id");
        Long ftemplate = dynamicObject.getLong("template.id");
        String fstatus = dynamicObject.getString("status");
        Long fmodel = dynamicObject.getLong("model.id");
        Long fcreater = dynamicObject.getLong("creater.id");
        Date fcreatedate = dynamicObject.getDate("createdate");
        Long fmodifier = dynamicObject.getLong("modifier.id");
        Date fmodifydate = dynamicObject.getDate("modifydate");
        Long fsubmituser = dynamicObject.getLong("submituser.id");
        Long submitEntity = dynamicObject.getLong("submitentity.id");
        Date submitdate = dynamicObject.getDate("submitdate");
        Long approvebill = dynamicObject.getLong("approvebill.id");
        ReportProcess reportProcess = new ReportProcess(fid, fmodel, ftemplate, fentity, fperiod, fdatatype, fversion, fstatus, fcreater, fcreatedate, fmodifier, fmodifydate, submitEntity, submitdate, fsubmituser, approvebill);
        reportProcess.setEntityNumber(dynamicObject.getString("entity.number"));
        reportProcess.setEntityName(dynamicObject.getString("entity.name"));
        reportProcess.setTemplateNumber(dynamicObject.getString("template.number"));
        reportProcess.setTemplateName(dynamicObject.getString("template.name"));
        reportProcess.setReadOnly(dynamicObject.getBoolean("template.isReadOnly"));
        return reportProcess;
    }

    public static List<ReportProcess> addOtherMessage(List<ReportProcess> reportProcessesList) {
        ReportProcess.addSubmitUserMessage(reportProcessesList);
        ReportProcess.addSubmitEntityMessage(reportProcessesList);
        ReportProcess.addApproveBillMessage(reportProcessesList);
        return reportProcessesList;
    }

    private static void addSubmitUserMessage(List<ReportProcess> reportProcessesList) {
        HashSet org = new HashSet(16);
        reportProcessesList.forEach(e -> {
            if (e.getSubmitUser() != null && e.getSubmitUser() != 0L) {
                org.add(e.getSubmitUser());
            }
        });
        if (org.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", org);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])qFilter.toArray());
        HashMap map = new HashMap(16);
        dynamicObjectCollection.forEach(e -> map.put(e.getLong("id"), e.getString("name")));
        reportProcessesList.forEach(e -> e.setSubmitUserName((String)map.get(e.getSubmitUser())));
    }

    private static void addSubmitEntityMessage(List<ReportProcess> reportProcessesList) {
        HashSet entity = new HashSet(16);
        reportProcessesList.forEach(e -> {
            if (e.getSubmitEntity() != null && e.getSubmitEntity() != 0L) {
                entity.add(e.getSubmitEntity());
            }
        });
        if (entity.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", entity);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,name", (QFilter[])qFilter.toArray());
        HashMap map = new HashMap(16);
        dynamicObjectCollection.forEach(e -> map.put(e.getLong("id"), e.getString("name")));
        reportProcessesList.forEach(e -> e.setSubmitEntityName((String)map.get(e.getSubmitEntity())));
    }

    private static void addApproveBillMessage(List<ReportProcess> reportProcessesList) {
        HashSet approveBillIds = new HashSet(16);
        reportProcessesList.forEach(e -> {
            if (e.getApproveBillId() != null && e.getApproveBillId() != 0L) {
                approveBillIds.add(e.getApproveBillId());
            }
        });
        if (approveBillIds.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,billno", (QFilter[])qFilter.toArray());
        HashMap map = new HashMap(16);
        dynamicObjectCollection.forEach(e -> map.put(e.getLong("id"), e.getString("billno")));
        reportProcessesList.forEach(e -> e.setBillno((String)map.get(e.getApproveBillId())));
    }

    public static ReportProcess createProcessFromDataSetRow(Row next, ObjectCache objectCache) {
        Long fid = next.getLong("fid");
        Long fentity = objectCache.valueOf(next.getLong("fentity"));
        Long fversion = objectCache.valueOf(next.getLong("fversion"));
        Long fdatatype = objectCache.valueOf(next.getLong("fdatatype"));
        Long fperiod = objectCache.valueOf(next.getLong("fperiod"));
        Long ftemplate = objectCache.valueOf(next.getLong("ftemplate"));
        String fstatus = objectCache.valueOf(next.getString("fstatus"));
        Long fmodel = objectCache.valueOf(next.getLong("fmodel"));
        Long fcreater = objectCache.valueOf(next.getLong("fcreater"));
        Date fcreatedate = objectCache.valueOf(next.getDate("fcreatedate"));
        Long fmodifier = objectCache.valueOf(next.getLong("fmodifier"));
        Date fmodifydate = objectCache.valueOf(next.getDate("fmodifydate"));
        Long fsubmituser = objectCache.valueOf(next.getLong("fsubmituser"));
        Long submitEntity = objectCache.valueOf(next.getLong("fsubmitentity"));
        Date submitdate = objectCache.valueOf(next.getDate("fsubmitdate"));
        Long approvebill = next.getLong("fapprovebill");
        return new ReportProcess(fid, fmodel, ftemplate, fentity, fperiod, fdatatype, fversion, fstatus, fcreater, fcreatedate, fmodifier, fmodifydate, submitEntity, submitdate, fsubmituser, approvebill);
    }

    public static StringBuilder getInsertSql() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("insert into t_eb_reportprocess");
        sqlBuilder.append("(").append(INSERT_FIELD_KEYS).append(")");
        sqlBuilder.append("values(");
        ArrayList<String> placeHolder = new ArrayList<String>(16);
        for (int i = 0; i < INSERT_FIELD_KEYS.split(",").length; ++i) {
            placeHolder.add("?");
        }
        sqlBuilder.append(String.join((CharSequence)",", placeHolder));
        sqlBuilder.append(")");
        return sqlBuilder;
    }

    public static String getUpdateSql() {
        return "update t_eb_reportprocess set fstatus = ?, fsubmitentity = ?, fsubmitdate = ?, fsubmituser = ?, fmodifier = ?, fmodifydate = ?, fapprovebill = ? where fid = ? and fstatus != '9'";
    }

    public static StringBuilder getAddSql() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("insert into t_eb_reportprocess");
        sqlBuilder.append("(").append(ADD_FIELD_KEYS).append(")");
        sqlBuilder.append("values(");
        ArrayList<String> placeHolder = new ArrayList<String>(16);
        for (int i = 0; i < ADD_FIELD_KEYS.split(",").length; ++i) {
            placeHolder.add("?");
        }
        sqlBuilder.append(String.join((CharSequence)",", placeHolder));
        sqlBuilder.append(")");
        return sqlBuilder;
    }

    public static SqlBuilder getDeleteSql(Set<Long> reportProcessIdSet) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_reportprocess where (fstatus = '7' or fstatus = '0'  or fstatus = '9') and ", new Object[0]);
        sqlBuilder.appendIn("fid", reportProcessIdSet.toArray());
        return sqlBuilder;
    }

    public static SqlBuilder getSelectAllFieldSql() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess ", new Object[0]);
        return sqlBuilder;
    }

    public Object[] getAddParams() {
        Object[] params = new Object[ADD_FIELD_KEYS.split(",").length];
        params[0] = this.id;
        params[1] = this.entityId;
        params[2] = this.versionId;
        params[3] = this.dataTypeId;
        params[4] = this.periodId;
        params[5] = this.templateId;
        params[6] = this.modelId;
        params[7] = this.modifier;
        params[8] = this.modifyDate;
        params[9] = this.creater;
        params[10] = this.createDate;
        params[11] = this.status;
        params[12] = this.submitEntity;
        params[13] = this.submitDate;
        params[14] = this.submitUser;
        params[15] = this.approveBillId;
        return params;
    }

    public Object[] getUpdateParams() {
        Object[] params = new Object[]{this.status, this.submitEntity, this.submitDate, this.submitUser, this.modifier, this.modifyDate, this.approveBillId, this.id};
        return params;
    }

    public Object[] getInsertParams(Long creater, Date createDate) {
        Object[] params = new Object[]{this.id, this.entityId, this.versionId, this.dataTypeId, this.periodId, this.templateId, this.modelId, creater, createDate, this.status, this.submitEntity, this.submitDate, this.submitUser, this.approveBillId};
        return params;
    }

    public static ReportProcess createProcessFromDynamicObjectV2(DynamicObject dynamicObject) {
        Long fid = dynamicObject.getLong("id");
        Long fentity = dynamicObject.getLong("entity");
        Long fversion = dynamicObject.getLong("version");
        Long fdatatype = dynamicObject.getLong("datatype");
        Long fperiod = dynamicObject.getLong("period");
        Long ftemplate = dynamicObject.getLong("template");
        String fstatus = dynamicObject.getString("status");
        Long fmodel = dynamicObject.getLong("model");
        Long fcreater = dynamicObject.getLong("creater");
        Date fcreatedate = dynamicObject.getDate("createdate");
        Long fmodifier = dynamicObject.getLong("modifier");
        Date fmodifydate = dynamicObject.getDate("modifydate");
        Long fsubmituser = dynamicObject.getLong("submituser");
        Long submitEntity = dynamicObject.getLong("submitentity");
        Date submitdate = dynamicObject.getDate("submitdate");
        Long approvebill = dynamicObject.getLong("approvebill");
        return new ReportProcess(fid, fmodel, ftemplate, fentity, fperiod, fdatatype, fversion, fstatus, fcreater, fcreatedate, fmodifier, fmodifydate, submitEntity, submitdate, fsubmituser, approvebill);
    }

    public int hashCode() {
        return this.hashKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReportProcess) {
            ReportProcess reportProcess = (ReportProcess)obj;
            if (!Objects.equals(this.templateId, reportProcess.getTemplateId())) {
                return false;
            }
            if (!Objects.equals(this.entityId, reportProcess.getEntityId())) {
                return false;
            }
            if (!Objects.equals(this.periodId, reportProcess.getPeriodId())) {
                return false;
            }
            if (!Objects.equals(this.dataTypeId, reportProcess.getDataTypeId())) {
                return false;
            }
            return Objects.equals(this.versionId, reportProcess.getVersionId());
        }
        return false;
    }

    public ReportProcess clone() throws CloneNotSupportedException {
        return (ReportProcess)super.clone();
    }
}

