/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.entity.dto;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateEntityDto
implements Serializable {
    private static final long serialVersionUID = 2631417474403097596L;
    private Long templateId;
    private Long entityId;
    private Integer entityRange;
    private Set<Long> deleteEntity;
    private Long recordId;

    public TemplateEntityDto() {
    }

    public TemplateEntityDto(Long templateId, Long entityId, Integer entityRange) {
        this.templateId = templateId;
        this.entityId = entityId;
        this.entityRange = entityRange;
    }

    public TemplateEntityDto(Long templateId, Long entityId) {
        this.templateId = templateId;
        this.entityId = entityId;
        this.entityRange = RangeEnum.VALUE_10.getValue();
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Integer getEntityRange() {
        return this.entityRange;
    }

    public void setEntityRange(Integer entityRange) {
        this.entityRange = entityRange;
    }

    public Set<Long> getDeleteEntity() {
        return this.deleteEntity;
    }

    public void setDeleteEntity(Set<Long> deleteEntity) {
        this.deleteEntity = deleteEntity;
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public Set<Long> getEntityIdSet(Long entityViewId, IModelCacheHelper modelCacheHelper) {
        HashSet<Long> entityIds = new HashSet<Long>(16);
        if (RangeEnum.VALUE_10.getValue() == this.getEntityRange().intValue()) {
            entityIds.add(this.getEntityId());
        }
        List<Member> entityMemberByView = MemberHelper.getEntityMemberByView(modelCacheHelper, entityViewId, this.getEntityId(), this.getEntityRange());
        for (Member member : entityMemberByView) {
            entityIds.add(member.getId());
        }
        if (CollectionUtils.isNotEmpty(this.deleteEntity)) {
            entityIds.removeAll(this.deleteEntity);
        }
        return entityIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateEntityDto that = (TemplateEntityDto)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.entityRange, that.entityRange) && Objects.equals(this.deleteEntity, that.deleteEntity) && Objects.equals(this.recordId, that.recordId);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.entityId, this.entityRange, this.deleteEntity, this.recordId);
    }
}

