/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.entity.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class BaseRptProcessRequest {
    private CancelType cancelType;
    private Long modelId;
    private Long entityViewId;
    private Long periodId;
    private Long dataTypeId;
    private Long versionId;
    private Long schemeId;
    private IModelCacheHelper modelCacheHelper;
    private boolean hasDisableEntity = false;
    private List<TemplateEntityDto> templateEntityDtoList;

    public synchronized IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate(this.modelId);
        }
        return this.modelCacheHelper;
    }

    public synchronized void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    public boolean isHasDisableEntity() {
        return this.hasDisableEntity;
    }

    public void setHasDisableEntity(boolean hasDisableEntity) {
        this.hasDisableEntity = hasDisableEntity;
    }

    public BaseRptProcessRequest(Long modelId, Long entityViewId, Long periodId, Long dataTypeId, Long versionId, @NotNull List<TemplateEntityDto> templateEntityDtoList) {
        this.modelId = modelId;
        this.entityViewId = entityViewId;
        this.periodId = periodId;
        this.dataTypeId = dataTypeId;
        this.versionId = versionId;
        this.templateEntityDtoList = templateEntityDtoList;
    }

    public CancelType getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(CancelType cancelType) {
        this.cancelType = cancelType;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getEntityViewId() {
        return this.entityViewId;
    }

    public void setEntityViewId(Long entityViewId) {
        this.entityViewId = entityViewId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Long dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public List<TemplateEntityDto> getTemplateEntityDtoList() {
        return this.templateEntityDtoList;
    }

    public void setTemplateEntityDtoList(List<TemplateEntityDto> templateEntityDtoList) {
        this.templateEntityDtoList = templateEntityDtoList;
    }

    public List<BaseRptProcessRequest> toList() {
        ArrayList<BaseRptProcessRequest> result = new ArrayList<BaseRptProcessRequest>(16);
        result.add(this);
        return result;
    }

    public String getPdvStr() {
        return this.periodId + "#" + this.dataTypeId + "#" + this.versionId;
    }

    public Set<Long> getTemplateIdSet() {
        HashSet<Long> result = new HashSet<Long>(16);
        for (TemplateEntityDto templateEntityDto : this.templateEntityDtoList) {
            result.add(templateEntityDto.getTemplateId());
        }
        return result;
    }

    public Set<Long> getEntityIdSet() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(this.modelId);
        HashSet<Long> result = new HashSet<Long>(16);
        for (TemplateEntityDto templateEntityDto : this.templateEntityDtoList) {
            if (RangeEnum.VALUE_10.getValue() == templateEntityDto.getEntityRange().intValue()) {
                result.add(templateEntityDto.getEntityId());
                continue;
            }
            List<Member> entityMemberByView = MemberHelper.getEntityMemberByView(modelCacheHelper, this.entityViewId, templateEntityDto.getEntityId(), templateEntityDto.getEntityRange());
            for (Member member : entityMemberByView) {
                result.add(member.getId());
            }
            if (!CollectionUtils.isNotEmpty(templateEntityDto.getDeleteEntity())) continue;
            result.removeAll(templateEntityDto.getDeleteEntity());
        }
        return result;
    }

    public Map<TemplateEntityDto, Set<Long>> getTemplateDtoEntityMap() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(this.modelId);
        HashMap<TemplateEntityDto, Set<Long>> result = new HashMap<TemplateEntityDto, Set<Long>>(16);
        if (CollectionUtils.isEmpty(this.templateEntityDtoList)) {
            return result;
        }
        HashMap entityRangeCache = new HashMap(16);
        String entityViewIdStr = String.valueOf(this.entityViewId);
        for (TemplateEntityDto templateEntityDto : this.templateEntityDtoList) {
            Set entityIds = result.computeIfAbsent(templateEntityDto, t -> new HashSet(16));
            if (RangeEnum.VALUE_10.getValue() == templateEntityDto.getEntityRange().intValue()) {
                entityIds.add(templateEntityDto.getEntityId());
                continue;
            }
            String entityRangeCacheKey = CollectionUtils.isNotEmpty(templateEntityDto.getDeleteEntity()) ? entityViewIdStr + templateEntityDto.getEntityId() + templateEntityDto.getEntityRange() + "#" + templateEntityDto.hashCode() : entityViewIdStr + templateEntityDto.getEntityId() + templateEntityDto.getEntityRange();
            Set cacheEntityIds = (Set)entityRangeCache.get(entityRangeCacheKey);
            if (cacheEntityIds == null) {
                List<Member> entityMemberByView = MemberHelper.getEntityMemberByView(modelCacheHelper, this.entityViewId, templateEntityDto.getEntityId(), templateEntityDto.getEntityRange());
                cacheEntityIds = entityMemberByView.stream().map(e -> e.getId()).collect(Collectors.toSet());
                Set<Long> deleteEntity = templateEntityDto.getDeleteEntity();
                if (CollectionUtils.isNotEmpty(deleteEntity)) {
                    cacheEntityIds.removeAll(deleteEntity);
                }
                entityRangeCache.put(entityRangeCacheKey, cacheEntityIds);
            }
            entityIds.addAll(cacheEntityIds);
        }
        return result;
    }

    public Map<Long, Set<Long>> getTemplateEntityMap() {
        return this.getTemplateEntityMap(null);
    }

    public Map<Long, Set<Long>> getTemplateEntityMap(Set<Long> filterTemplateSet) {
        if (CollectionUtils.isEmpty(this.templateEntityDtoList)) {
            return Collections.emptyMap();
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(this.modelId);
        LinkedHashMap entityRangeCache = new LinkedHashMap();
        LinkedHashMap<Long, Set<Long>> result = new LinkedHashMap<Long, Set<Long>>();
        String entityViewIdStr = String.valueOf(this.entityViewId);
        for (TemplateEntityDto templateEntityDto : this.templateEntityDtoList) {
            Long templateId = templateEntityDto.getTemplateId();
            if (CollectionUtils.isNotEmpty(filterTemplateSet) && !filterTemplateSet.contains(templateId)) continue;
            Set entityIds = result.computeIfAbsent(templateId, t -> new HashSet(16));
            if (RangeEnum.VALUE_10.getValue() == templateEntityDto.getEntityRange().intValue()) {
                entityIds.add(templateEntityDto.getEntityId());
                continue;
            }
            String entityRangeCacheKey = CollectionUtils.isNotEmpty(templateEntityDto.getDeleteEntity()) ? entityViewIdStr + templateEntityDto.getEntityId() + templateEntityDto.getEntityRange() + "#" + templateEntityDto.hashCode() : entityViewIdStr + templateEntityDto.getEntityId() + templateEntityDto.getEntityRange();
            Set cacheEntityIds = (Set)entityRangeCache.get(entityRangeCacheKey);
            if (cacheEntityIds == null) {
                List<Member> entityMemberByView = MemberHelper.getEntityMemberByView(modelCacheHelper, this.entityViewId, templateEntityDto.getEntityId(), templateEntityDto.getEntityRange());
                cacheEntityIds = entityMemberByView.stream().filter(e -> !e.getNumber().endsWith("offsetentry")).map(e -> e.getId()).collect(Collectors.toSet());
                Set<Long> deleteEntity = templateEntityDto.getDeleteEntity();
                if (CollectionUtils.isNotEmpty(deleteEntity)) {
                    cacheEntityIds.removeAll(deleteEntity);
                }
                entityRangeCache.put(entityRangeCacheKey, cacheEntityIds);
            }
            entityIds.addAll(cacheEntityIds);
        }
        return result;
    }

    public Map<Long, Integer> getEntityRangeMap() {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        for (TemplateEntityDto templateEntityDto : this.templateEntityDtoList) {
            result.put(templateEntityDto.getEntityId(), templateEntityDto.getEntityRange());
        }
        return result;
    }

    public SqlBuilder getQuerySql() {
        SqlBuilder sqlBuilder = ReportProcess.getSelectAllFieldSql();
        sqlBuilder.append(" where fperiod = ? ", new Object[]{this.periodId});
        sqlBuilder.append(" and fdatatype = ? ", new Object[]{this.dataTypeId});
        sqlBuilder.append(" and fversion = ? ", new Object[]{this.versionId});
        Set<Long> templateIdSet = this.getTemplateIdSet();
        Set<Long> entityIdSet = this.getEntityIdSet();
        if (CollectionUtils.isNotEmpty(templateIdSet)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn("ftemplate", templateIdSet.toArray());
        }
        if (CollectionUtils.isNotEmpty(entityIdSet)) {
            sqlBuilder.append(" and", new Object[0]);
            sqlBuilder.appendIn("fentity", entityIdSet.toArray());
        }
        sqlBuilder.append(" order by fcreatedate desc", new Object[0]);
        return sqlBuilder;
    }

    public static enum CancelType {
        SCHEME,
        TASK,
        UNALLOC;

    }
}

