/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.entity.request;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class UpdateRptProcessStatusRequest {
    private static final Log log = LogFactory.getLog(UpdateRptProcessStatusRequest.class);
    private Long modelId;
    private Long entityViewId;
    private Set<Long> templateIdSet;
    private Long entityId;
    private Long periodId;
    private Long dataTypeId;
    private Long versionId;
    private BgTaskStateEnum stateEnum;
    private Long approveBillId;
    private boolean isForwardUpdate = true;
    private Date modifyDate = null;
    private static final Map<String, String> updateFieldMap = new HashMap<String, String>(16);

    public UpdateRptProcessStatusRequest(Long modelId, Long entityViewId, Set<Long> templateIdSet, Long entityId, Long periodId, Long dataTypeId, Long versionId, Long approveBillId, BgTaskStateEnum stateEnum) {
        this.modelId = modelId;
        this.entityViewId = entityViewId;
        this.templateIdSet = templateIdSet;
        this.entityId = entityId;
        this.periodId = periodId;
        this.dataTypeId = dataTypeId;
        this.versionId = versionId;
        this.stateEnum = stateEnum;
        this.approveBillId = approveBillId;
    }

    public UpdateRptProcessStatusRequest(Long modelId, Long entityViewId, Set<Long> templateIdSet, Long entityId, Long periodId, Long dataTypeId, Long versionId, BgTaskStateEnum stateEnum, boolean isForwardUpdate) {
        this.modelId = modelId;
        this.entityViewId = entityViewId;
        this.templateIdSet = templateIdSet;
        this.entityId = entityId;
        this.periodId = periodId;
        this.dataTypeId = dataTypeId;
        this.versionId = versionId;
        this.stateEnum = stateEnum;
        this.isForwardUpdate = isForwardUpdate;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public UpdateRptProcessStatusRequest setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
        return this;
    }

    public Long getApproveBillId() {
        return this.approveBillId;
    }

    public void setApproveBillId(Long approveBillId) {
        this.approveBillId = approveBillId;
    }

    public BgTaskStateEnum getStateEnum() {
        return this.stateEnum;
    }

    public void setStateEnum(BgTaskStateEnum stateEnum) {
        this.stateEnum = stateEnum;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getEntityViewId() {
        return this.entityViewId;
    }

    public void setEntityViewId(Long entityViewId) {
        this.entityViewId = entityViewId;
    }

    public Set<Long> getTemplateIdSet() {
        return this.templateIdSet;
    }

    public void setTemplateIdSet(Set<Long> templateIdSet) {
        this.templateIdSet = templateIdSet;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Long dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public boolean isForwardUpdate() {
        return this.isForwardUpdate;
    }

    public void setForwardUpdate(boolean forwardUpdate) {
        this.isForwardUpdate = forwardUpdate;
    }

    public Object[] getUpdateStatusParams() {
        Object[] params = null;
        if (this.stateEnum == BgTaskStateEnum.TEMPSAVE || this.stateEnum == BgTaskStateEnum.INCOMPLETE) {
            params = new Object[]{this.modifyDate == null ? TimeServiceHelper.now() : this.modifyDate, RequestContext.get().getCurrUserId(), this.stateEnum.getNumber(), this.modelId, this.periodId, this.dataTypeId, this.versionId};
        } else if (this.stateEnum == BgTaskStateEnum.UNDERWAY) {
            params = new Object[]{this.modifyDate == null ? TimeServiceHelper.now() : this.modifyDate, RequestContext.get().getCurrUserId(), this.entityId, this.stateEnum.getNumber(), this.approveBillId, this.modelId, this.periodId, this.dataTypeId, this.versionId};
        } else if (this.stateEnum == BgTaskStateEnum.COMPLETED) {
            params = new Object[]{this.stateEnum.getNumber(), this.modelId, this.periodId, this.dataTypeId, this.versionId};
        }
        return params;
    }

    public SqlBuilder getUpdateStatusSql() {
        String updateKeyStr = updateFieldMap.get(this.stateEnum.getNumber());
        SqlBuilder sqlBuilder = new SqlBuilder();
        Object[] updateStatusParams = this.getUpdateStatusParams();
        if (updateStatusParams == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateRptProcessStatusRequest_01", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        Set<Object> entityIdSetByRange = new HashSet(16);
        Set<Object> notApproveBillProcessIdSet = new HashSet(16);
        if (this.stateEnum == BgTaskStateEnum.COMPLETED) {
            entityIdSetByRange = this.getEntityIdSetByRange();
            sqlBuilder.append("update t_eb_reportprocess set ", new Object[0]);
            sqlBuilder.append(updateKeyStr, new Object[0]);
            sqlBuilder.append(" where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? ", updateStatusParams);
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" ftemplate ", this.templateIdSet.toArray());
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fentity ", entityIdSetByRange.toArray());
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.append(" fapprovebill =", new Object[0]);
            sqlBuilder.append(String.valueOf(this.approveBillId), new Object[0]);
        } else if (this.stateEnum == BgTaskStateEnum.UNDERWAY) {
            entityIdSetByRange = this.getEntityIdSetByRange();
            List<ReportProcess> notApproveBillProcessList = ApproveBillHelper.getNotApproveBillProcessList(this.modelId, this.entityViewId, this.periodId, this.dataTypeId, this.versionId, this.templateIdSet, entityIdSetByRange, true);
            notApproveBillProcessIdSet = notApproveBillProcessList.stream().map(ReportProcess::getId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(notApproveBillProcessIdSet)) {
                log.info("getUpdateStatusSql notApproveBillProcessIdSet empty.");
                return null;
            }
            sqlBuilder.append("update t_eb_reportprocess set ", new Object[0]);
            sqlBuilder.append(updateKeyStr, new Object[0]);
            sqlBuilder.append(" where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? and fstatus != '5' ", updateStatusParams);
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fid ", notApproveBillProcessIdSet.toArray());
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" ftemplate ", this.templateIdSet.toArray());
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fentity ", entityIdSetByRange.toArray());
        } else if (this.isForwardUpdate) {
            entityIdSetByRange = new HashSet(16);
            entityIdSetByRange.add(this.entityId);
            notApproveBillProcessIdSet = ApproveBillHelper.getNotApproveBillProcessIdSet(this.modelId, this.entityViewId, this.periodId, this.dataTypeId, this.versionId, this.templateIdSet, entityIdSetByRange, true);
            if (CollectionUtils.isEmpty(notApproveBillProcessIdSet)) {
                return null;
            }
            Object[] params = new Object[]{this.modifyDate == null ? TimeServiceHelper.now() : this.modifyDate, RequestContext.get().getCurrUserId(), this.stateEnum.getNumber()};
            updateKeyStr = updateFieldMap.get(this.stateEnum.getNumber());
            sqlBuilder.append("update t_eb_reportprocess set ", new Object[0]);
            sqlBuilder.append(updateKeyStr, params);
            sqlBuilder.append(" where ", new Object[0]);
            sqlBuilder.appendIn(" fid ", notApproveBillProcessIdSet.toArray());
            sqlBuilder.appendIn(" and fstatus ", (Object[])new String[]{"0", "1", "7"});
        } else {
            entityIdSetByRange = this.getEntityIdSetByRange();
            List<ReportProcess> notApproveBillProcessList = ApproveBillHelper.getNotApproveBillProcessList(this.modelId, this.entityViewId, this.periodId, this.dataTypeId, this.versionId, this.templateIdSet, entityIdSetByRange, true);
            notApproveBillProcessIdSet = notApproveBillProcessList.stream().map(ReportProcess::getId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(notApproveBillProcessIdSet)) {
                return null;
            }
            entityIdSetByRange.clear();
            entityIdSetByRange.add(this.entityId);
            HashSet<Long> hasModifyDateAndUserProcessIdSet = new HashSet<Long>(16);
            HashSet<Long> notModifyDateAndUserProcessIdSet = new HashSet<Long>(16);
            HashSet<Long> approveBillHasNotExitProcessIdSet = new HashSet<Long>(16);
            Set<Long> approveBillIdSet = ApproveBillHelper.getApproveBillIdSet(this.modelId, this.periodId, this.dataTypeId, this.versionId, false);
            for (ReportProcess reportProcess : notApproveBillProcessList) {
                Long approveBillId;
                if (reportProcess.getModifyDate() == null && IDUtils.isEmptyLong(reportProcess.getModifier()).booleanValue()) {
                    notModifyDateAndUserProcessIdSet.add(reportProcess.getId());
                } else {
                    hasModifyDateAndUserProcessIdSet.add(reportProcess.getId());
                }
                if (!IDUtils.isNotEmptyLong(approveBillId = reportProcess.getApproveBillId()).booleanValue() || approveBillIdSet.contains(approveBillId)) continue;
                approveBillHasNotExitProcessIdSet.add(reportProcess.getId());
            }
            Set<Long> rptReadonlyTemplateSet = this.getRptReadonlyTemplateSet();
            if (CollectionUtils.isNotEmpty(hasModifyDateAndUserProcessIdSet)) {
                if (this.stateEnum == BgTaskStateEnum.TEMPSAVE && !rptReadonlyTemplateSet.isEmpty()) {
                    this.handleRptReadOnlyTemplate(sqlBuilder, hasModifyDateAndUserProcessIdSet, rptReadonlyTemplateSet);
                    HashSet<Long> allTemplateSet = new HashSet<Long>(this.getTemplateIdSet());
                    allTemplateSet.removeAll(rptReadonlyTemplateSet);
                    if (!allTemplateSet.isEmpty()) {
                        Object[] params1 = new Object[]{this.stateEnum.getNumber()};
                        updateKeyStr = updateFieldMap.get(this.stateEnum.getNumber() + "_reverse");
                        SqlBuilder sqlBuilder1 = new SqlBuilder();
                        sqlBuilder1.append("update t_eb_reportprocess set ", new Object[0]);
                        sqlBuilder1.append(updateKeyStr, params1);
                        sqlBuilder1.append(" where ", new Object[0]);
                        sqlBuilder1.appendIn(" fid ", hasModifyDateAndUserProcessIdSet.toArray());
                        sqlBuilder1.append(" and ", new Object[0]);
                        sqlBuilder1.appendIn(" ftemplate ", allTemplateSet.toArray());
                        sqlBuilder.appendSqlBuilder(sqlBuilder1);
                    }
                } else {
                    Object[] params1 = new Object[]{this.stateEnum.getNumber()};
                    updateKeyStr = updateFieldMap.get(this.stateEnum.getNumber() + "_reverse");
                    SqlBuilder sqlBuilder1 = new SqlBuilder();
                    sqlBuilder1.append("update t_eb_reportprocess set ", new Object[0]);
                    sqlBuilder1.append(updateKeyStr, params1);
                    sqlBuilder1.append(" where ", new Object[0]);
                    sqlBuilder1.appendIn(" fid ", hasModifyDateAndUserProcessIdSet.toArray());
                    sqlBuilder.appendSqlBuilder(sqlBuilder1);
                }
            }
            if (CollectionUtils.isNotEmpty(notModifyDateAndUserProcessIdSet)) {
                Object[] params2 = new Object[]{BgTaskStateEnum.INCOMPLETE == this.stateEnum ? this.stateEnum.getNumber() : BgTaskStateEnum.UNPREPARED.getNumber()};
                updateKeyStr = updateFieldMap.get(this.stateEnum.getNumber() + "_reverse");
                SqlBuilder sqlBuilder2 = new SqlBuilder();
                sqlBuilder2.append("update t_eb_reportprocess set ", new Object[0]);
                sqlBuilder2.append(updateKeyStr, params2);
                sqlBuilder2.append(" where ", new Object[0]);
                sqlBuilder2.appendIn(" fid ", notModifyDateAndUserProcessIdSet.toArray());
                sqlBuilder.appendSqlBuilder(sqlBuilder2);
            }
            if (CollectionUtils.isNotEmpty(approveBillHasNotExitProcessIdSet)) {
                SqlBuilder sqlBuilder2 = new SqlBuilder();
                sqlBuilder2.append("update t_eb_reportprocess set fapprovebill = 0 where ", new Object[0]);
                sqlBuilder2.appendIn(" fid ", approveBillHasNotExitProcessIdSet.toArray());
                sqlBuilder.appendSqlBuilder(sqlBuilder2);
            }
        }
        if (!sqlBuilder.isEmpty()) {
            sqlBuilder.append(" and fstatus != '9' ", new Object[0]);
        }
        return sqlBuilder;
    }

    private void handleRptReadOnlyTemplate(SqlBuilder sqlBuilder, Set<Long> hasModifyDateAndUserProcessIdSet, Set<Long> rptReadonlyTemplateSet) {
        Object[] params1 = new Object[]{BgTaskStateEnum.UNPREPARED.getNumber()};
        String updateKeyStr = updateFieldMap.get(this.stateEnum.getNumber() + "_reverse");
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("update t_eb_reportprocess set ", new Object[0]);
        sqlBuilder1.append(updateKeyStr, params1);
        sqlBuilder1.append(" where ", new Object[0]);
        sqlBuilder1.appendIn(" fid ", hasModifyDateAndUserProcessIdSet.toArray());
        sqlBuilder1.append(" and ", new Object[0]);
        sqlBuilder1.appendIn(" ftemplate ", rptReadonlyTemplateSet.toArray());
        sqlBuilder.appendSqlBuilder(sqlBuilder1);
    }

    private Set<Long> getEntityIdSetByRange() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(this.getModelId());
        return MemberHelper.getEntityIdSetByView(modelCacheHelper, this.entityViewId, this.entityId, RangeEnum.VALUE_50.getValue());
    }

    private Set<Long> getRptReadonlyTemplateSet() {
        HashSet<Long> rptReadonlyTemplateIdSet = new HashSet<Long>(16);
        Set<Long> templateIdSet = this.getTemplateIdSet();
        if (CollectionUtils.isEmpty(templateIdSet)) {
            return rptReadonlyTemplateIdSet;
        }
        QFilter qFilter = new QFilter("id", "in", templateIdSet);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,isreadonly,rptreadonly", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isNotEmpty((Collection)templates)) {
            for (DynamicObject template : templates) {
                if (template.getBoolean("isreadonly") || !template.getBoolean("rptreadonly")) continue;
                rptReadonlyTemplateIdSet.add(template.getLong("id"));
            }
        }
        return rptReadonlyTemplateIdSet;
    }

    static {
        updateFieldMap.put(BgTaskStateEnum.TEMPSAVE.getNumber(), "fmodifydate = ?, fmodifier = ?, fstatus = ?, fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0");
        updateFieldMap.put(BgTaskStateEnum.INCOMPLETE.getNumber(), "fmodifydate = ?, fmodifier = ?, fstatus = ?, fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0");
        updateFieldMap.put(BgTaskStateEnum.TEMPSAVE.getNumber() + "_reverse", "fstatus = ?, fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill =0 ");
        updateFieldMap.put(BgTaskStateEnum.INCOMPLETE.getNumber() + "_reverse", "fstatus = ?, fapprovebill =0 ");
        updateFieldMap.put(BgTaskStateEnum.UNDERWAY.getNumber(), "fsubmitdate = ? , fsubmituser = ?, fsubmitentity = ?, fstatus = ?, fapprovebill = ?");
        updateFieldMap.put(BgTaskStateEnum.COMPLETED.getNumber(), "fstatus = ?");
    }
}

