/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillSortInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.lock.Lock;

public class ApproveBillHelper {
    private static final String ApproveBillInfo_fields = "id,billno,billstatus,createrid,orgviewid,parentbillid,eborgid,centralorg.id,auditnode,centralbilltype,approvetype,createdate,entryentity.tempid as tempid,splitversion,dim_period,dim_version,dim_datatype";

    public static List<ReportProcess> getNotApproveBillProcessList(Long modelId, Long entityViewId, Long periodId, Long dataTypeId, Long versionId, Set<Long> templateIdSet, Set<Long> entityIdSet, boolean isFilterBillStatus) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        Map<Long, String> map = ApproveBillHelper.getApproveBillIdsForAlreadySubmit(modelId, periodId, dataTypeId, versionId, isFilterBillStatus);
        List<ReportProcess> reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, entityViewId, entityIdSet, templateIdSet, periodId, dataTypeId, versionId);
        if (reportProcessList != null && reportProcessList.size() == 1) {
            return reportProcessList;
        }
        if (reportProcessList != null) {
            for (ReportProcess reportProcess : reportProcessList) {
                Long approveBillId = reportProcess.getApproveBillId();
                if (IDUtils.isNotNull(approveBillId) && map.containsKey(approveBillId) && !StringUtils.equals("C", map.get(approveBillId))) continue;
                result.add(reportProcess);
            }
        }
        return result;
    }

    public static Map<Long, String> getApproveBillIdsForAlreadySubmit(Long modelId, Long periodId, Long dataTypeId, Long versionId, boolean isFilterBillStatus) {
        DynamicObject[] approveBillList = ApproveBillHelper.getApproveBillList(modelId, periodId, dataTypeId, versionId, isFilterBillStatus);
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        if (approveBillList != null && approveBillList.length > 0) {
            for (DynamicObject dynamicObject : approveBillList) {
                if (dynamicObject == null || !IDUtils.isNotNull(dynamicObject.getLong("id"))) continue;
                map.put(dynamicObject.getLong("id"), dynamicObject.getString("billstatus"));
            }
        }
        return map;
    }

    public static Set<Long> getNotApproveBillProcessIdSet(Long modelId, Long entityViewId, Long periodId, Long dataTypeId, Long versionId, Set<Long> templateIdSet, Set<Long> entityIdSet, boolean isFilterBillStatus) {
        List<ReportProcess> notApproveBillProcessList = ApproveBillHelper.getNotApproveBillProcessList(modelId, entityViewId, periodId, dataTypeId, versionId, templateIdSet, entityIdSet, isFilterBillStatus);
        return notApproveBillProcessList.stream().map(ReportProcess::getId).collect(Collectors.toSet());
    }

    public static Set<Long> getApproveBillIdSet(Long modelId, Long periodId, Long dataTypeId, Long versionId, boolean isFilterBillStatus) {
        DynamicObject[] approveBillList;
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : approveBillList = ApproveBillHelper.getApproveBillList(modelId, periodId, dataTypeId, versionId, isFilterBillStatus)) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    private static DynamicObject[] getApproveBillList(Long modelId, Long periodId, Long dataTypeId, Long versionId, boolean isFilterBillStatus) {
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        filter.and("dim_period", "=", (Object)periodId);
        filter.and("dim_version", "=", (Object)versionId);
        filter.and("dim_datatype", "=", (Object)dataTypeId);
        if (isFilterBillStatus) {
            filter.and("billstatus", "in", (Object)new String[]{"B", "C", "E"});
        }
        return BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id, eborgid, entryentity.tempid, billstatus", (QFilter[])filter.toArray());
    }

    public static DynamicObject[] getApproveBillListByStatus(Long modelId, Long periodId, Long dataTypeId, Long versionId, List<String> billStatus) {
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        filter.and("dim_period", "=", (Object)periodId);
        filter.and("dim_version", "=", (Object)versionId);
        filter.and("dim_datatype", "=", (Object)dataTypeId);
        if (CollectionUtils.isNotEmpty(billStatus)) {
            filter.and("billstatus", "in", billStatus);
        }
        return BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id, eborgid, entryentity.tempid,entryentity.tempid, billstatus", (QFilter[])filter.toArray());
    }

    public static boolean isCentralApproveBill(Long billId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        qFilter.and("parentbillid", "!=", (Object)0L);
        qFilter.and("splitbilltype", "=", (Object)CentralBillType.Child.getNumber());
        return QueryServiceHelper.exists((String)"eb_approvebill", (QFilter[])qFilter.toArray());
    }

    public static Map<Long, Long> getParentApproveBills(Set<Long> billIds) {
        HashMap<Long, Long> parentBillMap = new HashMap<Long, Long>(16);
        if (billIds == null || billIds.size() == 0) {
            return parentBillMap;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, parentbillid", (QFilter[])qFilter.toArray());
        bills.forEach(e -> parentBillMap.put(e.getLong("id"), e.getLong("parentbillid")));
        return parentBillMap;
    }

    public static List<ApproveBillInfo> getSubApproveBillList(Long mainBillId) {
        return ApproveBillHelper.getSubApproveBillList(mainBillId, true);
    }

    public static List<ApproveBillInfo> getSubApproveBillList(Long mainBillId, boolean containDiscard) {
        Map<Long, List<ApproveBillInfo>> subApproveBillLists = ApproveBillHelper.getSubApproveBillLists(Sets.newHashSet((Object[])new Long[]{mainBillId}), containDiscard);
        return subApproveBillLists.getOrDefault(mainBillId, new ArrayList(16));
    }

    public static void deleteAllSubApproveBill(Long mainBillId) {
    }

    public static Map<Long, List<ApproveBillInfo>> getSubApproveBillLists(Set<Long> mainBillIds) {
        return ApproveBillHelper.getSubApproveBillLists(mainBillIds, true);
    }

    public static Map<Long, List<ApproveBillInfo>> getSubApproveBillLists(Set<Long> mainBillIds, boolean containDiscard) {
        HashMap<Long, List<ApproveBillInfo>> result = new HashMap<Long, List<ApproveBillInfo>>(16);
        if (mainBillIds == null || mainBillIds.isEmpty()) {
            return result;
        }
        QFilter qFilter = new QFilter("parentbillid", "in", mainBillIds);
        qFilter.and("centralbilltype", "=", (Object)CentralBillType.Child.getNumber());
        if (!containDiscard) {
            qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        }
        Map<Long, ApproveBillInfo> billInfoMap = ApproveBillHelper.loadBillInfo(qFilter);
        billInfoMap.values().forEach(billInfo -> result.computeIfAbsent(billInfo.getParentBillId(), key -> new ArrayList(16)).add(billInfo));
        return result;
    }

    public static Set<Long> filterCentralBill(Set<Long> billIds) {
        if (billIds == null || billIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> centralBillIds = new HashSet<Long>(billIds.size());
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and("centralbilltype", "=", (Object)CentralBillType.Child.getNumber());
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"eb_approvebill", (String)"id", (QFilter[])qFilter.toArray());
        objs.forEach(obj -> centralBillIds.add(obj.getLong("id")));
        return centralBillIds;
    }

    public static Set<Long> getSubApproveBillIdLists(Set<Long> mainBillIds) {
        Map<Long, List<ApproveBillInfo>> subApproveBillLists = ApproveBillHelper.getSubApproveBillLists(mainBillIds);
        HashSet<Long> result = new HashSet<Long>(subApproveBillLists.size());
        if (subApproveBillLists.size() > 0) {
            subApproveBillLists.values().forEach(childBills -> childBills.forEach(childBill -> result.add(childBill.getBillId())));
        }
        return result;
    }

    public static ApproveBillInfo queryBill(Long billId) {
        if (IDUtils.isNull(billId)) {
            return null;
        }
        return ApproveBillHelper.queryBill(Collections.singletonList(billId)).get(billId);
    }

    public static Map<Long, ApproveBillInfo> queryBill(Collection<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        return ApproveBillHelper.loadBillInfo(qFilter);
    }

    public static Map<Long, ApproveBillInfo> loadBillInfo(QFilter ... qFilters) {
        HashMap<Long, ApproveBillInfo> result = new HashMap<Long, ApproveBillInfo>(32);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"eb_approvebill", (String)ApproveBillInfo_fields, (QFilter[])qFilters);
        if (CollectionUtils.isNotEmpty(objs)) {
            objs.forEach(obj -> {
                ApproveBillInfo billInfo = result.computeIfAbsent(obj.getLong("id"), k -> new ApproveBillInfo((DynamicObject)obj));
                billInfo.addTemplate(obj.getLong("tempid"));
            });
        }
        return result;
    }

    public static void upSortVal4CentralBill(DynamicObject mainBillObj) {
        if (mainBillObj != null) {
            long mainBillSortVal = mainBillObj.getLong("sortval") - 10000L;
            DynamicObject[] centralBillObjs = ApproveBillHelper.loadCentralBillObj(mainBillObj.getLong("id"), "id,centralorg,sortval,createdate");
            ApproveBillHelper.updateSortVal(centralBillObjs, mainBillSortVal);
        }
    }

    public static void upSortVal4RejectBill(DynamicObject sourceBillObj) {
        if (sourceBillObj != null) {
            long sortVal = sourceBillObj.getLong("sortval") - 10000L;
            QFilter qFilter = new QFilter("parentbillid", "=", (Object)sourceBillObj.getLong("id"));
            qFilter.and("splitbilltype", "=", (Object)CentralBillType.Reject.getNumber());
            DynamicObject[] rejectBills = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,sortval,createdate", (QFilter[])qFilter.toArray());
            ApproveBillHelper.updateSortVal(rejectBills, sortVal);
        }
    }

    private static void updateSortVal(DynamicObject[] approveBills, long sortVal) {
        if (approveBills.length > 0) {
            ArrayList<CentralBillSortInfo> objSortList = new ArrayList<CentralBillSortInfo>(approveBills.length);
            for (DynamicObject obj : approveBills) {
                if (obj == null) continue;
                String billNo = obj.getString("billNo");
                objSortList.add(new CentralBillSortInfo(billNo, obj.getDate("createdate"), obj));
            }
            objSortList.sort(Comparator.comparing(CentralBillSortInfo::getBillNo).thenComparing(CentralBillSortInfo::getCreateDate));
            int max = objSortList.size();
            int seq = 0;
            for (CentralBillSortInfo sortInfo : objSortList) {
                sortInfo.getBillObj().set("sortval", (Object)(sortVal + (long)(max - seq)));
                ++seq;
            }
            SaveServiceHelper.save((DynamicObject[])approveBills);
        }
    }

    public static void setSortVal(DynamicObject billObj) {
        long sortVal = billObj.getLong("sortval");
        if (sortVal == 0L) {
            billObj.set("sortval", (Object)ApproveBillHelper.getSortVal(1)[0]);
        }
    }

    public static Long[] getSortVal(int size) {
        Long[] sortVals = new Long[size];
        Lock.lock(() -> {
            long maxSeq;
            boolean needInsert = false;
            try (DataSet dataSet = DB.queryDataSet((String)"getSortVal", (DBRoute)BgFormConstant.DBROUTE, (String)"select fseq from t_eb_approvebill_sortseq");){
                if (dataSet.hasNext()) {
                    maxSeq = dataSet.next().getLong("fseq");
                } else {
                    needInsert = true;
                    maxSeq = 10000L;
                }
            }
            for (int i = 0; i < size; ++i) {
                sortVals[i] = maxSeq;
                maxSeq += 10000L;
            }
            if (needInsert) {
                DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)"insert into t_eb_approvebill_sortseq(fid,fseq) values(?,?)", (Object[])new Object[]{GlobalIdUtil.genGlobalLongId(), maxSeq});
            } else {
                DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)"update t_eb_approvebill_sortseq set fseq = ?", (Object[])new Object[]{maxSeq});
            }
        }, "approveBillSortVal", 600000L);
        return sortVals;
    }

    public static String getAppBillIdStrFromPage(IFormView formView) {
        Object val;
        String result = null;
        if (formView != null && (val = formView.getFormShowParameter().getCustomParam("taskApproveBill")) != null) {
            result = val.toString();
        }
        return result;
    }

    public static Long getAppBillIdFromPage(IFormView formView) {
        if (formView == null) {
            return 0L;
        }
        String paramStr = formView.getPageCache().get("taskApproveBill");
        if (paramStr == null) {
            paramStr = ApproveBillHelper.getAppBillIdStrFromPage(formView);
        }
        if (paramStr != null) {
            return IDUtils.toLong(paramStr);
        }
        return 0L;
    }

    public static boolean hasCentralBill(Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and("centralbilltype", "=", (Object)CentralBillType.Child.getNumber());
        return QueryServiceHelper.exists((String)"eb_approvebill", (QFilter[])qFilter.toArray());
    }

    public static boolean hasCentralBill(IFormView formView) {
        Long appBillId = ApproveBillHelper.getAppBillIdFromPage(formView);
        return IDUtils.isNotNull(appBillId) && ApproveBillHelper.hasCentralBill(Collections.singletonList(appBillId));
    }

    public static boolean isNormalBill(Long approveBillId) {
        QFilter qFilter = new QFilter("id", "=", (Object)approveBillId);
        qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        return QueryServiceHelper.exists((String)"eb_approvebill", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] loadCentralBillObj(Long mainBillId, String selectProperties) {
        QFilter qFilter = new QFilter("parentbillid", "=", (Object)mainBillId);
        qFilter.and("centralbilltype", "=", (Object)CentralBillType.Child.getNumber());
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)selectProperties, (QFilter[])qFilter.toArray());
        return objs;
    }
}

