/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;

public class BgTaskProcessHelper {
    public static Map<String, Long> getTaskProcessIdSetFromRptProcess(Set<Long> taskListIdSet, Set<Long> reportProcessIdSet, Long modelId) {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CollectionUtils.isEmpty(taskListIdSet) || CollectionUtils.isEmpty(reportProcessIdSet)) {
            return result;
        }
        List<ReportProcess> reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(reportProcessIdSet);
        Map<ReportProcess, ReportProcess> rptProcessMap = ReportProcessServiceImpl.getInstance().convertReportProcessListToCombinationMap(reportProcessList);
        QFilter filter2 = new QFilter("id", "in", taskListIdSet);
        DynamicObjectCollection taskListCollection = QueryServiceHelper.query((String)"eb_tasklist", (String)"id, datatype,version, year", (QFilter[])filter2.toArray());
        HashMap<Long, String> taskListPdvMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : taskListCollection) {
            long id = dynamicObject.getLong("id");
            long datatype = dynamicObject.getLong("datatype");
            long version = dynamicObject.getLong("version");
            long year = dynamicObject.getLong("year");
            String pdvStr = BgTaskProcessHelper.getPdvStr(year, datatype, version);
            taskListPdvMap.put(id, pdvStr);
        }
        QFilter filter = new QFilter("tasklist", "in", taskListIdSet);
        DynamicObjectCollection taskIdList = QueryServiceHelper.query((String)"eb_task", (String)"id,tasklist", (QFilter[])filter.toArray());
        HashMap<Long, Long> taskListIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : taskIdList) {
            long id = dynamicObject.getLong("id");
            long tasklist = dynamicObject.getLong("tasklist");
            taskListIdMap.put(id, tasklist);
        }
        QFilter filter1 = new QFilter("task", "in", taskListIdMap.keySet());
        DynamicObjectCollection taskProcessList = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id, task, org, orgview, template", (QFilter[])filter1.toArray());
        for (DynamicObject dynamicObject : taskProcessList) {
            long id = dynamicObject.getLong("id");
            long task = dynamicObject.getLong("task");
            long org = dynamicObject.getLong("org");
            long template = dynamicObject.getLong("template");
            Long taskListId = (Long)taskListIdMap.get(task);
            String pdvStr = (String)taskListPdvMap.get(taskListId);
            ReportProcess reportProcessKey = ReportProcess.buildReportProcessCombination(modelId, template, org, pdvStr);
            ReportProcess reportProcess = rptProcessMap.get(reportProcessKey);
            if (reportProcess == null) continue;
            result.put(org + "#" + template + "#" + task, id);
        }
        return result;
    }

    private static String getPdvStr(Long year, Long dataType, Long version) {
        return year + "#" + dataType + "#" + version;
    }

    public static boolean loadReportProcessStatus(Long modelId, QFBuilder builder, Map<Long, String> reportProcessStatusMap) {
        String unionKey;
        Long tempId;
        Long versionId;
        Long dataTypeId;
        Long yearId;
        Long orgId;
        if (IDUtils.isNull(modelId) || builder == null || reportProcessStatusMap == null) {
            return true;
        }
        LinkedHashMap tmpMap = Maps.newLinkedHashMap();
        LinkedHashSet taskIdSet = Sets.newLinkedHashSet();
        LinkedHashSet orgSet = Sets.newLinkedHashSet();
        LinkedHashSet yearSet = Sets.newLinkedHashSet();
        LinkedHashSet dtSet = Sets.newLinkedHashSet();
        LinkedHashSet versionSet = Sets.newLinkedHashSet();
        LinkedHashSet tempIdSet = Sets.newLinkedHashSet();
        String selectFields = "id,org.id as orgId,task.id as taskId,task.tasklist.year as yearId,task.tasklist.datatype as dataTypeId,task.tasklist.version as versionId,template";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)selectFields, (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    Long id = row.getLong("id");
                    orgId = row.getLong("orgId");
                    yearId = row.getLong("yearId");
                    dataTypeId = row.getLong("dataTypeId");
                    versionId = row.getLong("versionId");
                    tempId = row.getLong("template");
                    Long taskId = row.getLong("taskId");
                    taskIdSet.add(taskId);
                    tempIdSet.add(tempId);
                    orgSet.add(orgId);
                    yearSet.add(yearId);
                    versionSet.add(versionId);
                    dtSet.add(dataTypeId);
                    unionKey = modelId + "#" + tempId + "#" + orgId + "#" + yearId + "#" + dataTypeId + "#" + versionId + "#" + taskId;
                    tmpMap.put(unionKey, id);
                }
            }
        }
        if (orgSet.isEmpty() || tempIdSet.isEmpty()) {
            return true;
        }
        QFBuilder _builder = new QFBuilder();
        _builder.add("model", "=", modelId);
        _builder.add("period", "in", yearSet);
        _builder.add("version", "in", versionSet);
        _builder.add("datatype", "in", dtSet);
        _builder.and("entity", "in", orgSet);
        _builder.and("template", "in", tempIdSet);
        String reportFields = "status,entity,submitentity.id,datatype.id,period.id,version.id,template.id as templateId";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"loadReportProcessStatus", (String)"eb_reportprocess", (String)reportFields, (QFilter[])_builder.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    String status = row.getString("status");
                    orgId = row.getLong("entity");
                    yearId = row.getLong("period.id");
                    dataTypeId = row.getLong("datatype.id");
                    versionId = row.getLong("version.id");
                    tempId = row.getLong("templateId");
                    for (Long _taskId : taskIdSet) {
                        unionKey = modelId + "#" + tempId + "#" + orgId + "#" + yearId + "#" + dataTypeId + "#" + versionId + "#" + _taskId;
                        Long taskProcessId = (Long)tmpMap.get(unionKey);
                        if (!IDUtils.isNotNull(taskProcessId)) continue;
                        reportProcessStatusMap.put(taskProcessId, status);
                    }
                }
            }
        }
        tmpMap.clear();
        return false;
    }
}

