/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;

public class MemberHelper {
    public static List<Member> getEntityMemberByView(IModelCacheHelper modelCacheHelper, Long viewId, Long entityId, Integer range) {
        return MemberHelper.getEntityMemberByView(modelCacheHelper, viewId, Collections.singleton(entityId), range);
    }

    public static List<Member> getEntityMemberByView(IModelCacheHelper modelCacheHelper, Long viewId, Set<Long> entityIds, Integer range) {
        if (entityIds == null || entityIds.size() == 0) {
            return Collections.emptyList();
        }
        Dimension dimension = modelCacheHelper.getDimension("Entity");
        HashSet memNumSet = new HashSet(1000);
        ArrayList<Member> memberList = new ArrayList<Member>(1000);
        for (Long entityId : entityIds) {
            List<Member> _members;
            Member member = dimension.getMember(viewId, entityId);
            if (member == null || (_members = modelCacheHelper.getMember("Entity", viewId, member.getNumber(), (int)range)) == null) continue;
            _members.forEach(m -> {
                if (memNumSet.add(m.getNumber())) {
                    memberList.add((Member)m);
                }
            });
        }
        return memberList;
    }

    public static Set<Long> getEntityIdSetByView(IModelCacheHelper modelCacheHelper, Long entityViewId, Long entityId, Integer range) {
        HashSet<Long> entityIdSet = new HashSet<Long>(16);
        List<Member> entityMemberByView = MemberHelper.getEntityMemberByView(modelCacheHelper, entityViewId, entityId, range);
        for (Member member : entityMemberByView) {
            entityIdSet.add(member.getId());
        }
        return entityIdSet;
    }
}

