/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.service.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.TaskDispatchSaveSourceEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.entity.request.UpdateRptProcessStatusRequest;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.reportprocess.service.IReportProcessService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessConfig;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class ReportProcessAggService {
    private static final Log log = LogFactory.getLog(ReportProcessAggService.class);
    private static final ReportProcessAggService INSTANCE = new ReportProcessAggService();
    private final IReportProcessService reportProcessService = ReportProcessServiceImpl.getInstance();

    public static ReportProcessAggService getInstance() {
        return INSTANCE;
    }

    private ReportProcessAggService() {
    }

    public void saveReportProcess(@NotNull List<BaseRptProcessRequest> saveRptProcessRequests, Long modelId, ReportProcessConfig config) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(saveRptProcessRequests)) {
            return;
        }
        try (DLock lock = DLock.create((String)("eb/saveReportProcess/" + modelId));){
            boolean isLocked = false;
            try {
                isLocked = lock.tryLock(5000L);
                if (!isLocked) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u5185\u6709\u5176\u4ed6\u65b9\u6848\u6b63\u5728\u4e0b\u8fbe\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportSchemeAssignPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
                Map approveBillMap = Collections.emptyMap();
                Set<Long> readTemplateIds = Collections.emptySet();
                if (config != null) {
                    approveBillMap = config.getApproveBillMap().computeIfAbsent(false, f -> this.getApproveBillMap(modelId, "'B', 'C', 'E'"));
                    readTemplateIds = config.getReadTemplateIds(() -> {
                        Map roTemplates = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("isReadOnly", "=", (Object)Boolean.TRUE)});
                        return IDUtils.toLongs(roTemplates.keySet());
                    });
                }
                HashSet<Long> templateIdSet = new HashSet<Long>(16);
                for (BaseRptProcessRequest saveRptProcessRequest : saveRptProcessRequests) {
                    Set<Long> _templateIdSet = saveRptProcessRequest.getTemplateIdSet();
                    if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(_templateIdSet)) continue;
                    templateIdSet.addAll(_templateIdSet);
                }
                if (readTemplateIds.isEmpty() && !templateIdSet.isEmpty()) {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and("isReadOnly", "=", (Object)Boolean.TRUE);
                    qFilter.and("id", "in", templateIdSet);
                    Map roTemplates = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (roTemplates != null && roTemplates.size() > 0) {
                        readTemplateIds = IDUtils.toLongs(roTemplates.keySet());
                    }
                }
                for (BaseRptProcessRequest saveRptProcessRequest : saveRptProcessRequests) {
                    saveRptProcessRequest.setModelCacheHelper(modelCache);
                    Long periodId = saveRptProcessRequest.getPeriodId();
                    Long dataTypeId = saveRptProcessRequest.getDataTypeId();
                    Long versionId = saveRptProcessRequest.getVersionId();
                    List<ReportProcess> _reportProcess = this.reportProcessService.getReportProcessList(modelId, periodId, dataTypeId, versionId, null, null);
                    Map<ReportProcess, ReportProcess> reportProcessListFromDbMap = this.reportProcessService.convertReportProcessListToCombinationMap(_reportProcess);
                    this.createReportProcessList(reportProcessListFromDbMap, saveRptProcessRequest, config, modelCache, approveBillMap, readTemplateIds);
                }
            }
            catch (Exception ex) {
                log.error("saveReportProcess error:" + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            finally {
                if (config != null) {
                    config.clear();
                }
                if (isLocked) {
                    lock.unlock();
                }
            }
        }
    }

    private void createReportProcessList(Map<ReportProcess, ReportProcess> reportProcessListFromDbMap, BaseRptProcessRequest saveRptProcessRequest, ReportProcessConfig config, IModelCacheHelper modelCache, Map<ReportProcess, Long> approveBillMap, Set<Long> readTemplateIds) {
        Long modelId = saveRptProcessRequest.getModelId();
        Long periodId = saveRptProcessRequest.getPeriodId();
        Long versionId = saveRptProcessRequest.getVersionId();
        Long dataTypeId = saveRptProcessRequest.getDataTypeId();
        Long entityViewId = saveRptProcessRequest.getEntityViewId();
        Map<Long, Set<Long>> templateEntityMap = config != null && config.getTemplateOrgIds() != null ? config.getTemplateOrgIds() : saveRptProcessRequest.getTemplateEntityMap();
        IModelCacheHelper modelCacheHelper = saveRptProcessRequest.getModelCacheHelper();
        List<Member> members = modelCacheHelper.getMembers(entityViewId, SysDimensionEnum.Entity.getNumber());
        List templatePartition = Lists.partition(new ArrayList<Long>(templateEntityMap.keySet()), (int)10);
        CountDownLatch countDownLatch = new CountDownLatch(templatePartition.size());
        for (List templatePart : templatePartition) {
            EpmThreadPools.PROCESS_ASSIGN_POOL.execute(() -> {
                try {
                    HashSet<ReportProcess> reportProcessSet = new HashSet<ReportProcess>(1000);
                    for (Long templateId : templatePart) {
                        Set entityIdSet = (Set)templateEntityMap.get(templateId);
                        int count = entityIdSet.size();
                        long[] ids = GlobalIdUtil.genGlobalLongIds(count);
                        int i = 0;
                        for (Member entity : members) {
                            if (!entityIdSet.contains(entity.getId()) || !saveRptProcessRequest.isHasDisableEntity() && entity.isDisable() || entity.getNumber().endsWith("offsetentry")) continue;
                            ReportProcess reportProcess = new ReportProcess(ids[i++], modelId, entityViewId, templateId, entity.getId(), periodId, dataTypeId, versionId);
                            reportProcessSet.add(reportProcess);
                        }
                    }
                    this.saveReportProcessList(reportProcessListFromDbMap, reportProcessSet, modelCache, approveBillMap, readTemplateIds);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            }, RequestContext.get());
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveReportProcessList(Map<ReportProcess, ReportProcess> reportProcessListFromDbMap, Set<ReportProcess> reportProcessSet, IModelCacheHelper modelCache, Map<ReportProcess, Long> approveBillMap, Set<Long> readTemplateIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(reportProcessSet)) {
            return;
        }
        LinkedList<Object[]> insertParams = new LinkedList<Object[]>();
        LinkedList<Object[]> updateParams = new LinkedList<Object[]>();
        boolean hasApproveBill = approveBillMap.size() > 0;
        long creater = RequestContext.get().getCurrUserId();
        Date createDate = TimeServiceHelper.now();
        HashMap<Long, List<Member>> entityParentMemberMap = new HashMap<Long, List<Member>>(16);
        HashMap<String, Set<Long>> entityIdAndViewMapCache = new HashMap<String, Set<Long>>(16);
        for (ReportProcess reportProcess : reportProcessSet) {
            ReportProcess parentOrgReport;
            ReportProcess fromDbReportProcess = reportProcessListFromDbMap.get(reportProcess.getReportProcessCombination());
            ReportProcess reportProcess2 = parentOrgReport = hasApproveBill ? this.getReportProcess(modelCache, approveBillMap, reportProcessListFromDbMap, reportProcess, reportProcess.getEntityId(), entityParentMemberMap, entityIdAndViewMapCache) : null;
            if (fromDbReportProcess != null) {
                Long approveBillId = approveBillMap.get(fromDbReportProcess.getReportProcessCombination());
                reportProcess.setId(fromDbReportProcess.getId());
                if (!IDUtils.isEmptyLong(approveBillId).booleanValue() || fromDbReportProcess.getStatus().equals(BgTaskStateEnum.UNDERWAY.getNumber()) || fromDbReportProcess.getStatus().equals(BgTaskStateEnum.COMPLETED.getNumber())) continue;
                if (parentOrgReport != null) {
                    reportProcess.setStatus(parentOrgReport.getStatus());
                    reportProcess.setApproveBillId(parentOrgReport.getApproveBillId());
                    reportProcess.setSubmitDate(parentOrgReport.getSubmitDate());
                    reportProcess.setSubmitEntity(parentOrgReport.getSubmitEntity());
                    reportProcess.setSubmitUser(parentOrgReport.getSubmitUser());
                } else if (IDUtils.isNotEmptyLong(fromDbReportProcess.getModifier()).booleanValue()) {
                    reportProcess.setStatus(BgTaskStateEnum.TEMPSAVE.getNumber());
                    reportProcess.setModifier(fromDbReportProcess.getModifier());
                    reportProcess.setModifyDate(fromDbReportProcess.getModifyDate());
                } else {
                    reportProcess.setStatus(BgTaskStateEnum.UNPREPARED.getNumber());
                }
                updateParams.add(reportProcess.getUpdateParams());
                continue;
            }
            if (IDUtils.isEmptyLong(reportProcess.getId()).booleanValue()) {
                reportProcess.setId(GlobalIdUtil.genGlobalLongId());
            }
            if (parentOrgReport != null) {
                reportProcess.setStatus(parentOrgReport.getStatus());
                reportProcess.setApproveBillId(parentOrgReport.getApproveBillId());
                reportProcess.setSubmitDate(parentOrgReport.getSubmitDate());
                reportProcess.setSubmitEntity(parentOrgReport.getSubmitEntity());
                reportProcess.setSubmitUser(parentOrgReport.getSubmitUser());
            }
            if (readTemplateIds.contains(reportProcess.getTemplateId())) {
                reportProcess.setStatus(BgTaskStateEnum.READONLY.getNumber());
            } else if (StringUtils.isEmpty(reportProcess.getStatus())) {
                reportProcess.setStatus(BgTaskStateEnum.UNPREPARED.getNumber());
            }
            Object[] params = reportProcess.getInsertParams(creater, createDate);
            insertParams.add(params);
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(updateParams)) {
            this.reportProcessService.updateReportProcess(updateParams);
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(insertParams)) {
            this.reportProcessService.saveReportProcess(insertParams);
        }
    }

    private ReportProcess getReportProcess(IModelCacheHelper modelCacheHelper, Map<ReportProcess, Long> approveBillMap, Map<ReportProcess, ReportProcess> reportProcessListFromDbMap, ReportProcess reportProcess, Long entityId, Map<Long, List<Member>> entityParentMemberMap, Map<String, Set<Long>> entityIdAndViewMapCache) {
        ReportProcess parentOrgReport = null;
        Long entityViewId = reportProcess.getEntityViewId();
        List parents = entityParentMemberMap.computeIfAbsent(entityId, t -> {
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId);
            if (member != null) {
                return modelCacheHelper.getParents(entityViewId, member, false);
            }
            return new ArrayList(16);
        });
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)parents)) {
            for (Member member : parents) {
                Long approveBillId;
                Long parentId = member.getId();
                ReportProcess parentProcess = new ReportProcess(reportProcess.getModelId(), reportProcess.getTemplateId(), parentId, reportProcess.getPeriodId(), reportProcess.getDataTypeId(), reportProcess.getVersionId());
                parentOrgReport = reportProcessListFromDbMap.get(parentProcess);
                if (parentOrgReport == null || !IDUtils.isNotEmptyLong(approveBillId = approveBillMap.get(parentOrgReport.getReportProcessCombination())).booleanValue()) continue;
                return parentOrgReport;
            }
        }
        if (approveBillMap != null && !approveBillMap.isEmpty()) {
            for (Map.Entry entry : approveBillMap.entrySet()) {
                Long approveBillId;
                ReportProcess parentProcess;
                boolean contains;
                ReportProcess key = (ReportProcess)entry.getKey();
                if (!key.getVersionId().equals(reportProcess.getVersionId()) || !key.getPeriodId().equals(reportProcess.getPeriodId()) || !key.getDataTypeId().equals(reportProcess.getDataTypeId())) continue;
                String cacheKey = key.getEntityViewId() + "_" + key.getEntityId();
                Set<Long> childMember = entityIdAndViewMapCache.get(cacheKey);
                if (childMember == null) {
                    List<Member> member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), key.getEntityViewId(), key.getEntityId(), RangeEnum.ALL_EXCLUDE.getIndex());
                    childMember = org.apache.commons.collections4.CollectionUtils.isNotEmpty(member) ? member.stream().map(BaseCache::getId).collect(Collectors.toSet()) : Collections.emptySet();
                    entityIdAndViewMapCache.put(cacheKey, childMember);
                }
                if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(childMember) || !(contains = childMember.contains(entityId)) || (parentOrgReport = reportProcessListFromDbMap.get(parentProcess = new ReportProcess(reportProcess.getModelId(), reportProcess.getTemplateId(), key.getEntityId(), reportProcess.getPeriodId(), reportProcess.getDataTypeId(), reportProcess.getVersionId()))) == null || !IDUtils.isNotEmptyLong(approveBillId = approveBillMap.get(parentOrgReport.getReportProcessCombination())).booleanValue()) continue;
                return parentOrgReport;
            }
        }
        return parentOrgReport;
    }

    public void updateReportProcessStatus(@NotNull UpdateRptProcessStatusRequest updateRptProcessStatusRequest) {
        this.reportProcessService.updateReportProcessStatus(updateRptProcessStatusRequest);
    }

    public void updateReportProcessStatus(@NotNull List<UpdateRptProcessStatusRequest> updateRptProcessStatusRequestList) {
        this.reportProcessService.updateReportProcessStatus(updateRptProcessStatusRequestList);
    }

    public void deleteReportProcess(@NotNull List<BaseRptProcessRequest> deleteRptProcessRequests, Long modelId) {
        String traceId = RequestContext.get().getTraceId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        List<DynamicObject> taskList = this.getTaskList(modelId, deleteRptProcessRequests);
        Map<Long, Set<String>> allSchemePdvMap = this.getSchemePdvMap(modelId, deleteRptProcessRequests);
        for (BaseRptProcessRequest rptProcessRequest : deleteRptProcessRequests) {
            HashSet periodIds = Sets.newHashSet((Object[])new Long[]{rptProcessRequest.getPeriodId()});
            HashSet dataTypeIds = Sets.newHashSet((Object[])new Long[]{rptProcessRequest.getDataTypeId()});
            HashSet versionIds = Sets.newHashSet((Object[])new Long[]{rptProcessRequest.getVersionId()});
            HashSet entityIdSet = Sets.newHashSet(rptProcessRequest.getEntityIdSet());
            HashSet allTemplateIdSet = Sets.newHashSet(rptProcessRequest.getTemplateIdSet());
            LinkedHashMap<Long, Set<String>> schemePdvMap = new LinkedHashMap<Long, Set<String>>(allSchemePdvMap);
            if (IDUtils.isNotEmptyLong(rptProcessRequest.getSchemeId()).booleanValue() && BaseRptProcessRequest.CancelType.UNALLOC != rptProcessRequest.getCancelType()) {
                schemePdvMap.remove(rptProcessRequest.getSchemeId());
            }
            log.info("deleteReportProcess modelId:{} entitySize:{} templateSize:{}", new Object[]{modelId, entityIdSet.size(), allTemplateIdSet.size()});
            List partition = Lists.partition(new ArrayList(allTemplateIdSet), (int)20);
            CountDownLatch countDownLatch = new CountDownLatch(partition.size());
            AtomicInteger batchCount = new AtomicInteger(0);
            for (List subTemplateIds : partition) {
                EpmThreadPools.PROCESS_CANCEL_POOL.execute(() -> {
                    try {
                        List<ReportProcess> onlyOneQuoteReportProcessList;
                        List<ReportProcess> notApproveBillProcessList;
                        HashSet templateIdSet = Sets.newHashSet((Iterable)subTemplateIds);
                        log.info("deleteReportProcess trace:{} batch:{} template:{}", new Object[]{traceId, batchCount.incrementAndGet(), templateIdSet});
                        Map<Long, Set<Long>> templateEntityMap = rptProcessRequest.getTemplateEntityMap(templateIdSet);
                        ImmutableMap pdvStrTemplateEntityMap = ImmutableMap.of((Object)rptProcessRequest.getPdvStr(), templateEntityMap);
                        Map<ReportProcess, Integer> wantToDeleteMap = this.reportProcessService.queryReportProcess(modelId, periodIds, dataTypeIds, versionIds, entityIdSet, templateIdSet, (Map<String, Map<Long, Set<Long>>>)pdvStrTemplateEntityMap);
                        log.info("deleteReportProcess trace:{} batch:{} processSize:{}", new Object[]{traceId, batchCount.incrementAndGet(), wantToDeleteMap.size()});
                        if (MapUtils.isEmpty(wantToDeleteMap)) {
                            return;
                        }
                        if (IDUtils.isNotEmptyLong(rptProcessRequest.getSchemeId()).booleanValue() && BaseRptProcessRequest.CancelType.UNALLOC != rptProcessRequest.getCancelType()) {
                            wantToDeleteMap.forEach((k, v) -> wantToDeleteMap.put((ReportProcess)k, 1));
                        }
                        Map<ReportProcess, Integer> targetNumber = Collections.emptyMap();
                        if (rptProcessRequest.getCancelType() != null && (rptProcessRequest.getCancelType() == BaseRptProcessRequest.CancelType.SCHEME || rptProcessRequest.getCancelType() == BaseRptProcessRequest.CancelType.UNALLOC)) {
                            targetNumber = this.createTargetNumber(rptProcessRequest, modelCache, templateIdSet);
                        }
                        if (org.apache.commons.collections4.CollectionUtils.isEmpty(notApproveBillProcessList = this.filterApproveBill(onlyOneQuoteReportProcessList = this.filterReportProcessQuote(modelId, entityIdSet, taskList, schemePdvMap, wantToDeleteMap, templateIdSet, targetNumber), modelId))) {
                            return;
                        }
                        Set<Long> collect = notApproveBillProcessList.stream().map(ReportProcess::getId).collect(Collectors.toSet());
                        log.info("deleteReportProcess trace:{} batch:{} deleteSize:{}", new Object[]{traceId, batchCount.incrementAndGet(), collect.size()});
                        this.reportProcessService.deleteReportProcess(collect);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }, RequestContext.get());
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<ReportProcess> filterReportProcessQuote(Long modelId, Set<Long> entityIdSet, List<DynamicObject> taskList, Map<Long, Set<String>> schemePdvMap, Map<ReportProcess, Integer> wantToDeleteMap, Set<Long> templateIdSet, Map<ReportProcess, Integer> targetNumber) {
        Map<ReportProcess, Integer> filterTaskProcessList = this.filterQuoteFromTask(modelId, taskList, wantToDeleteMap, entityIdSet, templateIdSet);
        Map<ReportProcess, Integer> filterAssignProcessList = this.filterQuoteFromSchemeAssign(modelId, entityIdSet, schemePdvMap, filterTaskProcessList, templateIdSet, targetNumber);
        return this.filterMatchQuoteProcess(filterAssignProcessList);
    }

    private List<ReportProcess> filterMatchQuoteProcess(Map<ReportProcess, Integer> map) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        map.forEach((k, v) -> {
            if (v < 2) {
                result.add((ReportProcess)k);
            }
        });
        return result;
    }

    public List<ReportProcess> filterApproveBill(List<ReportProcess> wantToDeleteList, Long modelId) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        Map<ReportProcess, Long> approveBillMap = this.getApproveBillMap(modelId, "'B','C','E'");
        if (approveBillMap.size() == 0) {
            return wantToDeleteList;
        }
        for (ReportProcess reportProcess : wantToDeleteList) {
            Long approveBillId;
            if (IDUtils.isNotEmptyLong(reportProcess.getApproveBillId()).booleanValue() || IDUtils.isNotEmptyLong(approveBillId = approveBillMap.get(reportProcess.getReportProcessCombination())).booleanValue()) continue;
            result.add(reportProcess);
        }
        return result;
    }

    private Map<ReportProcess, Long> getApproveBillMap(Long modelId, String billStatusFilter) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        String sql = "select a.fid, a.fdimperiodnew, a.fdimdatatype, a.fdimversionnew, a.feborgid, a.forgviewid,b.ftempid from t_eb_approvebill a, t_eb_approvebillentry b where a.fid = b.fid and a.fmodelid = ?";
        if (StringUtils.isNotEmpty(billStatusFilter)) {
            sql = "select a.fid, a.fdimperiodnew, a.fdimdatatype, a.fdimversionnew, a.feborgid,a.forgviewid, b.ftempid from t_eb_approvebill a, t_eb_approvebillentry b where a.fid = b.fid and a.fmodelid = ? and fbillstatus in (" + billStatusFilter + ")";
        }
        sqlBuilder.append(sql, new Object[]{modelId});
        LinkedHashMap<ReportProcess, Long> approveBillMap = new LinkedHashMap<ReportProcess, Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"getAllApproveBill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            for (Row next : dataSet) {
                Long approveBillId = next.getLong("fid");
                Long periodId = next.getLong("fdimperiodnew");
                Long dataTypeId = next.getLong("fdimdatatype");
                Long versionId = next.getLong("fdimversionnew");
                Long entityId = next.getLong("feborgid");
                Long templateId = next.getLong("ftempid");
                ReportProcess rptCombinationStr = this.getRptCombinationStr(modelId, templateId, entityId, periodId, dataTypeId, versionId);
                rptCombinationStr.setEntityViewId(next.getLong("forgviewid"));
                approveBillMap.put(rptCombinationStr, approveBillId);
            }
        }
        return approveBillMap;
    }

    private ReportProcess getRptCombinationStr(Long modelId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId) {
        return ReportProcess.buildReportProcessCombination(modelId, templateId, entityId, periodId, dataTypeId, versionId);
    }

    private Map<ReportProcess, Integer> filterQuoteFromSchemeAssign(Long modelId, Set<Long> filterEntityIdSet, Map<Long, Set<String>> schemePdvMap, Map<ReportProcess, Integer> wantToDeleteList, Set<Long> templateIdSet, Map<ReportProcess, Integer> targetNumber) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Map<ReportProcess, Integer> result = new HashMap<ReportProcess, Integer>(16);
        if (wantToDeleteList.isEmpty()) {
            return result;
        }
        if (MapUtils.isEmpty(schemePdvMap)) {
            return wantToDeleteList;
        }
        Set<Long> schemeIdSet = schemePdvMap.keySet();
        Map<Long, Long> schemeOrgViewMap = this.getSchemeOrgViewMap(schemeIdSet);
        DynamicObjectCollection templateOrgListBySchemeIdSet = this.getTemplateOrgListBySchemeIdSet(schemeIdSet, templateIdSet);
        LinkedHashMap<ReportProcess, Set<Long>> pdvStrIdMap = new LinkedHashMap<ReportProcess, Set<Long>>();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)templateOrgListBySchemeIdSet)) {
            return result;
        }
        List<Object> recordIdList = templateOrgListBySchemeIdSet.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map<Long, Set<Long>> recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
        for (DynamicObject dynamicObject : templateOrgListBySchemeIdSet) {
            long id = dynamicObject.getLong("id");
            long scheme = dynamicObject.getLong("scheme.id");
            Long orgViewId = schemeOrgViewMap.get(scheme);
            Set<String> pdvStrSet = schemePdvMap.get(scheme);
            long template = dynamicObject.getLong("template.id");
            long org = dynamicObject.getLong("org.id");
            int orgrange = dynamicObject.getInt("orgrange");
            Set<Long> entityRange = MemberHelper.getEntityIdSetByView(modelCacheHelper, orgViewId, org, orgrange);
            Sets.SetView entityIdSet = Sets.intersection(filterEntityIdSet, entityRange);
            Set<Long> deleteEntity = recordDeleteEntity.get(id);
            for (String pdvStr : pdvStrSet) {
                for (Long entityId : entityIdSet) {
                    if (deleteEntity != null && deleteEntity.contains(entityId)) continue;
                    ReportProcess reportKey = this.getRptProcessCombinationStr(modelId, template, entityId, pdvStr);
                    Set templateOrgId = pdvStrIdMap.computeIfAbsent(reportKey, t -> new HashSet(16));
                    templateOrgId.add(id);
                }
            }
        }
        result = this.calcProcessQuote(pdvStrIdMap, wantToDeleteList, targetNumber);
        return result;
    }

    private Map<ReportProcess, Integer> calcProcessQuote(Map<ReportProcess, Set<Long>> pdvStrIdMap, Map<ReportProcess, Integer> wantToDeleteList, Map<ReportProcess, Integer> targetNumber) {
        if (MapUtils.isEmpty(pdvStrIdMap)) {
            return wantToDeleteList;
        }
        wantToDeleteList.forEach((k, v) -> {
            Set processIdSet = (Set)pdvStrIdMap.get(k);
            if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)processIdSet)) {
                return;
            }
            if (MapUtils.isEmpty((Map)targetNumber)) {
                wantToDeleteList.put((ReportProcess)k, (Integer)wantToDeleteList.get(k) + processIdSet.size());
            } else {
                Integer count = (Integer)targetNumber.get(k);
                if (count != null && count.intValue() == processIdSet.size()) {
                    wantToDeleteList.put((ReportProcess)k, (Integer)wantToDeleteList.get(k) + 1);
                } else {
                    wantToDeleteList.put((ReportProcess)k, (Integer)wantToDeleteList.get(k) + processIdSet.size());
                }
            }
        });
        return wantToDeleteList;
    }

    private Map<ReportProcess, Integer> createTargetNumber(BaseRptProcessRequest request, IModelCacheHelper modelCache, Set<Long> filterTemplateSet) {
        HashMap<ReportProcess, Integer> result = new HashMap<ReportProcess, Integer>(1000);
        Long modelId = modelCache.getModelobj().getId();
        Long version = request.getVersionId();
        Long datatype = request.getDataTypeId();
        Long period = request.getPeriodId();
        for (TemplateEntityDto templateEntityDto : request.getTemplateEntityDtoList()) {
            Long templateId = templateEntityDto.getTemplateId();
            if (!filterTemplateSet.contains(templateId)) continue;
            Set<Long> entityIdSet = MemberHelper.getEntityIdSetByView(modelCache, request.getEntityViewId(), templateEntityDto.getEntityId(), templateEntityDto.getEntityRange());
            for (Long entityId : entityIdSet) {
                ReportProcess reportProcess = ReportProcess.buildReportProcessCombination(modelId, templateId, entityId, period, datatype, version);
                result.merge(reportProcess, 1, Integer::sum);
            }
        }
        return result;
    }

    private Map<Long, Long> getSchemeOrgViewMap(Set<Long> schemeIdSet) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("id", "in", schemeIdSet);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_rptscheme", (String)"id, orgview", (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : query) {
            long id = dynamicObject.getLong("id");
            long orgview = dynamicObject.getLong("orgview");
            result.put(id, orgview);
        }
        return result;
    }

    private DynamicObjectCollection getTemplateOrgListBySchemeIdSet(Set<Long> schemeIdSet, Set<Long> templateIdSet) {
        QFilter filter = new QFilter("scheme", "in", schemeIdSet);
        filter.and("template", "in", templateIdSet);
        return QueryServiceHelper.query((String)"eb_templateorg", (String)"id, template.id, org.id, scheme.id, orgrange", (QFilter[])filter.toArray());
    }

    private Map<Long, Set<String>> getSchemePdvMap(Long modelId, List<BaseRptProcessRequest> deleteRptProcessRequests) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(deleteRptProcessRequests)) {
            return Collections.emptyMap();
        }
        HashSet<String> pdvStrSet = new HashSet<String>(16);
        for (BaseRptProcessRequest deleteRptProcessRequest : deleteRptProcessRequests) {
            pdvStrSet.add(deleteRptProcessRequest.getPdvStr());
        }
        ArrayList<DynamicObject> schemeAssignList = new ArrayList<DynamicObject>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id, year, datatype, version, scheme", (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : query) {
            String str = this.getPdvStr(dynamicObject);
            if (!pdvStrSet.contains(str)) continue;
            schemeAssignList.add(dynamicObject);
        }
        HashMap<Long, Set<String>> schemePdvStrMap = new HashMap<Long, Set<String>>(schemeAssignList.size());
        for (DynamicObject dynamicObject : schemeAssignList) {
            long scheme = dynamicObject.getLong("scheme");
            String pdvStr = this.getPdvStr(dynamicObject);
            Set set = schemePdvStrMap.computeIfAbsent(scheme, t -> new HashSet(16));
            set.add(pdvStr);
        }
        return schemePdvStrMap;
    }

    private String getPdvStr(DynamicObject dynamicObject) {
        long year = dynamicObject.getLong("year");
        long datatype = dynamicObject.getLong("datatype");
        long version = dynamicObject.getLong("version");
        return year + "#" + datatype + "#" + version;
    }

    private Map<ReportProcess, Integer> filterQuoteFromTask(Long modelId, List<DynamicObject> taskList, Map<ReportProcess, Integer> wantToDeleteList, Set<Long> filterEntityIdSet, Set<Long> templateIdSet) {
        Map<ReportProcess, Integer> result = new HashMap<ReportProcess, Integer>(16);
        if (wantToDeleteList.isEmpty()) {
            return result;
        }
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(taskList)) {
            return wantToDeleteList;
        }
        HashSet<Long> taskListIdSet = new HashSet<Long>(16);
        HashMap<Long, String> taskListPdvStrMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : taskList) {
            long id = dynamicObject.getLong("id");
            taskListIdSet.add(id);
            taskListPdvStrMap.put(id, this.getPdvStr(dynamicObject));
        }
        DynamicObjectCollection tasks = this.getTasks(taskListIdSet);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)tasks)) {
            return wantToDeleteList;
        }
        HashSet<Long> taskIdSet = new HashSet<Long>(16);
        HashMap taskPdvMap = new HashMap(16);
        for (DynamicObject task : tasks) {
            long tasklist = task.getLong("tasklist");
            long id = task.getLong("id");
            taskIdSet.add(id);
            taskPdvMap.put(id, taskListPdvStrMap.get(tasklist));
        }
        QFilter qFilter = new QFilter("taskid", "in", taskIdSet);
        qFilter.and("taskstatus", "=", (Object)"1");
        qFilter.and("distorg", "in", filterEntityIdSet);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"task, taskid, sourcetype,distorg", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> taskTaskListMap = new HashMap<Long, Long>(16);
        HashMap<Long, Map> taskListTaskMap = new HashMap<Long, Map>(16);
        HashSet<Long> toQueryTaskIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : query) {
            toQueryTaskIds.add(dynamicObject.getLong("taskid"));
            String sourcetype = dynamicObject.getString("sourcetype");
            taskTaskListMap.put(dynamicObject.getLong("taskid"), dynamicObject.getLong("task"));
            if (!TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue().equals(sourcetype)) continue;
            Map taskOrgMap = taskListTaskMap.computeIfAbsent(dynamicObject.getLong("task"), t -> new HashMap(16));
            Set longs = taskOrgMap.computeIfAbsent(dynamicObject.getLong("taskid"), v -> new HashSet(16));
            longs.add(dynamicObject.getLong("distorg"));
        }
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(toQueryTaskIds)) {
            return wantToDeleteList;
        }
        HashMap<Long, Set> taskTimes = new HashMap<Long, Set>(16);
        HashMap<ReportProcess, Set<Long>> rptProcessCombinationQuoteMap = new HashMap<ReportProcess, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, ftaskid, forgid, ftemplateid from t_eb_taskprocess where ", new Object[0]);
        sqlBuilder.appendIn("ftaskid", toQueryTaskIds.toArray());
        sqlBuilder.appendIn(" and ftemplateid", templateIdSet.toArray());
        HashSet<String> hasPutTaskIds = new HashSet<String>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"queryTaskProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long forgid = next.getLong("forgid");
                Long taskProcessId = next.getLong("fid");
                Long ftaskid = next.getLong("ftaskid");
                Long ftemplateid = next.getLong("ftemplateid");
                Long _taskListId = (Long)taskTaskListMap.get(ftaskid);
                Map taskOrgMap = (Map)taskListTaskMap.get(_taskListId);
                if (taskOrgMap != null && taskOrgMap.get(ftaskid) != null && ((Set)taskOrgMap.get(ftaskid)).contains(forgid) && !hasPutTaskIds.add(_taskListId + "_" + ftemplateid + "_" + forgid)) continue;
                ReportProcess reportKey = this.getRptProcessCombinationStr(modelId, ftemplateid, forgid, (String)taskPdvMap.get(ftaskid));
                Set taskProcessIdSet = rptProcessCombinationQuoteMap.computeIfAbsent(reportKey, t -> new HashSet(16));
                String strTemplateAndOrg = ftemplateid + "#" + forgid;
                if (taskTimes.containsKey(ftaskid) && ((Set)taskTimes.get(ftaskid)).contains(strTemplateAndOrg)) continue;
                Set set = taskTimes.computeIfAbsent(ftaskid, v -> new HashSet(16));
                set.add(strTemplateAndOrg);
                taskProcessIdSet.add(taskProcessId);
            }
        }
        result = this.calcProcessQuote(rptProcessCombinationQuoteMap, wantToDeleteList, Collections.emptyMap());
        return result;
    }

    private ReportProcess getRptProcessCombinationStr(Long modelId, Long templateId, Long orgId, String pdvStr) {
        return ReportProcess.buildReportProcessCombination(modelId, templateId, orgId, pdvStr);
    }

    private DynamicObjectCollection getTasks(Set<Long> taskListIdSet) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(taskListIdSet)) {
            return result;
        }
        QFilter filter = new QFilter("tasklist", "in", taskListIdSet);
        return QueryServiceHelper.query((String)"eb_task", (String)"id, tasklist", (QFilter[])filter.toArray());
    }

    private List<DynamicObject> getTaskList(Long modelId, List<BaseRptProcessRequest> deleteRptProcessRequests) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(deleteRptProcessRequests)) {
            return result;
        }
        HashSet<String> pdvStrSet = new HashSet<String>(16);
        for (BaseRptProcessRequest deleteRptProcessRequest : deleteRptProcessRequests) {
            pdvStrSet.add(deleteRptProcessRequest.getPdvStr());
        }
        QFilter taskListFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection taskListObjs = QueryServiceHelper.query((String)"eb_tasklist", (String)"id, year, datatype, version", (QFilter[])taskListFilter.toArray());
        for (DynamicObject taskListObj : taskListObjs) {
            String str = this.getPdvStr(taskListObj);
            if (!pdvStrSet.contains(str)) continue;
            result.add(taskListObj);
        }
        return result;
    }

    public List<ReportProcess> getReportProcessList(Long modelId) {
        return this.reportProcessService.getReportProcessList(modelId);
    }

    public List<ReportProcess> getReportProcessList(Long modelId, Long entityId) {
        return this.reportProcessService.getReportProcessList(modelId, entityId);
    }

    public List<ReportProcess> getReportProcessList(Long modelId, Set<Long> entityIdSet) {
        return this.reportProcessService.getReportProcessList(modelId, entityIdSet);
    }

    public List<ReportProcess> getReportProcessList(@NotNull BaseRptProcessRequest queryRptProcessRequest) {
        return this.reportProcessService.getReportProcessList(queryRptProcessRequest.toList());
    }

    public List<ReportProcess> getReportProcessList(@NotNull List<BaseRptProcessRequest> queryRptProcessRequestList) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(queryRptProcessRequestList)) {
            return result;
        }
        return this.reportProcessService.getReportProcessList(queryRptProcessRequestList);
    }

    public List<ReportProcess> getReportProcessListWithOtherMsg(@NotNull List<BaseRptProcessRequest> queryRptProcessRequestList) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(queryRptProcessRequestList)) {
            return result;
        }
        log.info("getReportProcessListWithOtherMsg start className:" + this.reportProcessService.getClass().getName() + "," + org.apache.commons.collections4.CollectionUtils.isEmpty(queryRptProcessRequestList));
        return this.reportProcessService.getReportProcessListWithOtherMsg(queryRptProcessRequestList);
    }

    public Map<ReportProcess, ReportProcess> convertReportProcessListToCombinationMap(List<ReportProcess> reportProcesses) {
        return this.reportProcessService.convertReportProcessListToCombinationMap(reportProcesses);
    }

    private DataSet queryHasApproveReportProcessList(SqlBuilder sqlBuilder) {
        return DB.queryDataSet((String)"queryHasApproveReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public boolean checkRequestHasApproveBill(List<BaseRptProcessRequest> deleteRptProcessRequest, Long modelId) {
        Set<TemplateEntityDto> templateEntityDtosWithApproveBill = this.checkRequestHasApproveBill(deleteRptProcessRequest, modelId, true);
        return templateEntityDtosWithApproveBill != null && templateEntityDtosWithApproveBill.size() > 0;
    }

    public Set<TemplateEntityDto> checkRequestHasApproveBill(List<BaseRptProcessRequest> deleteRptProcessRequest, Long modelId, boolean quickReturn) {
        HashSet<TemplateEntityDto> templateEntityDtosWithApproveBill = new HashSet<TemplateEntityDto>(16);
        for (BaseRptProcessRequest baseRptProcessRequest : deleteRptProcessRequest) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            Long periodId = baseRptProcessRequest.getPeriodId();
            Long dataTypeId = baseRptProcessRequest.getDataTypeId();
            Long versionId = baseRptProcessRequest.getVersionId();
            Set<Long> templateIdSet = baseRptProcessRequest.getTemplateIdSet();
            Object[] param = new Object[]{modelId, periodId, dataTypeId, versionId};
            sqlBuilder.append("select fapprovebill,ftemplate, fentity from t_eb_reportprocess where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? ", param);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(templateIdSet)) {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn("ftemplate", templateIdSet.toArray());
            }
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fstatus", (Object[])new String[]{BgTaskStateEnum.UNDERWAY.getNumber(), BgTaskStateEnum.COMPLETED.getNumber()});
            Map<TemplateEntityDto, Set<Long>> templateDtoEntityMap = baseRptProcessRequest.getTemplateDtoEntityMap();
            HashSet<TemplateEntityDto> toCheck = new HashSet<TemplateEntityDto>(16);
            HashMap<String, Set<Long>> entityRangeCache = new HashMap<String, Set<Long>>(16);
            if (templateDtoEntityMap != null) {
                templateDtoEntityMap.forEach((k, v) -> {
                    toCheck.add((TemplateEntityDto)k);
                    String entityCacheKey = k.getEntityId() + "_" + k.getEntityRange() + "_" + k.hashCode();
                    if (!entityRangeCache.containsKey(entityCacheKey)) {
                        entityRangeCache.put(entityCacheKey, (Set<Long>)v);
                    }
                });
            }
            DataSet dataSet = this.queryHasApproveReportProcessList(sqlBuilder);
            Throwable throwable = null;
            try {
                Long entityId;
                Row next;
                Long templateId;
                boolean allChecked;
                while (!(!dataSet.hasNext() || (allChecked = ReportProcessUtil.checkTemplateEntityDto(templateId = (next = dataSet.next()).getLong("ftemplate"), entityId = next.getLong("fentity"), toCheck, templateEntityDtosWithApproveBill, entityRangeCache)) || quickReturn && templateEntityDtosWithApproveBill.size() > 0)) {
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return templateEntityDtosWithApproveBill;
    }

    private DynamicObjectCollection queryTemplateOrgRecord(Set<Long> schemeIdSet) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(schemeIdSet)) {
            return null;
        }
        QFilter qFilter = new QFilter("scheme", "in", schemeIdSet);
        qFilter.and(new QFilter("templatetype", "=", (Object)"0").or(new QFilter("templatetype", "=", (Object)" ")));
        return QueryServiceHelper.query((String)"eb_templateorg", (String)"id,scheme.id,template.id,org.id,orgrange", (QFilter[])new QFilter[]{qFilter});
    }

    public void createReportProcessBySchemeAssign(Long modelId, Set<Long> schemeAssignIdSet) {
        DynamicObjectCollection schemeAssignList = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id, scheme, scheme.name, scheme.orgview, year, version, datatype", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeAssignIdSet)});
        HashMap<Long, Long> schemeViewMap = new HashMap<Long, Long>(16);
        HashMap<Long, Set> schemeAssignMap = new HashMap<Long, Set>(16);
        HashMap<Long, Triple> assignPdvMap = new HashMap<Long, Triple>(16);
        HashMap<Long, DynamicObject> schemeDynamicObjectMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : schemeAssignList) {
            long scheme = dynamicObject.getLong("scheme");
            long orgViewId = dynamicObject.getLong("scheme.orgview");
            long assignId = dynamicObject.getLong("id");
            long l = dynamicObject.getLong("year");
            long versionId = dynamicObject.getLong("version");
            long dataTypeId = dynamicObject.getLong("datatype");
            assignPdvMap.put(assignId, Triple.of((Object)l, (Object)dataTypeId, (Object)versionId));
            schemeViewMap.put(scheme, orgViewId);
            Set longs = schemeAssignMap.computeIfAbsent(assignId, t -> new HashSet(16));
            longs.add(scheme);
            schemeDynamicObjectMap.put(scheme, dynamicObject);
        }
        HashMap<Long, List> schemeTemplateEntityDtoListMap = new HashMap<Long, List>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        DynamicObjectCollection dynamicObjects = this.queryTemplateOrgRecord(schemeViewMap.keySet());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            List<Object> recordIdList = dynamicObjects.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            Map<Long, Set<Long>> recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long l = dynamicObject.getLong("template.id");
                Long l2 = dynamicObject.getLong("org.id");
                Long schemeid = dynamicObject.getLong("scheme.id");
                Integer orgrange = dynamicObject.getInt("orgrange");
                Long viewId = (Long)schemeViewMap.get(schemeid);
                if (IDUtils.isEmptyLong(l).booleanValue() || IDUtils.isEmptyLong(l2).booleanValue() || IDUtils.isEmptyLong(viewId).booleanValue()) continue;
                TemplateEntityDto templateEntityDto = new TemplateEntityDto(l, l2, orgrange);
                templateEntityDto.setDeleteEntity(recordDeleteEntity.get(dynamicObject.getLong("id")));
                List templateEntityDtoList = schemeTemplateEntityDtoListMap.computeIfAbsent(schemeid, t -> new ArrayList(16));
                templateEntityDtoList.add(templateEntityDto);
            }
        }
        LinkedHashMap<Long, Set<Long>> templateOrgIds = new LinkedHashMap<Long, Set<Long>>();
        for (Map.Entry entry : schemeTemplateEntityDtoListMap.entrySet()) {
            Long l = (Long)entry.getKey();
            Long viewId = (Long)schemeViewMap.get(l);
            List shcemeEntityList = (List)entry.getValue();
            ArrayList<String> msgs = new ArrayList<String>(shcemeEntityList.size());
            LinkedHashSet<Member> memberSet = new LinkedHashSet<Member>();
            for (TemplateEntityDto templateEntityDto : shcemeEntityList) {
                List<Member> members = MemberHelper.getEntityMemberByView(modelCache, viewId, templateEntityDto.getEntityId(), templateEntityDto.getEntityRange());
                if (members.isEmpty()) {
                    Member member = modelCache.getMember("Entity", viewId, templateEntityDto.getEntityId());
                    RangeEnum range = RangeEnum.getRangeByVal(templateEntityDto.getEntityRange());
                    if (member != null) {
                        msgs.add(ResManager.loadResFormat((String)"\"%1\"\u7ec4\u7ec7\"%2\"\u6ca1\u6709\u542f\u7528\u7684\u6210\u5458", (String)"ReportSchemeAssignPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{member.getName(), range.getName()}));
                    }
                }
                Set children = templateOrgIds.computeIfAbsent(templateEntityDto.getTemplateId(), f -> Sets.newLinkedHashSet());
                for (Member member1 : members) {
                    if (member1.isDisable()) continue;
                    Set<Long> deleteEntity = templateEntityDto.getDeleteEntity();
                    if (CollectionUtils.isNotEmpty(deleteEntity)) {
                        if (deleteEntity.contains(member1.getId())) continue;
                        memberSet.add(member1);
                        children.add(member1.getId());
                        continue;
                    }
                    memberSet.add(member1);
                    children.add(member1.getId());
                }
            }
            if (!org.apache.commons.collections4.CollectionUtils.isEmpty(memberSet)) continue;
            msgs.add(ResManager.loadResFormat((String)"\u65b9\u6848%1\u6ca1\u6709\u542f\u7528\u7684\u7ec4\u7ec7\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u3002", (String)"ReportSchemeAssignPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{((DynamicObject)schemeDynamicObjectMap.get(l)).getString("scheme.name")}));
            throw new KDBizException(StringUtils.join(msgs, ','));
        }
        ArrayList<BaseRptProcessRequest> saveRptProcessRequestList = new ArrayList<BaseRptProcessRequest>(16);
        for (Map.Entry entry : assignPdvMap.entrySet()) {
            Long assignId = (Long)entry.getKey();
            Triple pdv = (Triple)entry.getValue();
            Set schemeIdSet = (Set)schemeAssignMap.get(assignId);
            for (Long schemeId : schemeIdSet) {
                Long viewId = (Long)schemeViewMap.get(schemeId);
                List templateEntityDtoList = (List)schemeTemplateEntityDtoListMap.get(schemeId);
                if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)templateEntityDtoList)) continue;
                BaseRptProcessRequest saveRptProcessRequest = new BaseRptProcessRequest(modelId, viewId, (Long)pdv.getLeft(), (Long)pdv.getMiddle(), (Long)pdv.getRight(), templateEntityDtoList);
                saveRptProcessRequestList.add(saveRptProcessRequest);
            }
        }
        ReportProcessConfig reportProcessConfig = new ReportProcessConfig();
        reportProcessConfig.setTemplateOrgIds(templateOrgIds);
        this.saveReportProcess(saveRptProcessRequestList, modelId, reportProcessConfig);
    }

    public List<BaseRptProcessRequest> createDeleteRptProcessRequest(Long viewId, Long modelId, List<Triple<Long, Long, Long>> pdvTripleList, List<Triple<Long, Long, Integer>> needUnAllocate) {
        ArrayList<BaseRptProcessRequest> result = new ArrayList<BaseRptProcessRequest>(16);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(pdvTripleList) || org.apache.commons.collections.CollectionUtils.isEmpty(needUnAllocate)) {
            return result;
        }
        ArrayList<BaseRptProcessRequest> deleteRptProcessRequests = new ArrayList<BaseRptProcessRequest>(16);
        for (Triple<Long, Long, Long> pdvTriple : pdvTripleList) {
            Long periodId = (Long)pdvTriple.getLeft();
            Long dataTypeId = (Long)pdvTriple.getMiddle();
            Long versionId = (Long)pdvTriple.getRight();
            ArrayList<TemplateEntityDto> templateEntityDtos = new ArrayList<TemplateEntityDto>(16);
            for (Triple<Long, Long, Integer> triple : needUnAllocate) {
                Long templateId = (Long)triple.getLeft();
                Long entityId = (Long)triple.getMiddle();
                Integer entityRange = (Integer)triple.getRight();
                TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, entityId, entityRange);
                templateEntityDtos.add(templateEntityDto);
            }
            BaseRptProcessRequest deleteRptProcessRequest = new BaseRptProcessRequest(modelId, viewId, periodId, dataTypeId, versionId, templateEntityDtos);
            deleteRptProcessRequests.add(deleteRptProcessRequest);
        }
        return deleteRptProcessRequests;
    }

    public List<BaseRptProcessRequest> createDeleteRptProcessRequestV2(Long viewId, Long modelId, List<Triple<Long, Long, Long>> pdvTripleList, List<TemplateEntityDto> needUnAllocate) {
        ArrayList<BaseRptProcessRequest> result = new ArrayList<BaseRptProcessRequest>(16);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(pdvTripleList) || org.apache.commons.collections.CollectionUtils.isEmpty(needUnAllocate)) {
            return result;
        }
        ArrayList<BaseRptProcessRequest> deleteRptProcessRequests = new ArrayList<BaseRptProcessRequest>(16);
        for (Triple<Long, Long, Long> pdvTriple : pdvTripleList) {
            Long periodId = (Long)pdvTriple.getLeft();
            Long dataTypeId = (Long)pdvTriple.getMiddle();
            Long versionId = (Long)pdvTriple.getRight();
            BaseRptProcessRequest deleteRptProcessRequest = new BaseRptProcessRequest(modelId, viewId, periodId, dataTypeId, versionId, needUnAllocate);
            deleteRptProcessRequest.setCancelType(BaseRptProcessRequest.CancelType.UNALLOC);
            deleteRptProcessRequests.add(deleteRptProcessRequest);
        }
        return deleteRptProcessRequests;
    }

    public DynamicObjectCollection queryReportProcessDynamicList(Collection<Long> ids, String selectFields) {
        return QueryServiceHelper.query((String)"eb_reportprocess", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    public Map<Long, Set<Long>> getReportProcessMap(Long modelId, Long periodId, Long dataTypeId, Long versionId, Set<Long> entityIdSet, Set<Long> templateIdSet, Set<String> rptFilterStatus) {
        ArrayList<Long> temp;
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        String sql = "select fid, fentity, ftemplate from t_eb_reportprocess where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? ";
        Object[] params = new Object[]{modelId, periodId, dataTypeId, versionId};
        sqlBuilder.append(sql, params);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(entityIdSet)) {
            if (entityIdSet.size() == 1) {
                temp = new ArrayList<Long>(entityIdSet);
                sqlBuilder.append(" and fentity = ?", new Object[]{temp.get(0)});
            } else {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn(" fentity ", entityIdSet.toArray());
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(templateIdSet)) {
            if (templateIdSet.size() == 1) {
                temp = new ArrayList<Long>(templateIdSet);
                sqlBuilder.append(" and ftemplate = ?", new Object[]{temp.get(0)});
            } else {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn(" ftemplate ", templateIdSet.toArray());
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(rptFilterStatus)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fstatus ", rptFilterStatus.toArray());
        }
        try (DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            log.info("getReportProcessListWithOtherMsg sqlBuilder:" + sqlBuilder + "," + dataSet.hasNext());
            for (Row row : dataSet) {
                Set fentity = result.computeIfAbsent(row.getLong("fentity"), t -> new HashSet(16));
                fentity.add(row.getLong("ftemplate"));
            }
        }
        return result;
    }

    public Map<Long, List<ReportProcess>> getReportProcessListMap(Long modelId, Long periodId, Long dataTypeId, Long versionId, Set<Long> entityIdSet, Set<Long> templateIdSet) {
        ArrayList<Long> temp;
        LinkedHashMap<Long, List<ReportProcess>> result = new LinkedHashMap<Long, List<ReportProcess>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        String sql = "select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? ";
        Object[] params = new Object[]{modelId, periodId, dataTypeId, versionId};
        sqlBuilder.append(sql, params);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(entityIdSet)) {
            if (entityIdSet.size() == 1) {
                temp = new ArrayList<Long>(entityIdSet);
                sqlBuilder.append(" and fentity = ?", new Object[]{temp.get(0)});
            } else {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn(" fentity ", entityIdSet.toArray());
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(templateIdSet)) {
            if (templateIdSet.size() == 1) {
                temp = new ArrayList<Long>(templateIdSet);
                sqlBuilder.append(" and ftemplate = ?", new Object[]{temp.get(0)});
            } else {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn(" ftemplate ", templateIdSet.toArray());
            }
        }
        ObjectCache objectCache = new ObjectCache();
        try (DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            log.info("getReportProcessListWithOtherMsg sqlBuilder:" + sqlBuilder + "," + dataSet.hasNext());
            for (Row row : dataSet) {
                List reportProcesses = result.computeIfAbsent(row.getLong("fentity"), t -> new ArrayList(16));
                reportProcesses.add(ReportProcess.createProcessFromDataSetRow(row, objectCache));
            }
        }
        return result;
    }

    public boolean checkCurrentSchemeCanOperation(Long orgViewId, Long periodId, Long dataTypeId, Long versionId, Long modelId, Long schemeId, Map<Long, Set<Long>> orgMap, boolean isSumbit) {
        if (orgMap == null || orgMap.isEmpty()) {
            return true;
        }
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        filter.and(new QFilter("templatetype", "=", (Object)"0"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_templateorg", (String)"id,template.id,org.id, orgrange", (QFilter[])filter.toArray());
        HashMap<Long, Set<TemplateEntityDto>> entityAndTemplateMap = new HashMap<Long, Set<TemplateEntityDto>>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return true;
        }
        List<Object> recordIdList = dynamicObjects.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map<Long, Set<Long>> recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set<Long> entityRange;
            Long templateid = dynamicObject.getLong("template.id");
            Long orgid = dynamicObject.getLong("org.id");
            Integer orgrange = dynamicObject.getInt("orgrange");
            if (IDUtils.isEmptyLong(templateid).booleanValue() || IDUtils.isEmptyLong(orgid).booleanValue() || org.apache.commons.collections4.CollectionUtils.isEmpty(entityRange = MemberHelper.getEntityIdSetByView(modelCacheHelper, orgViewId, orgid, orgrange))) continue;
            Set<Long> deleteEntity = recordDeleteEntity.get(dynamicObject.getLong("id"));
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(deleteEntity)) {
                entityRange.removeAll(deleteEntity);
            }
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(entityRange)) continue;
            for (Long entity : entityRange) {
                Set maps = entityAndTemplateMap.computeIfAbsent(entity, k -> new HashSet());
                TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateid, entity);
                maps.add(templateEntityDto);
            }
        }
        return !this.isFindOneCannotOperation(orgViewId, periodId, dataTypeId, versionId, modelId, orgMap, entityAndTemplateMap, isSumbit);
    }

    public boolean checkCurrentTaskCanOperation(Long orgViewId, Long periodId, Long dataTypeId, Long versionId, Long modelId, Long taskListId, Map<Long, Set<Long>> orgMap, boolean isSumbit) {
        if (orgMap == null || orgMap.isEmpty()) {
            return true;
        }
        QFilter filter = new QFilter("template.model.id", "=", (Object)modelId);
        filter.and(new QFilter("task.tasklist.year.id", "=", (Object)periodId));
        filter.and(new QFilter("task.tasklist.datatype.id", "=", (Object)dataTypeId));
        filter.and(new QFilter("task.tasklist.version.id", "=", (Object)versionId));
        filter.and(new QFilter("task.tasklist.id", "=", (Object)taskListId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id,org.id,template.id", (QFilter[])filter.toArray());
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)query)) {
            return true;
        }
        HashMap<Long, Set<TemplateEntityDto>> entityAndTemplateMap = new HashMap<Long, Set<TemplateEntityDto>>(16);
        for (DynamicObject dynamicObject : query) {
            Set maps = entityAndTemplateMap.computeIfAbsent(dynamicObject.getLong("org.id"), k -> new HashSet());
            TemplateEntityDto templateEntityDto = new TemplateEntityDto(dynamicObject.getLong("template.id"), dynamicObject.getLong("org.id"));
            maps.add(templateEntityDto);
        }
        return !this.isFindOneCannotOperation(orgViewId, periodId, dataTypeId, versionId, modelId, orgMap, entityAndTemplateMap, isSumbit);
    }

    private boolean isFindOneCannotOperation(Long orgViewId, Long periodId, Long dataTypeId, Long versionId, Long modelId, Map<Long, Set<Long>> orgMap, Map<Long, Set<TemplateEntityDto>> entityAndTemplateMap, boolean isSumbit) {
        boolean findOneCannotCommit = false;
        for (Map.Entry<Long, Set<Long>> orgEntity : orgMap.entrySet()) {
            BaseRptProcessRequest baseRptProcessRequest;
            List<ReportProcess> reportProcessList;
            Set<Long> value = orgEntity.getValue();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(value)) continue;
            ArrayList<TemplateEntityDto> templateEntityDtoList = new ArrayList<TemplateEntityDto>(16);
            for (Long childOrg : value) {
                Set<TemplateEntityDto> maps = entityAndTemplateMap.get(childOrg);
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(maps)) continue;
                templateEntityDtoList.addAll(maps);
            }
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(templateEntityDtoList) || org.apache.commons.collections4.CollectionUtils.isEmpty(reportProcessList = this.getReportProcessList((baseRptProcessRequest = new BaseRptProcessRequest(modelId, orgViewId, periodId, dataTypeId, versionId, templateEntityDtoList)).toList()))) continue;
            HashSet canOperationStatus = isSumbit ? Sets.newHashSet((Object[])new String[]{BgTaskStateEnum.UNPREPARED.getNumber(), BgTaskStateEnum.TEMPSAVE.getNumber(), BgTaskStateEnum.INCOMPLETE.getNumber()}) : Sets.newHashSet((Object[])new String[]{BgTaskStateEnum.UNDERWAY.getNumber(), BgTaskStateEnum.COMPLETED.getNumber()});
            for (ReportProcess reportProcess : reportProcessList) {
                if (!canOperationStatus.contains(reportProcess.getStatus())) continue;
                findOneCannotCommit = true;
                break;
            }
            if (!findOneCannotCommit) continue;
            break;
        }
        return findOneCannotCommit;
    }
}

