/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ReportProcessQuoteService {
    private static final Log log = LogFactory.getLog(ReportProcessQuoteService.class);
    private static final ReportProcessQuoteService INSTANCE = new ReportProcessQuoteService();

    public static ReportProcessQuoteService getInstance() {
        return INSTANCE;
    }

    private ReportProcessQuoteService() {
    }

    public Map<ProcessTypeEnum, Set<ReportProcessQuote>> getReportProcessQuote(Set<Long> reportProcessIdSet, Long modelId) {
        ReportProcessQuote reportProcessQuote;
        Set sourceSet;
        ReportProcess reportProcess;
        HashMap<ProcessTypeEnum, Set<ReportProcessQuote>> result = new HashMap<ProcessTypeEnum, Set<ReportProcessQuote>>(16);
        if (CollectionUtils.isEmpty(reportProcessIdSet)) {
            return result;
        }
        if (IDUtils.isEmptyLong(modelId).booleanValue()) {
            return result;
        }
        List<ReportProcess> reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(reportProcessIdSet);
        if (reportProcessList.isEmpty()) {
            return result;
        }
        HashSet templateIds = new HashSet(reportProcessList.size());
        HashSet periodIds = new HashSet(reportProcessList.size());
        HashSet datatypeIds = new HashSet(reportProcessList.size());
        HashSet versionIds = new HashSet(reportProcessList.size());
        reportProcessList.forEach(e -> {
            templateIds.add(e.getTemplateId());
            periodIds.add(e.getPeriodId());
            datatypeIds.add(e.getDataTypeId());
            versionIds.add(e.getVersionId());
        });
        Map<ReportProcess, ReportProcess> reportProcessMap = ReportProcessServiceImpl.getInstance().convertReportProcessListToCombinationMap(reportProcessList);
        QFilter filter = new QFilter("template.model.id", "=", (Object)modelId);
        filter.and(new QFilter("task.tasklist.year.id", "in", periodIds));
        filter.and(new QFilter("task.tasklist.datatype.id", "in", datatypeIds));
        filter.and(new QFilter("task.tasklist.version.id", "in", versionIds));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id, task.id, task.tasklist.year.id, task.tasklist.datatype.id, task.tasklist.version.id, org.id, orgview.id, template.id, task.tasklist.id", (QFilter[])filter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dynamicObject : query) {
                long periodId = dynamicObject.getLong("task.tasklist.year.id");
                long dataTypeId = dynamicObject.getLong("task.tasklist.datatype.id");
                long versionId = dynamicObject.getLong("task.tasklist.version.id");
                long orgId = dynamicObject.getLong("org.id");
                long orgViewId = dynamicObject.getLong("orgview.id");
                long templateId = dynamicObject.getLong("template.id");
                long taskListId = dynamicObject.getLong("task.tasklist.id");
                long taskIdLong = dynamicObject.getLong("task.id");
                long taskProcessId = dynamicObject.getLong("id");
                ReportProcess reportProcessKey = new ReportProcess(modelId, orgViewId, templateId, orgId, periodId, dataTypeId, versionId);
                reportProcess = reportProcessMap.get(reportProcessKey);
                if (reportProcess == null) continue;
                sourceSet = result.computeIfAbsent(ProcessTypeEnum.TASK, t -> new HashSet(16));
                reportProcessQuote = new ReportProcessQuote(ProcessTypeEnum.TASK, reportProcess.getId(), taskListId, taskProcessId, orgViewId);
                reportProcessQuote.setReportOrTaskIdLong(taskIdLong);
                sourceSet.add(reportProcessQuote);
            }
        }
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        filter1.and("applyscope", "!=", (Object)"2");
        filter1.and("year.id", "in", periodIds);
        filter1.and("datatype.id", "in", datatypeIds);
        filter1.and("version.id", "in", versionIds);
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id, scheme.id, scheme.orgview.id, year.id, datatype.id, version.id", (QFilter[])filter1.toArray());
        if (CollectionUtils.isEmpty((Collection)query1)) {
            return result;
        }
        HashMap<Long, List> schemePdvMap = new HashMap<Long, List>(16);
        HashMap<Long, Long> schemeAssignMap = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : query1) {
            long schemeId = dynamicObject.getLong("scheme.id");
            long periodId = dynamicObject.getLong("year.id");
            long dataTypeId = dynamicObject.getLong("datatype.id");
            long versionId = dynamicObject.getLong("version.id");
            long schemeAssignId = dynamicObject.getLong("id");
            List listIDs = schemePdvMap.computeIfAbsent(schemeId, t -> new ArrayList(16));
            Long[] ids = new Long[]{periodId, dataTypeId, versionId, schemeAssignId};
            listIDs.add(ids);
            schemeAssignMap.put(schemeId, schemeAssignId);
        }
        HashMap<Long, List> schemeTemplateEntityListMap = new HashMap<Long, List>(16);
        QFilter filter2 = new QFilter("templatetype", "!=", (Object)"1");
        filter2.and("scheme", "in", schemePdvMap.keySet());
        filter2.and("template.id", "in", templateIds);
        DynamicObjectCollection templateOrg = QueryServiceHelper.query((String)"eb_templateorg", (String)"id,scheme.id,template.id,org.id,orgrange,scheme.orgview.id", (QFilter[])filter2.toArray());
        List<Object> recordIdList = templateOrg.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map<Long, Set<Long>> recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
        HashMap<Long, Long> schemeViewIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : templateOrg) {
            long schemeId = dynamicObject.getLong("scheme.id");
            long templateId = dynamicObject.getLong("template.id");
            long orgId = dynamicObject.getLong("org.id");
            Integer orgrange = dynamicObject.getInt("orgrange");
            Long orgViewId = dynamicObject.getLong("scheme.orgview.id");
            schemeViewIdMap.put(schemeId, orgViewId);
            TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, orgId, orgrange);
            templateEntityDto.setDeleteEntity(recordDeleteEntity.get(dynamicObject.getLong("id")));
            List templateEntityDtoList = schemeTemplateEntityListMap.computeIfAbsent(schemeId, t -> new ArrayList(16));
            templateEntityDtoList.add(templateEntityDto);
        }
        for (Map.Entry entry : schemePdvMap.entrySet()) {
            Long schemeId = (Long)entry.getKey();
            List value = (List)entry.getValue();
            for (Long[] ids : value) {
                List templateEntityDtos = (List)schemeTemplateEntityListMap.get(schemeId);
                if (!CollectionUtils.isNotEmpty((Collection)templateEntityDtos)) continue;
                BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelId, (Long)schemeViewIdMap.get(schemeId), ids[0], ids[1], ids[2], templateEntityDtos);
                baseRptProcessRequest.setHasDisableEntity(true);
                List<ReportProcess> tmpReportProcessList = ReportProcessServiceImpl.getInstance().createReportProcessList(baseRptProcessRequest, null);
                for (ReportProcess tmpReportProcess : tmpReportProcessList) {
                    reportProcess = reportProcessMap.get(tmpReportProcess);
                    if (reportProcess == null) continue;
                    sourceSet = result.computeIfAbsent(ProcessTypeEnum.REPORT, t -> new HashSet(16));
                    reportProcessQuote = new ReportProcessQuote(ProcessTypeEnum.REPORT, reportProcess.getId(), schemeId, (Long)schemeAssignMap.get(schemeId), (Long)schemeViewIdMap.get(schemeId));
                    reportProcessQuote.setReportOrTaskIdLong(schemeId);
                    sourceSet.add(reportProcessQuote);
                }
            }
        }
        return result;
    }

    public Map<ProcessTypeEnum, Set<ReportProcessQuote>> getReportProcessQuote(Long reportProcessId, Long modelId) {
        HashSet<Long> param = new HashSet<Long>(4);
        param.add(reportProcessId);
        return this.getReportProcessQuote(param, modelId);
    }

    public Set<Long> filterReportProcessByProcessType(Set<Long> reportProcessIdSet, ProcessTypeEnum processTypeEnum, Long modelId) {
        int inMaxSize;
        if (CollectionUtils.isEmpty(reportProcessIdSet) || processTypeEnum == null || IDUtils.isEmptyLong(modelId).booleanValue()) {
            return new HashSet<Long>(16);
        }
        int reportProcessSize = reportProcessIdSet.size();
        if (reportProcessSize > (inMaxSize = HugeInConfig.inMaxSize())) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u9700\u8981\u8fc7\u6ee4\u7684\u62a5\u8868\u5b9e\u4f8b\u4e2a\u6570%1\u8d85\u8fc7in\u53c2\u6570\u9650\u5236%2\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportProcessQuoteService_0", (String)"epm-eb-common", (Object[])new Object[]{reportProcessSize, inMaxSize}));
        }
        HashSet<Long> filterReportProcessSet = new HashSet<Long>(reportProcessSize);
        QFBuilder builder = new QFBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<Long> templateIdSet = new HashSet<Long>(reportProcessSize);
        HashMap<String, Set> reportProcessTemEntStrMap = new HashMap<String, Set>(reportProcessSize);
        builder.add("id", "in", reportProcessIdSet);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"queryReportProcessByIds", (String)"eb_reportprocess", (String)"id,template,entity", (QFilter[])builder.toArrays(), null);
        Object object = null;
        try {
            while (ds != null && ds.hasNext()) {
                stringBuilder.setLength(0);
                Row row = ds.next();
                Long templateId = row.getLong("template");
                templateIdSet.add(templateId);
                String temEntStr = stringBuilder.append(templateId).append("_").append(row.getLong("entity")).toString();
                Set temEntStrSet = reportProcessTemEntStrMap.computeIfAbsent(temEntStr, f -> new HashSet(16));
                temEntStrSet.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtils.isEmpty(templateIdSet)) {
            log.info("templateIdSet is empty");
            return filterReportProcessSet;
        }
        HashSet<String> existTemEntStrSet = new HashSet<String>(reportProcessSize);
        if (ProcessTypeEnum.REPORT == processTypeEnum) {
            this.getExistTemEntStrSetByReport(modelId, existTemEntStrSet, null, null, null);
        } else if (ProcessTypeEnum.TASK == processTypeEnum) {
            this.getExistTemEntStrSetByTask(templateIdSet, existTemEntStrSet);
        }
        for (Map.Entry entry : reportProcessTemEntStrMap.entrySet()) {
            String tmpEntStr = (String)entry.getKey();
            if (!existTemEntStrSet.contains(tmpEntStr)) continue;
            filterReportProcessSet.addAll((Collection)entry.getValue());
        }
        return filterReportProcessSet;
    }

    private void getExistTemEntStrSetByTask(Set<Long> templateIdSet, Set<String> existTemEntStrSet) {
        if (CollectionUtils.isEmpty(templateIdSet) || existTemEntStrSet == null) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("template", "in", templateIdSet);
        StringBuilder stringBuilder = new StringBuilder();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTaskProcessByTemplateIds", (String)"eb_taskprocess", (String)"template,org", (QFilter[])builder.toArrays(), null);){
            while (ds != null && ds.hasNext()) {
                stringBuilder.setLength(0);
                Row row = ds.next();
                existTemEntStrSet.add(stringBuilder.append(row.getLong("template")).append("_").append(row.getLong("org")).toString());
            }
        }
    }

    private void getExistTemEntStrSetByReport(Long modelId, Set<String> existTemEntStrSet, Long sourceId, Map<String, Long> periodVersionDataTypeMap, Set<Long> templateIdSet) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || existTemEntStrSet == null) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        builder.add("model", "=", modelId);
        if (IDUtils.isNotEmptyLong(sourceId).booleanValue()) {
            builder.add("scheme", "=", sourceId);
        }
        if (periodVersionDataTypeMap != null) {
            if (periodVersionDataTypeMap.containsKey(SysDimensionEnum.DataType.getNumber())) {
                builder.add("datatype", "=", periodVersionDataTypeMap.get(SysDimensionEnum.DataType.getNumber()));
            }
            if (periodVersionDataTypeMap.containsKey(SysDimensionEnum.Version.getNumber())) {
                builder.add("version", "=", periodVersionDataTypeMap.get(SysDimensionEnum.Version.getNumber()));
            }
            if (periodVersionDataTypeMap.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                builder.add("year", "=", periodVersionDataTypeMap.get(SysDimensionEnum.BudgetPeriod.getNumber()));
            }
        }
        HashSet<Long> assignSchemeSet = new HashSet<Long>(16);
        HashMap<Long, Long> schemeOrgViewIdMap = new HashMap<Long, Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySchemeAssignByModelId", (String)"eb_schemeassign", (String)"scheme,scheme.orgview", (QFilter[])builder.toArrays(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                assignSchemeSet.add(row.getLong("scheme"));
                schemeOrgViewIdMap.put(row.getLong("scheme"), row.getLong("scheme.orgview"));
            }
        }
        if (CollectionUtils.isEmpty(assignSchemeSet)) {
            return;
        }
        builder.clear();
        builder.add("scheme", "in", assignSchemeSet);
        if (CollectionUtils.isNotEmpty(templateIdSet)) {
            builder.add("template", "in", templateIdSet);
        }
        HashMap orgRangeMap = new HashMap(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryRptTemplateOrgBySchemeIds", (String)"eb_templateorg", (String)"scheme,template,org,orgrange", (QFilter[])builder.toArrays(), null);){
            String entityNumber = SysDimensionEnum.Entity.getNumber();
            while (ds != null && ds.hasNext()) {
                List orgList;
                stringBuilder.setLength(0);
                Row row = ds.next();
                Long org = row.getLong("org");
                Long orgView = (Long)schemeOrgViewIdMap.get(row.getLong("scheme"));
                String orgRange = row.getString("orgrange");
                String orgRangeKey = stringBuilder.append(org).append("_").append(orgView).append("_").append(orgRange).toString();
                if (orgRangeMap.containsKey(orgRangeKey)) {
                    orgList = (List)orgRangeMap.get(orgRangeKey);
                } else {
                    List<Member> members;
                    Member member = modelCacheHelper.getMember(entityNumber, orgView, org);
                    if (member == null || CollectionUtils.isEmpty(members = modelCacheHelper.getMember(entityNumber, orgView, member.getNumber(), Integer.parseInt(orgRange)))) continue;
                    orgList = members.stream().map(BaseCache::getId).collect(Collectors.toList());
                    orgRangeMap.put(orgRangeKey, orgList);
                }
                if (CollectionUtils.isEmpty((Collection)orgList)) continue;
                for (Long orgId : orgList) {
                    stringBuilder.setLength(0);
                    existTemEntStrSet.add(stringBuilder.append(row.getLong("template")).append("_").append(orgId).toString());
                }
            }
        }
    }

    public boolean checkSchemeOrTaskHasProcessQuote(Set<Long> reportProcessIdSet, ProcessTypeEnum processTypeEnum, Long modelId, Long sourceId) {
        int inMaxSize;
        if (CollectionUtils.isEmpty(reportProcessIdSet) || processTypeEnum == null || IDUtils.isEmptyLong(modelId).booleanValue() || IDUtils.isEmptyLong(sourceId).booleanValue()) {
            return false;
        }
        int reportProcessSize = reportProcessIdSet.size();
        if (reportProcessSize > (inMaxSize = HugeInConfig.inMaxSize())) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u9700\u8981\u8fc7\u6ee4\u7684\u62a5\u8868\u5b9e\u4f8b\u4e2a\u6570%1\u8d85\u8fc7in\u53c2\u6570\u9650\u5236%2\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportProcessQuoteService_0", (String)"epm-eb-common", (Object[])new Object[]{reportProcessSize, inMaxSize}));
        }
        HashMap<Long, Long> templateEntityMap = new HashMap<Long, Long>(reportProcessSize);
        HashSet<String> reportProcessTemEntStrSet = new HashSet<String>(reportProcessSize);
        HashSet<Long> inTableProcessId = new HashSet<Long>(reportProcessIdSet.size());
        HashMap<String, Long> periodVersionDataTypeMap = new HashMap<String, Long>(3);
        if (ProcessTypeEnum.REPORT == processTypeEnum) {
            QFilter qFilter = new QFilter("scheme", "=", (Object)sourceId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject == null) {
                return false;
            }
            if (!this.checkProcessIsInTable(reportProcessIdSet, templateEntityMap, reportProcessTemEntStrSet, inTableProcessId, periodVersionDataTypeMap)) {
                return false;
            }
            HashSet<String> existTemEntStrSet = new HashSet<String>(reportProcessSize);
            this.getExistTemEntStrSetByReport(modelId, existTemEntStrSet, sourceId, periodVersionDataTypeMap, templateEntityMap.keySet());
            reportProcessTemEntStrSet.retainAll(existTemEntStrSet);
            return CollectionUtils.isNotEmpty(reportProcessTemEntStrSet);
        }
        if (ProcessTypeEnum.TASK == processTypeEnum) {
            QFilter filter = new QFilter("template.model.id", "=", (Object)modelId);
            filter.and(new QFilter("task.tasklist", "=", (Object)sourceId));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dynamicObject == null) {
                return false;
            }
            if (!this.checkProcessIsInTable(reportProcessIdSet, templateEntityMap, reportProcessTemEntStrSet, inTableProcessId, periodVersionDataTypeMap)) {
                return false;
            }
            QFBuilder builder1 = new QFBuilder();
            builder1.add("template", "in", templateEntityMap.keySet());
            builder1.add("org", "in", templateEntityMap.values());
            filter.and(new QFilter("task.tasklist.year.id", "=", periodVersionDataTypeMap.get(SysDimensionEnum.BudgetPeriod.getNumber())));
            filter.and(new QFilter("task.tasklist.datatype.id", "=", periodVersionDataTypeMap.get(SysDimensionEnum.DataType.getNumber())));
            filter.and(new QFilter("task.tasklist.version.id", "=", periodVersionDataTypeMap.get(SysDimensionEnum.Version.getNumber())));
            HashSet<String> existTemEntStrSet = new HashSet<String>(reportProcessSize);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTaskProcessByTemplateIds", (String)"eb_taskprocess", (String)"template,org", (QFilter[])builder1.toArrays(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    existTemEntStrSet.add(row.getLong("template") + "_" + row.getLong("org"));
                }
            }
            if (CollectionUtils.isEmpty(existTemEntStrSet)) {
                return false;
            }
            reportProcessTemEntStrSet.retainAll(existTemEntStrSet);
            return CollectionUtils.isNotEmpty(reportProcessTemEntStrSet);
        }
        return false;
    }

    private boolean checkProcessIsInTable(Set<Long> reportProcessIdSet, Map<Long, Long> templateEntityMap, Set<String> reportProcessTemEntStrSet, Set<Long> inTableProcessId, Map<String, Long> periodVersionDataTypeMap) {
        QFBuilder builder = new QFBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        builder.add("id", "in", reportProcessIdSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryReportProcessByIds", (String)"eb_reportprocess", (String)"id,template,entity,datatype,version,period", (QFilter[])builder.toArrays(), null);){
            while (ds != null && ds.hasNext()) {
                stringBuilder.setLength(0);
                Row row = ds.next();
                if (periodVersionDataTypeMap != null && periodVersionDataTypeMap.size() == 0) {
                    periodVersionDataTypeMap.put(SysDimensionEnum.DataType.getNumber(), row.getLong("datatype"));
                    periodVersionDataTypeMap.put(SysDimensionEnum.Version.getNumber(), row.getLong("version"));
                    periodVersionDataTypeMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), row.getLong("period"));
                }
                Long templateId = row.getLong("template");
                templateEntityMap.put(templateId, row.getLong("entity"));
                inTableProcessId.add(row.getLong("id"));
                reportProcessTemEntStrSet.add(stringBuilder.append(templateId).append("_").append(row.getLong("entity")).toString());
            }
        }
        return !CollectionUtils.isEmpty(inTableProcessId);
    }
}

