/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.entity.request.UpdateRptProcessStatusRequest;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.IReportProcessService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessConfig;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class ReportProcessServiceImpl
implements IReportProcessService {
    private static final Log log = LogFactory.getLog(ReportProcessServiceImpl.class);
    private static final ReportProcessServiceImpl INSTANCE = new ReportProcessServiceImpl();

    private ReportProcessServiceImpl() {
    }

    public static ReportProcessServiceImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public ReportProcess getReportProcess(Long modelId, Long templateId, Long entityId, Long periodId, Long dataTypeId, Long versionId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        Object[] params = new Object[]{modelId, periodId, dataTypeId, versionId, templateId, entityId};
        sqlBuilder.append("select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? and ftemplate = ? and fentity = ? ", params);
        try (DataSet ds = DB.queryDataSet((String)"querySingleReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            if (ds != null && ds.hasNext()) {
                Row next = ds.next();
                ReportProcess reportProcess = ReportProcess.createProcessFromDataSetRow(next, new ObjectCache());
                return reportProcess;
            }
        }
        return null;
    }

    public List<ReportProcess> getReportProcess(Collection<Long> reportProcessIds) {
        ArrayList reportProcessList = Lists.newArrayListWithExpectedSize((int)reportProcessIds.size());
        DynamicObjectCollection dojs = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,template, entity, version,datatype, period, status, model,submitdate, submituser,submitentity,creater, createdate,modifier,modifydate,approvebill", (QFilter[])new QFBuilder("id", "in", reportProcessIds).toArrays());
        for (DynamicObject doj : dojs) {
            reportProcessList.add(ReportProcess.createProcessFromDynamicObjectV2(doj));
        }
        return reportProcessList;
    }

    public DynamicObjectCollection getApplyBill(Collection<Long> ids) {
        return QueryServiceHelper.query((String)"eb_bgapplybill", (String)"id,org,year,version,datatype", (QFilter[])new QFBuilder("id", "in", ids).toArrays());
    }

    @Override
    public List<ReportProcess> getReportProcessList(Long modelId) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        DataSet dataSet = this.queryProcessByModel(modelId);
        ObjectCache objectCache = new ObjectCache();
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            result.add(ReportProcess.createProcessFromDataSetRow(next, objectCache));
        }
        return result;
    }

    @Override
    public List<ReportProcess> getReportProcessList(Long modelId, Boolean excludeNotEditedBoolean) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        DataSet dataSet = this.queryProcessByModel(modelId, excludeNotEditedBoolean);
        ObjectCache objectCache = new ObjectCache();
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            result.add(ReportProcess.createProcessFromDataSetRow(next, objectCache));
        }
        return result;
    }

    @Override
    public List<ReportProcess> getReportProcessList(Long modelId, Long periodId, Long dataTypeId, Long versionId, Set<Long> entityIdSet, Set<Long> templateIdSet) {
        ArrayList<Long> temp;
        LinkedList<ReportProcess> result = new LinkedList<ReportProcess>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        String sql = "select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ? and fperiod = ? and fdatatype = ? and fversion = ? ";
        Object[] params = new Object[]{modelId, periodId, dataTypeId, versionId};
        sqlBuilder.append(sql, params);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(entityIdSet)) {
            if (entityIdSet.size() == 1) {
                temp = new ArrayList<Long>(entityIdSet);
                sqlBuilder.append(" and fentity = ?", new Object[]{temp.get(0)});
            } else {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn(" fentity ", entityIdSet.toArray());
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(templateIdSet)) {
            if (templateIdSet.size() == 1) {
                temp = new ArrayList<Long>(templateIdSet);
                sqlBuilder.append(" and ftemplate = ?", new Object[]{temp.get(0)});
            } else {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn(" ftemplate ", templateIdSet.toArray());
            }
        }
        ObjectCache objectCache = new ObjectCache();
        try (DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            log.info("getReportProcessListWithOtherMsg sqlBuilder:" + sqlBuilder + "," + dataSet.hasNext());
            for (Row row : dataSet) {
                result.add(ReportProcess.createProcessFromDataSetRow(row, objectCache));
            }
        }
        return result;
    }

    @Override
    public List<ReportProcess> getReportProcessList(Set<Long> reportProcessIdSet) {
        List partitionReportProcessIdListList = ListUtils.partition(new ArrayList<Long>(reportProcessIdSet), (int)100000);
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(reportProcessIdSet.size());
        for (List reportProcessIdLongList : partitionReportProcessIdListList) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where ", new Object[0]);
            sqlBuilder.appendIn(" fid", reportProcessIdLongList.toArray());
            this.queryReportProcess(sqlBuilder, result);
        }
        return result;
    }

    private void queryReportProcess(SqlBuilder sqlBuilder, List<ReportProcess> result) {
        DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        ObjectCache objectCache = new ObjectCache();
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            result.add(ReportProcess.createProcessFromDataSetRow(next, objectCache));
        }
    }

    @Override
    public List<ReportProcess> getReportProcessList(Long modelId, Long entityViewId, Set<Long> entityIdSet, Set<Long> templateIdSet, Long periodId, Long dataTypeId, Long versionId) {
        ArrayList<TemplateEntityDto> templateEntityDtoList = new ArrayList<TemplateEntityDto>(16);
        for (Long entityId : entityIdSet) {
            for (Long templateId : templateIdSet) {
                TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, entityId);
                templateEntityDtoList.add(templateEntityDto);
            }
        }
        BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelId, entityViewId, periodId, dataTypeId, versionId, templateEntityDtoList);
        return this.getReportProcessList(baseRptProcessRequest.toList());
    }

    @Override
    public List<ReportProcess> getReportProcessListWithStatus(Long modelId, Long entityViewId, Set<Long> entityIdSet, Set<Long> templateIdSet, Long periodId, Long dataTypeId, Long versionId, Set<String> status) {
        ArrayList<TemplateEntityDto> templateEntityDtoList = new ArrayList<TemplateEntityDto>(16);
        for (Long entityId : entityIdSet) {
            for (Long templateId : templateIdSet) {
                TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, entityId);
                templateEntityDtoList.add(templateEntityDto);
            }
        }
        BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelId, entityViewId, periodId, dataTypeId, versionId, templateEntityDtoList);
        List<ReportProcess> reportProcessList = this.getReportProcessList(baseRptProcessRequest.toList());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(reportProcessList)) {
            Iterator<ReportProcess> iterator = reportProcessList.iterator();
            while (iterator.hasNext()) {
                ReportProcess next = iterator.next();
                if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(status) || status.contains(next.getStatus())) continue;
                iterator.remove();
            }
            return reportProcessList;
        }
        return reportProcessList;
    }

    @Override
    public List<ReportProcess> getReportProcessListWithOtherMsg(List<BaseRptProcessRequest> queryRptProcessRequests) {
        List<ReportProcess> result = new ArrayList<ReportProcess>(16);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(queryRptProcessRequests)) {
            return result;
        }
        result = this.getReportProcessList(queryRptProcessRequests);
        log.info("getReportProcessListWithOtherMsg submit task:" + result.size());
        ReportProcess.addOtherMessage(result);
        return result;
    }

    public List<ReportProcess> getReportProcessDynamicList(QFilter qFilter) {
        LinkedList<ReportProcess> result = new LinkedList<ReportProcess>();
        String selectFields = "id, template.id, template.number, template.isReadOnly,template.name, entity.id, entity.number, entity.name, version.id, datatype.id, period.id, status, model.id, submitdate, submituser.id, submituser.name, submitentity.id, submitentity.name, creater.id, createdate, modifier.id, modifydate, approvebill.id, approvebill.billno";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_reportprocess", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        dynamicObjectCollection.forEach(e -> result.add(ReportProcess.createProcessFromDataSetRow(e)));
        return result;
    }

    @Override
    public List<ReportProcess> getReportProcessList(List<BaseRptProcessRequest> queryRptProcessRequests) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(queryRptProcessRequests)) {
            return Collections.emptyList();
        }
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(128);
        HashMap<Long, List> queryRptProcessRequestsMap = new HashMap<Long, List>(16);
        for (BaseRptProcessRequest queryRptProcessRequest : queryRptProcessRequests) {
            List baseRptProcessRequests = queryRptProcessRequestsMap.computeIfAbsent(queryRptProcessRequest.getModelId(), t -> new LinkedList());
            baseRptProcessRequests.add(queryRptProcessRequest);
        }
        for (Map.Entry entry : queryRptProcessRequestsMap.entrySet()) {
            Long modelId = (Long)entry.getKey();
            HashSet<Long> periodIds = new HashSet<Long>(16);
            HashSet<Long> dataTypeIds = new HashSet<Long>(16);
            HashSet<Long> versionIds = new HashSet<Long>(16);
            LinkedHashSet<Long> entityIdSet = new LinkedHashSet<Long>();
            LinkedHashSet<Long> templateIdSet = new LinkedHashSet<Long>();
            HashMap<String, Map<Long, Set<Long>>> pdvStrTemplateEntityMap = new HashMap<String, Map<Long, Set<Long>>>(16);
            for (BaseRptProcessRequest queryRptProcessRequest : (List)entry.getValue()) {
                periodIds.add(queryRptProcessRequest.getPeriodId());
                dataTypeIds.add(queryRptProcessRequest.getDataTypeId());
                versionIds.add(queryRptProcessRequest.getVersionId());
                entityIdSet.addAll(queryRptProcessRequest.getEntityIdSet());
                templateIdSet.addAll(queryRptProcessRequest.getTemplateIdSet());
                Map templateEntityMap = pdvStrTemplateEntityMap.computeIfAbsent(queryRptProcessRequest.getPdvStr(), t -> new HashMap(16));
                CollectionUtils.merge(templateEntityMap, queryRptProcessRequest.getTemplateEntityMap());
            }
            Map<ReportProcess, Integer> map = this.queryReportProcess(modelId, periodIds, dataTypeIds, versionIds, entityIdSet, templateIdSet, pdvStrTemplateEntityMap);
            if (!MapUtils.isNotEmpty(map)) continue;
            result.addAll(map.keySet());
        }
        return result;
    }

    @Override
    public Map<ReportProcess, Integer> queryReportProcess(Long modelId, Set<Long> periodIds, Set<Long> dataTypeIds, Set<Long> versionIds, Set<Long> entityIdSet, Set<Long> templateIdSet, Map<String, Map<Long, Set<Long>>> pdvStrTemplateEntityMap) {
        LinkedHashMap<ReportProcess, Integer> result = new LinkedHashMap<ReportProcess, Integer>(1000);
        SqlBuilder sqlBuilder = new SqlBuilder();
        String sql = "select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ? ";
        Object[] params = new Object[]{modelId};
        sqlBuilder.append(sql, params);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(periodIds)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fperiod ", periodIds.toArray());
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(dataTypeIds)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fdatatype ", dataTypeIds.toArray());
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(versionIds)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fversion ", versionIds.toArray());
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(entityIdSet)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" fentity ", entityIdSet.toArray());
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(templateIdSet)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn(" ftemplate ", templateIdSet.toArray());
        }
        ObjectCache objectCache = new ObjectCache();
        try (DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                Set<Long> entityIds;
                Long entityId = objectCache.valueOf(row.getLong("fentity"));
                Long versionId = objectCache.valueOf(row.getLong("fversion"));
                Long dataTypeId = objectCache.valueOf(row.getLong("fdatatype"));
                Long periodId = objectCache.valueOf(row.getLong("fperiod"));
                Long templateId = objectCache.valueOf(row.getLong("ftemplate"));
                String pdvStr = periodId + "#" + dataTypeId + "#" + versionId;
                Map<Long, Set<Long>> templateEntityMap = pdvStrTemplateEntityMap.get(pdvStr);
                if (MapUtils.isEmpty(templateEntityMap) || org.apache.commons.collections4.CollectionUtils.isEmpty(entityIds = templateEntityMap.get(templateId)) || !entityIds.contains(entityId)) continue;
                ReportProcess reportProcess = ReportProcess.createProcessFromDataSetRow(row, objectCache);
                result.put(reportProcess, 0);
            }
        }
        return result;
    }

    @Override
    public List<ReportProcess> getReportProcessList(Long modelId, Long entityId) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        String sql = "select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ? and fentity = ?";
        Object[] params = new Object[]{modelId, entityId};
        DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])params);
        ObjectCache objectCache = new ObjectCache();
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            result.add(ReportProcess.createProcessFromDataSetRow(next, objectCache));
        }
        return result;
    }

    @Override
    public List<ReportProcess> getReportProcessList(Long modelId, Set<Long> entityIdSet) {
        if (IDUtils.isNull(modelId) || entityIdSet == null || entityIdSet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ?", new Object[]{modelId});
        sqlBuilder.append(" and ", new Object[0]);
        sqlBuilder.appendIn(" fentity ", entityIdSet.toArray());
        DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        ObjectCache objectCache = new ObjectCache();
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            result.add(ReportProcess.createProcessFromDataSetRow(next, objectCache));
        }
        return result;
    }

    private DataSet queryProcessByModel(Long modelId) {
        String sql = "select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ?";
        Object[] params = new Object[]{modelId};
        return DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])params);
    }

    private DataSet queryProcessByModel(Long modelId, Boolean excludeNotEditedBoolean) {
        String sql = "select fid, fentity, fversion, fdatatype, fperiod, ftemplate, fstatus, fmodel, fcreater, fcreatedate,fmodifier,fmodifydate,fsubmitentity, fsubmitdate, fsubmituser, fapprovebill from t_eb_reportprocess where fmodel = ?";
        if (Boolean.TRUE.equals(excludeNotEditedBoolean)) {
            sql = sql + " and fstatus != '0' and fmodifier != 0 and fmodifier is not null";
        }
        Object[] params = new Object[]{modelId};
        return DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])params);
    }

    @Override
    public List<ReportProcess> createReportProcessList(BaseRptProcessRequest saveRptProcessRequest, ReportProcessConfig config) {
        Long modelId = saveRptProcessRequest.getModelId();
        Long periodId = saveRptProcessRequest.getPeriodId();
        Long versionId = saveRptProcessRequest.getVersionId();
        Long dataTypeId = saveRptProcessRequest.getDataTypeId();
        Long entityViewId = saveRptProcessRequest.getEntityViewId();
        HashSet<ReportProcess> reportProcessSet = new HashSet<ReportProcess>();
        Map<Long, Set<Long>> templateEntityMap = config != null && config.getTemplateOrgIds() != null ? config.getTemplateOrgIds() : saveRptProcessRequest.getTemplateEntityMap();
        int count = 0;
        for (Set<Long> e : templateEntityMap.values()) {
            count += e.size();
        }
        long[] ids = GlobalIdUtil.genGlobalLongIds(count);
        int i = 0;
        IModelCacheHelper modelCacheHelper = saveRptProcessRequest.getModelCacheHelper();
        List<Member> members = modelCacheHelper.getMembers(entityViewId, SysDimensionEnum.Entity.getNumber());
        for (Map.Entry<Long, Set<Long>> entry : templateEntityMap.entrySet()) {
            Long templateId = entry.getKey();
            Set<Long> entityIdSet = entry.getValue();
            for (Member entity : members) {
                ReportProcess reportProcess;
                if (!entityIdSet.contains(entity.getId()) || !saveRptProcessRequest.isHasDisableEntity() && entity.isDisable() || entity.getNumber().endsWith("offsetentry") || reportProcessSet.contains(reportProcess = new ReportProcess(ids[i++], modelId, entityViewId, templateId, entity.getId(), periodId, dataTypeId, versionId))) continue;
                reportProcessSet.add(reportProcess);
            }
        }
        return new ArrayList<ReportProcess>(reportProcessSet);
    }

    @Override
    public Map<ReportProcess, ReportProcess> convertReportProcessListToCombinationMap(List<ReportProcess> reportProcesses) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(reportProcesses)) {
            return Collections.emptyMap();
        }
        HashMap<ReportProcess, ReportProcess> result = new HashMap<ReportProcess, ReportProcess>(reportProcesses.size());
        for (ReportProcess reportProcess : reportProcesses) {
            result.put(reportProcess, reportProcess);
        }
        return result;
    }

    @Override
    public void deleteReportProcess(Set<Long> reportProcessIdSet) {
        List partition = Lists.partition(new ArrayList<Long>(reportProcessIdSet), (int)10000);
        for (List part : partition) {
            SqlBuilder deleteSql = ReportProcess.getDeleteSql(new HashSet<Long>(part));
            this.executeBatchDeleteSql(deleteSql);
        }
    }

    private void executeBatchDeleteSql(SqlBuilder deleteSql) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)deleteSql);
    }

    @Override
    public void saveReportProcess(List<Object[]> insertParams) {
        String sql = ReportProcess.getInsertSql().toString();
        List partition = Lists.partition(insertParams, (int)200000);
        for (List objects : partition) {
            this.executeBatchSql(sql, objects);
        }
    }

    private void executeBatchSql(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
    }

    @Override
    public void updateReportProcess(List<Object[]> updateParams) {
        String sql = ReportProcess.getUpdateSql();
        List partition = Lists.partition(updateParams, (int)200000);
        for (List objects : partition) {
            this.executeBatchSql(sql, objects);
        }
    }

    @Override
    public void updateReportProcessStatus(@NotNull UpdateRptProcessStatusRequest updateRptProcessStatusRequest) {
        SqlBuilder updateStatusSql = updateRptProcessStatusRequest.getUpdateStatusSql();
        if (updateStatusSql == null || ApproveBillHelper.isCentralApproveBill(updateRptProcessStatusRequest.getApproveBillId())) {
            return;
        }
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)updateStatusSql);
    }

    @Override
    public void updateReportProcessStatus(List<UpdateRptProcessStatusRequest> updateRptProcessStatusRequestList) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(updateRptProcessStatusRequestList)) {
            return;
        }
        boolean hasUp = false;
        for (UpdateRptProcessStatusRequest updateRptProcessStatusRequest : updateRptProcessStatusRequestList) {
            SqlBuilder updateStatusSql;
            if (ApproveBillHelper.isCentralApproveBill(updateRptProcessStatusRequest.getApproveBillId()) || (updateStatusSql = updateRptProcessStatusRequest.getUpdateStatusSql()) == null) continue;
            hasUp = true;
            this.executeSql(updateStatusSql);
        }
        if (hasUp) {
            CacheServiceHelper.clearEntityCache("eb_reportprocess");
        }
    }

    private void executeSql(SqlBuilder sql) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sql);
    }

    public Set<Long> queryRefRptProcessByBill(ApproveBillSubMitDim subMitDim) {
        HashSet<Long> rptProcessIds = new HashSet<Long>(16);
        List<ReportProcess> reportProcessList = this.getReportProcessList(subMitDim.getModelId(), subMitDim.getViewId(), Sets.newHashSet((Object[])new Long[]{subMitDim.getOrgId()}), subMitDim.getTempIds(), subMitDim.getYearPeriodId(), subMitDim.getDataTypeId(), subMitDim.getVersionId());
        reportProcessList.forEach(reportProcess -> rptProcessIds.add(reportProcess.getId()));
        return rptProcessIds;
    }
}

