/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.ApproveBill.ApproveBillUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportProcessUpgradeService {
    private static final Log log = LogFactory.getLog(ReportProcessUpgradeService.class);

    public static ReportProcessUpgradeService getInstance() {
        return new ReportProcessUpgradeService();
    }

    private ReportProcessUpgradeService() {
    }

    public void updateSingleModelReportAttachment(Long modelId) {
        Serializable frptentityid;
        HashMap<Long, Set> taskAttachmentMap = new HashMap<Long, Set>(16);
        HashMap<Long, Set> dynamicReportAttachmentMap = new HashMap<Long, Set>(16);
        List<ReportProcess> reportProcessList = ReportProcessAggService.getInstance().getReportProcessList(modelId);
        Map<ReportProcess, ReportProcess> reportProcessMap = ReportProcessAggService.getInstance().convertReportProcessListToCombinationMap(reportProcessList);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select frptentityid, ftaskproid, fid from t_eb_reportattachment where fmodelid = ?", new Object[]{modelId});
        try (DataSet dataSet = DB.queryDataSet((String)"getModelReportProcessAttachment", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Set attachmentIds;
                Row next = dataSet.next();
                frptentityid = next.getLong("frptentityid");
                Long ftaskproid = next.getLong("ftaskproid");
                Long l = next.getLong("fid");
                if (IDUtils.isNotEmptyLong((Long)frptentityid).booleanValue()) {
                    attachmentIds = dynamicReportAttachmentMap.computeIfAbsent((Long)frptentityid, t -> new HashSet(16));
                    attachmentIds.add(l);
                }
                if (!IDUtils.isNotEmptyLong(ftaskproid).booleanValue()) continue;
                attachmentIds = taskAttachmentMap.computeIfAbsent(ftaskproid, t -> new HashSet(16));
                attachmentIds.add(l);
            }
        }
        HashMap<Long, Set> reportProcessIdAttachmentMap = new HashMap<Long, Set>(16);
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select a.fid as id, a.ftemplateid as templateId, a.forgid as orgId, c.fyearid as yearId, c.fversionid as versionId, c.fdatetypeid as dataTypeId from t_eb_taskprocess a, t_eb_task b, t_eb_tasklist c where a.ftaskid = b.fid and b.ftasklistid = c.fid and b.fmodelid = ?", new Object[]{modelId});
        if (taskAttachmentMap.size() > 0) {
            sqlBuilder1.append(" and ", new Object[0]);
            sqlBuilder1.appendIn(" a.fid ", (Object[])taskAttachmentMap.keySet().toArray(new Long[0]));
        }
        DataSet dataSet = DB.queryDataSet((String)"updateGetTaskProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder1);
        frptentityid = null;
        try {
            while (dataSet != null && dataSet.hasNext()) {
                Set attachmentIds;
                Row next = dataSet.next();
                Long l = next.getLong("id");
                Long templateId = next.getLong("templateId");
                Long orgId = next.getLong("orgId");
                Long yearId = next.getLong("yearId");
                Long versionId = next.getLong("versionId");
                Long dataTypeId = next.getLong("dataTypeId");
                ReportProcess reportProcessKey = new ReportProcess(modelId, 0L, templateId, orgId, yearId, dataTypeId, versionId);
                ReportProcess reportProcess = reportProcessMap.get(reportProcessKey);
                if (reportProcess == null || CollectionUtils.isEmpty((Collection)(attachmentIds = (Set)taskAttachmentMap.get(l)))) continue;
                Set attachments = reportProcessIdAttachmentMap.computeIfAbsent(reportProcess.getId(), t -> new HashSet(16));
                attachments.addAll(attachmentIds);
            }
        }
        catch (Throwable throwable) {
            frptentityid = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (frptentityid != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)frptentityid).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select a.fid as id, b.fyearid as yearId, b.fdatatypeid as dataTypeId, b.fversionid as versionId, a.ftemplateid as templateId, a.forg as orgId from t_eb_dynamicreport a, t_eb_schemeassign b where a.fschemeassignid = b.fid ", new Object[0]);
        sqlBuilder2.append(" and b.fmodelid = ? ", new Object[]{modelId});
        if (dynamicReportAttachmentMap.size() > 0) {
            sqlBuilder2.append(" and ", new Object[0]);
            sqlBuilder2.appendIn(" a.fid ", (Object[])dynamicReportAttachmentMap.keySet().toArray(new Long[0]));
        }
        DataSet dataSet2 = DB.queryDataSet((String)"updateGetTaskProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder2);
        Object object = null;
        try {
            while (dataSet2 != null && dataSet2.hasNext()) {
                Set attachmentIds;
                Row row = dataSet2.next();
                Long dynamicReportId = row.getLong("id");
                Long templateId = row.getLong("templateId");
                Long orgId = row.getLong("orgId");
                Long yearId = row.getLong("yearId");
                Long versionId = row.getLong("versionId");
                Long dataTypeId = row.getLong("dataTypeId");
                ReportProcess reportProcessKey = ReportProcess.buildReportProcessCombination(modelId, templateId, orgId, yearId, dataTypeId, versionId);
                ReportProcess reportProcess = reportProcessMap.get(reportProcessKey);
                if (reportProcess == null || CollectionUtils.isEmpty((Collection)(attachmentIds = (Set)dynamicReportAttachmentMap.get(dynamicReportId)))) continue;
                Set attachments = reportProcessIdAttachmentMap.computeIfAbsent(reportProcess.getId(), t -> new HashSet(16));
                attachments.addAll(attachmentIds);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet2 != null) {
                if (object != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        if (reportProcessIdAttachmentMap.size() > 0) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Map.Entry entry : reportProcessIdAttachmentMap.entrySet()) {
                Set value = (Set)entry.getValue();
                for (Long attachmentId : value) {
                    Object[] param = new Object[]{entry.getKey(), attachmentId};
                    params.add(param);
                }
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_reportattachment set freportprocess = ? where fid = ?", params);
        }
    }

    public void updateSingleModelProcess(Long modelId, boolean isUpdate) {
        Object next52;
        Serializable orgViewId;
        Object next222;
        Object next3;
        HashMap<Long, List> taskProcessMap = new HashMap<Long, List>(16);
        HashMap<Long, List> schemeProcessMap = new HashMap<Long, List>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Dimension entityDimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        if (entityDimension == null) {
            return;
        }
        LinkedHashMap<ReportProcess, Set> orgViewIdMap = new LinkedHashMap<ReportProcess, Set>();
        String sql = "select fid from t_eb_dimensionview where fmodelid = ? and fdimensionid = ?";
        SqlBuilder sqlBuilder4 = new SqlBuilder();
        Object[] param = new Object[]{modelId, entityDimension.getId()};
        sqlBuilder4.append(sql, param);
        HashSet<Long> viewIdSetFromDb = new HashSet<Long>(16);
        try (DataSet dataSet1 = DB.queryDataSet((String)"queryAllEntityViewIds", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder4);){
            while (dataSet1.hasNext()) {
                next3 = dataSet1.next();
                viewIdSetFromDb.add(next3.getLong("fid"));
            }
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid as taskProcessId, a.forgid as orgId, a.forgviewid as orgViewId, a.ftemplateid as templateId, b.fmodelid as modelId, c.fyearid as yearId, c.fdatetypeid as dataTypeId, c.fversionid as versionId from t_eb_taskprocess a, t_eb_task b, t_eb_tasklist c ", new Object[0]);
        sqlBuilder.append(" where a.ftaskid = b.fid and b.ftasklistid = c.fid and b.fmodelid=?", new Object[]{modelId});
        DataSet dataSet = DB.queryDataSet((String)"updateReportProcessGetTaskProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        next3 = null;
        try {
            while (dataSet != null && dataSet.hasNext()) {
                next222 = dataSet.next();
                Long taskProcessId = next222.getLong("taskProcessId");
                Long orgId = next222.getLong("orgId");
                Long orgViewId2 = next222.getLong("orgViewId");
                if (IDUtils.isNotEmptyLong(orgViewId2).booleanValue() && CollectionUtils.isNotEmpty(viewIdSetFromDb) && !viewIdSetFromDb.contains(orgViewId2)) continue;
                Long templateId = next222.getLong("templateId");
                Long yearId = next222.getLong("yearId");
                Long l = next222.getLong("dataTypeId");
                Long versionId = next222.getLong("versionId");
                ArrayList<TemplateEntityDto> templateEntityDtoList = new ArrayList<TemplateEntityDto>(16);
                templateEntityDtoList.add(new TemplateEntityDto(templateId, orgId));
                BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelId, orgViewId2, yearId, l, versionId, templateEntityDtoList);
                List<ReportProcess> list = ReportProcessServiceImpl.getInstance().createReportProcessList(baseRptProcessRequest, null);
                List reportProcesses = taskProcessMap.computeIfAbsent(taskProcessId, t -> new ArrayList(16));
                reportProcesses.addAll(list);
                for (ReportProcess reportProcess : list) {
                    Set longs = orgViewIdMap.computeIfAbsent(reportProcess, t -> new HashSet(16));
                    longs.add(orgViewId2);
                }
            }
        }
        catch (Throwable next222) {
            next3 = next222;
            throw next222;
        }
        finally {
            if (dataSet != null) {
                if (next3 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable next222) {
                        ((Throwable)next3).addSuppressed(next222);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select a.fid as schemeassignId, a.fyearid as yearId, a.fversionid as versionId, a.fdatatypeid as dataTypeId, a.fmodelid as modelId, b.forgviewid as orgViewId, c.ftemplateid as templateId, c.forgid as orgId, c.forgrange as orgRange from t_eb_schemeassign a, t_eb_rptscheme b, t_eb_templateorg c where a.fschemeid = b.fid and b.fid = c.fschemeid and a.fmodelid=?", new Object[]{modelId});
        DataSet dataSet2 = DB.queryDataSet((String)"updateReportProcessGetReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder1);
        next222 = null;
        try {
            while (dataSet2 != null && dataSet2.hasNext()) {
                Row next4 = dataSet2.next();
                Long schemeassignId = next4.getLong("schemeassignId");
                Long orgId = next4.getLong("orgId");
                orgViewId = next4.getLong("orgViewId");
                if (IDUtils.isNotEmptyLong((Long)orgViewId).booleanValue() && CollectionUtils.isNotEmpty(viewIdSetFromDb) && !viewIdSetFromDb.contains(orgViewId)) continue;
                Long templateId = next4.getLong("templateId");
                Long l = next4.getLong("yearId");
                Long dataTypeId = next4.getLong("dataTypeId");
                Long versionId = next4.getLong("versionId");
                Integer orgRange = next4.getInteger("orgRange");
                ArrayList<TemplateEntityDto> arrayList = new ArrayList<TemplateEntityDto>(16);
                arrayList.add(new TemplateEntityDto(templateId, orgId, orgRange));
                BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelId, (Long)orgViewId, l, dataTypeId, versionId, arrayList);
                List<ReportProcess> reportProcessList = ReportProcessServiceImpl.getInstance().createReportProcessList(baseRptProcessRequest, null);
                List reportProcesses = schemeProcessMap.computeIfAbsent(schemeassignId, t -> new ArrayList(16));
                reportProcesses.addAll(reportProcessList);
                for (ReportProcess reportProcess : reportProcessList) {
                    Set longs = orgViewIdMap.computeIfAbsent(reportProcess, t -> new HashSet(16));
                    longs.add(orgViewId);
                }
            }
        }
        catch (Throwable next4) {
            next222 = next4;
            throw next4;
        }
        finally {
            if (dataSet2 != null) {
                if (next222 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable next4) {
                        ((Throwable)next222).addSuppressed(next4);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        Set taskProcessIdSet = taskProcessMap.keySet();
        Set schemeAssignIdSet = schemeProcessMap.keySet();
        HashMap<Long, List> approveBillMap = new HashMap<Long, List>(16);
        SqlBuilder sqlBuilder3 = new SqlBuilder();
        sqlBuilder3.append("select a.fcreaterid as createrid, a.fbillstatus as billstatus, a.feborgid as orgId, b.ftempid as templateId, a.fcreatedate as createdate,b.ftaskprocessjson as json, a.fid as approveBillId from t_eb_approvebill a, t_eb_approvebillentry b where a.fid = b.fid and a.fbillstatus in ('B', 'C','E') and a.fmodelid = ?", new Object[]{modelId});
        DataSet dataSet3 = DB.queryDataSet((String)"updateReportProcessGetReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder3);
        orgViewId = null;
        try {
            while (dataSet3 != null && dataSet3.hasNext()) {
                next52 = dataSet3.next();
                String string = next52.getString("json");
                if (StringUtils.isEmpty(string)) continue;
                Long approveBillId = next52.getLong("approveBillId");
                Set<Long> taskProcessIds = IDUtils.toLongs(ApproveBillUtil.getTaskProcessIdSet(string));
                for (Long l : taskProcessIds) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    map.put("id", approveBillId);
                    map.put("createrid", next52.getLong("createrid"));
                    map.put("createdate", next52.getDate("createdate"));
                    map.put("billstatus", next52.getString("billstatus"));
                    map.put("orgId", next52.getLong("orgId"));
                    map.put("templateId", next52.getLong("templateId"));
                    List maps = approveBillMap.computeIfAbsent(l, t -> new ArrayList(16));
                    maps.add(map);
                }
            }
        }
        catch (Throwable next52) {
            orgViewId = next52;
            throw next52;
        }
        finally {
            if (dataSet3 != null) {
                if (orgViewId != null) {
                    try {
                        dataSet3.close();
                    }
                    catch (Throwable next52) {
                        ((Throwable)orgViewId).addSuppressed(next52);
                    }
                } else {
                    dataSet3.close();
                }
            }
        }
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select fid, fmodifydate, fmodifier, fcreater, fcreatedate, fschemeassignid, ftaskprocessid, forg, ftemplateid from t_eb_dynamicreport where 1=1 ", new Object[0]);
        if (CollectionUtils.isNotEmpty(schemeAssignIdSet)) {
            sqlBuilder2.append(" and ", new Object[0]);
            sqlBuilder2.appendIn(" fschemeassignid", schemeAssignIdSet.toArray());
        }
        if (CollectionUtils.isNotEmpty(taskProcessIdSet)) {
            sqlBuilder2.append(" or ", new Object[0]);
            sqlBuilder2.appendIn(" ftaskprocessid ", taskProcessIdSet.toArray());
        }
        DataSet dataSet4 = DB.queryDataSet((String)"updateReportProcessGetReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder2);
        next52 = null;
        try {
            block52: while (dataSet4 != null && dataSet4.hasNext()) {
                List reportProcesses;
                Long orgId;
                Date parentCreateDate;
                Date createdate;
                Map map;
                Iterator iterator;
                Map parentApproveBillMap;
                Object maps;
                Row row = dataSet4.next();
                Long dynamicReportId = row.getLong("fid");
                Long fmodifier = row.getLong("fmodifier");
                Date fmodifydate = row.getDate("fmodifydate");
                Long l = row.getLong("fschemeassignid");
                Long ftaskprocessid = row.getLong("ftaskprocessid");
                Long forg = row.getLong("forg");
                Long ftemplateid = row.getLong("ftemplateid");
                Long fcreater = row.getLong("fcreater");
                Date fcreatedate = row.getDate("fcreatedate");
                Map approveBillInfoMap = null;
                if (IDUtils.isNotEmptyLong(l).booleanValue()) {
                    maps = (List)approveBillMap.get(dynamicReportId);
                    parentApproveBillMap = null;
                    if (maps != null) {
                        iterator = maps.iterator();
                        while (iterator.hasNext()) {
                            map = (Map)iterator.next();
                            createdate = (Date)map.get("createdate");
                            if (parentApproveBillMap == null) {
                                parentApproveBillMap = map;
                            } else {
                                parentCreateDate = (Date)parentApproveBillMap.get("createdate");
                                if (parentCreateDate.getTime() > createdate.getTime()) {
                                    parentApproveBillMap = map;
                                }
                            }
                            if (!(orgId = IDUtils.toLong(map.get("orgId"))).equals(forg)) continue;
                            approveBillInfoMap = map;
                            break;
                        }
                    }
                    if (approveBillInfoMap == null) {
                        approveBillInfoMap = parentApproveBillMap;
                    }
                    reportProcesses = (List)schemeProcessMap.get(l);
                } else {
                    maps = (List)approveBillMap.get(ftaskprocessid);
                    parentApproveBillMap = null;
                    if (maps != null) {
                        iterator = maps.iterator();
                        while (iterator.hasNext()) {
                            map = (Map)iterator.next();
                            createdate = (Date)map.get("createdate");
                            if (parentApproveBillMap == null) {
                                parentApproveBillMap = map;
                            } else {
                                parentCreateDate = (Date)parentApproveBillMap.get("createdate");
                                if (parentCreateDate.getTime() > createdate.getTime()) {
                                    parentApproveBillMap = map;
                                }
                            }
                            if (!(orgId = IDUtils.toLong(map.get("orgId"))).equals(forg)) continue;
                            approveBillInfoMap = map;
                            break;
                        }
                    }
                    if (approveBillInfoMap == null) {
                        approveBillInfoMap = parentApproveBillMap;
                    }
                    reportProcesses = (List)taskProcessMap.get(ftaskprocessid);
                }
                if (reportProcesses == null) continue;
                for (ReportProcess reportProcess : reportProcesses) {
                    Long entityId = reportProcess.getEntityId();
                    Long templateId = reportProcess.getTemplateId();
                    if (IDUtils.isEmptyLong(entityId).booleanValue() || IDUtils.isEmptyLong(templateId).booleanValue() || !entityId.equals(forg) || !templateId.equals(ftemplateid)) continue;
                    reportProcess.setStatus(BgTaskStateEnum.TEMPSAVE.getNumber());
                    reportProcess.setModifier(fmodifier);
                    reportProcess.setModifyDate(fmodifydate);
                    reportProcess.setCreateDate(fcreatedate);
                    reportProcess.setCreater(fcreater);
                    if (approveBillInfoMap == null) continue;
                    String billstatus = String.valueOf(approveBillInfoMap.get("billstatus"));
                    Long id = IDUtils.toLong(approveBillInfoMap.get("id"));
                    Long createrid = IDUtils.toLong(approveBillInfoMap.get("createrid"));
                    Date createdate2 = (Date)approveBillInfoMap.get("createdate");
                    Long orgId2 = IDUtils.toLong(approveBillInfoMap.get("orgId"));
                    BgTaskStateEnum taskStateEnum = null;
                    if (StringUtils.equals("B", billstatus)) {
                        taskStateEnum = BgTaskStateEnum.UNDERWAY;
                    } else if (StringUtils.equals("E", billstatus)) {
                        taskStateEnum = BgTaskStateEnum.COMPLETED;
                    }
                    if (taskStateEnum == null) continue block52;
                    reportProcess.setStatus(taskStateEnum.getNumber());
                    reportProcess.setApproveBillId(id);
                    reportProcess.setSubmitEntity(orgId2);
                    reportProcess.setSubmitUser(createrid);
                    reportProcess.setSubmitDate(createdate2);
                    continue block52;
                }
            }
        }
        catch (Throwable throwable) {
            next52 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet4 != null) {
                if (next52 != null) {
                    try {
                        dataSet4.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)next52).addSuppressed(throwable);
                    }
                } else {
                    dataSet4.close();
                }
            }
        }
        LinkedHashMap<ReportProcess, ReportProcess> reportProcessMap = new LinkedHashMap<ReportProcess, ReportProcess>();
        schemeProcessMap.putAll(taskProcessMap);
        for (Map.Entry entry : schemeProcessMap.entrySet()) {
            List value = (List)entry.getValue();
            for (ReportProcess reportProcess : value) {
                ReportProcess reportProcess2 = (ReportProcess)reportProcessMap.get(reportProcess);
                if (reportProcess2 != null) {
                    boolean isParentApproveBill;
                    boolean isOwnApproveBill;
                    Long oldEntityId;
                    Long oldSubmitEntity;
                    Long entityId;
                    Long submitEntity;
                    String status = reportProcess.getStatus();
                    String oldStatus = reportProcess2.getStatus();
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)status) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)oldStatus) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)status) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oldStatus)) continue;
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)oldStatus)) {
                        reportProcessMap.put(reportProcess, reportProcess);
                        continue;
                    }
                    if (BgTaskStateEnum.TEMPSAVE.getNumber().equals(status) && BgTaskStateEnum.TEMPSAVE.getNumber().equals(oldStatus)) {
                        Date modifyDate = reportProcess.getModifyDate();
                        Date modifyDate1 = reportProcess2.getModifyDate();
                        if (modifyDate.getTime() <= modifyDate1.getTime()) continue;
                        reportProcessMap.put(reportProcess, reportProcess);
                        continue;
                    }
                    if (!BgTaskStateEnum.TEMPSAVE.getNumber().equals(status) && Integer.parseInt(status) > Integer.parseInt(oldStatus)) {
                        submitEntity = reportProcess.getSubmitEntity();
                        entityId = reportProcess.getEntityId();
                        oldSubmitEntity = reportProcess2.getSubmitEntity();
                        oldEntityId = reportProcess2.getEntityId();
                        isOwnApproveBill = submitEntity.equals(entityId) && oldEntityId.equals(oldSubmitEntity);
                        boolean bl = isParentApproveBill = !submitEntity.equals(entityId) && !oldEntityId.equals(oldSubmitEntity);
                        if (isOwnApproveBill || isParentApproveBill) {
                            reportProcessMap.put(reportProcess, reportProcess);
                            continue;
                        }
                        if (!submitEntity.equals(entityId)) continue;
                        reportProcessMap.put(reportProcess, reportProcess);
                        continue;
                    }
                    if (BgTaskStateEnum.TEMPSAVE.getNumber().equals(status) || Integer.parseInt(status) != Integer.parseInt(oldStatus)) continue;
                    submitEntity = reportProcess.getSubmitEntity();
                    entityId = reportProcess.getEntityId();
                    oldSubmitEntity = reportProcess2.getSubmitEntity();
                    oldEntityId = reportProcess2.getEntityId();
                    isOwnApproveBill = submitEntity.equals(entityId) && oldEntityId.equals(oldSubmitEntity);
                    boolean bl = isParentApproveBill = !submitEntity.equals(entityId) && !oldEntityId.equals(oldSubmitEntity);
                    if (isOwnApproveBill || isParentApproveBill) {
                        Date submitDate = reportProcess.getSubmitDate();
                        Date oldSubmitDate = reportProcess2.getSubmitDate();
                        if (oldSubmitDate == null) {
                            reportProcessMap.put(reportProcess, reportProcess);
                            continue;
                        }
                        if (submitDate.getTime() <= oldSubmitDate.getTime()) continue;
                        reportProcessMap.put(reportProcess, reportProcess);
                        continue;
                    }
                    if (!submitEntity.equals(entityId)) continue;
                    reportProcessMap.put(reportProcess, reportProcess);
                    continue;
                }
                reportProcessMap.put(reportProcess, reportProcess);
            }
        }
        for (Map.Entry entry : reportProcessMap.entrySet()) {
            Member member;
            ReportProcess key = (ReportProcess)entry.getKey();
            ReportProcess value = (ReportProcess)entry.getValue();
            Long entityId = value.getEntityId();
            String string = value.getStatus();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string) || BgTaskStateEnum.TEMPSAVE.getNumber().equals(string) || (member = entityDimension.getStructOfMember(entityId)) == null) continue;
            String entityNum = member.getNumber();
            Set orgViewIdSet = (Set)orgViewIdMap.get(key);
            if (!CollectionUtils.isNotEmpty((Collection)orgViewIdSet)) continue;
            for (Long orgViewId3 : orgViewIdSet) {
                List<Member> children = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong(orgViewId3), entityNum, RangeEnum.ALL_EXCLUDE.getIndex());
                for (Member child : children) {
                    ReportProcess reportProcessKey = ReportProcess.buildReportProcessCombination(value.getModelId(), value.getTemplateId(), child.getId(), value.getPeriodId(), value.getDataTypeId(), value.getVersionId());
                    ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(reportProcessKey);
                    if (reportProcess == null || IDUtils.isNotEmptyLong(reportProcess.getApproveBillId()).booleanValue() && reportProcess.getModifyDate() != null) continue;
                    reportProcess.setSubmitDate(value.getSubmitDate());
                    reportProcess.setSubmitEntity(value.getSubmitEntity());
                    reportProcess.setSubmitUser(value.getSubmitUser());
                    reportProcess.setStatus(value.getStatus());
                    reportProcess.setApproveBillId(value.getApproveBillId());
                }
            }
        }
        List<ReportProcess> reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId);
        Map<ReportProcess, ReportProcess> map = ReportProcessServiceImpl.getInstance().convertReportProcessListToCombinationMap(reportProcessList);
        ArrayList<Object[]> addParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Map.Entry entry : reportProcessMap.entrySet()) {
            ReportProcess value = (ReportProcess)entry.getValue();
            ReportProcess reportProcess = map.get(entry.getKey());
            if (reportProcess != null) {
                Object[] updateParam = new Object[]{value.getStatus(), value.getApproveBillId(), value.getModifier(), value.getModifyDate(), value.getSubmitUser(), value.getSubmitDate(), value.getSubmitEntity(), reportProcess.getId()};
                updateParams.add(updateParam);
                continue;
            }
            Object[] insertParams = value.getAddParams();
            addParams.add(insertParams);
        }
        if (CollectionUtils.isNotEmpty(addParams)) {
            StringBuilder addSql = ReportProcess.getAddSql();
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)addSql.toString(), addParams);
        }
        if (isUpdate && CollectionUtils.isNotEmpty(updateParams)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_reportprocess set fstatus = ?, fapprovebill = ?, fmodifier = ?, fmodifydate = ?, fsubmituser = ?,fsubmitdate = ?, fsubmitentity = ? where fid = ? and fstatus != '9'", updateParams);
        }
    }

    public Set<Long> getAllBgmModelIdSet() {
        HashSet<Long> result = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_eb_model where freporttype = '7'", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"getAllBgmModel", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long fid = next.getLong("fid");
                result.add(fid);
            }
        }
        return result;
    }

    public void removeRepeatReportProcess(Long modelId) {
        LinkedHashMap<ReportProcess, List<ReportProcess>> map = new LinkedHashMap<ReportProcess, List<ReportProcess>>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fmodel, ftemplate, fentity, fdatatype, fversion, fperiod from t_eb_reportprocess group by fmodel, ftemplate, fentity, fdatatype, fversion, fperiod having count(fid) > 1 and fmodel = ?", new Object[]{modelId});
        DataSet ds = DB.queryDataSet((String)"queryRepeatReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fmodel = row.getLong("fmodel");
                Long ftemplate = row.getLong("ftemplate");
                Long fentity = row.getLong("fentity");
                Long fdatatype = row.getLong("fdatatype");
                Long fversion = row.getLong("fversion");
                Long fperiod = row.getLong("fperiod");
                Object[] param = new Object[]{ftemplate, fentity, fperiod, fdatatype, fversion, fmodel};
                this.createReportProcessForDelete(map, param);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<Long> toDeleteIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : map.entrySet()) {
            List value = (List)entry.getValue();
            boolean flag = false;
            Long retainId = 0L;
            for (ReportProcess reportProcess : value) {
                if (BgTaskStateEnum.TEMPSAVE.getNumber().equals(reportProcess.getStatus())) {
                    flag = true;
                    continue;
                }
                if (BgTaskStateEnum.UNDERWAY.getNumber().equals(reportProcess.getStatus())) {
                    flag = true;
                    continue;
                }
                if (BgTaskStateEnum.COMPLETED.getNumber().equals(reportProcess.getStatus())) {
                    flag = true;
                    continue;
                }
                if (IDUtils.isEmptyLong(retainId).booleanValue()) {
                    retainId = reportProcess.getId();
                    continue;
                }
                toDeleteIdSet.add(reportProcess.getId());
            }
            if (!flag || !IDUtils.isNotEmptyLong(retainId).booleanValue()) continue;
            toDeleteIdSet.add(retainId);
        }
        if (CollectionUtils.isNotEmpty(toDeleteIdSet)) {
            SqlBuilder sqlBuilder1 = new SqlBuilder();
            sqlBuilder1.append("delete from t_eb_reportprocess where ", new Object[0]);
            sqlBuilder1.appendIn(" fid ", toDeleteIdSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder1);
        }
    }

    private void createReportProcessForDelete(Map<ReportProcess, List<ReportProcess>> map, Object[] param) {
        DataSet dataSet = DB.queryDataSet((String)"queryToDeleteRepeatProcess", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid, fstatus, fmodel, ftemplate, fentity, fdatatype, fversion, fperiod from t_eb_reportprocess where ftemplate = ? and fentity = ? and fperiod = ? and fdatatype = ? and fversion = ? and fmodel = ?", (Object[])param);
        while (dataSet != null && dataSet.hasNext()) {
            Row next1 = dataSet.next();
            Long fid1 = next1.getLong("fid");
            String fstatus1 = next1.getString("fstatus");
            Long fmodel1 = next1.getLong("fmodel");
            Long ftemplate1 = next1.getLong("ftemplate");
            Long fentity1 = next1.getLong("fentity");
            Long fdatatype1 = next1.getLong("fdatatype");
            Long fversion1 = next1.getLong("fversion");
            Long fperiod1 = next1.getLong("fperiod");
            ReportProcess reportProcess = new ReportProcess(fmodel1, ftemplate1, fentity1, fperiod1, fdatatype1, fversion1);
            reportProcess.setId(fid1);
            reportProcess.setStatus(fstatus1);
            List reportProcesses = map.computeIfAbsent(reportProcess.getReportProcessCombination(), t -> new ArrayList(16));
            reportProcesses.add(reportProcess);
        }
    }
}

