/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.reportprocess.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.PreTaskMonitorLogic;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.reportprocess.utils.ProcessConsumer;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportProcessUtil {
    private static Log log = LogFactory.getLog(ReportProcessUtil.class);

    public static void deleteApproveBill(Collection<Long> reportProcessIds) {
        if (reportProcessIds != null && reportProcessIds.size() != 0) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_reportprocess set fapprovebill = 0 where ", new Object[0]);
            sqlBuilder.appendIn("fid", reportProcessIds.toArray());
            DB.update((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
    }

    public static Map<String, String> getReportProcessStatus(Long modelId, QFilter taskProcessQFilter, boolean needExecutor) {
        HashMap<String, String> reportProcessStatusMap = new HashMap<String, String>(16);
        LinkedHashSet taskIdSet = Sets.newLinkedHashSet();
        LinkedHashMap tmpMap = Maps.newLinkedHashMap();
        LinkedHashSet orgSet = Sets.newLinkedHashSet();
        LinkedHashSet tempidSet = Sets.newLinkedHashSet();
        if (taskProcessQFilter == null) {
            taskProcessQFilter = new QFilter("templatetype", "=", (Object)"eb_templateentity");
        } else {
            taskProcessQFilter.and("templatetype", "=", (Object)"eb_templateentity");
        }
        if (needExecutor) {
            taskProcessQFilter.and("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId());
        }
        String selectFields = "id,org.id as orgId,task.tasklist.id as taskId,task.tasklist.year as yearId,task.tasklist.datatype as dataTypeId,task.tasklist.version as versionId,template";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)selectFields, (QFilter[])taskProcessQFilter.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    String id = row.getString("id");
                    String orgId = row.getString("orgId");
                    String yearId = row.getString("yearId");
                    String dataTypeId = row.getString("dataTypeId");
                    String versionId = row.getString("versionId");
                    String tempId = row.getString("template");
                    String taskId = row.getString("taskId");
                    taskIdSet.add(Long.parseLong(taskId));
                    tempidSet.add(Long.parseLong(tempId));
                    orgSet.add(Long.parseLong(orgId));
                    String unionKey = modelId + "#" + tempId + "#" + orgId + "#" + yearId + "#" + dataTypeId + "#" + versionId + "#" + taskId;
                    tmpMap.put(unionKey, id);
                }
            }
        }
        if (orgSet.isEmpty() || tempidSet.isEmpty()) {
            return reportProcessStatusMap;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("entity", "in", (Object)orgSet));
        qFilter.and(new QFilter("template", "in", (Object)tempidSet));
        String reportFields = "status,entity,submitentity.id,datatype.id,period.id,version.id,template.id as templateId";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReportProcessUtil.class.getName(), (String)"eb_reportprocess", (String)reportFields, (QFilter[])qFilter.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    String status = row.getString("status");
                    String orgId = row.getString("entity");
                    String yearId = row.getString("period.id");
                    String dataTypeId = row.getString("datatype.id");
                    String versionId = row.getString("version.id");
                    String tempId = row.getString("templateId");
                    for (Long taskId : taskIdSet) {
                        String unionKey = modelId + "#" + tempId + "#" + orgId + "#" + yearId + "#" + dataTypeId + "#" + versionId + "#" + taskId;
                        String taskProcessId = (String)tmpMap.get(unionKey);
                        if (!StringUtils.isNotEmpty(taskProcessId)) continue;
                        reportProcessStatusMap.put(taskProcessId, status);
                    }
                }
            }
        }
        tmpMap.clear();
        return reportProcessStatusMap;
    }

    public static Long getReportProcessId(Long modelId, Long templateId, String entityNumber, Long periodId, Long versionId, Long dataTypeId, Long viewId) {
        ReportProcess reportProcess;
        Long entityId = 0L;
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate(modelId);
        Member member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entityNumber);
        if (member != null) {
            entityId = member.getId();
        }
        Long reportProcessId = 0L;
        if (IDUtils.isNotNull(modelId) && IDUtils.isNotNull(entityId) && IDUtils.isNotNull(templateId) && IDUtils.isNotNull(periodId) && IDUtils.isNotNull(versionId) && IDUtils.isNotNull(dataTypeId) && (reportProcess = ReportProcessServiceImpl.getInstance().getReportProcess(modelId, templateId, entityId, periodId, dataTypeId, versionId)) != null) {
            reportProcessId = reportProcess.getId();
        }
        String msg = "modelId:" + modelId + ",viewId:" + viewId + ",templateId:" + templateId + ",entityId:" + entityId + ",entityNumber:" + entityNumber + ",periodId:" + periodId + ",versionId:" + versionId + ",datatypeId:" + dataTypeId;
        log.info("ReportProcessUtil getReportProcessId check :" + msg + "\uff0creportProcessId : " + reportProcessId);
        return reportProcessId;
    }

    public static Map<String, Long> getDimensionIdByReportProcess(Long reportProcessId) {
        QFilter qFilter;
        DynamicObject dynamicObject;
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        Long periodId = 0L;
        Long versionId = 0L;
        Long dataTypeId = 0L;
        Long templateId = 0L;
        if (IDUtils.isNotNull(reportProcessId) && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"period,version,datatype,template", (QFilter[])(qFilter = new QFilter("id", "=", (Object)reportProcessId)).toArray())) != null) {
            periodId = dynamicObject.getLong("period");
            versionId = dynamicObject.getLong("version");
            dataTypeId = dynamicObject.getLong("datatype");
            templateId = dynamicObject.getLong("template");
        }
        map.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodId);
        map.put(SysDimensionEnum.Version.getNumber(), versionId);
        map.put(SysDimensionEnum.DataType.getNumber(), dataTypeId);
        map.put("template", templateId);
        log.info("ReportProcessUtil getDimensionIdByReportProcess check : reportProcessId:" + reportProcessId + ",periodId:" + periodId + ",versionId:" + versionId + ",datatypeId:" + dataTypeId);
        return map;
    }

    public static Boolean checkReportProcessStatus(Long reportProcessId, Long approveBillId) {
        boolean result = false;
        Integer processStatus = ApproveBillQuery.getInstance().getProcessStatus(reportProcessId, approveBillId);
        if (processStatus != null) {
            String status = processStatus.toString();
            result = BgTaskStateEnum.UNDERWAY.getNumber().equals(status) || BgTaskStateEnum.COMPLETED.getNumber().equals(status);
        }
        log.info("ReportProcessUtil checkReportProcessStatus reportProcessId:" + reportProcessId + ", result:" + result);
        return result;
    }

    public static Long checkVimReportProcessStatus(Long modelId, Long templateId, String entityNumber, Long periodId, Long versionId, Long dataTypeId, Long viewId) {
        return ReportProcessUtil.checkVimReportProcessStatus(modelId, templateId, null, entityNumber, periodId, versionId, dataTypeId, viewId);
    }

    public static Long checkVimReportProcessStatus(Long modelId, Long templateId, Long entityId, String entityNumber, Long periodId, Long versionId, Long dataTypeId, Long viewId) {
        List<Member> parents;
        Long result = 0L;
        if (IDUtils.isNull(modelId) || IDUtils.isNull(templateId) || IDUtils.isNull(entityId) && StringUtils.isEmpty(entityNumber) || IDUtils.isNull(periodId) || IDUtils.isNull(versionId) || IDUtils.isNull(dataTypeId)) {
            return result;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate(modelId);
        Member member = null;
        if (IDUtils.isNotNull(entityId)) {
            member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entityId);
        } else if (StringUtils.isNotEmpty(entityNumber)) {
            member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entityNumber);
        }
        if (member != null && CollectionUtils.isNotEmpty(parents = orCreate.getParents(viewId, member, false))) {
            HashSet ids = new HashSet(16);
            parents.forEach(e -> ids.add(e.getId()));
            QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
            qFilter.and("eborgid", "in", ids);
            qFilter.and("entryentity.tempid", "=", (Object)templateId);
            qFilter.and("dim_period", "=", (Object)periodId);
            qFilter.and("dim_version", "=", (Object)versionId);
            qFilter.and("dim_datatype", "=", (Object)dataTypeId);
            qFilter.and("billstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"B", "E"}));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,eborgid.id", (QFilter[])qFilter.toArray());
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                HashSet<Long> entityIds = new HashSet<Long>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    entityIds.add(dynamicObject.getLong("eborgid.id"));
                }
                qFilter = new QFilter("model", "=", (Object)modelId);
                qFilter.and("entity", "in", entityIds);
                qFilter.and("template", "=", (Object)templateId);
                qFilter.and("period", "=", (Object)periodId);
                qFilter.and("version", "=", (Object)versionId);
                qFilter.and("datatype", "=", (Object)dataTypeId);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_reportprocess", (String)"id", (QFilter[])qFilter.toArray());
                if (dynamicObject != null) {
                    result = dynamicObject.getLong("id");
                }
            }
        }
        String msg = "modelId:" + modelId + ",viewId:" + viewId + ",templateId:" + templateId + ",entityId:" + entityId + ",entityNumber:" + entityNumber + ",periodId:" + periodId + ",versionId:" + versionId + ",datatypeId:" + dataTypeId;
        log.info("ReportProcessUtil checkVimReportProcessStatus check :" + msg + "\uff0cresult : " + result);
        return result;
    }

    public static boolean checkTemplateEntityDto(Long templateId, Long entityId, Set<TemplateEntityDto> toCheck, Set<TemplateEntityDto> checked, Map<String, Set<Long>> entityRangeCache) {
        if (toCheck == null || toCheck.isEmpty() || entityRangeCache == null) {
            return true;
        }
        Iterator<TemplateEntityDto> it = toCheck.iterator();
        while (it.hasNext()) {
            Set<Long> entityIds;
            TemplateEntityDto templateEntityDto = it.next();
            if (!IDUtils.equals(templateId, templateEntityDto.getTemplateId()) || (entityIds = entityRangeCache.get(templateEntityDto.getEntityId() + "_" + templateEntityDto.getEntityRange() + "_" + templateEntityDto.hashCode())) == null || !entityIds.contains(entityId)) continue;
            checked.add(templateEntityDto);
            it.remove();
        }
        return toCheck.isEmpty();
    }

    public static Map<Long, Set<Long>> getSubTaskRelTaskProcess(Set<Long> preTaskIds, PreTaskMonitorLogic preTaskMonitorLogic, Long submitOrgId) {
        HashMap<Long, Set<Long>> subTaskRelTaskProcessIdMap = new HashMap<Long, Set<Long>>(16);
        QFilter qFilter = new QFilter("task", "in", preTaskIds);
        if (preTaskMonitorLogic == PreTaskMonitorLogic.BY_ORG) {
            qFilter.and("org", "=", (Object)submitOrgId);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getSubTaskRelTaskProcess", (String)"eb_taskprocess", (String)"id,org,task.id", (QFilter[])qFilter.toArray(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                subTaskRelTaskProcessIdMap.computeIfAbsent(row.getLong("task.id"), e -> new HashSet(16)).add(row.getLong("id"));
            }
        }
        return subTaskRelTaskProcessIdMap;
    }

    public static Map<Long, Long> getTaskProcessToReportProcessMap(Long modelId, Set<Long> taskProcessIds) {
        HashMap<Long, Long> taskProcessToReportProcessMap = new HashMap<Long, Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> yearIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> dataTypeIds = new HashSet<Long>(16);
        HashMap<String, Long> taskProcessMap = new HashMap<String, Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getTaskProcessToReportProcessMap", (String)"eb_taskprocess", (String)"id,org,template,task.tasklist.year as period,task.tasklist.version as version,task.tasklist.datatype as datatype", (QFilter[])new QFilter("id", "in", taskProcessIds).toArray(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                entityIds.add(row.getLong("org"));
                templateIds.add(row.getLong("template"));
                yearIds.add(row.getLong("period"));
                versionIds.add(row.getLong("version"));
                dataTypeIds.add(row.getLong("datatype"));
                taskProcessMap.put(row.getString("org") + "_" + row.getLong("template") + "_" + row.getLong("period") + "_" + row.getString("version") + "_" + row.getString("datatype"), row.getLong("id"));
            }
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("period", "in", yearIds);
        qFilter.and("datatype", "in", dataTypeIds);
        qFilter.and("version", "in", versionIds);
        qFilter.and("template", "in", templateIds);
        qFilter.and("entity", "in", entityIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getTaskProcessToReportProcessMap", (String)"eb_reportprocess", (String)"id,entity,period,version,datatype,template", (QFilter[])qFilter.toArray(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String groupKey = row.getString("entity") + "_" + row.getLong("template") + "_" + row.getLong("period") + "_" + row.getString("version") + "_" + row.getString("datatype");
                if (!taskProcessMap.containsKey(groupKey)) continue;
                taskProcessToReportProcessMap.put((Long)taskProcessMap.get(groupKey), row.getLong("id"));
            }
        }
        return taskProcessToReportProcessMap;
    }

    public static void queryProcess(Long modelId, Collection<Long> entityIds, Collection<Long> periodIds, Collection<Long> dataTypeIds, Collection<Long> versionIds, Collection<Long> tempIds, ProcessConsumer processConsumer) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || entityIds.isEmpty() || periodIds.isEmpty() || dataTypeIds.isEmpty() || versionIds.isEmpty() || tempIds.isEmpty() || processConsumer == null) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fperiod,fdatatype,fversion,fentity,ftemplate from t_eb_reportprocess where ", new Object[0]);
        sqlBuilder.append("fmodel = ? ", new Object[]{modelId});
        sqlBuilder.append(" and ", new Object[0]).appendIn("fperiod", periodIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fdatatype", dataTypeIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fversion", versionIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fentity", entityIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("ftemplate", tempIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long reportProcessId = row.getLong("fid");
                Long periodId = row.getLong("fperiod");
                Long dataTypeId = row.getLong("fdatatype");
                Long versionId = row.getLong("fversion");
                Long entityId = row.getLong("fentity");
                Long tempId = row.getLong("ftemplate");
                processConsumer.accept(tempId, entityId, dataTypeId, periodId, versionId, reportProcessId);
            }
        }
    }
}

