/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.resource.ResourceUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class ControlException {
    public static final String DONTCONTROL_FM = "dont-control-fm";
    public static final String DONTCONTROL_PROCESS_SCHEME = "dont-control-process-scheme";
    public static final String SUCCESS_NO_MODEL = "success-no-model";
    public static final String SUCCESS_EMPTY_PARAMS = "success-empty-params";
    public static final String SUCCESS = "success";
    public static final String SUCCESS_CHECK_IDEMPOTENT = "success-check-idempotent";
    public static final String ERROR_CONTROL_PARAMETER = "error-control-parameter";
    public static final String ERROR_DYNAMIC_OBJECT = "error-dynamic-object";
    public static final String ERROR_BIZ_ENTITY_NUMBER = "error-biz-entity-number";
    public static final String ERROR_BIZ_NUMBER = "error-biz-number";
    public static final String ERROR_ORG_NULL = "error-org-null";
    public static final String ERROR_ORG_NOT_EXIST = "error-org-not-exist";
    public static final String ERROR_ORG_NUMBER_NAME = "error-org-number-name";
    public static final String ERROR_BIZ_ID = "error-biz-id";
    public static final String ERROR_MAPPING_ID = "error-mapping-id";
    public static final String ERROR_OPERATION = "error-operation";
    public static final String ERROR_BIZ_TIME = "error-biz-time";
    public static final String ERROR_LOCK = "error-lock";
    public static final String ERROR_CONTROL_LOCK = "error-control-lock";
    public static final String ERROR_BIZ_MODEL = "error-biz-model";
    public static final String ERROR_NO_DEFAULT_BIZPROP = "error-no-default-bizprop";
    public static final String ERROR_NO_DEFAULT_BIZ_ORGUNITPROP = "error-no-default-biz-orgunitprop";
    public static final String ERROR_DEFAULT_BIZ_ORGUNITPROP = "error-default-biz-orgunitprop";
    public static final String ERROR_NOT_DEFAULT_BIZTIMEPROP = "error-not-default-biztimeprop";
    public static final String ERROR_BIZ_TIMEPROP = "error-biz-timeprop";
    public static final String ERROR_PROP_VALUE_IS_NULL = "error-prop-value-is-null";
    public static final String ERROR_PROP_VALUE_IS_NULL_OTHER = "error-prop-value-is-null-other";
    public static final String ERROR_NOT_DIMENSION_MAPPING = "error-not-dimension-mapping";
    public static final String ERROR_NOT_DIMENSION_MAPPING_BY_LOANBILL = "error-not-dimension-mapping-by-loanbill";
    public static final String EROR_EXIST_MORE_GROUP = "error-exist-more-group";
    public static final String EROR_EXIST_MORE_MODEL = "error-exist-more-model";
    public static final String ERROR_NOT_EXIST_MEMBER = "error-not-exist-member";
    public static final String ERROR_NOT_PROCESSSET = "error-not-processset";
    public static final String ERROR_PROCESSSET = "error-processset";
    public static final String ERROR_NOT_CONTROL_PROCESS = "error-not-control-process";
    public static final String ERROR_ENTRYDC = "error-entrydc";
    public static final String ERROR_NOT_DEFAULT_RULE = "error-not-default-rule";
    public static final String ERROR_NOT_CONTROL_VERSION = "error-not-control-version";
    public static final String ERROR_NOT_CONTROL_VERSION_DIM = "error-not-control-version-dim";
    public static final String ERROR_CONNECT_OLAP_FAIL = "error-connect-olap-fail";
    public static final String ERROR_MORE_CONTROL_TABLE = "error-more-control-table";
    public static final String ERROR_QUERY_TARGET = "error-query-target";
    public static final String ERROR_ER_LOANBILL = "error-er-loanbill";
    public static final String ERROR_BEYOND_BUDGET = "EB090001";
    public static final String ERROR_EXIST_WRITE_OFF = "error-exist-write-off";
    public static final String ERROR_NO_CONTROL_DIMENSION = "error-no-control-dimension";
    public static final String ERROR_ORG_NO_DYNAMIC_OBJECT = "error-org-no-dynamic-object";
    public static final String ERROR_NOT_EXIST_RECORD_MEMBER = "error-not-exist-record-member";
    public static final String ERROR_GET_RECORD_MEMBER_DIMENSION_NULL = "error-get-record-member-dimension-null";
    public static final String ERROR_GET_RECORD_MEMBER_NULL = "error-get-record-member-null";
    public static final String ERROR_REMOVE_RECORD_MEMBER = "error-remove-record-member";
    public static final String ERROR_NULL_CONTROL_SCHEME = "error-null-control-scheme";
    public static final String ERROR_MAPPING_MEMBER_NULL = "error-mapping-member-null";
    public static final String ERROR_CONTROL_SCHEME_CONDITION = "error-control-scheme-condition";
    public static final String ERROR_WRITEOFF_ENTITY = "error-writeoff-entity";
    public static final String ERROR_WRITEOFF_TYPE = "error-writeoff-type";
    public static final String ERROR_WRITEOFF_VALUE = "error-writeoff-value";
    public static final String ERROR_WRITEOFF_MULTI = "error-writeoff-multi";
    public static final String ERROR_QUERY_RECORD_MEMBER = "error-query-record-member";
    public static final String ERROR_AMOUNT_LESS_WRITEOFF = "error-amount-less-writeoff";
    public static final String ERROR_DELENTRY_BYENTRY = "error-delentry-byentry";
    public static final String ERROR_REVIEWOCC_CLOSED = "error-reviewocc-closed";
    public static final String ERR_DEL_WRITEOFFS = "error-del-writeoffs";
    public static final String ERR_NEGATIVE_EXECUTE = "err_negative_execute";
    public static final String ERROR_OTHER = "error-other";

    public static void errorControlParameter() throws KDBizException {
        throw new KDBizException(new ErrorCode(ERROR_CONTROL_PARAMETER, ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"ResourceUtils_0", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorDynamicObject() {
        throw new KDBizException(new ErrorCode(ERROR_DYNAMIC_OBJECT, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5bf9\u8c61\u6216\u8005\u4e1a\u52a1\u5355\u636e\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ResourceUtils_1", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorBizEntityNumber() {
        throw new KDBizException(new ErrorCode(ERROR_BIZ_ENTITY_NUMBER, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a\uff08entityNumber\uff09\u3002", (String)"ResourceUtils_2", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorBizNumber() {
        throw new KDBizException(new ErrorCode(ERROR_BIZ_NUMBER, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u7801\u4e3a\u7a7a\uff08number\uff09\u3002", (String)"ResourceUtils_3", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorOrg(DynamicObject bizOrg) {
        if (bizOrg != null) {
            throw new KDBizException(new ErrorCode(ERROR_ORG_NOT_EXIST, ResManager.loadResFormat((String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u7ec4\u7ec7\u3002", (String)"ResourceUtils_5", (String)"epm-eb-common", (Object[])new Object[]{bizOrg.getString("number")})), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(ERROR_ORG_NULL, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7684\u9ed8\u8ba4\u63a7\u5236\u7ec4\u7ec7\u5728\u4e1a\u52a1\u5355\u5143\u4e0a\u4e0d\u5b58\u5728\u3002", (String)"ResourceUtils_7", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorOrgNumberAndName(String name, String number) {
        throw new KDBizException(new ErrorCode(ERROR_ORG_NUMBER_NAME, ResManager.loadResFormat((String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%1\u201d\u7f16\u7801\u4e3a\u201c%2\u201d\u7684\u7ec4\u7ec7\u3002", (String)"ResourceUtils_8", (String)"epm-eb-common", (Object[])new Object[]{name, number})), new Object[0]);
    }

    public static void errorOrg(String bizOrgNumber) {
        if (bizOrgNumber != null) {
            throw new KDBizException(new ErrorCode(ERROR_ORG_NOT_EXIST, ResManager.loadResFormat((String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u7ec4\u7ec7\u3002", (String)"ResourceUtils_5", (String)"epm-eb-common", (Object[])new Object[]{bizOrgNumber})), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(ERROR_ORG_NULL, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7684\u9ed8\u8ba4\u63a7\u5236\u7ec4\u7ec7\u5728\u4e1a\u52a1\u5355\u5143\u4e0a\u4e0d\u5b58\u5728\u3002", (String)"ResourceUtils_7", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorBizId() {
        throw new KDBizException(new ErrorCode(ERROR_BIZ_ID, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61ID\u4e3a\u7a7a\uff08bizId\uff09\u3002", (String)"ResourceUtils_11", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorMappingId() {
        throw new KDBizException(new ErrorCode(ERROR_MAPPING_ID, ResManager.loadKDString((String)"\u57fa\u7840\u670d\u52a1\u672a\u914d\u7f6e\u6620\u5c04\u3002", (String)"ResourceUtils_12", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorOperation() {
        throw new KDBizException(new ErrorCode(ERROR_OPERATION, ResManager.loadResFormat((String)"\u4e1a\u52a1\u65b9\u6cd5\u4e3a\u7a7a\uff08operation\uff09\u3002", (String)"ResourceUtils_13", (String)"epm-eb-common", (Object[])new Object[]{"operation"})), new Object[0]);
    }

    public static void errorBizTime(String bizTimeProp, Object propValue) {
        throw new KDBizException(new ErrorCode(ERROR_BIZ_TIME, ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u4e1a\u52a1\u65f6\u95f4\u5c5e\u6027\uff0c\u4e1a\u52a1\u5c5e\u6027\uff1a%1\uff0c\u4e1a\u52a1\u5c5e\u6027\u503c\uff1a%2\u3002", (String)"ResourceUtils_14", (String)"epm-eb-common", (Object[])new Object[]{bizTimeProp, propValue != null ? propValue.toString() : ""})), new Object[0]);
    }

    public static void errorLock() {
        throw new KDBizException(new ErrorCode(ERROR_LOCK, ResManager.loadKDString((String)"\u9884\u7b97\u7533\u8bf7\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u3002", (String)"ResourceUtils_17", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorControlLock() {
        throw new KDBizException(new ErrorCode(ERROR_CONTROL_LOCK, ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u7533\u8bf7\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u3002", (String)"ResourceUtils_18", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorBizModel() {
        throw new KDBizException(new ErrorCode(ERROR_BIZ_MODEL, ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u8005\u4f53\u7cfb\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"ResourceUtils_19", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void notDefaultBizProp(String entityNumber) {
        throw new KDBizException(new ErrorCode(ERROR_NO_DEFAULT_BIZPROP, ResManager.loadResFormat((String)"\u9884\u7b97\u63a7\u5236\u6ca1\u6709\u6ce8\u518c\u4e1a\u52a1\u5355\u636e\uff1a%1\u7684\u9ed8\u8ba4\u5c5e\u6027\u503c\u3002", (String)"ResourceUtils_20", (String)"epm-eb-common", (Object[])new Object[]{entityNumber})), new Object[0]);
    }

    public static void notDefaultBizOrgUnitProp() {
        throw new KDBizException(new ErrorCode(ERROR_NO_DEFAULT_BIZ_ORGUNITPROP, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7ec4\u7ec7\u5c5e\u6027\u3002", (String)"ResourceUtils_21", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorDefaultBizOrgUnitProp() {
        throw new KDBizException(new ErrorCode(ERROR_DEFAULT_BIZ_ORGUNITPROP, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u7684\u9ed8\u8ba4\u7ec4\u7ec7\u5c5e\u6027\u4e0d\u5141\u8bb8\u4f7f\u7528\u591a\u7ec4\u7ec7\u5c5e\u6027\u3002", (String)"ResourceUtils_22", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void notDefaultBizTimeProp() {
        throw new KDBizException(new ErrorCode(ERROR_NOT_DEFAULT_BIZTIMEPROP, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u4e1a\u52a1\u65f6\u95f4\u5c5e\u6027\u3002", (String)"ResourceUtils_23", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorBizTimeProp() {
        throw new KDBizException(new ErrorCode(ERROR_BIZ_TIMEPROP, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u7684\u9ed8\u8ba4\u4e1a\u52a1\u65f6\u95f4\u5c5e\u6027\u975e\u65e5\u671f\u7c7b\u578b\u3002", (String)"ResourceUtils_24", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void propValueIsNull(String propName) {
        throw new KDBizException(new ErrorCode(ERROR_PROP_VALUE_IS_NULL, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u4e1a\u52a1\u5b57\u6bb5\uff1a%1\u7684\u5c5e\u6027\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u6570\u636e\u3001\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u662f\u5426\u6b63\u786e\u3002", (String)"ResourceUtils_25", (String)"epm-eb-common", (Object[])new Object[]{propName})), new Object[0]);
    }

    public static void propValueIsNull() {
        throw new KDBizException(new ErrorCode(ERROR_PROP_VALUE_IS_NULL_OTHER, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4f20\u5165\u7684\u5c5e\u6027\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u4e0a\u7684\u6570\u636e\u6216\u8005\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ResourceUtils_27", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void notDimensionMapping(BizModel bizModel, String entityNumber) {
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING, ResManager.loadResFormat((String)"\u672a\u627e\u5230\u4f53\u7cfb\u201c%1\u201d\u7684\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u6216\u8005\u9002\u7528\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff0c\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a%2\u3002", (String)"ResourceUtils_28", (String)"epm-eb-common", (Object[])new Object[]{bizModel.getName(), entityNumber})), new Object[0]);
    }

    public static void nullEntityErr(String msg) {
        throw new KDBizException(new ErrorCode(ERROR_PROP_VALUE_IS_NULL_OTHER, msg), new Object[0]);
    }

    public static void notDimensionMappings(Map<String, Collection<BizModel>> bizModels, String entityNumber, Set<String> hasOnlyCheck) {
        StringBuilder msg = new StringBuilder();
        HashSet<String> namesNoCheck = new HashSet<String>(10);
        HashSet<String> namesHasCheck = new HashSet<String>(10);
        Map<String, String> groupNames = ControlException.queryGroupName(IDUtils.toLongs(bizModels.keySet()));
        for (Map.Entry<String, Collection<BizModel>> entry : bizModels.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            namesNoCheck.clear();
            namesHasCheck.clear();
            for (BizModel bizModel : entry.getValue()) {
                if (hasOnlyCheck == null || !hasOnlyCheck.contains(entry.getKey() + "!" + bizModel.getId())) {
                    namesNoCheck.add(bizModel.getName());
                    continue;
                }
                namesHasCheck.add(bizModel.getName());
            }
            if (!namesNoCheck.isEmpty()) {
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                msg.append(ResourceUtils.loadResFormat("%1\u5339\u914d\u89c4\u5219\u7ec4\u4e2d%2\u4f53\u7cfb\u672a\u8bbe\u7f6e\u5339\u914d\u89c4\u5219\u3002", "ResourceUtils_63", "epm-eb-common", groupNames.get(entry.getKey()) == null ? entry.getKey() : groupNames.get(entry.getKey()), String.join((CharSequence)", ", namesNoCheck)));
            }
            if (namesHasCheck.isEmpty()) continue;
            if (msg.length() > 0) {
                msg.append("\r\n");
            }
            msg.append(ResourceUtils.loadResFormat("%1\u5339\u914d\u89c4\u5219\u7ec4\u4e2d%2\u4f53\u7cfb\u672a\u8bbe\u7f6e\u8bb0\u5f55\u5b9e\u9645\u6570\u7684\u5339\u914d\u89c4\u5219\u3002", "ResourceUtils_67", "epm-eb-common", groupNames.get(entry.getKey()) == null ? entry.getKey() : groupNames.get(entry.getKey()), String.join((CharSequence)", ", namesHasCheck)));
        }
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING, msg.toString()), new Object[0]);
    }

    public static Map<String, String> queryGroupName(Set<Long> groupIds) {
        HashMap<String, String> groupNames = new HashMap<String, String>(10);
        if (groupIds == null || groupIds.isEmpty()) {
            return groupNames;
        }
        QFilter qf = new QFilter("id", "in", groupIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"eb_adddimmaterule", (String)"id, number, name", (QFilter[])qf.toArray());
        for (DynamicObject group : doc) {
            groupNames.put(group.getString("id"), group.getString("name"));
        }
        return groupNames;
    }

    public static void notDimensionMappings(String entityNumber) {
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING, ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u542f\u7528\u7684\u5339\u914d\u89c4\u5219\u7ec4\u3002", (String)"ResourceUtils_64", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void notDimensionMappings1(String s1, String s2) {
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING, ResourceUtils.loadResFormat("\u751f\u6548\u7684\u89c4\u5219\u7ec4%1\u4e2d\u672a\u8bbe\u7f6e%2\u4f53\u7cfb\u7684\u5339\u914d\u89c4\u5219", "ResourceUtils_72", "epm-eb-common", s1, s2)), new Object[0]);
    }

    public static void notDimensionMappingByLoanBills(String entityNumber, Collection<BizModel> bizModels, BizOrgUnit bizOrgUnit) {
        HashSet<String> names = new HashSet<String>(10);
        for (BizModel bizModel : bizModels) {
            names.add(bizModel.getName());
        }
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING_BY_LOANBILL, ResManager.loadResFormat((String)"\u76ee\u6807\u5355\u636e(%1)\u6ca1\u6709\u8bbe\u7f6e\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u3002\u4f53\u7cfb\uff08%2\uff09\uff0c\u7ec4\u7ec7\uff08%3\uff09\u3002", (String)"ResourceUtils_65", (String)"epm-eb-common", (Object[])new Object[]{entityNumber, names, bizOrgUnit.getName()})), new Object[0]);
    }

    public static void notDimensionMappingByLoanBill(String entityNumber, BizModel bizModel, BizOrgUnit bizOrgUnit) {
        String username = bizModel.getCreator();
        try {
            UserInfo u;
            Long creatorid = bizModel.getObject().getLong("creator.id");
            if (IDUtils.isNotNull(creatorid) && (u = UserUtils.getUserInfo(creatorid)) != null) {
                username = u.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING_BY_LOANBILL, ResManager.loadResFormat((String)"\u76ee\u6807\u5355\u636e(%1)\u6ca1\u6709\u8bbe\u7f6e\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u3002\u4f53\u7cfb\uff08%2\uff09\uff0c\u521b\u5efa\u4eba\uff08%3\uff09\uff0c\u7ec4\u7ec7\uff08%4\uff09\u3002", (String)"ResourceUtils_44", (String)"epm-eb-common", (Object[])new Object[]{entityNumber, bizModel.getName(), username != null ? username : "", bizOrgUnit.getName()})), new Object[0]);
    }

    public static void notDimensionMapping() {
        throw new KDBizException(new ErrorCode(ERROR_NOT_DIMENSION_MAPPING, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u3002", (String)"ResourceUtils_60", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorMoreGroup(String entityNumber) {
        throw new KDBizException(new ErrorCode(EROR_EXIST_MORE_GROUP, ResManager.loadResFormat((String)"\u76ee\u6807\u5355\u636e(%1)\u672a\u542f\u7528\u591a\u91cd\u63a7\u5236\uff0c\u4f46\u5b58\u5728\u591a\u4e2a\u542f\u7528\u7684\u5339\u914d\u89c4\u5219\u7ec4\u3002", (String)"ResourceUtils_66", (String)"epm-eb-common", (Object[])new Object[]{entityNumber})), new Object[0]);
    }

    public static void notDefaultRule(BizModel bizModel) {
        throw new KDBizException(new ErrorCode(ERROR_NOT_DEFAULT_RULE, ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7684\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u3002", (String)"ResourceUtils_31", (String)"epm-eb-common", (Object[])new Object[]{bizModel.getName()})), new Object[0]);
    }

    public static void notProcessSet(String modelName, String orgUnitNumber) {
        throw new KDBizException(new ErrorCode(ERROR_NOT_PROCESSSET, ResManager.loadResFormat((String)"\u672a\u8bbe\u7f6e\u201c\u9884\u7b97\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\uff08\u4f53\u7cfb%1\uff0c\u7ec4\u7ec7\u7f16\u7801\uff1a%2\uff09\u201d\u3002", (String)"ResourceUtils_33", (String)"epm-eb-common", (Object[])new Object[]{modelName, orgUnitNumber})), new Object[0]);
    }

    public static String notExistByMember(Dimension dimension, BizModel bizModel, Member member) {
        if (dimension == null || bizModel == null || member == null) {
            throw new KDBizException("model or dimension or member is null.");
        }
        String showModel = bizModel.getNumber() + " - " + bizModel.getName();
        String showMember = member.getNumber();
        if (StringUtils.isNotEmpty(member.getName())) {
            showMember = showMember + " - " + member.getName();
        }
        return ResManager.loadResFormat((String)"\u201c\u9884\u7b97\u4f53\u7cfb\uff1a%1\uff1b\u7ef4\u5ea6\u7ba1\u7406\uff1a%2\u201d\u4e0b\u6307\u5b9a\u7684\u6210\u5458\u201c%3\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ResourceUtils_36", (String)"epm-eb-common", (Object[])new Object[]{showModel, dimension.getName(), showMember});
    }

    public static void notExistMember(String msg) {
        throw new KDBizException(new ErrorCode(ERROR_NOT_EXIST_MEMBER, msg), new Object[0]);
    }

    public static String notExistByMemberFirst(String prop, BizModel bizModel, String groupName, String title) {
        if (bizModel == null) {
            throw new KDBizException("model or dimension is null.");
        }
        String showModel = bizModel.getNumber() + " - " + bizModel.getName();
        return ResManager.loadResFormat((String)"\u4e1a\u52a1\u5b57\u6bb5\u201c%1\u201d\u4f7f\u7528\u89c4\u5219\u7ec4\u201c%2\u201d\u7684\u89c4\u5219\u201c%3\u201d\uff0c\u5728\u9884\u7b97\u4f53\u7cfb\u201c%4\u201d\u5339\u914d\u4e0d\u5230\u9884\u7b97\u7ef4\u5ea6\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u8fd0\u7ef4\u4eba\u5458\u3002", (String)"ResourceUtils_46", (String)"epm-eb-common", (Object[])new Object[]{prop, groupName, title, showModel});
    }

    public static String memberNameAndNumberFormat(Member member) {
        if (member == null) {
            throw new KDBizException("member is null.");
        }
        String showMember = member.getNumber();
        if (StringUtils.isNotEmpty(member.getName())) {
            showMember = showMember + " - " + member.getName();
        }
        return showMember;
    }

    public static String beyondBalanceValueMessage(String value) {
        return String.format(ResManager.loadKDString((String)"\u8d85\u989d%s", (String)"ResourceUtils_56", (String)"epm-eb-common", (Object[])new Object[0]), value);
    }

    public static String notExistMemberByDim(int i, String dimName, List<String> notExistMembers) {
        if (notExistMembers == null) {
            throw new KDBizException("member is null.");
        }
        return ResManager.loadResFormat((String)"%1.\u5339\u914d\u4e0d\u5230%2\u6210\u5458\uff1a%3\u3002", (String)"ResourceUtils_47", (String)"epm-eb-common", (Object[])new Object[]{i, dimName, StringUtils.join(notExistMembers, "\uff0c")});
    }

    public static String notLeafByMemberFirst(List<String> dimNames, BizModel bizModel) {
        if (dimNames == null || bizModel == null) {
            throw new KDBizException("model or dimension is null.");
        }
        String showModel = bizModel.getNumber() + " - " + bizModel.getName();
        String join = StringUtils.join(dimNames, "\u3001");
        return ResManager.loadResFormat((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u5728\u9884\u7b97\u4f53\u7cfb\u201c%1\u201d\u7684\u7ef4\u5ea6\u201c%2\u201d\u4e2d\u5339\u914d\u5230\u975e\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ResourceUtils_48", (String)"epm-eb-common", (Object[])new Object[]{showModel, join});
    }

    public static String notLeafMemberByDim(int i, String dimName, List<String> notLeafMembers) {
        if (notLeafMembers == null) {
            throw new KDBizException("member is null.");
        }
        return ResManager.loadResFormat((String)"%1\u5339\u914d\u5230\u7684%2\u975e\u660e\u7ec6\u6210\u5458\u201c%3\u201d\u3002", (String)"ResourceUtils_49", (String)"epm-eb-common", (Object[])new Object[]{i, dimName, StringUtils.join(notLeafMembers, "\uff0c")});
    }

    public static String outOfBalanceByBg(BizModel bizModel) {
        if (bizModel == null) {
            throw new KDBizException("model is null.");
        }
        String showModel = bizModel.getNumber() + " - " + bizModel.getName();
        return ResManager.loadResFormat((String)"\u9884\u7b97\u4f53\u7cfb\uff1a%1\u4ee5\u4e0b\u53ef\u7528\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ResourceUtils_50", (String)"epm-eb-common", (Object[])new Object[]{showModel});
    }

    public static String notExistByMember1(Dimension dimension, BizModel bizModel, Long memberId) {
        if (dimension == null || bizModel == null || memberId == null) {
            throw new KDBizException("model or dimension or member is null.");
        }
        String showModel = bizModel.getNumber() + " - " + bizModel.getName();
        String showMember = memberId.toString();
        return ResManager.loadResFormat((String)"\u9884\u7b97\u4f53\u7cfb\uff1a%1\u7ef4\u5ea6\u7ba1\u7406-%2\u4e0b\u6307\u5b9a\u6210\u5458ID\uff1a%3\u4e0d\u5b58\u5728\u3002", (String)"ResourceUtils_35", (String)"epm-eb-common", (Object[])new Object[]{showModel, dimension.getName(), showMember});
    }

    public static void notControlVersion() {
        throw new KDBizException(new ErrorCode(ERROR_NOT_CONTROL_VERSION, ResManager.loadKDString((String)"\u5df2\u9009\u671f\u95f4\u672a\u67e5\u8be2\u5230\u751f\u6548\u7684\u63a7\u5236\u7248\u672c\u3002", (String)"ResourceUtils_52", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void notModelOrVersion() {
        throw new KDBizException(new ErrorCode(ERROR_NOT_CONTROL_VERSION_DIM, ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f53\u7cfb\uff0c\u6216\u4f53\u7cfb\u672a\u542f\u7528\u63a7\u5236\u7248\u672c\uff0c\u6216\u672a\u914d\u7f6e\u63a7\u5236\u7ef4\u5ea6\u3002", (String)"ResourceUtils_40", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void existMoreModel(Collection<BizModel> models) {
    }

    public static String requestBudget(String bizNo) {
        return ResManager.loadResFormat((String)"%1\u4e1a\u52a1\u5355\u636e\u63d0\u4ea4\u9884\u7b97\u6210\u529f", (String)"ResourceUtils_42", (String)"epm-eb-common", (Object[])new Object[]{bizNo});
    }

    public static String returnBudget(String bizNo) {
        return ResManager.loadResFormat((String)"%1\u4e1a\u52a1\u5355\u636e\u8fd4\u8fd8\u9884\u7b97\u6210\u529f", (String)"ResourceUtils_71", (String)"epm-eb-common", (Object[])new Object[]{bizNo});
    }

    public static void errorProcessSet() {
        throw new KDBizException(new ErrorCode(ERROR_PROCESSSET, ResManager.loadKDString((String)"\u672a\u627e\u5230\u63a7\u5236\u8fc7\u7a0b\u53c2\u6570\u6216\u8005\u63a7\u5236\u8fc7\u7a0b\u53c2\u6570\u7684\u63a7\u5236\u503c\u5c5e\u6027\u4e3a\u7a7a\u3002", (String)"ResourceUtils_43", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorEntryDc(String entryDc) {
        throw new KDBizException(new ErrorCode(ERROR_ENTRYDC, ResManager.loadResFormat((String)"\u51ed\u8bc1\u5206\u5f55\u7684\u65b9\u5411\u5c5e\u6027\u4e0d\u6b63\u786e\uff08\u201c%1\u201d\uff09\u3002", (String)"ResourceUtils_45", (String)"epm-eb-common", (Object[])new Object[]{entryDc})), new Object[0]);
    }

    public static void errorEntryDc() {
        throw new KDBizException(new ErrorCode(ERROR_ENTRYDC, ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u65b9\u5411\u5c5e\u6027\u4e3a\u7a7a\u3002", (String)"ResourceUtils_70", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void notControlProcess() {
        throw new KDBizException(new ErrorCode(ERROR_NOT_CONTROL_PROCESS, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u542f\u7528\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u3002", (String)"ResourceUtils_53", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void connectOlapFail() {
        throw new KDBizException(new ErrorCode(ERROR_CONNECT_OLAP_FAIL, ResManager.loadKDString((String)"\u67e5\u8be2\u591a\u7ef4\u6570\u636e\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"ResourceUtils_54", (String)"epm-eb-common", (Object[])new Object[0])), new Object[0]);
    }

    public static void moreControlTable() {
        throw new KDBizException(new ErrorCode(ERROR_MORE_CONTROL_TABLE, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7684\u5b58\u5728\u591a\u5f20\u63a7\u5236\u8bb0\u5f55\u8868\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CloseBudgetImpl_1", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorQueryTarget() {
        throw new KDBizException(new ErrorCode(ERROR_QUERY_TARGET, ResManager.loadKDString((String)"\u67e5\u8be2\u4e0b\u6e38\u5355\u636e\u53d1\u751f\u5f02\u5e38\u3002", (String)"CloseBudgetImpl_0", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorErLoanBill() {
        throw new KDBizException(new ErrorCode(ERROR_ER_LOANBILL, ResManager.loadKDString((String)"\u6ca1\u6709\u4ece\u4e1a\u52a1\u5355\u636e\u4e0a\u8bfb\u53d6\u5230\u5173\u8054\u7684\u4e0a\u6e38\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u4fdd\u5b58\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"AbstractControlImpl_0", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorOutOfBalance(String message) {
        throw new KDBizException(new ErrorCode(ERROR_BEYOND_BUDGET, message), new Object[0]);
    }

    public static void errorExistWriteOff() {
        throw new KDBizException(new ErrorCode(ERROR_EXIST_WRITE_OFF, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u7ecf\u6709\u5bf9\u5f53\u524d\u5355\u636e\u7684\u51b2\u51cf\u8bb0\u5f55\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5220\u9664\u9884\u7b97\u7684\u64cd\u4f5c\u3002", (String)"ReturnBudgetImpl_0", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorNoControlDimension() {
        throw new KDBizException(new ErrorCode(ERROR_NO_CONTROL_DIMENSION, ResManager.loadKDString((String)"\u5f53\u524d\u9884\u7b97\u4f53\u7cfb\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalcBalance_2", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorOrgNoDynamicObject() {
        throw new KDBizException(new ErrorCode(ERROR_ORG_NO_DYNAMIC_OBJECT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5b57\u6bb5\u4e0d\u662f\u52a8\u6001\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u4fee\u6539\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u3002", (String)"CalcBalance_0", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorNoExistRecordMember() {
        throw new KDBizException(new ErrorCode(ERROR_NOT_EXIST_RECORD_MEMBER, ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u8bb0\u5f55\u8bbe\u7f6e\u6210\u5458\u9519\u8bef\uff0c\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\u6216\u8005\u7ef4\u5ea6\u6210\u5458\u7684\u7ef4\u5ea6\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AbstractBgControlRecord_3", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorGetRecordMemberDimensionNull() {
        throw new KDBizException(new ErrorCode(ERROR_GET_RECORD_MEMBER_DIMENSION_NULL, ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u8bb0\u5f55\u8fd4\u56de\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBgControlRecord_0", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorGetRecordMemberNull(String dimension) {
        throw new KDBizException(new ErrorCode(ERROR_GET_RECORD_MEMBER_NULL, ResManager.loadResFormat((String)"\u9884\u7b97\u63a7\u5236\u8bb0\u5f55\u8fd4\u56de\u201c%1\u201d\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBgControlRecord_4", (String)"epm-eb-business", (Object[])new Object[]{dimension})), new Object[0]);
    }

    public static void errorRemoveRecordMember() {
        throw new KDBizException(new ErrorCode(ERROR_REMOVE_RECORD_MEMBER, ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u8bb0\u5f55\u5220\u9664\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBgControlRecord_2", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorNullControlScheme() {
        throw new KDBizException(new ErrorCode(ERROR_NULL_CONTROL_SCHEME, ResManager.loadKDString((String)"\u9884\u7b97\u5355\u636e\u6620\u5c04\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgControlScheme_0", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorMappingMemberNull(String dimension) {
        throw new KDBizException(new ErrorCode(ERROR_MAPPING_MEMBER_NULL, ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgControlScheme_1", (String)"epm-eb-business", (Object[])new Object[]{dimension})), new Object[0]);
    }

    public static void errorControlSchemeCondition(String condition) {
        throw new KDBizException(new ErrorCode(ERROR_CONTROL_SCHEME_CONDITION, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u7684\u9002\u7528\u6761\u4ef6(%1)\u89e3\u6790\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgControlScheme_2", (String)"epm-eb-business", (Object[])new Object[]{condition})), new Object[0]);
    }

    public static void errorWriteOffEntity(String writeOffNumber) {
        throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_ENTITY, ResManager.loadResFormat((String)"\u51b2\u9500\u65b9\u6848(%1)\u5355\u636e\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOff_0", (String)"epm-eb-business", (Object[])new Object[]{writeOffNumber})), new Object[0]);
    }

    public static void errorWriteOffType(String writeOffNumber, DynamicObject entityNumber) {
        throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_TYPE, ResManager.loadResFormat((String)"\u51b2\u9500\u65b9\u6848(%1)\u5355\u636e(%2)\u7684\u51b2\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOff_2", (String)"epm-eb-business", (Object[])new Object[]{writeOffNumber, entityNumber})), new Object[0]);
    }

    public static void errorWriteOffValue(String writeOffNumber, DynamicObject entityNumber) {
        throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_VALUE, ResManager.loadResFormat((String)"\u51b2\u9500\u65b9\u6848(%1)\u5355\u636e(%2)\u7684\u51b2\u9500\u91d1\u989d\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOff_3", (String)"epm-eb-business", (Object[])new Object[]{writeOffNumber, entityNumber})), new Object[0]);
    }

    public static void errorWriteOffMulti(BizModel bizModel) {
        if (bizModel == null) {
            throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_VALUE, ResManager.loadResFormat((String)"\u4e0b\u6e38\u5355\u636e\u63a7\u5236\u91cd\u6570\u5c0f\u4e8e\u4e0a\u6e38\uff0c\u51b2\u9500\u5931\u8d25\u3002", (String)"WriteOff_4", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
        }
        if (bizModel.isEBByModel() || BizModel.isNewEBByModel(bizModel.getObject())) {
            throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_VALUE, ResManager.loadResFormat((String)"%1\u4f53\u7cfb\u7684\u4e0b\u6e38\u5355\u636e\u63a7\u5236\u91cd\u6570\u5c0f\u4e8e\u4e0a\u6e38\uff0c\u51b2\u9500\u5931\u8d25\u3002", (String)"WriteOff_5", (String)"epm-eb-business", (Object[])new Object[]{bizModel.getName()})), new Object[0]);
        }
        DynamicObject bussModel = BusinessDataServiceHelper.loadSingleFromCache((Object)bizModel.getControlBusModelId(), (String)"eb_businessmodel", (String)"id,name");
        if (bussModel == null) {
            throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_VALUE, ResManager.loadResFormat((String)"%1\u4f53\u7cfb\u7684\u4e0b\u6e38\u5355\u636e\u63a7\u5236\u91cd\u6570\u5c0f\u4e8e\u4e0a\u6e38\uff0c\u51b2\u9500\u5931\u8d25\u3002", (String)"WriteOff_5", (String)"epm-eb-business", (Object[])new Object[]{bizModel.getName()})), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(ERROR_WRITEOFF_VALUE, ResManager.loadResFormat((String)"%1\u4f53\u7cfb%2\u4e1a\u52a1\u6a21\u578b\u7ba1\u63a7\u7684\u4e0b\u6e38\u5355\u636e\u63a7\u5236\u91cd\u6570\u5c0f\u4e8e\u4e0a\u6e38\uff0c\u51b2\u9500\u5931\u8d25\u3002", (String)"WriteOff_6", (String)"epm-eb-business", (Object[])new Object[]{bizModel.getName(), bussModel.getString("name")})), new Object[0]);
    }

    public static void errorQueryRecordMember(String dimension) {
        throw new KDBizException(new ErrorCode(ERROR_QUERY_RECORD_MEMBER, ResManager.loadResFormat((String)"\u63a7\u5236\u8bb0\u5f55\u67e5\u8be2\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c(%1)\u7ef4\u5ea6\u7684\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgControlRecordUtils_1", (String)"epm-eb-business", (Object[])new Object[]{dimension})), new Object[0]);
    }

    public static void erorrOther(String message) {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, message), new Object[0]);
    }

    public static KDBizException erorrOther(Throwable e) {
        return new KDBizException(new ErrorCode(ERROR_OTHER, e.getMessage()), new Object[0]);
    }

    public static void errorAmountCheck(boolean isOcc) throws KDBizException {
        if (isOcc) {
            throw new KDBizException(new ErrorCode(ERROR_AMOUNT_LESS_WRITEOFF, ResManager.loadKDString((String)"\u672c\u5355\u9884\u7b97\u5360\u7528\u603b\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u4e0b\u6e38\u5df2\u51b2\u9500\u91d1\u989d\uff0c\u5360\u7528\u53d8\u66f4\u5931\u8d25\u3002", (String)"BalanceCheck_4", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(ERROR_AMOUNT_LESS_WRITEOFF, ResManager.loadKDString((String)"\u672c\u5355\u9884\u7b97\u6267\u884c\u603b\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u4e0b\u6e38\u5df2\u51b2\u9500\u91d1\u989d\uff0c\u6267\u884c\u53d8\u66f4\u5931\u8d25\u3002", (String)"BalanceCheck_8", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorReviewOccClosed() {
        throw new KDBizException(new ErrorCode(ERROR_REVIEWOCC_CLOSED, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u8fd4\u8fd8\u5360\u7528\uff0c\u8bf7\u91cd\u542f\u5360\u7528\u540e\u518d\u8fdb\u884c\u8865\u5145\u5360\u7528\u3002", (String)"BalanceCheck_3", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errordeleteWriteoffs() {
        throw new KDBizException(new ErrorCode(ERR_DEL_WRITEOFFS, ResManager.loadKDString((String)"\u5355\u636e\u539f\u6263\u51cf\u8bb0\u5f55\u5df2\u88ab\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6263\u51cf\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BalanceCheck_6", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errNegativeExecute() {
        throw new KDBizException(new ErrorCode(ERR_NEGATIVE_EXECUTE, ResManager.loadKDString((String)"\u5f53\u524d\u63a5\u53e3\u53c2\u6570\u4e0d\u652f\u6301\u9884\u7b97\u6267\u884c\u64cd\u4f5c\u3002", (String)"BalanceCheck_19", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static String getReturnErrMsg(String s1, String s2) {
        return ResManager.loadResFormat((String)"\u8fd4\u8fd8%1\u65f6\u9884\u7b97\u4e0d\u8db3\n%2", (String)"ControlException_0", (String)"epm-eb-common", (Object[])new Object[]{s1, s2});
    }

    public static void nullEntryId() {
        throw new KDBizException(new ErrorCode(ERROR_REVIEWOCC_CLOSED, ResManager.loadKDString((String)"\u6263\u51cf\u5931\u8d25\uff1a\u4e1a\u52a1\u5355\u636e\u672a\u4f20\u5165\u5206\u5f55\u552f\u4e00\u6807\u8bc6\u4fe1\u606f\uff0c\u8bf7\u5173\u95ed\u201c\u6309\u5355\u636e\u5206\u5f55\u6263\u51cf\u9884\u7b97\u201d\u529f\u80fd\u3002", (String)"BalanceCheck_7", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorDelEntryCheck() throws KDBizException {
        throw new KDBizException(new ErrorCode(ERROR_AMOUNT_LESS_WRITEOFF, ResManager.loadKDString((String)"\u5220\u9664\u5206\u5f55\u9884\u7b97\u65f6\uff0c\u56e0\u672c\u5206\u5f55\u53d1\u751f\u8fc7\u51b2\u51cf\u5bfc\u81f4\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BalanceCheck_9", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorDelEntryCheck1() throws KDBizException {
        throw new KDBizException(new ErrorCode(ERROR_DELENTRY_BYENTRY, ResManager.loadKDString((String)"\u6309\u7167\u6574\u5355\u6263\u51cf\u9884\u7b97\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u4e0d\u652f\u6301\u6309\u7167\u5355\u636e\u5206\u5f55\u5173\u95ed\u548c\u8fd4\u8fd8\u9884\u7b97\uff0c\u8bf7\u6309\u7167\u6574\u5355\u5173\u95ed\u548c\u8fd4\u8fd8\u9884\u7b97\u3002", (String)"BalanceCheck_12", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void repeatEntryId() throws KDBizException {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadKDString((String)"\u6263\u51cf\u5931\u8d25\uff1a\u672c\u5355\u636e\u4f20\u5165\u7684\u53c2\u6570\u5b58\u5728\u91cd\u590d\u7684\u5206\u5f55ID\u3002", (String)"BalanceCheck_16", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void entryIdMustInput() {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadKDString((String)"\u6263\u51cf\u5931\u8d25\uff1a\u4e0a\u6e38\u7684\u5355\u636e\u5df2\u5f00\u542f\u201c\u6309\u5206\u5f55\u6263\u51cf\u9884\u7b97\u201d\uff0c\u51b2\u9500\u4e0a\u6e38\u5355\u636e\u65f6\u9700\u4f20\u5165\u4e0a\u6e38\u5355\u636e\u5206\u5f55\u201cid\u201d\u3002", (String)"BalanceCheck_10", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void entryIdWriteOff() {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadKDString((String)"\u6263\u51cf\u5931\u8d25\uff1a\u51b2\u9500\u53c2\u6570\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5206\u5f55ID\u3002", (String)"BalanceCheck_17", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void bostTypeMustInput(String s) {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadResFormat((String)"\u6263\u51cf\u5931\u8d25\uff1a\u9884\u7b97\u63a5\u53e3\u7684\u51b2\u9500\u53c2\u6570\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u652f\u6301\u4f20\u5165%1\u6216\u8005\u4e0d\u4f20\u3002", (String)"BalanceCheck_13", (String)"epm-eb-business", (Object[])new Object[]{s})), new Object[0]);
    }

    public static void errorWriteOffInfoError1(String s) {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadResFormat((String)"\u5b58\u5728\u672a\u6309\u5206\u5f55\u6263\u51cf\u7684\u63a7\u5236\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u6309\u5206\u5f55%1", (String)"BalanceCheck_11", (String)"epm-eb-business", (Object[])new Object[]{s})), new Object[0]);
    }

    public static void errorParamEntryId() {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u201centryId\u201d\u4f20\u53c2\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BalanceCheck_15", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }

    public static void errorSourceAmountParam() {
        throw new KDBizException(new ErrorCode(ERROR_OTHER, ResManager.loadKDString((String)"\u6263\u51cf\u5931\u8d25\uff1a\u51b2\u51cf\u53c2\u6570\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u552f\u4e00\u6807\u8bc6\u3002", (String)"BalanceCheck_18", (String)"epm-eb-business", (Object[])new Object[0])), new Object[0]);
    }
}

