/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.edit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.EnumUtils;

public enum ToolEnum {
    COMPUTE("comppute", new MultiLangEnumBridge("\u8ba1\u7b97\u7b26\u53f7", "ToolEnum_0", "epm-eb-formplugin")),
    ADD("add", new MultiLangEnumBridge("+", "", ""), COMPUTE, "+"),
    SUB("sub", new MultiLangEnumBridge("-", "", ""), COMPUTE, "-"),
    MUL("mul", new MultiLangEnumBridge("*", "", ""), COMPUTE, "*"),
    DIV("div", new MultiLangEnumBridge("/", "", ""), COMPUTE, "/"),
    LBRA("lbra", new MultiLangEnumBridge("(", "", ""), COMPUTE, "("),
    RBRA("rbra", new MultiLangEnumBridge(")", "", ""), COMPUTE, ")"),
    LOGIC("logic", new MultiLangEnumBridge("\u903b\u8f91\u7b26\u53f7", "ToolEnum_1", "epm-eb-formplugin")),
    IF("if", new MultiLangEnumBridge("IF", "", ""), LOGIC, "IF( , , )"),
    AND("and", new MultiLangEnumBridge("AND", "", ""), LOGIC, "AND( , )"),
    OR("or", new MultiLangEnumBridge("OR", "", ""), LOGIC, "OR( , )"),
    BIG("big", new MultiLangEnumBridge(">", "", ""), LOGIC, ">"),
    SMALL("small", new MultiLangEnumBridge("<", "", ""), LOGIC, "<"),
    EQUAL("equal", new MultiLangEnumBridge("=", "", ""), LOGIC, "="),
    BEQUAL("bequal", new MultiLangEnumBridge(">=", "", ""), LOGIC, ">="),
    SEQUAL("sequal", new MultiLangEnumBridge("<=", "", ""), LOGIC, "<="),
    NEQUAL("nequal", new MultiLangEnumBridge("<>", "", ""), LOGIC, "<>"),
    ALL(RuleFunctionTypeEnum.All.getKey(), new MultiLangEnumBridge("\u51fd\u6570", "ToolEnum_2", "epm-eb-formplugin")),
    Relation(RuleFunctionTypeEnum.Relation.getKey(), new MultiLangEnumBridge("\u5173\u7cfb\u51fd\u6570", "RuleFunctionTypeEnum_7", "epm-eb-common"), ALL),
    MATH(RuleFunctionTypeEnum.Meth.getKey(), new MultiLangEnumBridge("\u6570\u5b66\u51fd\u6570", "RuleFunctionTypeEnum_3", "epm-eb-common"), ALL),
    STRING_FUN(RuleFunctionTypeEnum.String.getKey(), new MultiLangEnumBridge("\u5b57\u7b26\u51fd\u6570", "RuleFunctionTypeEnum_8", "epm-eb-common"), ALL),
    BOOL(RuleFunctionTypeEnum.Bool.getKey(), new MultiLangEnumBridge("\u5e03\u5c14\u51fd\u6570", "RuleFunctionTypeEnum_2", "epm-eb-common"), ALL),
    DateFun("DateFun", new MultiLangEnumBridge("\u65e5\u671f\u51fd\u6570", "RuleFunctionTypeEnum_5", "epm-eb-common"), ALL, true),
    YearValueFun("YearValueFun", new MultiLangEnumBridge("\u5e74\u53d6\u503c\u51fd\u6570", "RuleFunctionTypeEnum_6", "epm-eb-common"), ALL, true),
    FINANCE(RuleFunctionTypeEnum.Finance.getKey(), new MultiLangEnumBridge("\u8d22\u52a1\u51fd\u6570", "RuleFunctionTypeEnum_1", "epm-eb-common"), ALL),
    Attribute(RuleFunctionEnum.Attribute.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Attribute.getName(), "", ""), Relation),
    GetAttribute(RuleFunctionEnum.GetAttribute.getName(), new MultiLangEnumBridge(RuleFunctionEnum.GetAttribute.getName(), "", ""), Relation),
    List(RuleFunctionEnum.List.getName(), new MultiLangEnumBridge(RuleFunctionEnum.List.getName(), "", ""), Relation),
    Ancestor(RuleFunctionEnum.Ancestor.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Ancestor.getName(), "", ""), Relation),
    Children(RuleFunctionEnum.Children.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Children.getName(), "", ""), Relation),
    Relative(RuleFunctionEnum.Relative.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Relative.getName(), "", ""), Relation),
    Sibling(RuleFunctionEnum.Sibling.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Sibling.getName(), "", ""), Relation),
    Parent(RuleFunctionEnum.Parent.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Parent.getName(), "", ""), Relation),
    CurrMBR(RuleFunctionEnum.CurrMBR.getName(), new MultiLangEnumBridge(RuleFunctionEnum.CurrMBR.getName(), "", ""), Relation),
    Member(RuleFunctionEnum.Member.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Member.getName(), "", ""), Relation),
    IsChild(RuleFunctionEnum.IsChild.getName(), new MultiLangEnumBridge(RuleFunctionEnum.IsChild.getName(), "", ""), BOOL),
    IsAttribute(RuleFunctionEnum.IsAttribute.getName(), new MultiLangEnumBridge(RuleFunctionEnum.IsAttribute.getName(), "", ""), BOOL),
    Count(RuleFunctionEnum.Count.getName(), new MultiLangEnumBridge(RuleFunctionEnum.Count.getName(), "", ""), MATH),
    ROUND("round", new MultiLangEnumBridge("Round", "", ""), MATH, "@Round( , )"),
    SumRange("SumRange", new MultiLangEnumBridge("SumRange", "", ""), MATH, "@SumRange( , )"),
    ABS("ABS", new MultiLangEnumBridge("ABS", "", ""), MATH, "@ABS( )"),
    AVGRange("AVGRange", new MultiLangEnumBridge("AVGRange", "", ""), MATH, "@AVGRange( , )"),
    AVGRangeS("AVGRangeS", new MultiLangEnumBridge("AVGRangeS", "", ""), MATH, "@AVGRangeS( , )"),
    Max("Max", new MultiLangEnumBridge("Max", "", ""), MATH, "@Max( , )"),
    MaxRange("MaxRange", new MultiLangEnumBridge("MaxRange", "", ""), MATH, "@MaxRange( , )"),
    Min("Min", new MultiLangEnumBridge("Min", "", ""), MATH, "@Min( , )"),
    MinRange("MinRange", new MultiLangEnumBridge("MinRange", "", ""), MATH, "@MinRange( , )"),
    PeriodShift("PeriodShift", new MultiLangEnumBridge("PeriodShift", "", ""), MATH, "@PeriodShift( , )", true),
    IRR("IRR", new MultiLangEnumBridge("IRR", "", ""), FINANCE, "@IRR( , ,10%)"),
    NPV("NPV", new MultiLangEnumBridge("NPV", "", ""), FINANCE, "@NPV( , , )"),
    YearValue("YearValue", new MultiLangEnumBridge("YearValue", "", ""), YearValueFun),
    RecognitionP("RecognitionP", new MultiLangEnumBridge("RecognitionP", "", ""), FINANCE),
    RecognitionPC("RecognitionPC", new MultiLangEnumBridge("RecognitionPC", "", ""), FINANCE),
    RecognitionSP("RecognitionSP", new MultiLangEnumBridge("RecognitionSP", "", ""), FINANCE),
    Date("Date", new MultiLangEnumBridge("Date", "", ""), DateFun),
    DateDif("DateDif", new MultiLangEnumBridge("DateDif", "", ""), DateFun, "@DateDif( , , 'D')", true),
    Year("Year", new MultiLangEnumBridge("Year", "", ""), DateFun, "@Year( )", true),
    Month("Month", new MultiLangEnumBridge("Month", "", ""), DateFun, "@Month( )", true),
    GetNumber("GetNumber", new MultiLangEnumBridge("GetNumber", "", ""), STRING_FUN),
    GetName("GetName", new MultiLangEnumBridge("GetName", "", ""), STRING_FUN);

    private String code;
    private MultiLangEnumBridge name;
    private ToolEnum parent;
    private String showStr;
    private boolean visable = true;

    private ToolEnum(String code, MultiLangEnumBridge name) {
        this.code = code;
        this.name = name;
    }

    private ToolEnum(String code, MultiLangEnumBridge name, ToolEnum parent) {
        this.code = code;
        this.name = name;
        this.parent = parent;
    }

    private ToolEnum(String code, MultiLangEnumBridge name, ToolEnum parent, boolean visable) {
        this.code = code;
        this.name = name;
        this.parent = parent;
        this.visable = visable;
    }

    private ToolEnum(String code, MultiLangEnumBridge name, ToolEnum parent, String showStr) {
        this.code = code;
        this.name = name;
        this.parent = parent;
        this.showStr = showStr;
    }

    private ToolEnum(String code, MultiLangEnumBridge name, ToolEnum parent, String showStr, boolean visable) {
        this.code = code;
        this.name = name;
        this.parent = parent;
        this.showStr = showStr;
        this.visable = visable;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public ToolEnum getParent() {
        return this.parent;
    }

    public String getShowStr() {
        return this.showStr;
    }

    public static ToolEnum getToolEnumByKey(String key) {
        ToolEnum toolEnum = null;
        for (ToolEnum tool : ToolEnum.values()) {
            if (!tool.code.equals(key)) continue;
            toolEnum = tool;
            break;
        }
        return toolEnum;
    }

    public static List<ToolEnum> getToolsByParentKey(String parentKey) {
        ArrayList<ToolEnum> tools = new ArrayList<ToolEnum>(16);
        for (ToolEnum tool : ToolEnum.values()) {
            if (StringUtils.isEmpty(parentKey)) {
                if (tool.parent != null || !tool.visable) continue;
                tools.add(tool);
                continue;
            }
            if (tool.parent == null || !tool.parent.getCode().equals(parentKey) || !tool.visable) continue;
            tools.add(tool);
        }
        return tools;
    }

    public static boolean rangeFunctionBoolean(ToolEnum parentToolEnum) {
        if (parentToolEnum == null) {
            return false;
        }
        return Lists.newArrayList((Object[])new ToolEnum[]{SumRange, List, AVGRange, AVGRangeS, MaxRange, MinRange, IRR, NPV, Date}).contains((Object)parentToolEnum);
    }

    public boolean isShowInPage() {
        return this.getParent() == LOGIC || EnumUtils.equalsAny(this, ROUND, SumRange, ABS, AVGRange, AVGRangeS, Max, MaxRange, Min, MinRange, IRR, NPV, Date, Month, Year, DateDif, PeriodShift);
    }

    public static boolean memberFunctionBoolean(ToolEnum parentToolEnum) {
        if (parentToolEnum == null) {
            return false;
        }
        return parentToolEnum == Member;
    }

    public static boolean getNumberAndGetNameFunctionBoolean(ToolEnum parentToolEnum) {
        if (parentToolEnum == null) {
            return false;
        }
        return Lists.newArrayList((Object[])new ToolEnum[]{GetNumber, GetName}).contains((Object)parentToolEnum);
    }
}

