/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AttributeRuleFunction
extends RuleFunction {
    public AttributeRuleFunction(String functionName) {
        super(functionName);
    }

    public AttributeRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealAttributeVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealAttributeVal(StringBuilder sb) {
        RuleFunction childFun;
        String funStr;
        String dimNumber = (String)this.allVals.get("dimensionlist");
        sb.append(dimNumber);
        sb.append(',');
        if (this.allVals.containsKey("childIsFun")) {
            funStr = (String)this.allVals.get("dimmemberrange");
            childFun = RuleFunctionFactory.fromJsonString(funStr);
            sb.append(childFun.genNewFunParseStr());
        } else {
            sb.append("RangeMemberSetFun");
        }
        sb.append(',');
        sb.append('`');
        sb.append(this.allVals.get("attribute"));
        sb.append('`');
        sb.append(',');
        funStr = (String)this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
        if (this.allVals.containsKey("childIsFunByAttributeVal")) {
            childFun = RuleFunctionFactory.fromJsonString(funStr);
            sb.append(childFun.genNewFunParseStr());
        } else {
            sb.append('`');
            sb.append(this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey()));
            sb.append('`');
        }
    }

    @Override
    public FunctionRefMember genRefMemberFirst(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = super.genRefMemberFirst(leftMemberScope, modelCache, viewMap);
        this.filterByAttribute(modelCache, functionRefMember.getDimNumber(), functionRefMember, leftMemberScope, viewMap);
        return functionRefMember;
    }

    private void filterByAttribute(IModelCacheHelper modelCache, String dimNumber, FunctionRefMember functionRefMember, Map<String, Set<String>> leftMemberScope, Map<String, Long> viewMap) {
        if (modelCache.getModelobj() == null) {
            return;
        }
        long modelId = modelCache.getModelobj().getId();
        String attribute = (String)this.allVals.get("attribute");
        String attributeVal = (String)this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
        Set<String> members = functionRefMember.getMembers();
        if (CollectionUtils.isNotEmpty(members)) {
            CustomPropertyValue propertyValue;
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelId);
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (this.allVals.containsKey("childIsFunByAttributeVal")) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(attributeVal);
                propertyValue = childFun.handleAttributeValueGenRefMember(leftMemberScope, modelCache, viewMap);
                FunctionRefMember getAttributeFunctionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
                functionRefMember.setSkip(getAttributeFunctionRefMember.isSkip());
            } else {
                propertyValue = memberPropCache.getPropertyValue(dimNumber, attribute, attributeVal);
            }
            if (propertyValue != null) {
                List<Member> propMembers = memberPropCache.getMembersByPropValues(dimension.getId(), viewMap.get(dimension.getNumber()), propertyValue.getId());
                Set<String> propMemNumbers = propMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(functionRefMember.getFilterMembers())) {
                    propMemNumbers.retainAll(functionRefMember.getFilterMembers());
                } else {
                    propMemNumbers.retainAll(functionRefMember.getMembers());
                }
                functionRefMember.setFilterMembers(propMemNumbers);
            }
        }
        functionRefMember.setMembers(members);
    }

    private Set<String> filterByAttribute(IModelCacheHelper modelCache, String dimNumber, Set<String> refMembers, Map<String, Long> viewMap, Set<String> currMembers, Map<String, String> leftMemberMap, Long currDataSetId, Map<String, Set<String>> currMemberMap) {
        if (modelCache.getModelobj() == null) {
            return refMembers;
        }
        String attribute = (String)this.allVals.get("attribute");
        String attributeVal = (String)this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
        if (CollectionUtils.isNotEmpty(refMembers)) {
            CustomPropertyValue propertyValue;
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelCache.getModelobj().getId());
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (this.allVals.containsKey("childIsFunByAttributeVal")) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(attributeVal);
                propertyValue = childFun.handleAttributeValueByAnalyzeRealMember(modelCache, viewMap, dimNumber, currMembers, leftMemberMap, currDataSetId, currMemberMap);
            } else {
                propertyValue = memberPropCache.getPropertyValue(dimNumber, attribute, attributeVal);
            }
            if (propertyValue != null) {
                List<Member> propMembers = memberPropCache.getMembersByPropValues(dimension.getId(), viewMap.get(dimension.getNumber()), propertyValue.getId());
                Set propMemNumbers = propMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                refMembers.retainAll(propMemNumbers);
            }
        }
        return refMembers;
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember;
        String dimNumber = (String)this.allVals.get("dimensionlist");
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmemberrange");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
        } else {
            Long viewIdLong = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
            functionRefMember = new FunctionRefMember();
            functionRefMember.setDimNumber(dimNumber);
            Set<String> memberNumberStringSet = this.getMemberNumberSet(modelCache, dimNumber, viewIdLong);
            functionRefMember.setMembers(memberNumberStringSet);
        }
        String attribute = (String)this.allVals.get("attribute");
        functionRefMember.getRefPropSet().add(attribute);
        this.filterByAttribute(modelCache, dimNumber, functionRefMember, leftMemberScope, viewMap);
        return functionRefMember;
    }

    private Set<String> getMemberNumberSet(IModelCacheHelper modelCache, String dimNumber, Long viewIdLong) {
        return LambdaUtils.get(() -> {
            String memberNumber = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
            Pair<List<MemberCondition>, List<MemberCondition>> matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair(memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
            List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
            Set normalMemberNumberStringSet = normalMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, viewIdLong, item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
            List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
            if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
                return normalMemberNumberStringSet;
            }
            Set removeMemberNumberStringSet = removeMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, viewIdLong, item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
            normalMemberNumberStringSet.removeAll(removeMemberNumberStringSet);
            return normalMemberNumberStringSet;
        });
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        Set<Object> refMembers = new HashSet<String>(16);
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmemberrange");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            refMembers = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
        } else {
            Long viewIdLong = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
            Set<String> memberNumberStringSet = this.getMemberNumberSet(modelCache, dimNumber, viewIdLong);
            refMembers.addAll(memberNumberStringSet);
        }
        refMembers.addAll(memNumber);
        return this.filterByAttribute(modelCache, dimNumber, refMembers, viewMap, memNumber, leftMemberMap, currDataSetId, currMemberMap);
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        CustomPropertyValue propertyValue;
        LinkedList memberQuoteList = Lists.newLinkedList();
        String dimNumber = (String)this.allVals.get("dimensionlist");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmemberrange");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            List<MemberQuoteDao> childQuote = childFun.genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
            if (childQuote != null) {
                memberQuoteList.addAll(childQuote);
            }
        } else {
            String dimmemberrangeString = (String)this.allVals.get("dimmemberrange");
            List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)dimmemberrangeString);
            ArrayList memberIds = Lists.newArrayListWithExpectedSize((int)memberConditionList.size());
            for (MemberCondition memberCondition : memberConditionList) {
                Member member = dimension.getMember(IDUtils.toLong(memberCondition.getViewId()), memberCondition.getNumber());
                memberIds.add(member.getId());
            }
            Long viewIdLong = this.getDimensionViewId(this.allVals, dimNumber, Collections.emptyMap());
            MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), memberIds, MemberQuoteResourceEnum.BizRule, ruleId);
            for (Long memberId : memberIds) {
                RuleFunctionUtils.putMemberQuoteViewMap(memberId, viewIdLong, memberQuoteDao);
            }
            memberQuoteList.add(memberQuoteDao);
        }
        String attribute = (String)this.allVals.get("attribute");
        String attributeVal = (String)this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelId);
        CustomProperty property = memberPropCache.getProperty(dimNumber, attribute);
        if (property != null) {
            memberQuoteList.add(new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), property.getId(), MemberTypeEnum.ATTRIBUTE, MemberQuoteResourceEnum.BizRule, ruleId));
        }
        if (this.allVals.containsKey("childIsFunByAttributeVal")) {
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(attributeVal);
            propertyValue = childFun.handleAttributeValueGenFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
        } else {
            propertyValue = memberPropCache.getPropertyValue(dimNumber, attribute, attributeVal);
        }
        if (propertyValue != null) {
            memberQuoteList.add(new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), propertyValue.getId(), MemberTypeEnum.ATTRIBUTEVALUE, MemberQuoteResourceEnum.BizRule, ruleId));
        }
        return memberQuoteList;
    }
}

