/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.DateFunctionParamEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.var.TemplateVarCommonUtil;

public class DateRuleFunction
extends RuleFunction {
    public DateRuleFunction(String functionName) {
        super(functionName);
    }

    public DateRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealSiblingVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealSiblingVal(StringBuilder sb) {
        block5: for (DateFunctionParamEnum dateFunctionParamEnum : DateFunctionParamEnum.values()) {
            Object funStr = this.allVals.get(dateFunctionParamEnum.getMemberKey());
            if (funStr == null) continue;
            switch (dateFunctionParamEnum) {
                case Date: {
                    sb.append("'");
                    sb.append(funStr);
                    sb.append("'");
                    continue block5;
                }
                case CurrMember: {
                    RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr.toString());
                    sb.append(childFun.genNewFunParseStr());
                    continue block5;
                }
                case BudgetPeriod: {
                    sb.append('`');
                    sb.append(funStr);
                    sb.append('`');
                    continue block5;
                }
            }
        }
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = null;
        for (DateFunctionParamEnum dateFunctionParamEnum : DateFunctionParamEnum.values()) {
            String funStr = (String)this.allVals.get(dateFunctionParamEnum.getMemberKey());
            if (StringUtils.isEmpty(funStr) || dateFunctionParamEnum.getMemberKey().equals(DateFunctionParamEnum.Date.getMemberKey())) continue;
            if (dateFunctionParamEnum.getMemberKey().equals(DateFunctionParamEnum.CurrMember.getMemberKey())) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
                functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
            } else if (dateFunctionParamEnum.getMemberKey().equals(DateFunctionParamEnum.BudgetPeriod.getMemberKey())) {
                functionRefMember = new FunctionRefMember();
                functionRefMember.setDimNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                HashSet<String> members = new HashSet<String>(16);
                members.add(funStr);
                functionRefMember.setMembers(members);
            }
            if (functionRefMember == null) {
                return new FunctionRefMember();
            }
            if (functionRefMember.isSkip()) {
                functionRefMember.setLoop(false);
            }
            Set<String> childMembers = functionRefMember.getMembers();
            LinkedHashSet members = Sets.newLinkedHashSet();
            for (String childMember : childMembers) {
                Long viewId = viewMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), viewId, childMember);
                List<Member> brother = modelCache.getBrother(viewId, member, false);
                Set memNumbers = brother.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                members.addAll(memNumbers);
            }
            functionRefMember.setMembers(members);
            return functionRefMember;
        }
        return new FunctionRefMember();
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        for (DateFunctionParamEnum dateFunctionParamEnum : DateFunctionParamEnum.values()) {
            Object funStr = this.allVals.get(dateFunctionParamEnum.getMemberKey());
            if (funStr == null || !dateFunctionParamEnum.getMemberKey().equals(DateFunctionParamEnum.CurrMember.getMemberKey())) continue;
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr.toString());
            memNumber = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
            break;
        }
        LinkedHashSet members = Sets.newLinkedHashSet();
        for (String childMember : memNumber) {
            Long viewId = viewMap.get(dimNumber);
            Member member = modelCache.getMember(dimNumber, viewId, childMember);
            List<Member> brother = modelCache.getBrother(viewId, member, false);
            Set memNumbers = brother.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            members.addAll(memNumbers);
        }
        return members;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        for (DateFunctionParamEnum dateFunctionParamEnum : DateFunctionParamEnum.values()) {
            Object funStr = this.allVals.get(dateFunctionParamEnum.getMemberKey());
            if (funStr == null) continue;
            if (dateFunctionParamEnum.getMemberKey().equals(DateFunctionParamEnum.CurrMember.getMemberKey())) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr.toString());
                return childFun.genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
            }
            if (!dateFunctionParamEnum.getMemberKey().equals(DateFunctionParamEnum.BudgetPeriod.getMemberKey())) continue;
            Dimension dimension = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
            if (TemplateVarCommonUtil.checkIsVar(funStr.toString(), SysDimensionEnum.BudgetPeriod.getNumber()).booleanValue()) {
                DynamicObject variable = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)funStr.toString()).toArray());
                return Lists.newArrayList((Object[])new MemberQuoteDao[]{new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), variable.getLong("id"), MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.BizRule, ruleId)});
            }
            Member member = dimension.getMember(null, funStr.toString());
            return Lists.newArrayList((Object[])new MemberQuoteDao[]{new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), member.getId(), MemberQuoteResourceEnum.BizRule, ruleId)});
        }
        return null;
    }
}

